/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.util;

import org.bouncycastle.crypto.digests.SM3Digest;

public class SM3AuthDigest {
    private SM3AuthDigest() {
    }

    public static byte[] encode(byte[] user, byte[] password, byte[] salt) {
        byte[] hexDigest = new byte[67];
        try {
            SM3Digest digest = new SM3Digest();
            byte[] passDigest = new byte[digest.getDigestSize()];
            byte[] tempDigest = new byte[digest.getDigestSize()];
            digest.update(password, 0, password.length);
            digest.update(user, 0, user.length);
            digest.doFinal(tempDigest, 0);
            SM3AuthDigest.bytesToHex(tempDigest, hexDigest, 0);
            digest.reset();
            digest.update(hexDigest, 0, digest.getDigestSize() * 2);
            digest.update(salt, 0, salt.length);
            digest.doFinal(passDigest, 0);
            SM3AuthDigest.bytesToHex(passDigest, hexDigest, 3);
            hexDigest[0] = 115;
            hexDigest[1] = 109;
            hexDigest[2] = 51;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to encode password with SM3", e);
        }
        return hexDigest;
    }

    private static void bytesToHex(byte[] bytes, byte[] hex, int offset) {
        char[] lookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int pos = offset;
        for (int i = 0; i < 32; ++i) {
            int c = bytes[i] & 0xFF;
            int j = c >> 4;
            hex[pos++] = (byte)lookup[j];
            j = c & 0xF;
            hex[pos++] = (byte)lookup[j];
        }
    }
}

