/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.util;

import com.hundsun.lightdb.core.QueryExecutor;
import com.hundsun.lightdb.jdbc.PgConnection;
import com.hundsun.lightdb.jdbc.PgPreparedStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.DbType;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.SQLUtils;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.hundsun.lightdb.shaded.com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.hundsun.lightdb.util.CompatibleUtil;
import java.sql.Connection;
import java.util.Arrays;
import java.util.stream.Collectors;

public class SqlPreHandler {
    public static String cleanFoundRows(QueryExecutor queryExecutor, String parsedSql) {
        if (CompatibleUtil.isMysqlCompatible(queryExecutor)) {
            return parsedSql.replaceAll("(?i)SQL_CALC_FOUND_ROWS", "");
        }
        return parsedSql;
    }

    public static String cleanEmptyChar(QueryExecutor queryExecutor, String parsedSql) {
        if (CompatibleUtil.isEnforceUtf8(queryExecutor)) {
            return parsedSql.replaceAll("\u0000", "");
        }
        return parsedSql;
    }

    public static String replaceSql(String sql, Connection connection) {
        PgConnection conn = (PgConnection)connection;
        if (CompatibleUtil.isMysqlCompatible(conn.getQueryExecutor()) && sql.toUpperCase().contains("SELECT FOUND_ROWS()")) {
            PgPreparedStatement prev = (PgPreparedStatement)conn.getPrev();
            String nativeSql = conn.prevRawSql().replaceAll("(?i)SQL_CALC_FOUND_ROWS", "");
            Object[] values = prev.getPreparedParameters().getValues();
            SQLSelectStatement sqlStatement = (SQLSelectStatement)SQLUtils.parseSingleMysqlStatement(nativeSql);
            MySqlSelectQueryBlock query = (MySqlSelectQueryBlock)sqlStatement.getSelect().getQuery();
            query.setLimit(null);
            sql = SQLUtils.toSQLString(Arrays.asList(sqlStatement), DbType.postgresql, Arrays.stream(values).collect(Collectors.toList()));
            StringBuilder stringBuilder = new StringBuilder(sql.length() + 40);
            stringBuilder.append("select count(");
            stringBuilder.append(0);
            stringBuilder.append(") from ( \n");
            stringBuilder.append(sql);
            stringBuilder.append("\n ) tmp_count");
            return stringBuilder.toString();
        }
        return sql;
    }
}

