/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core;

import com.hundsun.lightdb.shaded.org.slf4j.Logger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.Function;
import org.ehcache.Cache;
import org.ehcache.Status;
import org.ehcache.config.CacheRuntimeConfiguration;
import org.ehcache.core.EhcacheRuntimeConfiguration;
import org.ehcache.core.InternalCache;
import org.ehcache.core.Jsr107Cache;
import org.ehcache.core.SpecIterator;
import org.ehcache.core.StatusTransitioner;
import org.ehcache.core.events.CacheEventDispatcher;
import org.ehcache.core.exceptions.ExceptionFactory;
import org.ehcache.core.spi.LifeCycled;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.statistics.BulkOps;
import org.ehcache.core.statistics.CacheOperationOutcomes;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.shadow.org.terracotta.statistics.StatisticBuilder;
import org.ehcache.shadow.org.terracotta.statistics.StatisticsManager;
import org.ehcache.shadow.org.terracotta.statistics.observer.OperationObserver;
import org.ehcache.spi.loaderwriter.BulkCacheLoadingException;
import org.ehcache.spi.loaderwriter.BulkCacheWritingException;
import org.ehcache.spi.loaderwriter.CacheWritingException;
import org.ehcache.spi.resilience.ResilienceStrategy;
import org.ehcache.spi.resilience.StoreAccessException;

public abstract class EhcacheBase<K, V>
implements InternalCache<K, V> {
    protected final Logger logger;
    protected final StatusTransitioner statusTransitioner;
    protected final Store<K, V> store;
    protected final ResilienceStrategy<K, V> resilienceStrategy;
    protected final EhcacheRuntimeConfiguration<K, V> runtimeConfiguration;
    protected final OperationObserver<CacheOperationOutcomes.GetOutcome> getObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.GetOutcome.class).named("get")).of(this)).tag("cache")).build();
    protected final OperationObserver<CacheOperationOutcomes.GetAllOutcome> getAllObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.GetAllOutcome.class).named("getAll")).of(this)).tag("cache")).build();
    protected final OperationObserver<CacheOperationOutcomes.PutOutcome> putObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.PutOutcome.class).named("put")).of(this)).tag("cache")).build();
    protected final OperationObserver<CacheOperationOutcomes.PutAllOutcome> putAllObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.PutAllOutcome.class).named("putAll")).of(this)).tag("cache")).build();
    protected final OperationObserver<CacheOperationOutcomes.RemoveOutcome> removeObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.RemoveOutcome.class).named("remove")).of(this)).tag("cache")).build();
    protected final OperationObserver<CacheOperationOutcomes.RemoveAllOutcome> removeAllObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.RemoveAllOutcome.class).named("removeAll")).of(this)).tag("cache")).build();
    protected final OperationObserver<CacheOperationOutcomes.ConditionalRemoveOutcome> conditionalRemoveObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.ConditionalRemoveOutcome.class).named("conditionalRemove")).of(this)).tag("cache")).build();
    protected final OperationObserver<CacheOperationOutcomes.PutIfAbsentOutcome> putIfAbsentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.PutIfAbsentOutcome.class).named("putIfAbsent")).of(this)).tag("cache")).build();
    protected final OperationObserver<CacheOperationOutcomes.ReplaceOutcome> replaceObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.ReplaceOutcome.class).named("replace")).of(this)).tag("cache")).build();
    protected final OperationObserver<CacheOperationOutcomes.ClearOutcome> clearObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.ClearOutcome.class).named("clear")).of(this)).tag("cache")).build();
    protected final Map<BulkOps, LongAdder> bulkMethodEntries = new EnumMap<BulkOps, LongAdder>(BulkOps.class);

    EhcacheBase(EhcacheRuntimeConfiguration<K, V> runtimeConfiguration, Store<K, V> store, ResilienceStrategy<K, V> resilienceStrategy, CacheEventDispatcher<K, V> eventDispatcher, Logger logger, StatusTransitioner statusTransitioner) {
        this.store = store;
        runtimeConfiguration.addCacheConfigurationListener(store.getConfigurationChangeListeners());
        StatisticsManager.associate(store).withParent(this);
        this.resilienceStrategy = resilienceStrategy;
        this.runtimeConfiguration = runtimeConfiguration;
        runtimeConfiguration.addCacheConfigurationListener(eventDispatcher.getConfigurationChangeListeners());
        this.logger = logger;
        this.statusTransitioner = statusTransitioner;
        for (BulkOps bulkOp : BulkOps.values()) {
            this.bulkMethodEntries.put(bulkOp, new LongAdder());
        }
    }

    @Override
    public V get(K key) {
        this.getObserver.begin();
        try {
            this.statusTransitioner.checkAvailable();
            EhcacheBase.checkNonNull(key);
            try {
                Store.ValueHolder<V> valueHolder = this.doGet(key);
                if (valueHolder == null) {
                    this.getObserver.end(CacheOperationOutcomes.GetOutcome.MISS);
                    return null;
                }
                this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
                return valueHolder.get();
            }
            catch (StoreAccessException e) {
                V value = this.resilienceStrategy.getFailure(key, e);
                this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
                return value;
            }
        }
        catch (Throwable e) {
            this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
            throw e;
        }
    }

    protected abstract Store.ValueHolder<V> doGet(K var1) throws StoreAccessException;

    protected V getNoLoader(K key) {
        this.getObserver.begin();
        try {
            this.statusTransitioner.checkAvailable();
            EhcacheBase.checkNonNull(key);
            try {
                Store.ValueHolder<V> valueHolder = this.store.get(key);
                if (valueHolder == null) {
                    this.getObserver.end(CacheOperationOutcomes.GetOutcome.MISS);
                    return null;
                }
                this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
                return valueHolder.get();
            }
            catch (StoreAccessException e) {
                V value = this.resilienceStrategy.getFailure(key, e);
                this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
                return value;
            }
        }
        catch (Throwable e) {
            this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
            throw e;
        }
    }

    @Override
    public void put(K key, V value) {
        this.putObserver.begin();
        try {
            this.statusTransitioner.checkAvailable();
            EhcacheBase.checkNonNull(key, value);
            try {
                Store.PutStatus status = this.doPut(key, value);
                switch (status) {
                    case PUT: {
                        this.putObserver.end(CacheOperationOutcomes.PutOutcome.PUT);
                        break;
                    }
                    case NOOP: {
                        this.putObserver.end(CacheOperationOutcomes.PutOutcome.NOOP);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Invalid Status.");
                    }
                }
            }
            catch (StoreAccessException e) {
                this.resilienceStrategy.putFailure(key, value, e);
                this.putObserver.end(CacheOperationOutcomes.PutOutcome.FAILURE);
            }
        }
        catch (Throwable e) {
            this.putObserver.end(CacheOperationOutcomes.PutOutcome.FAILURE);
            throw e;
        }
    }

    protected abstract Store.PutStatus doPut(K var1, V var2) throws StoreAccessException;

    @Override
    public boolean containsKey(K key) {
        this.statusTransitioner.checkAvailable();
        EhcacheBase.checkNonNull(key);
        try {
            return this.store.containsKey(key);
        }
        catch (StoreAccessException e) {
            return this.resilienceStrategy.containsKeyFailure(key, e);
        }
    }

    @Override
    public void remove(K key) throws CacheWritingException {
        this.removeInternal(key);
    }

    protected boolean removeInternal(K key) {
        this.removeObserver.begin();
        try {
            this.statusTransitioner.checkAvailable();
            EhcacheBase.checkNonNull(key);
            boolean removed = false;
            try {
                removed = this.doRemoveInternal(key);
                if (removed) {
                    this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.SUCCESS);
                } else {
                    this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.NOOP);
                }
            }
            catch (StoreAccessException e) {
                this.resilienceStrategy.removeFailure(key, e);
                this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.FAILURE);
            }
            return removed;
        }
        catch (Throwable e) {
            this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.FAILURE);
            throw e;
        }
    }

    protected abstract boolean doRemoveInternal(K var1) throws StoreAccessException;

    @Override
    public void clear() {
        this.clearObserver.begin();
        try {
            this.statusTransitioner.checkAvailable();
            try {
                this.store.clear();
                this.clearObserver.end(CacheOperationOutcomes.ClearOutcome.SUCCESS);
            }
            catch (StoreAccessException e) {
                this.resilienceStrategy.clearFailure(e);
                this.clearObserver.end(CacheOperationOutcomes.ClearOutcome.FAILURE);
            }
        }
        catch (Throwable e) {
            this.clearObserver.end(CacheOperationOutcomes.ClearOutcome.FAILURE);
            throw e;
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.putIfAbsentObserver.begin();
        try {
            this.statusTransitioner.checkAvailable();
            EhcacheBase.checkNonNull(key, value);
            boolean[] put = new boolean[]{false};
            try {
                Store.ValueHolder<V> inCache = this.doPutIfAbsent(key, value, b -> {
                    put[0] = b;
                });
                if (put[0]) {
                    this.putIfAbsentObserver.end(CacheOperationOutcomes.PutIfAbsentOutcome.PUT);
                    return null;
                }
                this.putIfAbsentObserver.end(CacheOperationOutcomes.PutIfAbsentOutcome.HIT);
                return inCache.get();
            }
            catch (StoreAccessException e) {
                V newValue = this.resilienceStrategy.putIfAbsentFailure(key, value, e);
                this.putIfAbsentObserver.end(CacheOperationOutcomes.PutIfAbsentOutcome.FAILURE);
                return newValue;
            }
        }
        catch (Throwable e) {
            this.putIfAbsentObserver.end(CacheOperationOutcomes.PutIfAbsentOutcome.FAILURE);
            throw e;
        }
    }

    protected abstract Store.ValueHolder<V> doPutIfAbsent(K var1, V var2, Consumer<Boolean> var3) throws StoreAccessException;

    @Override
    public Iterator<Cache.Entry<K, V>> iterator() {
        this.statusTransitioner.checkAvailable();
        return new CacheEntryIterator();
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys) throws BulkCacheLoadingException {
        return this.getAllInternal(keys, true);
    }

    protected Map<K, V> getAllInternal(Set<? extends K> keys, boolean includeNulls) {
        this.getAllObserver.begin();
        try {
            this.statusTransitioner.checkAvailable();
            this.checkNonNullContent(keys);
            if (keys.isEmpty()) {
                this.getAllObserver.end(CacheOperationOutcomes.GetAllOutcome.SUCCESS);
                return Collections.emptyMap();
            }
            try {
                Map<? extends K, V> result = this.doGetAllInternal(keys, includeNulls);
                this.getAllObserver.end(CacheOperationOutcomes.GetAllOutcome.SUCCESS);
                return result;
            }
            catch (StoreAccessException e) {
                Map<? extends K, V> result = this.resilienceStrategy.getAllFailure(keys, e);
                this.getAllObserver.end(CacheOperationOutcomes.GetAllOutcome.FAILURE);
                return result;
            }
        }
        catch (Throwable e) {
            this.getAllObserver.end(CacheOperationOutcomes.GetAllOutcome.FAILURE);
            throw e;
        }
    }

    protected abstract Map<K, V> doGetAllInternal(Set<? extends K> var1, boolean var2) throws StoreAccessException;

    @Override
    public void putAll(Map<? extends K, ? extends V> entries) throws BulkCacheWritingException {
        this.putAllObserver.begin();
        try {
            this.statusTransitioner.checkAvailable();
            EhcacheBase.checkNonNull(entries);
            if (entries.isEmpty()) {
                this.putAllObserver.end(CacheOperationOutcomes.PutAllOutcome.SUCCESS);
                return;
            }
            try {
                this.doPutAll(entries);
                this.putAllObserver.end(CacheOperationOutcomes.PutAllOutcome.SUCCESS);
            }
            catch (StoreAccessException e) {
                this.resilienceStrategy.putAllFailure(entries, e);
                this.putAllObserver.end(CacheOperationOutcomes.PutAllOutcome.FAILURE);
            }
        }
        catch (Exception e) {
            this.putAllObserver.end(CacheOperationOutcomes.PutAllOutcome.FAILURE);
            throw e;
        }
    }

    protected abstract void doPutAll(Map<? extends K, ? extends V> var1) throws StoreAccessException, BulkCacheWritingException;

    protected boolean newValueAlreadyExpired(K key, V oldValue, V newValue) {
        return EhcacheBase.newValueAlreadyExpired(this.logger, this.runtimeConfiguration.getExpiryPolicy(), key, oldValue, newValue);
    }

    @Override
    public void removeAll(Set<? extends K> keys) throws BulkCacheWritingException {
        this.removeAllObserver.begin();
        try {
            this.statusTransitioner.checkAvailable();
            EhcacheBase.checkNonNull(keys);
            if (keys.isEmpty()) {
                this.removeAllObserver.end(CacheOperationOutcomes.RemoveAllOutcome.SUCCESS);
                return;
            }
            for (K key : keys) {
                if (key != null) continue;
                throw new NullPointerException();
            }
            try {
                this.doRemoveAll(keys);
                this.removeAllObserver.end(CacheOperationOutcomes.RemoveAllOutcome.SUCCESS);
            }
            catch (StoreAccessException e) {
                this.resilienceStrategy.removeAllFailure(keys, e);
                this.removeAllObserver.end(CacheOperationOutcomes.RemoveAllOutcome.FAILURE);
            }
        }
        catch (Throwable e) {
            this.removeAllObserver.end(CacheOperationOutcomes.RemoveAllOutcome.FAILURE);
            throw e;
        }
    }

    protected abstract void doRemoveAll(Set<? extends K> var1) throws BulkCacheWritingException, StoreAccessException;

    protected static <K, V> boolean newValueAlreadyExpired(Logger logger, ExpiryPolicy<? super K, ? super V> expiry, K key, V oldValue, V newValue) {
        Duration duration;
        if (newValue == null) {
            return false;
        }
        try {
            duration = oldValue == null ? expiry.getExpiryForCreation(key, newValue) : expiry.getExpiryForUpdate(key, () -> oldValue, newValue);
        }
        catch (RuntimeException re) {
            logger.error("Expiry computation caused an exception - Expiry duration will be 0 ", re);
            return true;
        }
        return Duration.ZERO.equals(duration);
    }

    @Override
    public boolean remove(K key, V value) {
        this.conditionalRemoveObserver.begin();
        try {
            this.statusTransitioner.checkAvailable();
            EhcacheBase.checkNonNull(key, value);
            try {
                Store.RemoveStatus status = this.doRemove(key, value);
                switch (status) {
                    case REMOVED: {
                        this.conditionalRemoveObserver.end(CacheOperationOutcomes.ConditionalRemoveOutcome.SUCCESS);
                        return true;
                    }
                    case KEY_MISSING: {
                        this.conditionalRemoveObserver.end(CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE_KEY_MISSING);
                        return false;
                    }
                    case KEY_PRESENT: {
                        this.conditionalRemoveObserver.end(CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE_KEY_PRESENT);
                        return false;
                    }
                }
                throw new AssertionError((Object)("Invalid Status: " + (Object)((Object)status)));
            }
            catch (StoreAccessException e) {
                boolean removed = this.resilienceStrategy.removeFailure(key, value, e);
                this.conditionalRemoveObserver.end(CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE);
                return removed;
            }
        }
        catch (Throwable e) {
            this.conditionalRemoveObserver.end(CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE);
            throw e;
        }
    }

    protected abstract Store.RemoveStatus doRemove(K var1, V var2) throws StoreAccessException;

    @Override
    public V replace(K key, V value) {
        this.replaceObserver.begin();
        try {
            this.statusTransitioner.checkAvailable();
            EhcacheBase.checkNonNull(key, value);
            try {
                V result = this.doReplace(key, value);
                if (result == null) {
                    this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.MISS_NOT_PRESENT);
                } else {
                    this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.HIT);
                }
                return result;
            }
            catch (StoreAccessException e) {
                V result = this.resilienceStrategy.replaceFailure(key, value, e);
                this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.FAILURE);
                return result;
            }
        }
        catch (Throwable e) {
            this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.FAILURE);
            throw e;
        }
    }

    protected abstract V doReplace(K var1, V var2) throws StoreAccessException;

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.replaceObserver.begin();
        try {
            this.statusTransitioner.checkAvailable();
            EhcacheBase.checkNonNull(key, oldValue, newValue);
            try {
                Store.ReplaceStatus status = this.doReplace(key, oldValue, newValue);
                switch (status) {
                    case HIT: {
                        this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.HIT);
                        return true;
                    }
                    case MISS_PRESENT: {
                        this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.MISS_PRESENT);
                        return false;
                    }
                    case MISS_NOT_PRESENT: {
                        this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.MISS_NOT_PRESENT);
                        return false;
                    }
                }
                throw new AssertionError((Object)("Invalid Status:" + (Object)((Object)status)));
            }
            catch (StoreAccessException e) {
                boolean success = this.resilienceStrategy.replaceFailure(key, oldValue, newValue, e);
                this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.FAILURE);
                return success;
            }
        }
        catch (Throwable e) {
            this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.FAILURE);
            throw e;
        }
    }

    protected abstract Store.ReplaceStatus doReplace(K var1, V var2, V var3) throws StoreAccessException;

    @Override
    public CacheRuntimeConfiguration<K, V> getRuntimeConfiguration() {
        return this.runtimeConfiguration;
    }

    @Override
    public void init() {
        this.statusTransitioner.init().succeeded();
    }

    @Override
    public void close() {
        this.statusTransitioner.close().succeeded();
    }

    @Override
    public Status getStatus() {
        return this.statusTransitioner.currentStatus();
    }

    @Override
    public void addHook(LifeCycled hook) {
        this.statusTransitioner.addHook(hook);
    }

    void removeHook(LifeCycled hook) {
        this.statusTransitioner.removeHook(hook);
    }

    protected void addBulkMethodEntriesCount(BulkOps op, long count) {
        this.bulkMethodEntries.get((Object)op).add(count);
    }

    @Override
    public Map<BulkOps, LongAdder> getBulkMethodEntries() {
        return this.bulkMethodEntries;
    }

    protected static void checkNonNull(Object thing) {
        Objects.requireNonNull(thing);
    }

    protected static void checkNonNull(Object ... things) {
        for (Object thing : things) {
            EhcacheBase.checkNonNull(thing);
        }
    }

    protected void checkNonNullContent(Collection<?> collectionOfThings) {
        EhcacheBase.checkNonNull(collectionOfThings);
        for (Object thing : collectionOfThings) {
            EhcacheBase.checkNonNull(thing);
        }
    }

    private static class ValueHolderBasedEntry<K, V>
    implements Cache.Entry<K, V> {
        private final Cache.Entry<K, Store.ValueHolder<V>> storeEntry;

        ValueHolderBasedEntry(Cache.Entry<K, Store.ValueHolder<V>> storeEntry) {
            this.storeEntry = storeEntry;
        }

        @Override
        public K getKey() {
            return this.storeEntry.getKey();
        }

        @Override
        public V getValue() {
            return this.storeEntry.getValue().get();
        }
    }

    private class CacheEntryIterator
    implements Iterator<Cache.Entry<K, V>> {
        private final Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator;
        private Cache.Entry<K, Store.ValueHolder<V>> current;
        private Cache.Entry<K, Store.ValueHolder<V>> next;
        private StoreAccessException nextException;

        public CacheEntryIterator() {
            this.iterator = EhcacheBase.this.store.iterator();
            this.advance();
        }

        private void advance() {
            try {
                while (this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                    if (this.next == null) continue;
                    return;
                }
                this.next = null;
            }
            catch (RuntimeException re) {
                this.nextException = new StoreAccessException(re);
                this.next = null;
            }
            catch (StoreAccessException cae) {
                this.nextException = cae;
                this.next = null;
            }
        }

        @Override
        public boolean hasNext() {
            EhcacheBase.this.statusTransitioner.checkAvailable();
            return this.nextException != null || this.next != null;
        }

        @Override
        public Cache.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            EhcacheBase.this.getObserver.begin();
            if (this.nextException == null) {
                EhcacheBase.this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
                this.current = this.next;
                this.advance();
                return new ValueHolderBasedEntry(this.current);
            }
            EhcacheBase.this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
            StoreAccessException cae = this.nextException;
            this.nextException = null;
            return EhcacheBase.this.resilienceStrategy.iteratorFailure(cae);
        }

        @Override
        public void remove() {
            EhcacheBase.this.statusTransitioner.checkAvailable();
            if (this.current == null) {
                throw new IllegalStateException("No current element");
            }
            EhcacheBase.this.remove(this.current.getKey(), this.current.getValue().get());
            this.current = null;
        }
    }

    protected abstract class Jsr107CacheBase
    implements Jsr107Cache<K, V> {
        protected Jsr107CacheBase() {
        }

        @Override
        public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, Function<Iterable<? extends K>, Map<K, V>> loadFunction) {
            if (keys.isEmpty()) {
                return;
            }
            if (replaceExistingValues) {
                this.loadAllReplace(keys, loadFunction);
            } else {
                this.loadAllAbsent(keys, loadFunction);
            }
        }

        @Override
        public Iterator<Cache.Entry<K, V>> specIterator() {
            return new SpecIterator(this, EhcacheBase.this.store);
        }

        @Override
        public V getNoLoader(K key) {
            return EhcacheBase.this.getNoLoader(key);
        }

        @Override
        public Map<K, V> getAll(Set<? extends K> keys) {
            return EhcacheBase.this.getAllInternal(keys, false);
        }

        private void loadAllAbsent(Set<? extends K> keys, Function<Iterable<? extends K>, Map<K, V>> loadFunction) {
            try {
                EhcacheBase.this.store.bulkComputeIfAbsent(keys, absentKeys -> this.cacheLoaderWriterLoadAllForKeys((Iterable)absentKeys, loadFunction).entrySet());
            }
            catch (StoreAccessException e) {
                throw ExceptionFactory.newCacheLoadingException(e);
            }
        }

        Map<K, V> cacheLoaderWriterLoadAllForKeys(Iterable<? extends K> keys, Function<Iterable<? extends K>, Map<K, V>> loadFunction) {
            try {
                Map loaded = loadFunction.apply(keys);
                LinkedHashMap rv = new LinkedHashMap();
                for (Object key : keys) {
                    rv.put(key, loaded.get(key));
                }
                return rv;
            }
            catch (Exception e) {
                throw ExceptionFactory.newCacheLoadingException(e);
            }
        }

        private void loadAllReplace(Set<? extends K> keys, Function<Iterable<? extends K>, Map<K, V>> loadFunction) {
            try {
                EhcacheBase.this.store.bulkCompute(keys, entries -> {
                    ArrayList keys1 = new ArrayList();
                    for (Map.Entry entry : entries) {
                        keys1.add(entry.getKey());
                    }
                    return this.cacheLoaderWriterLoadAllForKeys(keys1, loadFunction).entrySet();
                });
            }
            catch (StoreAccessException e) {
                throw ExceptionFactory.newCacheLoadingException(e);
            }
        }

        @Override
        public boolean remove(K key) {
            return EhcacheBase.this.removeInternal(key);
        }

        @Override
        public void removeAll() {
            ArrayList<StoreAccessException> failures = new ArrayList<StoreAccessException>();
            Store.Iterator iterator = EhcacheBase.this.store.iterator();
            while (iterator.hasNext()) {
                try {
                    Cache.Entry next = iterator.next();
                    this.remove(next.getKey());
                }
                catch (StoreAccessException cae) {
                    failures.add(cae);
                }
            }
            if (!failures.isEmpty()) {
                StoreAccessException removeAllFailure = new StoreAccessException("Iteration failures may have prevented a complete removal");
                failures.forEach(removeAllFailure::addSuppressed);
                EhcacheBase.this.resilienceStrategy.clearFailure(removeAllFailure);
            }
        }
    }
}

