/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core;

import com.hundsun.lightdb.shaded.org.slf4j.Logger;
import com.hundsun.lightdb.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.ehcache.Cache;
import org.ehcache.CachePersistenceException;
import org.ehcache.PersistentCacheManager;
import org.ehcache.Status;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.ResourceType;
import org.ehcache.core.DefaultCacheManagerProviderService;
import org.ehcache.core.Ehcache;
import org.ehcache.core.InternalCache;
import org.ehcache.core.StatusTransitioner;
import org.ehcache.core.config.DefaultConfiguration;
import org.ehcache.core.config.store.StoreEventSourceConfiguration;
import org.ehcache.core.config.store.StoreStatisticsConfiguration;
import org.ehcache.core.events.CacheEventDispatcher;
import org.ehcache.core.events.CacheEventDispatcherFactory;
import org.ehcache.core.events.CacheEventListenerConfiguration;
import org.ehcache.core.events.CacheEventListenerProvider;
import org.ehcache.core.events.CacheManagerListener;
import org.ehcache.core.resilience.DefaultRecoveryStore;
import org.ehcache.core.spi.LifeCycled;
import org.ehcache.core.spi.LifeCycledAdapter;
import org.ehcache.core.spi.ServiceLocator;
import org.ehcache.core.spi.service.CacheManagerProviderService;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.core.spi.store.InternalCacheManager;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.store.StoreConfigurationImpl;
import org.ehcache.core.store.StoreSupport;
import org.ehcache.core.util.ClassLoading;
import org.ehcache.event.CacheEventListener;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.loaderwriter.CacheLoaderWriterConfiguration;
import org.ehcache.spi.loaderwriter.CacheLoaderWriterProvider;
import org.ehcache.spi.loaderwriter.WriteBehindProvider;
import org.ehcache.spi.persistence.PersistableResourceService;
import org.ehcache.spi.resilience.ResilienceStrategy;
import org.ehcache.spi.resilience.ResilienceStrategyProvider;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.UnsupportedTypeException;
import org.ehcache.spi.service.MaintainableService;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.spi.service.ServiceProvider;

public class EhcacheManager
implements PersistentCacheManager,
InternalCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheManager.class);
    private final DefaultConfiguration configuration;
    private final ClassLoader cacheManagerClassLoader;
    private final boolean useLoaderInAtomics;
    private final ConcurrentMap<String, CacheHolder> caches = new ConcurrentHashMap<String, CacheHolder>();
    private final CopyOnWriteArrayList<CacheManagerListener> listeners = new CopyOnWriteArrayList();
    private final StatusTransitioner statusTransitioner = new StatusTransitioner(LOGGER);
    private final String simpleName;
    protected final ServiceLocator serviceLocator;

    public EhcacheManager(Configuration config) {
        this(config, Collections.emptyList(), true);
    }

    public EhcacheManager(Configuration config, Collection<Service> services) {
        this(config, services, true);
    }

    public EhcacheManager(Configuration config, Collection<Service> services, boolean useLoaderInAtomics) {
        this(config, dependencies -> dependencies.with(services), useLoaderInAtomics);
    }

    public EhcacheManager(Configuration config, UnaryOperator<ServiceLocator.DependencySet> customization, boolean useLoaderInAtomics) {
        String simpleName = this.getClass().getSimpleName();
        this.simpleName = simpleName.isEmpty() ? this.getClass().getName() : simpleName;
        this.configuration = new DefaultConfiguration(config);
        this.cacheManagerClassLoader = config.getClassLoader() != null ? config.getClassLoader() : ClassLoading.getDefaultClassLoader();
        this.useLoaderInAtomics = useLoaderInAtomics;
        this.validateServicesConfigs();
        this.serviceLocator = this.resolveServices(customization);
    }

    private void validateServicesConfigs() {
        HashSet classes = new HashSet();
        for (ServiceCreationConfiguration<?, ?> service : this.configuration.getServiceCreationConfigurations()) {
            if (classes.add(service.getServiceType())) continue;
            throw new IllegalStateException("Duplicate creation configuration for service " + service.getServiceType());
        }
    }

    private ServiceLocator resolveServices(UnaryOperator<ServiceLocator.DependencySet> customization) {
        ServiceLocator.DependencySet builder = ServiceLocator.dependencySet().with(Store.Provider.class).with(CacheLoaderWriterProvider.class).with(WriteBehindProvider.class).with(CacheEventDispatcherFactory.class).with(CacheEventListenerProvider.class).with(ResilienceStrategyProvider.class);
        if (!(builder = (ServiceLocator.DependencySet)customization.apply(builder)).contains(CacheManagerProviderService.class)) {
            builder = builder.with(new DefaultCacheManagerProviderService(this));
        }
        for (ServiceCreationConfiguration<?, ?> serviceConfig : this.configuration.getServiceCreationConfigurations()) {
            builder = builder.with(serviceConfig);
        }
        return builder.build();
    }

    StatusTransitioner getStatusTransitioner() {
        return this.statusTransitioner;
    }

    @Override
    public <K, V> Cache<K, V> getCache(String alias, Class<K> keyType, Class<V> valueType) {
        this.statusTransitioner.checkAvailable();
        CacheHolder cacheHolder = (CacheHolder)this.caches.get(alias);
        if (cacheHolder == null) {
            return null;
        }
        try {
            return cacheHolder.retrieve(keyType, valueType);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cache '" + alias + "' type is <" + cacheHolder.keyType.getName() + ", " + cacheHolder.valueType.getName() + ">, but you retrieved it with <" + keyType.getName() + ", " + valueType.getName() + ">");
        }
    }

    @Override
    public void removeCache(String alias) {
        if (alias == null) {
            throw new NullPointerException("Alias cannot be null");
        }
        this.removeCache(alias, true);
    }

    private void removeCache(String alias, boolean removeFromConfig) {
        this.statusTransitioner.checkAvailable();
        CacheHolder cacheHolder = (CacheHolder)this.caches.remove(alias);
        if (cacheHolder != null) {
            InternalCache ehcache = cacheHolder.retrieve(cacheHolder.keyType, cacheHolder.valueType);
            if (ehcache != null) {
                if (removeFromConfig) {
                    this.configuration.removeCacheConfiguration(alias);
                }
                if (!this.statusTransitioner.isTransitioning()) {
                    for (CacheManagerListener listener : this.listeners) {
                        listener.cacheRemoved(alias, ehcache);
                    }
                }
                ehcache.close();
                this.closeEhcache(alias, ehcache);
            }
            LOGGER.info("Cache '{}' removed from {}.", (Object)alias, (Object)this.simpleName);
        }
    }

    protected void closeEhcache(String alias, InternalCache<?, ?> ehcache) {
        for (ResourceType<?> resourceType : ehcache.getRuntimeConfiguration().getResourcePools().getResourceTypeSet()) {
            Object resourcePool;
            if (!resourceType.isPersistable() || (resourcePool = ehcache.getRuntimeConfiguration().getResourcePools().getPoolForResource(resourceType)).isPersistent()) continue;
            PersistableResourceService persistableResourceService = this.getPersistableResourceService(resourceType);
            try {
                persistableResourceService.destroy(alias);
            }
            catch (CachePersistenceException e) {
                LOGGER.warn("Unable to clear persistence space for cache {}", (Object)alias, (Object)e);
            }
        }
    }

    @Override
    public <K, V> Cache<K, V> createCache(String alias, Builder<? extends CacheConfiguration<K, V>> configBuilder) {
        return this.createCache(alias, configBuilder.build());
    }

    @Override
    public <K, V> Cache<K, V> createCache(String alias, CacheConfiguration<K, V> config) throws IllegalArgumentException {
        return this.createCache(alias, config, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <K, V> Cache<K, V> createCache(String alias, CacheConfiguration<K, V> originalConfig, boolean addToConfig) throws IllegalArgumentException {
        this.statusTransitioner.checkAvailable();
        LOGGER.debug("Creating Cache '{}' in {}.", (Object)alias, (Object)this.simpleName);
        CacheConfiguration<K, V> config = this.adjustConfigurationWithCacheManagerDefaults(alias, originalConfig);
        Class<K> keyType = config.getKeyType();
        Class<V> valueType = config.getValueType();
        CacheHolder value = new CacheHolder(keyType, valueType);
        if (this.caches.putIfAbsent(alias, value) != null) {
            throw new IllegalArgumentException("Cache '" + alias + "' already exists");
        }
        InternalCache<K, V> cache = null;
        boolean success = false;
        RuntimeException failure = null;
        try {
            cache = this.createNewEhcache(alias, config, keyType, valueType);
            cache.init();
            if (addToConfig) {
                this.configuration.addCacheConfiguration(alias, cache.getRuntimeConfiguration());
            } else {
                this.configuration.replaceCacheConfiguration(alias, originalConfig, cache.getRuntimeConfiguration());
            }
            success = true;
        }
        catch (RuntimeException e) {
            failure = e;
        }
        finally {
            if (!success) {
                this.caches.remove(alias);
                value.setCache(null);
            }
        }
        if (failure != null) throw new IllegalStateException("Cache '" + alias + "' creation in " + this.simpleName + " failed.", failure);
        try {
            if (!this.statusTransitioner.isTransitioning()) {
                for (CacheManagerListener listener : this.listeners) {
                    listener.cacheAdded(alias, cache);
                }
            }
        }
        finally {
            value.setCache(cache);
        }
        LOGGER.info("Cache '{}' created in {}.", (Object)alias, (Object)this.simpleName);
        return cache;
    }

    <K, V> InternalCache<K, V> createNewEhcache(final String alias, CacheConfiguration<K, V> config, Class<K> keyType, Class<V> valueType) {
        CacheLoaderWriter<K, V> loaderWriter;
        ArrayList adjustedServiceConfigs = new ArrayList(config.getServiceConfigurations());
        ArrayList<ServiceConfiguration> unknownServiceConfigs = new ArrayList<ServiceConfiguration>();
        for (ServiceConfiguration serviceConfiguration : adjustedServiceConfigs) {
            if (this.serviceLocator.knowsServiceFor(serviceConfiguration)) continue;
            unknownServiceConfigs.add(serviceConfiguration);
        }
        if (!unknownServiceConfigs.isEmpty()) {
            throw new IllegalStateException("Cannot find service(s) that can handle following configuration(s) : " + unknownServiceConfigs);
        }
        ArrayList<LifeCycled> lifeCycledList = new ArrayList<LifeCycled>();
        final CacheLoaderWriterProvider cacheLoaderWriterProvider = this.serviceLocator.getService(CacheLoaderWriterProvider.class);
        if (cacheLoaderWriterProvider != null) {
            loaderWriter = cacheLoaderWriterProvider.createCacheLoaderWriter(alias, config);
            if (loaderWriter != null) {
                lifeCycledList.add(new LifeCycledAdapter(){

                    @Override
                    public void close() throws Exception {
                        cacheLoaderWriterProvider.releaseCacheLoaderWriter(alias, loaderWriter);
                    }
                });
            }
        } else {
            loaderWriter = null;
        }
        Store<K, V> store = this.getStore(alias, config, keyType, valueType, adjustedServiceConfigs, lifeCycledList, loaderWriter);
        final CacheEventDispatcherFactory cenlProvider = this.serviceLocator.getService(CacheEventDispatcherFactory.class);
        final CacheEventDispatcher<K, V> evtService = cenlProvider.createCacheEventDispatcher(store, adjustedServiceConfigs.toArray(new ServiceConfiguration[adjustedServiceConfigs.size()]));
        lifeCycledList.add(new LifeCycledAdapter(){

            @Override
            public void close() {
                cenlProvider.releaseCacheEventDispatcher(evtService);
            }
        });
        evtService.setStoreEventSource(store.getStoreEventSource());
        ResilienceStrategyProvider resilienceProvider = this.serviceLocator.getService(ResilienceStrategyProvider.class);
        ResilienceStrategy<K, V> resilienceStrategy = loaderWriter == null ? resilienceProvider.createResilienceStrategy(alias, config, new DefaultRecoveryStore<K>(store)) : resilienceProvider.createResilienceStrategy(alias, config, new DefaultRecoveryStore<K>(store), loaderWriter);
        Ehcache<K, V> cache = new Ehcache<K, V>(config, store, resilienceStrategy, evtService, LoggerFactory.getLogger(Ehcache.class + "-" + alias), loaderWriter);
        final CacheEventListenerProvider evntLsnrFactory = this.serviceLocator.getService(CacheEventListenerProvider.class);
        if (evntLsnrFactory != null) {
            Collection<CacheEventListenerConfiguration> evtLsnrConfigs = ServiceUtils.findAmongst(CacheEventListenerConfiguration.class, config.getServiceConfigurations());
            for (CacheEventListenerConfiguration lsnrConfig : evtLsnrConfigs) {
                final CacheEventListener lsnr = evntLsnrFactory.createEventListener(alias, lsnrConfig);
                if (lsnr == null) continue;
                cache.getRuntimeConfiguration().registerCacheEventListener(lsnr, lsnrConfig.orderingMode(), lsnrConfig.firingMode(), lsnrConfig.fireOn());
                lifeCycledList.add(new LifeCycled(){

                    @Override
                    public void init() {
                    }

                    @Override
                    public void close() throws Exception {
                        evntLsnrFactory.releaseEventListener(lsnr);
                    }
                });
            }
            evtService.setListenerSource(cache);
        }
        for (LifeCycled lifeCycled : lifeCycledList) {
            cache.addHook(lifeCycled);
        }
        return cache;
    }

    protected <K, V> Store<K, V> getStore(String alias, CacheConfiguration<K, V> config, Class<K> keyType, Class<V> valueType, Collection<ServiceConfiguration<?, ?>> serviceConfigs, List<LifeCycled> lifeCycledList, CacheLoaderWriter<? super K, V> loaderWriter) {
        Set<ResourceType<?>> resourceTypes = config.getResourcePools().getResourceTypeSet();
        for (ResourceType<?> resourceType : resourceTypes) {
            if (!resourceType.isPersistable()) continue;
            final PersistableResourceService persistableResourceService = this.getPersistableResourceService(resourceType);
            try {
                final PersistableResourceService.PersistenceSpaceIdentifier<?> spaceIdentifier = persistableResourceService.getPersistenceSpaceIdentifier(alias, config);
                serviceConfigs.add(spaceIdentifier);
                lifeCycledList.add(new LifeCycledAdapter(){

                    @Override
                    public void close() throws Exception {
                        persistableResourceService.releasePersistenceSpaceIdentifier(spaceIdentifier);
                    }
                });
            }
            catch (CachePersistenceException e) {
                throw new RuntimeException("Unable to handle persistence", e);
            }
        }
        Serializer<K> keySerializer = null;
        Serializer<V> valueSerializer = null;
        final SerializationProvider serialization = this.serviceLocator.getService(SerializationProvider.class);
        ServiceConfiguration[] serviceConfigArray = serviceConfigs.toArray(new ServiceConfiguration[serviceConfigs.size()]);
        if (serialization != null) {
            try {
                final Serializer<K> keySer = serialization.createKeySerializer(keyType, config.getClassLoader(), serviceConfigArray);
                lifeCycledList.add(new LifeCycledAdapter(){

                    @Override
                    public void close() throws Exception {
                        serialization.releaseSerializer(keySer);
                    }
                });
                keySerializer = keySer;
            }
            catch (UnsupportedTypeException e) {
                for (ResourceType<?> resource : resourceTypes) {
                    if (!resource.requiresSerialization()) continue;
                    throw new RuntimeException(e);
                }
                LOGGER.debug("Could not create serializers for {}", (Object)alias, (Object)e);
            }
            try {
                final Serializer<V> valueSer = serialization.createValueSerializer(valueType, config.getClassLoader(), serviceConfigArray);
                lifeCycledList.add(new LifeCycledAdapter(){

                    @Override
                    public void close() throws Exception {
                        serialization.releaseSerializer(valueSer);
                    }
                });
                valueSerializer = valueSer;
            }
            catch (UnsupportedTypeException e) {
                for (ResourceType<?> resource : resourceTypes) {
                    if (!resource.requiresSerialization()) continue;
                    throw new RuntimeException(e);
                }
                LOGGER.debug("Could not create serializers for {}", (Object)alias, (Object)e);
            }
        }
        Collection<ServiceConfiguration<?, ?>> serviceConfigurations = config.getServiceConfigurations();
        int dispatcherConcurrency = ServiceUtils.findOptionalAmongst(StoreEventSourceConfiguration.class, serviceConfigurations).map(StoreEventSourceConfiguration::getDispatcherConcurrency).orElse(1);
        boolean operationStatisticsEnabled = ServiceUtils.findOptionalAmongst(StoreStatisticsConfiguration.class, serviceConfigurations).map(StoreStatisticsConfiguration::isOperationStatisticsEnabled).orElseGet(() -> config.getResourcePools().getResourceTypeSet().size() > 1);
        StoreConfigurationImpl<? super K, V> storeConfiguration = new StoreConfigurationImpl<K, V>(config, dispatcherConcurrency, operationStatisticsEnabled, keySerializer, valueSerializer, loaderWriter, this.useLoaderInAtomics);
        Store.Provider storeProvider = StoreSupport.selectWrapperStoreProvider(this.serviceLocator, serviceConfigs);
        if (storeProvider == null) {
            storeProvider = StoreSupport.selectStoreProvider(this.serviceLocator, resourceTypes, serviceConfigs);
        }
        final Store<? super K, V> store = storeProvider.createStore(storeConfiguration, serviceConfigArray);
        final AtomicReference<Store.Provider> storeProviderRef = new AtomicReference<Store.Provider>(storeProvider);
        lifeCycledList.add(new LifeCycled(){

            @Override
            public void init() {
                ((Store.Provider)storeProviderRef.get()).initStore(store);
            }

            @Override
            public void close() {
                ((Store.Provider)storeProviderRef.get()).releaseStore(store);
            }
        });
        return store;
    }

    private PersistableResourceService getPersistableResourceService(ResourceType<?> resourceType) {
        Collection<PersistableResourceService> services = this.serviceLocator.getServicesOfType(PersistableResourceService.class);
        for (PersistableResourceService service : services) {
            if (!service.handlesResourceType(resourceType)) continue;
            return service;
        }
        throw new IllegalStateException("No service found for persistable resource: " + resourceType);
    }

    private <K, V> CacheConfiguration<K, V> adjustConfigurationWithCacheManagerDefaults(String alias, CacheConfiguration<K, V> config) {
        CacheLoaderWriterConfiguration loaderWriterConfiguration;
        if (config.getClassLoader() == null && this.cacheManagerClassLoader != null) {
            config = config.derive().withClassLoader(this.cacheManagerClassLoader).build();
        }
        if ((loaderWriterConfiguration = ServiceUtils.findSingletonAmongst(CacheLoaderWriterConfiguration.class, config.getServiceConfigurations())) == null) {
            CacheLoaderWriterProvider loaderWriterProvider = this.serviceLocator.getService(CacheLoaderWriterProvider.class);
            CacheLoaderWriterConfiguration<?> preConfiguredCacheLoaderWriterConfig = loaderWriterProvider.getPreConfiguredCacheLoaderWriterConfig(alias);
            if (preConfiguredCacheLoaderWriterConfig != null) {
                config = config.derive().withService(preConfiguredCacheLoaderWriterConfig).build();
            }
            if (loaderWriterProvider.isLoaderJsrProvided(alias)) {
                config = config.derive().withService(new CacheLoaderWriterConfiguration<Void>(){}).build();
            }
        }
        return config;
    }

    @Override
    public void registerListener(CacheManagerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
            this.statusTransitioner.registerListener(listener);
        }
    }

    @Override
    public void deregisterListener(CacheManagerListener listener) {
        if (this.listeners.remove(listener)) {
            this.statusTransitioner.deregisterListener(listener);
        }
    }

    @Override
    public void init() {
        StatusTransitioner.Transition st = this.statusTransitioner.init();
        try {
            this.serviceLocator.startAllServices();
            ArrayDeque<String> initiatedCaches = new ArrayDeque<String>();
            try {
                for (Map.Entry<String, CacheConfiguration<?, ?>> cacheConfigurationEntry : this.configuration.getCacheConfigurations().entrySet()) {
                    String alias = cacheConfigurationEntry.getKey();
                    this.createCache(alias, cacheConfigurationEntry.getValue(), false);
                    initiatedCaches.push(alias);
                }
            }
            catch (RuntimeException e) {
                while (!initiatedCaches.isEmpty()) {
                    String toBeClosed = (String)initiatedCaches.pop();
                    try {
                        this.removeCache(toBeClosed, false);
                    }
                    catch (Exception exceptionClosingCache) {
                        LOGGER.error("Cache '{}' could not be removed after initialization failure due to ", (Object)toBeClosed, (Object)exceptionClosingCache);
                    }
                }
                try {
                    this.serviceLocator.stopAllServices();
                }
                catch (Exception exceptionStoppingServices) {
                    LOGGER.error("Stopping services after initialization failure failed due to ", exceptionStoppingServices);
                }
                throw e;
            }
            st.succeeded();
        }
        catch (Exception e) {
            throw st.failed(e);
        }
        finally {
            st.failed(null);
        }
    }

    @Override
    public Status getStatus() {
        return this.statusTransitioner.currentStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StatusTransitioner.Transition st = this.statusTransitioner.close();
        Exception firstException = null;
        try {
            for (String alias : this.caches.keySet()) {
                try {
                    this.removeCache(alias, false);
                }
                catch (Exception e) {
                    if (firstException == null) {
                        firstException = e;
                        continue;
                    }
                    LOGGER.error("Cache '{}' could not be removed due to ", (Object)alias, (Object)e);
                }
            }
            this.serviceLocator.stopAllServices();
            if (firstException == null) {
                st.succeeded();
            }
        }
        catch (Exception e) {
            if (firstException == null) {
                firstException = e;
            }
        }
        finally {
            if (firstException != null) {
                throw st.failed(firstException);
            }
            st.failed(null);
        }
    }

    @Override
    public Configuration getRuntimeConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyCache(String alias) throws CachePersistenceException {
        if (alias == null) {
            throw new NullPointerException("Alias cannot be null");
        }
        LOGGER.debug("Destroying Cache '{}' in {}.", (Object)alias, (Object)this.simpleName);
        StatusTransitioner.Transition maintenance = null;
        try {
            maintenance = this.statusTransitioner.maintenance();
        }
        catch (IllegalStateException e) {
            this.statusTransitioner.checkAvailable();
        }
        if (maintenance != null) {
            try {
                this.startMaintainableServices(MaintainableService.MaintenanceScope.CACHE);
                maintenance.succeeded();
            }
            catch (Throwable t) {
                throw maintenance.failed(t);
            }
        }
        try {
            this.removeCache(alias, true);
            this.destroyPersistenceSpace(alias);
        }
        finally {
            if (maintenance != null) {
                StatusTransitioner.Transition st = this.statusTransitioner.exitMaintenance();
                try {
                    this.stopMaintainableServices();
                    st.succeeded();
                }
                catch (Throwable t) {
                    throw st.failed(t);
                }
            }
        }
        LOGGER.info("Cache '{}' successfully destroyed in {}.", (Object)alias, (Object)this.simpleName);
    }

    private void destroyPersistenceSpace(String alias) throws CachePersistenceException {
        Collection<PersistableResourceService> services = this.serviceLocator.getServicesOfType(PersistableResourceService.class);
        for (PersistableResourceService service : services) {
            service.destroy(alias);
        }
    }

    @Override
    public void destroy() throws CachePersistenceException {
        StatusTransitioner.Transition st = this.statusTransitioner.maintenance();
        try {
            this.startMaintainableServices(MaintainableService.MaintenanceScope.CACHE_MANAGER);
            st.succeeded();
        }
        catch (Throwable t) {
            throw st.failed(t);
        }
        this.destroyInternal();
        st = this.statusTransitioner.exitMaintenance();
        try {
            this.stopMaintainableServices();
            st.succeeded();
        }
        catch (Throwable t) {
            throw st.failed(t);
        }
        LOGGER.info("All persistent data destroyed for {}", (Object)this.simpleName);
    }

    private void startMaintainableServices(MaintainableService.MaintenanceScope maintenanceScope) {
        ServiceProvider<MaintainableService> provider = this.getMaintainableServiceProvider();
        Collection<MaintainableService> services = this.serviceLocator.getServicesOfType(MaintainableService.class);
        for (MaintainableService service : services) {
            service.startForMaintenance(provider, maintenanceScope);
        }
    }

    private ServiceProvider<MaintainableService> getMaintainableServiceProvider() {
        return new ServiceProvider<MaintainableService>(){

            @Override
            public <U extends MaintainableService> U getService(Class<U> serviceType) {
                return (U)((MaintainableService)EhcacheManager.this.serviceLocator.getService(serviceType));
            }

            @Override
            public <U extends MaintainableService> Collection<U> getServicesOfType(Class<U> serviceType) {
                return EhcacheManager.this.serviceLocator.getServicesOfType(serviceType);
            }
        };
    }

    private void stopMaintainableServices() {
        Collection<MaintainableService> services = this.serviceLocator.getServicesOfType(MaintainableService.class);
        for (MaintainableService service : services) {
            service.stop();
        }
    }

    ClassLoader getClassLoader() {
        return this.cacheManagerClassLoader;
    }

    void destroyInternal() throws CachePersistenceException {
        this.statusTransitioner.checkMaintenance();
        Collection<PersistableResourceService> services = this.serviceLocator.getServicesOfType(PersistableResourceService.class);
        for (PersistableResourceService service : services) {
            service.destroyAll();
        }
    }

    private static final class CacheHolder {
        private final Class<?> keyType;
        private final Class<?> valueType;
        private volatile InternalCache<?, ?> cache;
        private volatile boolean isValueSet = false;

        CacheHolder(Class<?> keyType, Class<?> valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <K, V> InternalCache<K, V> retrieve(Class<K> refKeyType, Class<V> refValueType) {
            if (!this.isValueSet) {
                CacheHolder cacheHolder = this;
                synchronized (cacheHolder) {
                    boolean interrupted = false;
                    try {
                        while (!this.isValueSet) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                interrupted = true;
                            }
                        }
                    }
                    finally {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
            if (this.keyType == refKeyType && this.valueType == refValueType) {
                return CacheHolder.cast(this.cache);
            }
            throw new IllegalArgumentException();
        }

        private static <K, V> InternalCache<K, V> cast(InternalCache<?, ?> cache) {
            return cache;
        }

        public synchronized void setCache(InternalCache<?, ?> cache) {
            this.cache = cache;
            this.isValueSet = true;
            this.notifyAll();
        }
    }
}

