/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.osgi;

import com.hundsun.lightdb.shaded.org.slf4j.Logger;
import com.hundsun.lightdb.shaded.org.slf4j.LoggerFactory;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.ehcache.core.osgi.SafeOsgi;
import org.ehcache.core.spi.service.ServiceFactory;
import org.ehcache.core.util.ClassLoading;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class EhcacheActivator
implements BundleActivator {
    public static final String OSGI_LOADING = "org.ehcache.core.osgi";
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheActivator.class);
    private static final AtomicReference<BundleContext> CORE_BUNDLE = new AtomicReference();

    public void start(BundleContext context) throws Exception {
        BundleContext currentContext = CORE_BUNDLE.getAndUpdate(current -> current == null ? context : current);
        if (currentContext == null) {
            String greeting = "Detected OSGi Environment (core is in bundle: " + context.getBundle() + ")";
            if ("false".equalsIgnoreCase(context.getProperty(OSGI_LOADING))) {
                SafeOsgi.disableOSGiServiceLoading();
                LOGGER.info(greeting + ": OSGi Based Service Loading Disabled Via System/Framework Property - Extensions Outside This Bundle Will Not Be Detected");
                LOGGER.debug("JDK Service Loading Sees:\n\t" + StreamSupport.stream(Spliterators.spliterator(ClassLoading.servicesOfType(ServiceFactory.class).iterator(), Long.MAX_VALUE, 0), false).map(sf -> sf.getServiceType().getName()).collect(Collectors.joining("\n\t")));
            } else {
                SafeOsgi.enableOSGiServiceLoading();
                LOGGER.info(greeting + ": Using OSGi Based Service Loading");
            }
        } else {
            throw new IllegalStateException("Multiple bundle instances running against the same core classes: existing bundle: " + currentContext.getBundle() + " new bundle: " + context.getBundle());
        }
    }

    public void stop(BundleContext context) throws Exception {
        SafeOsgi.disableOSGiServiceLoading();
        CORE_BUNDLE.set(null);
    }

    public static BundleContext getCoreBundle() {
        return CORE_BUNDLE.get();
    }
}

