/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.heap;

import com.hundsun.lightdb.shaded.org.slf4j.Logger;
import com.hundsun.lightdb.shaded.org.slf4j.LoggerFactory;
import java.time.Duration;
import org.ehcache.core.events.StoreEventSink;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.impl.internal.store.heap.OnHeapStore;
import org.ehcache.impl.internal.store.heap.holders.OnHeapValueHolder;

interface OnHeapStrategy<K, V> {
    public static final Logger LOG = LoggerFactory.getLogger(OnHeapStore.class);

    public static <K, V> OnHeapStrategy<K, V> strategy(OnHeapStore<K, V> store, ExpiryPolicy<? super K, ? super V> expiry, TimeSource timeSource) {
        if (expiry == ExpiryPolicy.NO_EXPIRY) {
            LOG.debug("No expiration strategy detected");
            return new NoExpirationStrategy();
        }
        if (expiry.getClass().getName().equals("org.ehcache.config.builders.ExpiryPolicyBuilder$TimeToLiveExpiryPolicy")) {
            LOG.debug("TTL expiration strategy detected");
            return new TTLStrategy<K, V>(expiry, timeSource);
        }
        LOG.debug("TTI or custom expiration strategy detected");
        return new AllStrategy<K, V>(store, expiry, timeSource);
    }

    public boolean isExpired(OnHeapValueHolder<V> var1);

    public void setAccessAndExpiryTimeWhenCallerOutsideLock(K var1, OnHeapValueHolder<V> var2, long var3);

    public OnHeapValueHolder<V> setAccessAndExpiryWhenCallerlUnderLock(K var1, OnHeapValueHolder<V> var2, long var3, StoreEventSink<K, V> var5);

    public Duration getAccessDuration(K var1, Store.ValueHolder<V> var2);

    public Duration getUpdateDuration(K var1, OnHeapValueHolder<V> var2, V var3);

    public static class TTLStrategy<K, V>
    implements OnHeapStrategy<K, V> {
        private final TimeSource timeSource;
        private final ExpiryPolicy<? super K, ? super V> expiry;

        public TTLStrategy(ExpiryPolicy<? super K, ? super V> expiry, TimeSource timeSource) {
            this.timeSource = timeSource;
            this.expiry = expiry;
        }

        @Override
        public boolean isExpired(OnHeapValueHolder<V> mapping) {
            return mapping.isExpired(this.timeSource.getTimeMillis());
        }

        @Override
        public void setAccessAndExpiryTimeWhenCallerOutsideLock(K key, OnHeapValueHolder<V> valueHolder, long now) {
            valueHolder.accessed(now, null);
        }

        @Override
        public OnHeapValueHolder<V> setAccessAndExpiryWhenCallerlUnderLock(K key, OnHeapValueHolder<V> valueHolder, long now, StoreEventSink<K, V> eventSink) {
            valueHolder.accessed(now, null);
            return valueHolder;
        }

        @Override
        public Duration getAccessDuration(K key, Store.ValueHolder<V> valueHolder) {
            return null;
        }

        @Override
        public Duration getUpdateDuration(K key, OnHeapValueHolder<V> oldValue, V newValue) {
            Duration duration;
            try {
                duration = this.expiry.getExpiryForUpdate(key, oldValue, newValue);
                if (duration != null && duration.isNegative()) {
                    duration = Duration.ZERO;
                }
            }
            catch (RuntimeException re) {
                LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", re);
                duration = Duration.ZERO;
            }
            return duration;
        }
    }

    public static class NoExpirationStrategy<K, V>
    implements OnHeapStrategy<K, V> {
        @Override
        public boolean isExpired(OnHeapValueHolder<V> mapping) {
            return false;
        }

        @Override
        public void setAccessAndExpiryTimeWhenCallerOutsideLock(K key, OnHeapValueHolder<V> valueHolder, long now) {
            valueHolder.accessed(now, null);
        }

        @Override
        public OnHeapValueHolder<V> setAccessAndExpiryWhenCallerlUnderLock(K key, OnHeapValueHolder<V> valueHolder, long now, StoreEventSink<K, V> eventSink) {
            valueHolder.accessed(now, null);
            return valueHolder;
        }

        @Override
        public Duration getAccessDuration(K key, Store.ValueHolder<V> valueHolder) {
            return null;
        }

        @Override
        public Duration getUpdateDuration(K key, OnHeapValueHolder<V> oldValue, V newValue) {
            return null;
        }
    }

    public static class AllStrategy<K, V>
    implements OnHeapStrategy<K, V> {
        private final OnHeapStore<K, V> store;
        private final ExpiryPolicy<? super K, ? super V> expiry;
        private final TimeSource timeSource;

        public AllStrategy(OnHeapStore<K, V> store, ExpiryPolicy<? super K, ? super V> expiry, TimeSource timeSource) {
            this.store = store;
            this.expiry = expiry;
            this.timeSource = timeSource;
        }

        @Override
        public boolean isExpired(OnHeapValueHolder<V> mapping) {
            return mapping.isExpired(this.timeSource.getTimeMillis());
        }

        @Override
        public void setAccessAndExpiryTimeWhenCallerOutsideLock(K key, OnHeapValueHolder<V> valueHolder, long now) {
            Duration duration = this.getAccessDuration(key, valueHolder);
            if (Duration.ZERO.equals(duration)) {
                this.store.expireMappingUnderLock(key, valueHolder);
            } else {
                valueHolder.accessed(now, duration);
            }
        }

        @Override
        public Duration getAccessDuration(K key, Store.ValueHolder<V> valueHolder) {
            Duration duration;
            try {
                duration = this.expiry.getExpiryForAccess(key, valueHolder);
                if (duration != null && duration.isNegative()) {
                    duration = Duration.ZERO;
                }
            }
            catch (RuntimeException re) {
                LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", re);
                duration = Duration.ZERO;
            }
            return duration;
        }

        @Override
        public Duration getUpdateDuration(K key, OnHeapValueHolder<V> oldValue, V newValue) {
            Duration duration;
            try {
                duration = this.expiry.getExpiryForUpdate(key, oldValue, newValue);
                if (duration != null && duration.isNegative()) {
                    duration = Duration.ZERO;
                }
            }
            catch (RuntimeException re) {
                LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", re);
                duration = Duration.ZERO;
            }
            return duration;
        }

        @Override
        public OnHeapValueHolder<V> setAccessAndExpiryWhenCallerlUnderLock(K key, OnHeapValueHolder<V> valueHolder, long now, StoreEventSink<K, V> eventSink) {
            Duration duration = this.getAccessDuration(key, valueHolder);
            if (Duration.ZERO.equals(duration)) {
                this.store.fireOnExpirationEvent(key, valueHolder, eventSink);
                return null;
            }
            valueHolder.accessed(now, duration);
            return valueHolder;
        }
    }
}

