/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.offheapstore.util;

import com.hundsun.lightdb.shaded.org.slf4j.Logger;
import com.hundsun.lightdb.shaded.org.slf4j.LoggerFactory;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class Retryer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Retryer.class);
    private final ScheduledThreadPoolExecutor executor;
    private final long minimumDelay;
    private final long maximumDelay;
    private final TimeUnit unit;

    public Retryer(long minDelay, long maxDelay, TimeUnit unit, ThreadFactory threadFactory) {
        if (unit == null) {
            throw new IllegalArgumentException("Time unit must be non-null");
        }
        if (minDelay <= 0L) {
            throw new IllegalArgumentException("Minimum delay must be greater than zero");
        }
        if (maxDelay < minDelay) {
            throw new IllegalArgumentException("Maximum delay cannot be less than minimum delay");
        }
        if (threadFactory == null) {
            throw new IllegalArgumentException("Thread factory must be non-null");
        }
        this.minimumDelay = minDelay;
        this.maximumDelay = maxDelay;
        this.unit = unit;
        this.executor = new ScheduledThreadPoolExecutor(1, threadFactory);
    }

    public void completeAsynchronously(Runnable task) {
        this.scheduleTask(task, 0L);
    }

    public void shutdownNow() {
        this.executor.shutdownNow();
    }

    private void scheduleTask(Runnable task, long delay) {
        if (this.executor.isShutdown()) {
            // empty if block
        }
        this.executor.schedule(() -> {
            try {
                task.run();
            }
            catch (Throwable t) {
                long nextDelay = this.nextDelay(delay);
                LOGGER.warn(task + " failed, retrying in " + nextDelay + " " + this.unit.toString().toLowerCase(), t);
                this.scheduleTask(task, nextDelay);
            }
        }, delay, this.unit);
    }

    private long nextDelay(long delay) {
        if (delay < this.minimumDelay) {
            return this.minimumDelay;
        }
        if (delay >= this.maximumDelay) {
            return this.maximumDelay;
        }
        return Math.min(delay * 2L, this.maximumDelay);
    }
}

