/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.multiplex.common.utils.idworker;

import com.hundsun.lightdb.multiplex.common.utils.idworker.IdWorker;

/*
 * Exception performing whole class analysis ignored.
 */
public class SnowflakeIdWorker
implements IdWorker {
    private final long workerId;
    private static final long EPOCH = 1218154088000L;
    private static final long WORKERIDBITS = 10L;
    private final long maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << 10;
    private long sequence = 0L;
    private static final long SEQUENCEBITS = 12L;
    private final long workerIdShift;
    private final long timestampLeftShift = 12L + 10L;
    private final long sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << 12;
    private long lastTimestamp = -1L;

    public SnowflakeIdWorker(long workerId) {
        this.workerIdShift = 12L;
        if (workerId > this.maxWorkerId || workerId < 0L) {
            throw new IllegalArgumentException(String.format("Worker Id can't be greater than %d or less than 0", this.maxWorkerId));
        }
        this.workerId = workerId;
    }

    public synchronized long nextId() {
        long timestamp = SnowflakeIdWorker.timeGen();
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1218154088000L << (int)this.timestampLeftShift | this.workerId << (int)this.workerIdShift | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = SnowflakeIdWorker.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = SnowflakeIdWorker.timeGen();
        }
        return timestamp;
    }

    private static long timeGen() {
        return System.currentTimeMillis();
    }
}

