/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.multiplex.handler;

import com.hundsun.lightdb.multiplex.common.exception.TpException;
import com.hundsun.lightdb.unisql.model.Result;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class TpExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(TpExceptionHandler.class);

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public Object tpExceptionHandler(Exception ex) {
        if (log.isErrorEnabled()) {
            log.error("TpExceptionHandler\u5f02\u5e38\uff0c\u4fe1\u606f\u5982\u4e0b:{}", (Object)ex.getMessage());
        }
        if (ex instanceof TpException) {
            return ((TpException)ex).getResult();
        }
        return Result.fail((String)ExceptionUtils.getStackTrace((Throwable)ex));
    }
}

