/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.multiplex.runner;

import com.hundsun.lightdb.dbabrun.config.MultiplexJdbcConfig;
import com.hundsun.lightdb.dbabrun.util.DataCompareUtils;
import com.hundsun.lightdb.multiplex.service.impl.TestCaseSqlParser;
import com.hundsun.lightdb.multiplex.service.utils.CommonUtils;
import com.hundsun.lightdb.unisql.annotation.SuppressFBWarnings;
import com.hundsun.lightdb.unisql.model.MultiProperties;
import com.hundsun.lightdb.unisql.model.UnisqlProperties;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
@SuppressFBWarnings(value={"DM_SYSTEM_OUT", "DM_SYSTEM_ERR"})
public class TestCasesRunner
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(TestCasesRunner.class);
    private static final Logger consoleLogger = LoggerFactory.getLogger((String)"ConsoleLogger");
    @Autowired
    private MultiplexJdbcConfig multiplexConfig;

    public void run(ApplicationArguments args) {
        DateTimeFormatter dateFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if (!MultiProperties.autoTest()) {
            log.warn("\u672a\u542f\u7528\u81ea\u52a8\u5316\u6d4b\u8bd5\uff0c\u9000\u51fa\u6267\u884c [{}]", (Object)MultiProperties.RUN_WHAT);
            return;
        }
        log.warn("\u5f00\u59cb\u81ea\u52a8\u5316\u6d4b\u8bd5\uff0c\u8fd0\u884c\u6a21\u5f0f(\u652f\u6301\uff1a\u7edf\u4e00sql\u8f6c\u6362\u3001\u8f6c\u6362+\u591a\u53d1\u6bd4\u5bf9\u4e24\u79cd\u6a21\u5f0f)\uff1a [{}]", (Object)MultiProperties.RUN_WHAT);
        StringBuilder runMode = new StringBuilder();
        if (MultiProperties.multLoop()) {
            runMode.append("\u5faa\u73af\u6267\u884c:");
        }
        if (MultiProperties.autoTest()) {
            runMode.append("\u7edf\u4e00SQL\u8f6c\u6362");
        }
        if (MultiProperties.multiplex()) {
            runMode.append("+\u591a\u53d1");
        }
        if (MultiProperties.multLoop()) {
            long autoTestSleepTimeSeconds = MultiProperties.getMultiAutoSleepTime();
            LocalDateTime startTime = LocalDateTime.now();
            int loopCount = 0;
            try {
                while (true) {
                    LocalDateTime loopStartTime = LocalDateTime.now();
                    String loopStartTimeStr = dateFmt.format(loopStartTime);
                    log.info("\u5355\u6b21\u5f00\u59cb\u6267\u884c\u81ea\u52a8\u5316\u6d4b\u8bd5\uff0c\u7b2c {} \u6b21\u5faa\u73af", (Object)(++loopCount));
                    consoleLogger.info("\u8fd0\u884c\u6a21\u5f0f\u3010{}\u3011\uff0c\u5faa\u73af\u7b49\u5f85\u65f6\u95f4\u3010{} \u79d2\u3011\uff0c\u5f53\u524d\u662f\u7b2c {} \u6b21\u5faa\u73af\u6267\u884c\uff0c\u5f00\u59cb\u65f6\u95f4 {}", new Object[]{runMode, autoTestSleepTimeSeconds, loopCount, loopStartTimeStr});
                    DataCompareUtils.clearReportData();
                    int exitStatus = this.execAutoTest();
                    LocalDateTime loopEndTime = LocalDateTime.now();
                    String loopEndTimeStr = dateFmt.format(loopEndTime);
                    long loopDurationSeconds = ChronoUnit.SECONDS.between(loopStartTime, loopEndTime);
                    long totalDurationSeconds = ChronoUnit.SECONDS.between(startTime, loopEndTime);
                    log.info("\u5355\u6b21\u6267\u884c\u81ea\u52a8\u5316\u6d4b\u8bd5\u7ed3\u675f\uff0c\u6267\u884c\u72b6\u6001\u7801\u4e3a {}\uff0c\u672c\u6b21\u5faa\u73af\u8017\u65f6 {} \u79d2\uff0c\u603b\u5faa\u73af\u8017\u65f6 {} \u79d2\uff0c\u5f00\u59cb\u8fdb\u5165\u7b49\u5f85 {} \u79d2", new Object[]{exitStatus, loopDurationSeconds, totalDurationSeconds, autoTestSleepTimeSeconds});
                    consoleLogger.info("======== \u6d4b\u8bd5\u7528\u4f8b\u5355\u6b21\u6267\u884c\u5b8c\u6bd5\uff0c\u6267\u884c\u72b6\u6001\u7801\u4e3a {}\uff0c\u5f00\u59cb\u65f6\u95f4 {} \uff0c\u7ed3\u675f\u65f6\u95f4 {} \uff0c\u672c\u6b21\u5faa\u73af\u8017\u65f6 {} \u79d2\uff0c\u603b\u5faa\u73af\u8017\u65f6 {} \u79d2\uff0c\u7a0b\u5e8f\u7b49\u5f85 {} \u79d2\u540e\u7ee7\u7eed\u6267\u884c =======\n", new Object[]{exitStatus, loopStartTimeStr, loopEndTimeStr, loopDurationSeconds, totalDurationSeconds, autoTestSleepTimeSeconds});
                    Thread.sleep(autoTestSleepTimeSeconds * 1000L);
                }
            }
            catch (Exception e) {
                consoleLogger.error("\u6267\u884c run.what=5 \u81ea\u52a8\u5316\u6d4b\u8bd5\u5f02\u5e38\uff0c\u62a5\u9519\u4fe1\u606f {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                Thread.currentThread().interrupt();
                System.exit(1);
            }
        } else if (MultiProperties.autoTest()) {
            consoleLogger.info("\u8fd0\u884c\u6a21\u5f0f\u3010{}\u3011", (Object)runMode);
            int exitStatus = this.execAutoTest();
            consoleLogger.info("======== \u6d4b\u8bd5\u7528\u4f8b\u6267\u884c\u5b8c\u6bd5\uff0c\u7a0b\u5e8f\u5c06\u9000\u51fa =======");
            System.exit(exitStatus);
        }
    }

    private int execAutoTest() {
        long start = System.nanoTime();
        try {
            String casesDir = CommonUtils.getTestCasesDirectory();
            if (StringUtils.isBlank((CharSequence)casesDir)) {
                consoleLogger.error("unisql.testcases.path \u6d4b\u8bd5\u7528\u4f8b\u6839\u8def\u5f84\u672a\u914d\u7f6e");
                consoleLogger.error("\u7a0b\u5e8f\u9000\u51fa");
                return 1;
            }
            String formatFilePath = String.format(casesDir + "%s", FilenameUtils.getName((String)""));
            File rootCaseDir = new File(formatFilePath);
            if (!rootCaseDir.exists() || !rootCaseDir.isDirectory()) {
                consoleLogger.error("unisql.testcases.path \u7cfb\u7edf\u914d\u7f6e\u6307\u5b9a\u7684\u6d4b\u8bd5\u7528\u4f8b\u6839\u8def\u5f84\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u76ee\u5f55 [{}]", (Object)rootCaseDir.getAbsolutePath());
                consoleLogger.error("\u7a0b\u5e8f\u9000\u51fa");
                return 1;
            }
            CommonUtils.parseExcludeRuleFile();
            consoleLogger.info("\u6267\u884c\u521d\u59cb\u5316sql\u811a\u672ccases/init/mysql_init.sql oracle_init.sql");
            UnisqlProperties.autoTestInitMetaData = true;
            CommonUtils.executeInit((File)rootCaseDir);
            UnisqlProperties.autoTestInitMetaData = false;
            CommonUtils.loadMetadata();
            List configDatabaseDialects = this.multiplexConfig.getConfigDatabaseDialects();
            int databaseNums = configDatabaseDialects.size();
            String databaseNames = String.join((CharSequence)",", configDatabaseDialects);
            log.info(String.format("\u603b\u5171\u914d\u7f6e\u5e93\u6570\u91cf:%-1s: %-45s%n", databaseNums, databaseNames));
            consoleLogger.info("\u5f00\u59cb\u8fdb\u884c\u7edf\u4e00SQL\u8f6c\u6362\u7ed3\u679c\u7684\u6bd4\u5bf9(\u901a\u8fc7diff\u547d\u4ee4\u6bd4\u5bf9)\uff0c\u5f53\u8fd0\u884c\u591a\u53d1\u65f6\u9884\u7f16\u8bd1\u6587\u4ef6\u5728\u7b2c\u4e00\u6b65\u8f6c\u6362\u6267\u884c\u6570\u636e\u751f\u6210data_out\u6587\u4ef6");
            TestCaseSqlParser localTestCaseParse = TestCaseSqlParser.getInstance((MultiplexJdbcConfig)this.multiplexConfig);
            int exitStatus = localTestCaseParse.parseSqlFile(rootCaseDir);
            consoleLogger.info("\u8be6\u7ec6\u65e5\u5fd7\u8def\u5f84\u4e3a {}", (Object)CommonUtils.getLogPath());
            log.info("\u81ea\u52a8\u5316\u6d4b\u8bd5\u8fd0\u884c\u603b\u8017\u65f6 [{}]\u79d2\u3002\u5982\u672a\u6240\u6709\u6d4b\u8bd5\u7528\u4f8b\u901a\u8fc7\uff0c\u53ef\u67e5\u770bunisql/cases/mysql(\u6216oracle)/diff\u76ee\u5f55\u4e0b\u7684\u9519\u8bef\u5bf9\u6bd4\u6587\u4ef6", (Object)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start));
            consoleLogger.info("========\u6d4b\u8bd5\u7528\u4f8b\u6267\u884c\u5b8c\u6bd5\uff0c\u7a0b\u5e8f\u5c06\u9000\u51fa=======");
            log.info("========System.exit({})=======", (Object)exitStatus);
            return exitStatus;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u81ea\u52a8\u5316\u6267\u884c\u5f02\u5e38\uff0c[{}]", (Object)com.hundsun.lightdb.dbabrun.util.ExceptionUtils.getStackTrace((Exception)e));
            }
            if (log.isDebugEnabled()) {
                log.debug("runWhat\u503c {}", (Object)MultiProperties.RUN_WHAT);
            }
            return 1;
        }
    }
}

