/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.multiplex.service.impl;

import com.hundsun.lightdb.dbabrun.bean.CompareMessageEntity;
import com.hundsun.lightdb.dbabrun.config.MultiplexJdbcConfig;
import com.hundsun.lightdb.dbabrun.dbactuator.AbstractActuator;
import com.hundsun.lightdb.dbabrun.util.DataCompareUtils;
import com.hundsun.lightdb.dbabrun.util.SpringContextUtils;
import com.hundsun.lightdb.multiplex.service.dbactuator.CommonActuatorStrategy;
import com.hundsun.lightdb.multiplex.service.impl.TestCaseSqlParserListener;
import com.hundsun.lightdb.multiplex.service.parser.UnitTestListener;
import com.hundsun.lightdb.multiplex.service.parser.UnitTestParser;
import com.hundsun.lightdb.multiplex.service.parser.UnitTestScanner;
import com.hundsun.lightdb.multiplex.service.utils.CommonUtils;
import com.hundsun.lightdb.unisql.annotation.SuppressFBWarnings;
import com.hundsun.lightdb.unisql.model.MultiProperties;
import com.hundsun.lightdb.unisql.utils.JsonUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@SuppressFBWarnings(value={"DM_SYSTEM_OUT", "DM_SYSTEM_ERR"})
public class TestCaseSqlParser {
    private static final Logger log = LoggerFactory.getLogger(TestCaseSqlParser.class);
    private static volatile TestCaseSqlParser instance;
    private MultiplexJdbcConfig multiplexJdbcConfig;
    private String runCaseSrc;
    private static final Logger consoleLogger;

    private TestCaseSqlParser(MultiplexJdbcConfig multiplexJdbcConfig) {
        this.multiplexJdbcConfig = multiplexJdbcConfig;
        this.runCaseSrc = "";
    }

    private TestCaseSqlParser(MultiplexJdbcConfig multiplexJdbcConfig, String caseSrc) {
        this.multiplexJdbcConfig = multiplexJdbcConfig;
        this.runCaseSrc = caseSrc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TestCaseSqlParser getInstance(MultiplexJdbcConfig multiplexConfig) {
        if (instance != null) return instance;
        Class<TestCaseSqlParser> clazz = TestCaseSqlParser.class;
        synchronized (TestCaseSqlParser.class) {
            if (instance != null) return instance;
            String caseSource = CommonUtils.getTestCasesSource();
            instance = new TestCaseSqlParser(multiplexConfig, caseSource);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public Boolean needRunCase(String caseSrc) {
        if (StringUtils.isBlank((CharSequence)this.runCaseSrc) || StringUtils.equalsIgnoreCase((CharSequence)this.runCaseSrc, (CharSequence)caseSrc)) {
            return true;
        }
        return false;
    }

    public int parseSqlFile(File directory) throws UnitTestScanner.ScannerException, UnitTestParser.SyntaxException {
        Object[] files = directory.listFiles(File::isDirectory);
        if (ArrayUtils.isEmpty((Object[])files)) {
            log.error("\u6d4b\u8bd5\u7528\u4f8b\u6839\u76ee\u5f55\u4e3a\u7a7a [{}] \u9000\u51fa\u81ea\u52a8\u5316\u6267\u884c", (Object)directory.getAbsolutePath());
            return 1;
        }
        String casesRootDir = directory.getAbsolutePath();
        block10: for (Object sourceDbDir : files) {
            String outPath = String.join((CharSequence)File.separator, casesRootDir, ((File)sourceDbDir).getName(), "out");
            String diffPath = String.join((CharSequence)File.separator, casesRootDir, ((File)sourceDbDir).getName(), "diff");
            String dataDiffPath = String.join((CharSequence)File.separator, casesRootDir, ((File)sourceDbDir).getName(), "data_diff");
            String dataOutPath = String.join((CharSequence)File.separator, casesRootDir, ((File)sourceDbDir).getName(), "data_out");
            String comparisonOutPath = String.join((CharSequence)File.separator, casesRootDir, ((File)sourceDbDir).getName(), "comparison_out");
            String comparisonDiffOPath = String.join((CharSequence)File.separator, casesRootDir, ((File)sourceDbDir).getName(), "comparison_diff");
            TestCaseSqlParser.deleteDir((String)outPath);
            TestCaseSqlParser.deleteDir((String)diffPath);
            TestCaseSqlParser.deleteDir((String)dataDiffPath);
            TestCaseSqlParser.deleteDir((String)dataOutPath);
            TestCaseSqlParser.deleteDir((String)comparisonOutPath);
            TestCaseSqlParser.deleteDir((String)comparisonDiffOPath);
            String fileName = ((File)sourceDbDir).getName();
            String fileFullPath = ((File)sourceDbDir).getAbsolutePath();
            switch (fileName) {
                case "oracle": {
                    if (!this.needRunCase(fileName).booleanValue()) continue block10;
                    this.oracleSource(fileFullPath);
                    continue block10;
                }
                case "mysql": {
                    if (!this.needRunCase(fileName).booleanValue()) continue block10;
                    this.mysqlSource(fileFullPath);
                    continue block10;
                }
                case "init": {
                    continue block10;
                }
                default: {
                    if (!log.isWarnEnabled()) continue block10;
                    log.warn("\u4e0d\u652f\u6301\u7684\u6e90\u7aef\u76ee\u5f55 [{}](\u5982\u679c\u662finit\uff0c\u5219\u5ffd\u7565\u5373\u53ef)", (Object)((File)sourceDbDir).getAbsolutePath());
                }
            }
        }
        log.info("\u6240\u6709SQL\u7684\u5e73\u5747\u8f6c\u6362\u8017\u65f6 " + AbstractActuator.getAverageTime() + " us");
        DataCompareUtils dataCompareUtils = new DataCompareUtils();
        dataCompareUtils.setRunCaseSrc(this.runCaseSrc);
        if (MultiProperties.multiplex()) {
            dataCompareUtils.setExecuteDbConfig((MultiplexJdbcConfig)SpringContextUtils.getBean(MultiplexJdbcConfig.class));
            dataCompareUtils.initWorkerGroup(casesRootDir);
            dataCompareUtils.dataCompare(casesRootDir);
        }
        int exitState = dataCompareUtils.printDiffResults(casesRootDir);
        return exitState;
    }

    public static boolean deleteDir(String dirPath) {
        String formatFilePath = String.format(dirPath + "%s", FilenameUtils.getName((String)""));
        File dir = new File(formatFilePath);
        if (!dir.exists()) {
            log.info("\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u5220\u9664" + dir.getPath());
            return true;
        }
        if (!dir.isDirectory()) {
            log.info("\u8def\u5f84\u5b58\u5728\u4f46\u4e0d\u662f\u76ee\u5f55" + dir.getPath());
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    if (TestCaseSqlParser.deleteDir((String)file.getAbsolutePath())) continue;
                    log.error("\u5b50\u76ee\u5f55\u5220\u9664\u5931\u8d25" + file.getAbsolutePath());
                    return false;
                }
                if (file.delete()) continue;
                log.error("\u6587\u4ef6\u5220\u9664\u5931\u8d25" + file.getPath());
                return false;
            }
        }
        log.info("\u5220\u9664\u76ee\u5f55" + dir.getPath());
        return dir.delete();
    }

    private void deleteFilesInOutDirectory(File directory) {
        File[] files;
        if (directory.exists() && directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory() && "out".equals(file.getName())) {
                    this.deleteFilesRecursively(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.deleteFilesInOutDirectory(file);
            }
        }
    }

    private void deleteFilesRecursively(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteFilesRecursively(file);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Deleting file: {}", (Object)file.getAbsolutePath());
                }
                file.delete();
            }
        }
    }

    private void oracleSource(String oracleDir) throws UnitTestScanner.ScannerException, UnitTestParser.SyntaxException {
        this.executeTestCase("oracle", oracleDir);
    }

    private void mysqlSource(String mysqlDir) throws UnitTestScanner.ScannerException, UnitTestParser.SyntaxException {
        this.executeTestCase("mysql", mysqlDir);
    }

    private void executeTestCase(String sourceDbType, String databaseDir) throws UnitTestScanner.ScannerException, UnitTestParser.SyntaxException {
        Object[] targetDirectories;
        String casesPath = String.join((CharSequence)File.separator, databaseDir, "cases");
        String expectedPath = String.join((CharSequence)File.separator, databaseDir, "expected");
        String formatExpectPath = String.format(expectedPath + "%s", FilenameUtils.getName((String)""));
        File expectedDirectory = new File(formatExpectPath);
        if (!expectedDirectory.exists() || !expectedDirectory.isDirectory()) {
            log.info("expected\u76ee\u5f55\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u76ee\u5f55 [{}]", (Object)expectedDirectory.getAbsolutePath());
            return;
        }
        boolean multiplexEnabled = MultiProperties.multiplex();
        if (log.isDebugEnabled()) {
            log.info("runWhat\u503c {}", (Object)MultiProperties.RUN_WHAT);
        }
        if (ArrayUtils.isEmpty((Object[])(targetDirectories = expectedDirectory.listFiles(File::isDirectory)))) {
            log.info("expected\u76ee\u5f55\u4e2d\u4e0d\u5b58\u5728\u76ee\u6807\u6570\u636e\u5e93\u76ee\u5f55 [{}]", (Object)expectedDirectory.getAbsolutePath());
            return;
        }
        List configDatabaseDialects = this.multiplexJdbcConfig.getConfigDatabaseDialects();
        if (CollectionUtils.isEmpty((Collection)configDatabaseDialects)) {
            log.error("\u672a\u914d\u7f6e\u76ee\u6807\u7aef\u65b9\u8a00 [{}]", (Object)sourceDbType);
            return;
        }
        List targetNames = Stream.of(targetDirectories).map(File::getName).collect(Collectors.toList());
        targetNames.removeAll(configDatabaseDialects);
        if (!targetNames.isEmpty()) {
            consoleLogger.error("expected\u76ee\u5f55 [{}] \u4e0b\u7684\u76ee\u6807\u65b9\u8a00 [{}] \u7684\u6570\u636e\u6e90\u914d\u7f6e\u5728\u591a\u53d1\u914d\u7f6e\u6587\u4ef6\u4e2d\u672a\u627e\u5230\uff0c\u81ea\u52a8\u5316\u9000\u51fa!", (Object)expectedPath, (Object)JsonUtils.toJson(targetNames));
            System.exit(1);
        }
        for (Object targetDbDir : targetDirectories) {
            String targetDbType = ((File)targetDbDir).getName();
            if (log.isInfoEnabled()) {
                log.info("multiplexEnabled: {}", (Object)multiplexEnabled);
            }
            if (log.isDebugEnabled()) {
                String msg = String.format("\u76ee\u6807\u5e93\u6570\u636e\u5e93\u7c7b\u578b\u4e3a %s", targetDbType);
                log.debug(msg);
            }
            CompareMessageEntity compareMessage = this.buildCompareMessageEntity(sourceDbType, targetDbType, sourceDbType);
            try {
                this.runSqlInCasesDir(compareMessage, casesPath);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) continue;
                log.error("\u6267\u884c\u6d4b\u8bd5\u7528\u4f8b\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38:{}", (Throwable)e);
            }
        }
    }

    private CompareMessageEntity buildCompareMessageEntity(String sourceDbType, String targetDbType, String key) {
        CompareMessageEntity compareMessage = new CompareMessageEntity();
        compareMessage.setSourceDbType(sourceDbType);
        compareMessage.setTargetDbType(targetDbType);
        compareMessage.setKey(key);
        compareMessage.setCresBool(false);
        return compareMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSqlInCasesDir(CompareMessageEntity compareMessage, String caseDir) throws IOException, UnitTestScanner.ScannerException, UnitTestParser.SyntaxException {
        String formatCasePath = String.format(caseDir + "%s", FilenameUtils.getName((String)""));
        File casesDirectory = new File(formatCasePath);
        if (!casesDirectory.exists() || !casesDirectory.isDirectory()) {
            log.error("\u6e90\u7aef\u6570\u636e\u5e93cases\u76ee\u5f55\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u76ee\u5f55 [{}]", (Object)casesDirectory.getAbsolutePath());
            return;
        }
        Object[] files = casesDirectory.listFiles(File::isFile);
        if (ArrayUtils.isEmpty((Object[])files)) {
            log.error("\u6e90\u7aef\u6570\u636e\u5e93cases\u76ee\u5f55\u4e3a\u7a7a [{}]", (Object)casesDirectory.getAbsolutePath());
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("[{}]\u76ee\u5f55\u4e0b\u7684\u7528\u4f8b\u6587\u4ef6\u6570\u91cf\uff1a[{}]", (Object)casesDirectory.getAbsolutePath(), (Object)files.length);
        }
        for (int i = 0; i < files.length; ++i) {
            TestCaseSqlParserListener testCaseSqlParserListener;
            Object sqlFile;
            block21: {
                sqlFile = files[i];
                testCaseSqlParserListener = new TestCaseSqlParserListener(compareMessage);
                if (!CommonUtils.needExecSqlFile((String)compareMessage.getSourceDbType(), (String)compareMessage.getTargetDbType(), (String)((File)sqlFile).getName())) continue;
                testCaseSqlParserListener.setCurrentFileName(((File)sqlFile).getName());
                testCaseSqlParserListener.setPreparedFile(false);
                try (BufferedReader reader = Files.newBufferedReader(Path.of(((File)sqlFile).getAbsolutePath(), new String[0]));){
                    String lineContent;
                    if (reader == null) break block21;
                    while ((lineContent = reader.readLine()) != null) {
                        if (lineContent.indexOf("\u00a7{") < 0) continue;
                        testCaseSqlParserListener.setPreparedFile(true);
                        break;
                    }
                }
                catch (IOException e) {
                    log.error("\u5224\u65ad\u7528\u4f8b\u6587\u4ef6\u662f\u5426\u6709\u9884\u7f16\u8bd1sql\u5931\u8d25\uff1a{}", (Throwable)e);
                }
            }
            if (testCaseSqlParserListener.isPreparedFile() && CommonUtils.existExpectedPreparedFile((String)compareMessage.getSourceDbType(), (String)compareMessage.getTargetDbType(), (String)((File)sqlFile).getName())) {
                testCaseSqlParserListener.setPrepareNeedExecData(true);
            } else {
                testCaseSqlParserListener.setPrepareNeedExecData(false);
            }
            UnitTestParser parser = new UnitTestParser((InputStream)new FileInputStream((File)sqlFile));
            try {
                if (log.isDebugEnabled()) {
                    log.debug("\u5f00\u59cb\u6267\u884c\u7528\u4f8b\u6587\u4ef6 [{}]", (Object)((File)sqlFile).getAbsolutePath());
                }
                parser.walk((UnitTestListener)testCaseSqlParserListener);
                compareMessage.setInPreparedFile(testCaseSqlParserListener.isPreparedFile());
                compareMessage.setUnisqlConvertState(testCaseSqlParserListener.existConvertFail());
                continue;
            }
            catch (Exception e) {
                log.error("sql\u6587\u4ef6 :{},\u6e90\u7aef\u5e93 :{},\u76ee\u6807\u5e93:{}, parser.walk \u6267\u884c\u5f02\u5e38:{}", new Object[]{((File)sqlFile).getName(), compareMessage.getSourceDbType(), compareMessage.getTargetDbType(), ExceptionUtils.getStackTrace((Throwable)e)});
                continue;
            }
            finally {
                AbstractActuator actuator = CommonActuatorStrategy.getInstance().getActuator(compareMessage.getTargetDbType());
                actuator.executeDiff(compareMessage, ((File)sqlFile).getName());
            }
        }
    }

    public String getRunCaseSrc() {
        return this.runCaseSrc;
    }

    public void setRunCaseSrc(String runCaseSrc) {
        this.runCaseSrc = runCaseSrc;
    }

    static {
        consoleLogger = LoggerFactory.getLogger((String)"ConsoleLogger");
    }
}

