/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.multiplex.service.impl;

import com.alibaba.fastjson2.JSON;
import com.hundsun.lightdb.dbabrun.bean.CompareMessageEntity;
import com.hundsun.lightdb.dbabrun.dbactuator.AbstractActuator;
import com.hundsun.lightdb.dbabrun.util.CommonUtils;
import com.hundsun.lightdb.multiplex.service.dbactuator.CommonActuatorStrategy;
import com.hundsun.lightdb.multiplex.service.parser.UnitTestListener;
import com.hundsun.lightdb.unisql.golang.Transformer;
import com.hundsun.lightdb.unisql.model.MultiProperties;
import java.util.ArrayList;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class TestCaseSqlParserListener
implements UnitTestListener {
    private static final Logger log = LoggerFactory.getLogger(TestCaseSqlParserListener.class);
    private CompareMessageEntity initCompareMessage;
    private String currentFileName;
    private boolean isPreparedFile = false;
    private boolean existUnisqlConvertFail = true;
    private boolean prepareNeedExecData = false;
    static String REGEX = "\u00a7\\{(.*?)\\}";
    static Pattern PATTERN = Pattern.compile(REGEX);

    public boolean isPreparedFile() {
        return this.isPreparedFile;
    }

    public void setPreparedFile(boolean preparedFile) {
        this.isPreparedFile = preparedFile;
    }

    public boolean existConvertFail() {
        return this.existUnisqlConvertFail;
    }

    public void setExistConvertFail() {
        this.existUnisqlConvertFail = false;
    }

    public void setCurrentFileName(String currentFileName) {
        this.currentFileName = currentFileName;
    }

    public TestCaseSqlParserListener(CompareMessageEntity compareMessage) {
        this.initCompareMessage = compareMessage;
    }

    public void onComment(String comment) {
    }

    public void onReloadMetaData(String[] tableList) {
        AbstractActuator.loadUnisqlTableColumnMetadata((String)this.initCompareMessage.getTargetDbType(), null);
    }

    public void onSqlStatement(String execSqlID, String sqlType, String sql) {
        String fileName;
        if (sqlType.equalsIgnoreCase("DCL")) {
            if (log.isWarnEnabled()) {
                String msg = String.format("\u5ffd\u7565\u7528\u4f8b\u6587\u4ef6\u4e2d\u4f7f\u7528 EXEC DCL ``` \u5b9a\u4e49\u7684SQL\u8bed\u53e5\uff0c\u8be5\u8bed\u53e5\u4e0d\u8f6c\u6362\u4e5f\u4e0d\u6267\u884c %s", sql);
                log.warn(msg);
            }
            return;
        }
        if (StringUtils.isBlank((CharSequence)sql)) {
            log.error("\u7528\u4f8b\u6587\u4ef6\u4e2d\u51fa\u73b0\u7a7aSQL [{}]", (Object)this.currentFileName);
            return;
        }
        if (sql.endsWith(";")) {
            sql = StringUtils.trim((String)sql.substring(0, sql.length() - 1));
        }
        CompareMessageEntity newCompareMessage = new CompareMessageEntity();
        BeanUtils.copyProperties((Object)this.initCompareMessage, (Object)newCompareMessage);
        newCompareMessage.setSourceSql(sql);
        newCompareMessage.setTestCaseSqlType(sqlType);
        this.preparedHandler(newCompareMessage, sql);
        newCompareMessage.setFilename(this.currentFileName);
        if (log.isDebugEnabled()) {
            String json = JSON.toJSONString((Object)newCompareMessage);
            String msg = String.format("CompareMessage \u5c01\u88c5\u5b8c\u6bd5 %s", json);
            log.debug(msg);
        }
        if ((fileName = newCompareMessage.getFilename()) != null && fileName.startsWith("new")) {
            newCompareMessage.setNewTestFile(true);
        } else {
            newCompareMessage.setNewTestFile(false);
        }
        newCompareMessage.setExecSqlId(execSqlID);
        com.hundsun.lightdb.multiplex.service.utils.CommonUtils.parserCommentInfo((CompareMessageEntity)newCompareMessage);
        if (newCompareMessage.isNewTestFile()) {
            try {
                com.hundsun.lightdb.multiplex.service.utils.CommonUtils.determineSqlIdSpec((String)newCompareMessage.getExecSqlId());
                com.hundsun.lightdb.multiplex.service.utils.CommonUtils.determineIdentCompliance((String)newCompareMessage.getSourceSql());
            }
            catch (Exception e) {
                log.error("\u7528\u4f8b\u540d\u548c\u6807\u8bc6\u7b26\u5224\u65ad\u5f02\u5e38\uff0c\u62a5\u9519{}", (Object)com.hundsun.lightdb.dbabrun.util.ExceptionUtils.getStackTrace((Exception)e));
            }
        }
        AbstractActuator actuator = CommonActuatorStrategy.getInstance().getActuator(newCompareMessage.getTargetDbType());
        actuator.getTransferSQL(newCompareMessage);
        if (!newCompareMessage.getConvertState()) {
            this.setExistConvertFail();
        }
        if (this.isPreparedFile() && this.prepareNeedExecData && MultiProperties.multiplex()) {
            actuator.createPreparedDataOutFile(newCompareMessage);
        }
    }

    public void onSetStatement(String name, String value) {
        try {
            Transformer.setParamStr((String)name, (String)value);
            log.info("\u8bbe\u7f6e\u5168\u5c40\u8bbe\u7f6e\u914d\u7f6e\u53c2\u6570\u6210\u529f,paramName:{}, paramValue:{}", (Object)name, (Object)value);
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u5168\u5c40\u8bbe\u7f6e\u914d\u7f6e\u53c2\u6570\u5931\u8d25,paramName:{}, paramValue:{}, \u9519\u8bef\u4fe1\u606f:{}", new Object[]{name, value, ExceptionUtils.getStackTrace((Throwable)e)});
        }
    }

    private void preparedHandler(CompareMessageEntity newCompareMessage, String sql) {
        newCompareMessage.setInPreparedFile(this.isPreparedFile);
        Matcher matcher = PATTERN.matcher(sql);
        ArrayList<String> valueList = new ArrayList<String>();
        ArrayList<String> typeList = new ArrayList<String>();
        String temp = "";
        while (matcher.find()) {
            temp = matcher.group(1);
            if (temp.indexOf(",") >= 0) {
                String value = temp.split(",")[0];
                String type = CommonUtils.getJdbcType((String)temp.split(",")[1]).toString();
                if (Integer.parseInt(type) == 2004 || Integer.parseInt(type) == 2005) {
                    value = new String(Base64.getEncoder().encode(value.getBytes()));
                }
                valueList.add(value);
                typeList.add(type);
                continue;
            }
            valueList.add(temp);
            typeList.add(CommonUtils.getJdbcType((String)"").toString());
        }
        if (valueList.size() > 0) {
            String params = valueList.stream().collect(Collectors.joining(",")) + "\u00a7\u00a7" + typeList.stream().collect(Collectors.joining(","));
            newCompareMessage.setParams(params);
            newCompareMessage.setSourceSql(newCompareMessage.getSourceSql().replaceAll(REGEX, "?"));
            newCompareMessage.setPrepared(true);
        }
    }

    public boolean prepareNeedExecData() {
        return this.prepareNeedExecData;
    }

    public void setPrepareNeedExecData(boolean prepareExecData) {
        this.prepareNeedExecData = prepareExecData;
    }
}

