/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.multiplex.service.parser;

import com.hundsun.lightdb.multiplex.service.parser.UnitTestListener;
import com.hundsun.lightdb.multiplex.service.parser.UnitTestParser;
import com.hundsun.lightdb.multiplex.service.parser.UnitTestScanner;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnitTestParser {
    private static final String PRE_VARIABLE_REGEX = "\\$VAR\\{([^}]+)\\}";
    private static final String VAR_RANDOM_NAME = "random";
    private static final String VAR_TIMESTAMP_NAME = "current_timestamp";
    private static final String VAR_USER_NAME = "user";
    private static final String VAR_NAME = "name";
    private static int FIX_NAME_LENGTH = 15;
    private UnitTestScanner scanner;
    private final SecureRandom SEC_RANDOM = new SecureRandom();
    private Map<String, String> variableMap = new HashMap();
    private static final int PARSER_STMT_SET = 1;
    private static final int PARSER_STMT_SET_STRING = 2;
    private static final int PARSER_STMT_EXEC = 3;
    private static final int PARSER_STMT_COMMENT = 4;
    private static final int PARSER_STMT_EXEC_WITH_ID = 5;
    private static final int PARSER_STMT_RELOAD = 6;
    private static final int PARSER_STMT_RELOAD_WITH_TABLES = 7;
    private static final int PARSER_STMT_VAR = 8;
    private static final int PARSER_STMT_INCOMPLETED = 0;
    private static final int PARSER_STMT_INVALID = -1;
    private static final int[][] GRAM_ARRAY = new int[][]{{5, 303, 301, 40, 300, 41, 300}, {3, 303, 301, 300}, {4, 302}, {1, 303, 304, 301, 61, 301}, {2, 303, 304, 301, 61, 300}, {6, 303, 305, 306}, {7, 303, 305, 306, 300}, {8, 303, 307, 301, 61, 300}};
    private List<UnitTestScanner.Token> cacheTokenList;

    public UnitTestParser(InputStream inputStream) {
        this.scanner = new UnitTestScanner(new InputStreamReader(inputStream));
        this.cacheTokenList = new ArrayList();
    }

    public boolean isValidSqlType(String sqlType) {
        String[] validSqlTypes;
        for (String validSqlType : validSqlTypes = new String[]{"DQL", "DML", "DCL", "DDL", "INSERT", "UPDATE", "QUERY", "SET", "DML2DQL"}) {
            if (!sqlType.equalsIgnoreCase(validSqlType)) continue;
            return true;
        }
        return false;
    }

    private int gramStmtAccept(List<UnitTestScanner.Token> tokenList, int[] gramStmt) {
        if (gramStmt.length - 1 < tokenList.size()) {
            return -1;
        }
        int i = 0;
        for (i = 0; i < tokenList.size(); ++i) {
            if (tokenList.get(i).getType() == gramStmt[i + 1]) continue;
            return -1;
        }
        if (gramStmt.length - 1 == tokenList.size()) {
            return gramStmt[0];
        }
        return 0;
    }

    private String formatFixLengthName(String userName) {
        if (userName.length() == FIX_NAME_LENGTH) {
            return userName;
        }
        if (userName.length() > FIX_NAME_LENGTH) {
            return userName.substring(0, FIX_NAME_LENGTH);
        }
        StringBuilder result = new StringBuilder(userName);
        while (result.length() < FIX_NAME_LENGTH) {
            result.append('s');
        }
        return result.toString();
    }

    private String getInternelVariable(String name) {
        String userName = System.getenv("HUNDSUN_USER");
        if (userName == null) {
            userName = "unknown";
        }
        if (VAR_USER_NAME.equals(name)) {
            return this.formatFixLengthName(userName);
        }
        if (VAR_TIMESTAMP_NAME.equals(name)) {
            return String.valueOf(System.currentTimeMillis());
        }
        if (VAR_NAME.equals(name)) {
            return userName;
        }
        if (VAR_RANDOM_NAME.equals(name)) {
            long currentTimeMillis = System.currentTimeMillis() % 1000L;
            String currentTimeMillisStr = String.format("%03d", currentTimeMillis);
            String randomStr = String.format("%04d", this.SEC_RANDOM.nextInt(10000));
            return this.formatFixLengthName(userName) + currentTimeMillisStr + randomStr;
        }
        return null;
    }

    private String replaceVariables(String input) {
        Pattern pattern = Pattern.compile(PRE_VARIABLE_REGEX);
        Matcher matcher = pattern.matcher(input);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String variableName = matcher.group(1);
            String variableValue = (String)this.variableMap.get(variableName);
            if (variableValue == null) {
                variableValue = this.getInternelVariable(variableName);
            }
            if (variableValue == null) continue;
            matcher.appendReplacement(result, Matcher.quoteReplacement(variableValue));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private int gramAccept(List<UnitTestScanner.Token> tokenList) {
        for (int i = 0; i < GRAM_ARRAY.length; ++i) {
            int s = this.gramStmtAccept(tokenList, GRAM_ARRAY[i]);
            if (s == 0) {
                return 0;
            }
            if (s == -1) continue;
            return s;
        }
        return -1;
    }

    private void onSetStatement(List<UnitTestScanner.Token> tokenList, UnitTestListener listener) {
        listener.onSetStatement(tokenList.get(2).getValue(), tokenList.get(4).getValue());
    }

    private void onExecStatement(List<UnitTestScanner.Token> tokenList, UnitTestListener listener) throws SyntaxException {
        UnitTestScanner.Token token = tokenList.get(1);
        String sqlType = token.getValue().toUpperCase();
        if (!this.isValidSqlType(sqlType)) {
            throw new SyntaxException(token.getLine(), token.getPos(), "invalid sql type :" + sqlType);
        }
        String sql = tokenList.get(2).getValue();
        sql = this.replaceVariables(sql);
        listener.onSqlStatement("", tokenList.get(1).getValue(), sql);
    }

    private void onExecWithIdStatement(List<UnitTestScanner.Token> tokenList, UnitTestListener listener) {
        String sql = tokenList.get(5).getValue();
        sql = this.replaceVariables(sql);
        listener.onSqlStatement(tokenList.get(3).getValue(), tokenList.get(1).getValue(), sql);
    }

    private void onCommentStatement(List<UnitTestScanner.Token> tokenList, UnitTestListener listener) {
        listener.onComment(tokenList.get(0).getValue());
    }

    private void onReloadMetaDataStatement(List<UnitTestScanner.Token> tokenList, UnitTestListener listener) {
        listener.onReloadMetaData(null);
    }

    private void onReloadMetaDataWithTablesStatment(List<UnitTestScanner.Token> tokenList, UnitTestListener listener) {
        listener.onReloadMetaData(tokenList.get(3).getValue().split(","));
    }

    private void onVarStatement(List<UnitTestScanner.Token> tokenList, UnitTestListener listener) {
        String name = tokenList.get(2).getValue();
        String value = tokenList.get(4).getValue();
        value = this.replaceVariables(value);
        this.variableMap.put(name, value);
    }

    private void pushBackToken(UnitTestScanner.Token token) {
        this.cacheTokenList.add(token);
    }

    private UnitTestScanner.Token getNextToken() throws UnitTestScanner.ScannerException, IOException {
        if (!this.cacheTokenList.isEmpty()) {
            int i = this.cacheTokenList.size();
            UnitTestScanner.Token token = (UnitTestScanner.Token)this.cacheTokenList.get(i - 1);
            this.cacheTokenList.remove(i - 1);
            return token;
        }
        UnitTestScanner.Token token = this.scanner.getNextToken();
        return token;
    }

    public void onParsedTokenStatment(int gramStmt, UnitTestListener listener, List<UnitTestScanner.Token> stmtTokenList) throws SyntaxException {
        UnitTestScanner.Token token = stmtTokenList.get(0);
        switch (gramStmt) {
            case 1: 
            case 2: {
                this.onSetStatement(stmtTokenList, listener);
                break;
            }
            case 3: {
                this.onExecStatement(stmtTokenList, listener);
                break;
            }
            case 4: {
                this.onCommentStatement(stmtTokenList, listener);
                break;
            }
            case 5: {
                this.onExecWithIdStatement(stmtTokenList, listener);
                break;
            }
            case 7: {
                this.onReloadMetaDataWithTablesStatment(stmtTokenList, listener);
                break;
            }
            case 6: {
                this.onReloadMetaDataStatement(stmtTokenList, listener);
                break;
            }
            case 8: {
                this.onVarStatement(stmtTokenList, listener);
                break;
            }
            default: {
                throw new SyntaxException(token.getLine(), token.getPos(), "unsupported statement type: " + gramStmt);
            }
        }
    }

    public void walk(UnitTestListener listener) throws UnitTestScanner.ScannerException, IOException, SyntaxException {
        ArrayList<UnitTestScanner.Token> stmtTokenList = new ArrayList<UnitTestScanner.Token>();
        boolean isHaveAccept = false;
        int latestAccpetLength = 0;
        boolean isRollback = false;
        while (true) {
            UnitTestScanner.Token token = null;
            token = this.getNextToken();
            int gramStatt = 0;
            if (token != null) {
                stmtTokenList.add(token);
                gramStatt = this.gramAccept(stmtTokenList);
            }
            if (token == null || gramStatt == -1) {
                if (token == null && stmtTokenList.isEmpty()) {
                    return;
                }
                if (!isHaveAccept) {
                    if (token == null) {
                        throw new SyntaxException(0, 0, "unexpected EOF");
                    }
                    throw new SyntaxException(token.getLine(), token.getPos(), "syntax error: " + stmtTokenList.size());
                }
                while (stmtTokenList.size() > latestAccpetLength) {
                    int lastIndex = stmtTokenList.size() - 1;
                    this.pushBackToken((UnitTestScanner.Token)stmtTokenList.get(lastIndex));
                    stmtTokenList.remove(lastIndex);
                }
                isRollback = true;
            }
            if (isRollback) {
                gramStatt = this.gramAccept(stmtTokenList);
            }
            if (gramStatt == 0) continue;
            if (isRollback) {
                this.onParsedTokenStatment(gramStatt, listener, stmtTokenList);
                isHaveAccept = false;
                latestAccpetLength = 0;
                isRollback = false;
                stmtTokenList.clear();
                continue;
            }
            isHaveAccept = true;
            latestAccpetLength = stmtTokenList.size();
        }
    }

    public static void main(String[] args) throws IOException, UnitTestScanner.ScannerException, SyntaxException {
        FileInputStream fileInputStream = new FileInputStream("D:/test.txt");
        UnitTestParser parser = new UnitTestParser((InputStream)fileInputStream);
        parser.walk((UnitTestListener)new /* Unavailable Anonymous Inner Class!! */);
    }
}

