/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.multiplex.service.parser;

import com.hundsun.lightdb.multiplex.service.parser.UnitTestScanner;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class UnitTestScanner {
    private final InputStreamReader inputStream;
    private static final int SCANNER_STATE_EMPTY = 0;
    private static final int SCANNER_STATE_COMMENT_FIRST = 1;
    private static final int SCANNER_STATE_COMMENT = 5;
    private static final int SCANNER_STATE_BEGIN_SQL1 = 2;
    private static final int SCANNER_STATE_BEGIN_SQL2 = 3;
    private static final int SCANNER_STATE_END_SQL1 = 8;
    private static final int SCANNER_STATE_END_SQL2 = 9;
    private static final int SCANNER_STATE_SQL_IDENT = 4;
    private static final int SCANNER_STATE_IDENT = 6;
    private static final int SCANNER_STATE_BEGIN_DOUBLE_DOT = 7;
    private static final int SCANNER_MULTILINE_COMMENT = 10;
    private static final int SCANNER_MULTILINE_COMMENT2 = 11;
    private static final int SCANNER_MULTILINE_END = 12;
    private int state;
    private int line;
    private int pos;

    UnitTestScanner(InputStreamReader inputStream) {
        this.inputStream = inputStream;
        this.state = 0;
        this.line = 1;
        this.pos = 0;
    }

    private boolean isIdentChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '.' || c == '_' || c >= '0' && c <= '9';
    }

    private boolean isValidSingleChar(char c) {
        return c == '=' || c == '(' || c == ')';
    }

    public Token getNextToken() throws ScannerException, IOException {
        int v = -1;
        boolean readNextChar = true;
        boolean EOF = false;
        char c = '\u00ff';
        StringBuilder stringBuilder = new StringBuilder();
        block15: while (true) {
            if (readNextChar) {
                v = this.inputStream.read();
                if (v == -1) {
                    EOF = true;
                    c = '\u00ff';
                } else {
                    c = (char)v;
                    ++this.pos;
                    if (c == '\n') {
                        ++this.line;
                        this.pos = 0;
                    }
                }
            }
            readNextChar = true;
            switch (this.state) {
                case 0: {
                    if (EOF) {
                        return null;
                    }
                    if (Character.isWhitespace(c)) continue block15;
                    if (c == '-') {
                        stringBuilder.append(c);
                        this.state = 1;
                        continue block15;
                    }
                    if (c == '`') {
                        stringBuilder.append(c);
                        this.state = 2;
                        continue block15;
                    }
                    if (c == '\"') {
                        stringBuilder.append(c);
                        this.state = 7;
                        continue block15;
                    }
                    if (c == '/') {
                        stringBuilder.append(c);
                        this.state = 10;
                        continue block15;
                    }
                    if (this.isValidSingleChar(c)) {
                        return new Token("", (int)c, this.line, this.pos);
                    }
                    if (!this.isIdentChar(c)) {
                        throw new ScannerException(this.line, this.pos, "unexpected character: " + c);
                    }
                    stringBuilder.append(c);
                    this.state = 6;
                    continue block15;
                }
                case 1: {
                    if (!EOF && c == '-') {
                        stringBuilder.append(c);
                        this.state = 5;
                        continue block15;
                    }
                    this.state = 6;
                    readNextChar = false;
                    continue block15;
                }
                case 5: {
                    if (c == '\n' || EOF) {
                        this.state = 0;
                        return new Token(stringBuilder.substring(2), 302, this.line, this.pos);
                    }
                    stringBuilder.append(c);
                    continue block15;
                }
                case 2: {
                    if (!EOF && c == '`') {
                        stringBuilder.append(c);
                        this.state = 3;
                        continue block15;
                    }
                    this.state = 6;
                    readNextChar = false;
                    continue block15;
                }
                case 3: {
                    if (!EOF && c == '`') {
                        stringBuilder.append(c);
                        this.state = 4;
                        continue block15;
                    }
                    this.state = 6;
                    readNextChar = false;
                    continue block15;
                }
                case 4: {
                    if (EOF) {
                        throw new ScannerException(this.line, this.pos, "unexpected EOF");
                    }
                    stringBuilder.append(c);
                    if (c != 96) continue block15;
                    this.state = 8;
                    continue block15;
                }
                case 8: {
                    if (!EOF && c == '`') {
                        stringBuilder.append(c);
                        this.state = 9;
                        continue block15;
                    }
                    this.state = 4;
                    readNextChar = false;
                    continue block15;
                }
                case 9: {
                    if (!EOF && c == '`') {
                        stringBuilder.append(c);
                        this.state = 0;
                        int length = stringBuilder.length();
                        String sql = stringBuilder.substring(3, length - 3).trim();
                        return new Token(sql, 300, this.line, this.pos);
                    }
                    this.state = 4;
                    readNextChar = false;
                    continue block15;
                }
                case 6: {
                    if (EOF || Character.isWhitespace(c)) {
                        this.state = 0;
                        String value = stringBuilder.toString();
                        if (value.equalsIgnoreCase("exec")) {
                            return new Token("", 303, this.line, this.pos);
                        }
                        if (value.equalsIgnoreCase("set")) {
                            return new Token("", 304, this.line, this.pos);
                        }
                        if (value.equalsIgnoreCase("reload")) {
                            return new Token("", 305, this.line, this.pos);
                        }
                        if (value.equalsIgnoreCase("metadata")) {
                            return new Token("", 306, this.line, this.pos);
                        }
                        if (value.equalsIgnoreCase("var")) {
                            return new Token("", 307, this.line, this.pos);
                        }
                        return new Token(stringBuilder.toString(), 301, this.line, this.pos);
                    }
                    stringBuilder.append(c);
                    continue block15;
                }
                case 7: {
                    if (EOF) {
                        throw new ScannerException(this.line, this.pos, "unexpected EOF");
                    }
                    if (c == '\r' || c == '\n') {
                        throw new ScannerException(this.line, this.pos, "unexpected new line");
                    }
                    stringBuilder.append(c);
                    if (c != 34) continue block15;
                    int length = stringBuilder.length();
                    String str = stringBuilder.substring(1, length - 1);
                    this.state = 0;
                    return new Token(str, 300, this.line, this.pos);
                }
                case 10: {
                    if (c == '*') {
                        stringBuilder.append(c);
                        this.state = 11;
                        continue block15;
                    }
                    if (EOF) {
                        throw new ScannerException(this.line, this.pos, "unexpected EOF");
                    }
                    this.state = 6;
                    readNextChar = false;
                    continue block15;
                }
                case 11: {
                    if (EOF) {
                        throw new ScannerException(this.line, this.pos, "unexpected EOF");
                    }
                    stringBuilder.append(c);
                    if (c != 42) continue block15;
                    this.state = 12;
                    continue block15;
                }
                case 12: {
                    if (EOF) {
                        throw new ScannerException(this.line, this.pos, "unexpected EOF");
                    }
                    if (c == '/') {
                        stringBuilder.append(c);
                        this.state = 0;
                        int length = stringBuilder.length();
                        return new Token(stringBuilder.substring(2, length - 2), 302, this.line, this.pos);
                    }
                    this.state = 11;
                    readNextChar = false;
                    continue block15;
                }
            }
            break;
        }
        throw new ScannerException(this.line, this.pos, "unexpected state: " + this.state);
    }

    public static void main(String[] args) throws IOException, ScannerException {
        FileInputStream fileInputStream = new FileInputStream("D:/test.txt");
        UnitTestScanner scanner = new UnitTestScanner(new InputStreamReader(fileInputStream));
        Token token = null;
        int i = 1;
        while ((token = scanner.getNextToken()) != null) {
            System.out.printf("%d: type: %d, value: [%s]\n", i++, token.getType(), token.getValue());
        }
    }
}

