/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.multiplex.threadpool;

import com.alibaba.fastjson2.JSON;
import com.hundsun.lightdb.dbabrun.bean.CompareMessageEntity;
import com.hundsun.lightdb.dbabrun.util.ExceptionUtils;
import com.hundsun.lightdb.multiplex.common.utils.idworker.IdUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ProducerExecutor {
    private static final Logger log = LoggerFactory.getLogger(ProducerExecutor.class);
    private ConcurrentHashMap<String, LinkedBlockingQueue<CompareMessageEntity>> map;
    private static ConcurrentHashMap<String, LinkedBlockingQueue<CompareMessageEntity>> concurrentHashMap = new ConcurrentHashMap();
    private static volatile ProducerExecutor instance;

    private ProducerExecutor(ConcurrentHashMap map) {
        this.map = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized ProducerExecutor getInstance() {
        if (instance != null) return instance;
        Class<ProducerExecutor> clazz = ProducerExecutor.class;
        synchronized (ProducerExecutor.class) {
            if (instance != null) return instance;
            instance = new ProducerExecutor(concurrentHashMap);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void produce(CompareMessageEntity compareMessage) {
        block8: {
            if (compareMessage == null || StringUtils.isEmpty((Object)compareMessage.getKey())) {
                if (log.isErrorEnabled()) {
                    String json = JSON.toJSONString((Object)compareMessage);
                    String msg = String.format("\u65e0\u6548\u7684 compareMessage %s", json);
                    log.error(msg);
                }
                return;
            }
            String sqlSentence = compareMessage.getSourceSql();
            String key = compareMessage.getKey();
            String traceId = compareMessage.getTraceId();
            if (!StringUtils.hasText((String)traceId)) {
                compareMessage.setTraceId("" + IdUtil.nextId());
            }
            if (sqlSentence.endsWith(";")) {
                compareMessage.setSourceSql(sqlSentence.substring(0, sqlSentence.length() - 1));
            }
            this.map.putIfAbsent(key, new LinkedBlockingQueue());
            if (log.isDebugEnabled()) {
                log.debug("=====ProducerExecutor produce map size is:{} ======", (Object)this.map.size());
            }
            LinkedBlockingQueue queue = (LinkedBlockingQueue)this.map.get(key);
            try {
                if (log.isDebugEnabled()) {
                    String json = JSON.toJSONString((Object)compareMessage);
                    String msg = String.format("put to the queue %s for key %s", json, key);
                    log.debug(msg);
                }
                queue.put(compareMessage);
            }
            catch (InterruptedException e) {
                if (!log.isErrorEnabled()) break block8;
                String json = JSON.toJSONString((Object)compareMessage);
                String trace = ExceptionUtils.getStackTrace((Exception)e);
                String msg = String.format("put to the queue error %s %s", json, trace);
                log.error(msg);
            }
        }
    }
}

