/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.golang;

import com.alibaba.fastjson2.JSON;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import com.hundsun.lightdb.unisql.constant.ErrorMessages;
import com.hundsun.lightdb.unisql.golang.GlobalStaticParameter;
import com.hundsun.lightdb.unisql.golang.GoParserFactory;
import com.hundsun.lightdb.unisql.golang.IGoParser;
import com.hundsun.lightdb.unisql.golang.ReturnParameter;
import com.hundsun.lightdb.unisql.golang.SqlKeywordChecker;
import com.hundsun.lightdb.unisql.golang.SqlState;
import com.hundsun.lightdb.unisql.golang.SyntaxAnalyseResult;
import com.hundsun.lightdb.unisql.golang.VariableParameter;
import com.hundsun.lightdb.unisql.model.ColumnMetadata;
import com.hundsun.lightdb.unisql.model.ConnectionConfig;
import com.hundsun.lightdb.unisql.model.MultiProperties;
import com.hundsun.lightdb.unisql.model.TableMeta;
import com.hundsun.lightdb.unisql.model.UnisqlProperties;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.utils.JsonUtils;
import com.hundsun.lightdb.unisql.utils.Murmur32HashFunction;
import com.hundsun.lightdb.unisql.utils.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transformer {
    private static final Logger log = LoggerFactory.getLogger(Transformer.class);
    private static boolean DEBUG;
    public static boolean COLLECT_PARAMS;
    public static boolean SEND_TO_COMPARE_SERVER;
    public static boolean SEND_MQ_TO_COMPARE_SERVER;
    public static ThreadLocal<VariableParameter> VARIABLE_PARAMETER_THREAD_LOCAL;
    public static GlobalStaticParameter globalStaticParameter;
    public static ConcurrentLinkedHashMap<String, ReturnParameter> Cache;
    public static ConcurrentLinkedHashMap<String, TableNameValue> TableNameCache;
    private static String SUCCESS_CODE;
    private static String SUCCESS_MESSAGE;
    public static final int DEFAULT_CACHE_CAPACITY = 10000;
    private static Pattern PATTERN_SKIP;
    private static Pattern PATTERN_NO_SKIP;
    private static final Pattern PATTERN_ORACLE19C_META_NAME_REPLACER;
    private static final Pattern LAST_INSERT_ID_PATTERN;
    private static final Object GO_SYNCHRONIZED_LOCK;
    private static final ThreadLocal<String> genLastInsertIdSql;
    private static final Pattern INSERT_VALUES_PATTERN;

    public static boolean matchesLastInsertIdSql(String sql) {
        if (sql == null) {
            return false;
        }
        Matcher matcher = LAST_INSERT_ID_PATTERN.matcher(sql);
        return matcher.matches();
    }

    public static void setGenLastInsertIdSql(String sql) {
        genLastInsertIdSql.set(sql);
    }

    public static String getGenLastInsertIdSql() {
        return genLastInsertIdSql.get();
    }

    public static void removeGenLastInsertIdSql() {
        genLastInsertIdSql.remove();
    }

    public static void setConfigration() {
        try {
            UnisqlProperties properties = UnisqlProperties.getInstance();
            DEBUG = properties.isDebug();
            VARIABLE_PARAMETER_THREAD_LOCAL = new ThreadLocal<VariableParameter>(){

                @Override
                protected VariableParameter initialValue() {
                    return VariableParameter.builder().restoreFmt(0L).build();
                }
            };
            globalStaticParameter = new GlobalStaticParameter();
            if (properties.isSkip()) {
                globalStaticParameter.setGlobalSkip(1);
            }
            if (properties.isMysqlBackslashEscapes()) {
                globalStaticParameter.setMysqlBackslashEscapes(1);
            }
            if (properties.isErrorSkip()) {
                globalStaticParameter.setGlobalErrorSkip(1);
            }
            long goGc = properties.getGOGC();
            globalStaticParameter.setGoGc(goGc);
            long goMemLimit = properties.getGOMEMLIMIT();
            globalStaticParameter.setGoMemLimit(goMemLimit);
            if (DEBUG) {
                globalStaticParameter.setUniSqlDebugLog(1);
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getCompareServerUrl())) {
                COLLECT_PARAMS = true;
                SEND_TO_COMPARE_SERVER = true;
                globalStaticParameter.setCompareServerUrl(properties.getCompareServerUrl());
            } else {
                COLLECT_PARAMS = false;
            }
            SEND_MQ_TO_COMPARE_SERVER = MultiProperties.getSendCompareService();
            if (StringUtils.isNotBlank((CharSequence)properties.getSchema())) {
                globalStaticParameter.setSchema(properties.getSchema());
            }
            if (StringUtils.isNotBlank((CharSequence)String.valueOf(properties.getRemoveDoublequoted()))) {
                globalStaticParameter.setRemoveDoubleQuoted(properties.getRemoveDoublequoted());
            }
            if (StringUtils.isNotBlank((CharSequence)String.valueOf(properties.getPrintSysinfo()))) {
                globalStaticParameter.setPrintSysInfo(properties.getPrintSysinfo());
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getDecodeParametersFuncNames())) {
                globalStaticParameter.setDecodeParametersFuncNames(properties.getDecodeParametersFuncNames());
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getGlobalReplaceSql())) {
                globalStaticParameter.setGlobalReplaceSql(properties.getGlobalReplaceSql());
            }
            if (StringUtils.isNotBlank((CharSequence)String.valueOf(properties.getDefaultChangeDatabaseToSchema()))) {
                globalStaticParameter.setChangeDatabaseToSchema(properties.getDefaultChangeDatabaseToSchema());
            }
            globalStaticParameter.setTableOrColumnNameRandom(properties.isTableOrColumnNameRandom());
            globalStaticParameter.setChangeBackQuotesToDoubleQuotes(properties.isChangeBackQuotesToDoubleQuotes());
            if (StringUtils.isNotBlank((CharSequence)properties.getKeywordDoubleQuotes())) {
                globalStaticParameter.setKeywordDoubleQuotes(properties.getKeywordDoubleQuotes());
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getOnUpdateCurrentimestampColumn())) {
                globalStaticParameter.setKeyOnUpdateColumn(properties.getOnUpdateCurrentimestampColumn());
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getOnUpdateCurrentimestampColumn())) {
                globalStaticParameter.setKeyOnUpdateColumn(properties.getOnUpdateCurrentimestampColumn());
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getAutoIncrementColumn())) {
                globalStaticParameter.setAutoIncrementColumn(properties.getAutoIncrementColumn());
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getTableColumnMetaDataSchemas())) {
                globalStaticParameter.setTableColumnMetadataSchemas(properties.getTableColumnMetaDataSchemas());
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getTableColumnReplaceDatatype())) {
                globalStaticParameter.setTableColumnReplaceDatatype(properties.getTableColumnReplaceDatatype());
            }
            if (StringUtils.isNotBlank((CharSequence)String.valueOf(properties.getDatatypeNumberReplaceInteger()))) {
                globalStaticParameter.setDatatypeNumberReplaceInteger(properties.getDatatypeNumberReplaceInteger());
            }
            if (StringUtils.isNotBlank((CharSequence)String.valueOf(properties.isRemoveTablespace()))) {
                globalStaticParameter.setUnisqlRemoveTablespace(properties.isRemoveTablespace());
            }
            globalStaticParameter.setUnisqlSkipExceptionKeywords(properties.getSkipExceptionKeywords());
            globalStaticParameter.setUnisqlBindVariableMode(properties.getUnisqlBindVariableMode());
            if (SEND_MQ_TO_COMPARE_SERVER && StringUtils.isNotBlank((CharSequence)properties.getUnsqlExcludeRulesDirectory())) {
                Utils.parseExcludeFile(properties.getUnsqlExcludeRulesDirectory());
            }
            if (properties.isOpenCache()) {
                globalStaticParameter.setIsCache(1);
            }
            IGoParser parser = GoParserFactory.getGoParser();
            try {
                parser.SetGlobalStaticParameter(JsonUtils.toJson(globalStaticParameter));
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn(ErrorMessages.format(ErrorMessages.LTU0004, JsonUtils.toJson(globalStaticParameter)), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error(ErrorMessages.format(ErrorMessages.LTU0004, e.getMessage()), (Throwable)e);
        }
    }

    public static void cleanCache() {
        if (log.isInfoEnabled()) {
            log.info("\u5f00\u59cb\u6e05\u7406\u7f13\u5b58\uff0c\u5f53\u524d\u7f13\u5b58\u6570\u91cf\uff1a" + Cache.size());
        }
        Cache.clear();
        if (log.isInfoEnabled()) {
            log.info("\u6e05\u7406\u7f13\u5b58\u7ed3\u675f\uff0c\u5f53\u524d\u7f13\u5b58\u6570\u91cf\uff1a" + Cache.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parse(String sql, String source, String target) {
        try {
            String string = Transformer.parse(sql, source, target, VARIABLE_PARAMETER_THREAD_LOCAL.get());
            return string;
        }
        finally {
            VARIABLE_PARAMETER_THREAD_LOCAL.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parse(String sql, String source, String target, long sessionId) {
        try {
            VariableParameter variable = VARIABLE_PARAMETER_THREAD_LOCAL.get();
            variable.setSessionId(sessionId);
            String string = Transformer.parse(sql, source, target, variable);
            return string;
        }
        finally {
            VARIABLE_PARAMETER_THREAD_LOCAL.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parse(String sql, String source, String target, VariableParameter variableParameter) {
        try {
            String string = Transformer.parse(sql, source, target, variableParameter, null);
            return string;
        }
        finally {
            VARIABLE_PARAMETER_THREAD_LOCAL.remove();
        }
    }

    public static String parse(String sql, String source, String target, VariableParameter variableParameter, ReturnParameter parameter) {
        if (log.isDebugEnabled()) {
            log.debug("\u8f6c\u6362\u524d {}", (Object)sql);
        }
        ReturnParameter returnParameter = Transformer.parsePro(sql, source, target, variableParameter);
        if (!SqlState.SUCCESS.getState().equals(returnParameter.getState())) {
            throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0006, returnParameter.getState(), returnParameter.getMessage(), sql));
        }
        if (parameter != null) {
            parameter.setTargetSql(returnParameter.getTargetSql());
            parameter.setAutoIncrementColumnIndex(returnParameter.getAutoIncrementColumnIndex());
            parameter.setColumnCountSum(returnParameter.getColumnCountSum());
            parameter.setBindVariableOrder(returnParameter.getBindVariableOrder());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8f6c\u6362\u540e {}", (Object)returnParameter.getTargetSql());
        }
        return returnParameter.getTargetSql();
    }

    @Deprecated
    public static ReturnParameter parseUseCache(String sql, String source, String target, boolean useCache) {
        return Transformer.parseUseCache(sql, source, target, useCache, VariableParameter.builder().restoreFmt(0L).build());
    }

    @Deprecated
    public static ReturnParameter parseUseCache(String sql, String source, String target, boolean useCache, VariableParameter variableParameter) {
        return Transformer.parsePro(sql, source, target, variableParameter);
    }

    public static ReturnParameter returnSourceSql(String sql) {
        ReturnParameter returnParameter = new ReturnParameter();
        returnParameter.setSourceSql(sql);
        returnParameter.setTargetSql(sql);
        returnParameter.setState(SUCCESS_CODE);
        returnParameter.setMessage(SUCCESS_MESSAGE);
        return returnParameter;
    }

    public static boolean matchesInsertValuesSql(String sql) {
        if (sql == null) {
            return false;
        }
        Matcher matcher = INSERT_VALUES_PATTERN.matcher(sql);
        return matcher.matches();
    }

    public static String[] splitSqlByLastSemicolon(String sql) {
        if (sql == null || sql.isEmpty()) {
            return new String[]{sql};
        }
        int lastIndex = sql.lastIndexOf(59);
        if (lastIndex == -1) {
            return new String[]{sql};
        }
        String firstPart = sql.substring(0, lastIndex).trim();
        String secondPart = sql.substring(lastIndex + 1).trim();
        return new String[]{firstPart, secondPart};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReturnParameter parsePro(String sql, String source, String target, VariableParameter variableParameter) {
        ReturnParameter returnParameter;
        String key;
        ReturnParameter parameter;
        String cacheKey = "";
        if (globalStaticParameter.getIsCache() == 1 && (parameter = (ReturnParameter)Cache.get((Object)(cacheKey = Murmur32HashFunction.calcHash(key = String.join((CharSequence)":", source, target, sql))))) != null && parameter.getSourceSql().equals(sql)) {
            return parameter;
        }
        if (1 == UnisqlProperties.getGenLastInsertIdAfterInsert() && Transformer.matchesLastInsertIdSql(sql)) {
            String lastInsertIdSql = Transformer.getGenLastInsertIdSql();
            if (StringUtils.isNotBlank((CharSequence)lastInsertIdSql)) {
                return Transformer.returnSourceSql(lastInsertIdSql);
            }
            throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0026, sql));
        }
        if (globalStaticParameter.getGlobalSkip() == 1) {
            boolean sqlNoSkip = PATTERN_NO_SKIP.matcher(sql).find();
            if (!sqlNoSkip && !SqlKeywordChecker.isSqlHaveKeyword(sql, globalStaticParameter.getUnisqlSkipExceptionKeywords())) {
                returnParameter = Transformer.returnSourceSql(sql);
                Cache.put((Object)cacheKey, (Object)returnParameter);
                return returnParameter;
            }
        } else {
            boolean sqlSkip = PATTERN_SKIP.matcher(sql).find();
            if (sqlSkip) {
                returnParameter = Transformer.returnSourceSql(sql);
                Cache.put((Object)cacheKey, (Object)returnParameter);
                return returnParameter;
            }
        }
        IGoParser parser = GoParserFactory.getGoParser();
        variableParameter.setSourceSql(sql);
        variableParameter.setSourceDialect(source);
        variableParameter.setTargetDialect(target);
        Pointer transformResultPointer = null;
        try {
            String[] splitSqlByLastSemicolon;
            byte[] encode = variableParameter.encodeToBytes();
            Runtime runtime = Runtime.getSystemRuntime();
            Pointer transformParamPointer = Pointer.wrap((Runtime)runtime, (ByteBuffer)ByteBuffer.wrap(encode));
            if (MultiProperties.RUN_WHAT == 2) {
                Object object = GO_SYNCHRONIZED_LOCK;
                synchronized (object) {
                    transformResultPointer = parser.UnisqlTransformInternel(transformParamPointer);
                }
            } else {
                transformResultPointer = parser.UnisqlTransformInternel(transformParamPointer);
            }
            ReturnParameter returnParameter2 = ReturnParameter.decode(transformResultPointer);
            if (1 == UnisqlProperties.getGenLastInsertIdAfterInsert() && SqlState.SUCCESS.getState().equals(returnParameter2.getState()) && Transformer.matchesInsertValuesSql(sql) && (splitSqlByLastSemicolon = Transformer.splitSqlByLastSemicolon(returnParameter2.getTargetSql())).length == 2) {
                returnParameter2.setTargetSql(splitSqlByLastSemicolon[0]);
                Transformer.setGenLastInsertIdSql(splitSqlByLastSemicolon[1]);
            }
            if (globalStaticParameter.getIsCache() == 1) {
                returnParameter2.setSourceSql(sql);
                Cache.put((Object)cacheKey, (Object)returnParameter2);
            }
            ReturnParameter returnParameter3 = returnParameter2;
            if (transformResultPointer != null) {
                parser.FreePointer(transformResultPointer);
            }
            return returnParameter3;
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0005, e.getMessage()));
            }
            catch (Throwable throwable) {
                if (transformResultPointer != null) {
                    parser.FreePointer(transformResultPointer);
                }
                throw throwable;
            }
        }
    }

    public static boolean containsSkipTransform(String sql) {
        Pattern pattern = Pattern.compile("/\\*skipTransform\\*/", 2);
        if (pattern.matcher(sql).find()) {
            if (log.isWarnEnabled()) {
                log.warn("\u6ce8\u610f\uff1a\u5f53\u524dsql\u4f7f\u7528/*skipTransform*/\u6807\u8bc6\u7b26\u8df3\u8fc7\u8f6c\u5316\uff0c24.3\u7248\u672c\u5f00\u59cb\u5efa\u8bae\u4f7f\u7528\u6807\u8bc6\u7b26/*+skipTransform*/\uff0c\u539f\u6807\u8bc6\u7b26\u540e\u7eed\u4f1a\u5e9f\u5f03\u3002");
            }
            return true;
        }
        return false;
    }

    public static void setParamInt(String paramName, int paramValue) {
        IGoParser parser = GoParserFactory.getGoParser();
        parser.SetParamInt(paramName, paramValue);
    }

    public static void setParamStr(String paramName, String paramValue) {
        IGoParser parser = GoParserFactory.getGoParser();
        parser.SetParamStr(paramName, paramValue);
    }

    public static void setParamBool(String paramName, boolean paramValue) {
        IGoParser parser = GoParserFactory.getGoParser();
        parser.SetParamBool(paramName, paramValue);
    }

    public static void setSessionParamStr(String paramName, String paramValue, long sessionId) {
        IGoParser parser = GoParserFactory.getGoParser();
        parser.UnisqlSetSessionParamStr(paramName, paramValue, sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReturnParameter getDqlByDml(VariableParameter variableParameter) {
        Pointer p;
        IGoParser parser = GoParserFactory.getGoParser();
        String encode = variableParameter.encode();
        if (MultiProperties.RUN_WHAT == 2) {
            Object object = GO_SYNCHRONIZED_LOCK;
            synchronized (object) {
                p = parser.GetDqlByDml(encode);
            }
        } else {
            p = parser.GetDqlByDml(encode);
        }
        try {
            String utf8 = p.getString(0L, Integer.MAX_VALUE, StandardCharsets.UTF_8);
            ReturnParameter returnParameter = null;
            try {
                returnParameter = ReturnParameter.decode(utf8);
            }
            catch (Exception e) {
                throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0005, utf8));
            }
            ReturnParameter returnParameter2 = returnParameter;
            return returnParameter2;
        }
        finally {
            parser.FreePointer(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReturnParameter initTableMetas(String tableMetas) {
        IGoParser parser = GoParserFactory.getGoParser();
        Pointer p = parser.InitTableMetas(tableMetas);
        try {
            String utf8 = p.getString(0L, Integer.MAX_VALUE, StandardCharsets.UTF_8);
            ReturnParameter returnParameter = null;
            try {
                returnParameter = (ReturnParameter)JSON.parseObject((String)utf8, ReturnParameter.class);
            }
            catch (Exception e) {
                throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0005, utf8));
            }
            ReturnParameter returnParameter2 = returnParameter;
            return returnParameter2;
        }
        finally {
            parser.FreePointer(p);
        }
    }

    public static ReturnParameter initTableMetas(List<TableMeta> tableMetas) {
        return Transformer.initTableMetas(JsonUtils.toJson(tableMetas));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReturnParameter initTableColumnMetas(ConnectionConfig odbcConfig) {
        IGoParser parser = GoParserFactory.getGoParser();
        if (DbType.ORACLE_19C.name().equalsIgnoreCase(odbcConfig.getTargetDialect()) || DbType.ORACLE.name().equalsIgnoreCase(odbcConfig.getTargetDialect()) || DbType.OCEAN_BASE_ORACLE.name().equalsIgnoreCase(odbcConfig.getTargetDialect())) {
            List<ColumnMetadata> columnMetadataList;
            try {
                columnMetadataList = DbType.OCEAN_BASE_ORACLE.name().equalsIgnoreCase(odbcConfig.getTargetDialect()) ? Transformer.queryObOracleColumnMetadata(odbcConfig) : Transformer.queryOracleColumnMetadata(odbcConfig);
            }
            catch (Exception e) {
                throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0025, e.toString()), e);
            }
            String fileName = String.format("unisql_tmp_%s_%s_%s_%s_%s.txt", PATTERN_ORACLE19C_META_NAME_REPLACER.matcher(odbcConfig.getTargetDialect()).replaceAll("_"), PATTERN_ORACLE19C_META_NAME_REPLACER.matcher(odbcConfig.getHost()).replaceAll("_"), PATTERN_ORACLE19C_META_NAME_REPLACER.matcher(odbcConfig.getPort()).replaceAll("_"), PATTERN_ORACLE19C_META_NAME_REPLACER.matcher(odbcConfig.getDbname()).replaceAll("_"), PATTERN_ORACLE19C_META_NAME_REPLACER.matcher(odbcConfig.getUser()).replaceAll("_"));
            String tmpFileContent = JsonUtils.toJson(columnMetadataList);
            String tempDir = System.getProperty("java.io.tmpdir");
            Path tmpFilePath = Paths.get(tempDir, new String[0]).resolve(fileName);
            try {
                Files.write(tmpFilePath, tmpFileContent.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (Exception e) {
                throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0025, e.toString()), e);
            }
        }
        Pointer p = parser.InitTableColumnMetas(JsonUtils.toJson(odbcConfig));
        try {
            String utf8 = p.getString(0L, Integer.MAX_VALUE, StandardCharsets.UTF_8);
            ReturnParameter returnParameter = null;
            try {
                returnParameter = (ReturnParameter)JSON.parseObject((String)utf8, ReturnParameter.class);
            }
            catch (Exception e) {
                throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0005, utf8));
            }
            ReturnParameter returnParameter2 = returnParameter;
            return returnParameter2;
        }
        finally {
            parser.FreePointer(p);
        }
    }

    public static void checkVersion() {
        log.info("sql-convert-runtime\u7248\u672c\u53f7\u4e3a[{}]", (Object)"25.3.0");
        IGoParser parser = GoParserFactory.getGoParser();
        Pointer p = null;
        try {
            p = parser.CheckIterationVersion("25.3.0");
            String state = p.getString(0L, Integer.MAX_VALUE, StandardCharsets.UTF_8);
            if (!SqlState.SUCCESS.getState().equals(state)) {
                throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0016, state));
            }
            log.info("\u7edf\u4e00SQL\u7248\u672c\u53f7\u9a8c\u8bc1\u901a\u8fc7\uff1asql-convert-runtime\u7248\u672c\u53f7\u4e3a[{}]", (Object)"25.3.0");
        }
        catch (UnsatisfiedLinkError e) {
            String msg = String.format("\u7248\u672c\u53f7\u4e0d\u5339\u914d\uff1asql-convert-runtime\u7248\u672c\u53f7[%s] Go\u94fe\u63a5\u5e93\u4e0d\u652f\u6301\u8bfb\u53d6\u7248\u672c\u53f7", "25.3.0");
            log.error(msg);
            throw new RuntimeException(msg);
        }
        finally {
            if (p != null) {
                parser.FreePointer(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTableName(VariableParameter variableParameter) {
        Pointer p;
        String key;
        TableNameValue parameter;
        String cacheKey = "";
        if (globalStaticParameter.getIsCache() == 1 && (parameter = (TableNameValue)TableNameCache.get((Object)(cacheKey = Murmur32HashFunction.calcHash(key = String.join((CharSequence)":", variableParameter.getSourceDialect(), variableParameter.getTargetDialect(), variableParameter.getSourceSql()))))) != null && parameter.sourceSql.equals(variableParameter.getSourceSql())) {
            return parameter.tableNames;
        }
        IGoParser parser = GoParserFactory.getGoParser();
        String encode = variableParameter.encode();
        if (MultiProperties.RUN_WHAT == 2) {
            Object object = GO_SYNCHRONIZED_LOCK;
            synchronized (object) {
                p = parser.GetTableName(encode);
            }
        } else {
            p = parser.GetTableName(encode);
        }
        try {
            String tableNames = p.getString(0L, Integer.MAX_VALUE, StandardCharsets.UTF_8);
            if (globalStaticParameter.getIsCache() == 1) {
                TableNameCache.put((Object)cacheKey, (Object)new TableNameValue(variableParameter.getSourceSql(), tableNames));
            }
            String string = tableNames;
            return string;
        }
        finally {
            parser.FreePointer(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SyntaxAnalyseResult CheckCompatibleScanSql(VariableParameter variableParameter) {
        IGoParser parser = GoParserFactory.getGoParser();
        String encode = variableParameter.encode();
        Pointer p = parser.CheckCompatibleScanSql(encode);
        try {
            String utf8 = p.getString(0L, Integer.MAX_VALUE, StandardCharsets.UTF_8);
            SyntaxAnalyseResult returnParameter = null;
            try {
                returnParameter = (SyntaxAnalyseResult)JSON.parseObject((String)utf8, SyntaxAnalyseResult.class);
            }
            catch (Exception e) {
                throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0005, utf8));
            }
            SyntaxAnalyseResult syntaxAnalyseResult = returnParameter;
            return syntaxAnalyseResult;
        }
        finally {
            parser.FreePointer(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReturnParameter IdentifySqlType(VariableParameter variableParameter) {
        Pointer p;
        IGoParser parser = GoParserFactory.getGoParser();
        String encode = variableParameter.encode();
        if (MultiProperties.RUN_WHAT == 2) {
            Object object = GO_SYNCHRONIZED_LOCK;
            synchronized (object) {
                p = parser.UnisqlIdentifySQLType(encode);
            }
        } else {
            p = parser.UnisqlIdentifySQLType(encode);
        }
        try {
            String utf8 = p.getString(0L, Integer.MAX_VALUE, StandardCharsets.UTF_8);
            ReturnParameter returnParameter = null;
            try {
                returnParameter = ReturnParameter.decode(utf8);
            }
            catch (Exception e) {
                throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0005, utf8));
            }
            ReturnParameter returnParameter2 = returnParameter;
            return returnParameter2;
        }
        finally {
            parser.FreePointer(p);
        }
    }

    private static List<ColumnMetadata> queryOracleColumnMetadata(ConnectionConfig connectionConfig) throws Exception {
        String finalSchemas;
        Class.forName("oracle.jdbc.OracleDriver");
        if (StringUtils.isNotEmpty((CharSequence)connectionConfig.getSchemas())) {
            log.debug("\u4eceschema\uff1a[{}]\u4e2d\u83b7\u53d6\u5143\u6570\u636e", (Object)connectionConfig.getSchemas());
            finalSchemas = connectionConfig.getSchemas();
        } else if (StringUtils.isNotEmpty((CharSequence)globalStaticParameter.getTableColumnMetadataSchemas())) {
            log.debug("\u4eceschema\uff1a[{}]\u83b7\u53d6\u5143\u6570\u636e", (Object)globalStaticParameter.getTableColumnMetadataSchemas());
            finalSchemas = globalStaticParameter.getTableColumnMetadataSchemas();
        } else {
            log.debug("\u4f7f\u7528\u76ee\u6807\u5e93\u5f53\u524dschema\uff1a[sys_context('USERENV', 'CURRENT_SCHEMA')]\u83b7\u53d6\u5143\u6570\u636e");
            finalSchemas = "sys_context('USERENV', 'CURRENT_SCHEMA')";
        }
        String query = String.format("SELECT (cols.table_name) AS table_name, (cols.column_name) AS column_name, (cols.data_type) AS data_type, CASE cols.nullable WHEN 'N' THEN 'NO' ELSE 'YES' END AS is_nullable, CASE WHEN (  SELECT cons.CONSTRAINT_TYPE  FROM ALL_CONSTRAINTS cons  WHERE cons.OWNER = COLS.OWNER  AND cons.TABLE_NAME = cols.TABLE_NAME  AND cons.CONSTRAINT_NAME = indc.INDEX_NAME  AND rownum = 1 ) = 'P' THEN 'PRIMARY KEY' WHEN (  SELECT inds.UNIQUENESS  FROM ALL_INDEXES inds  WHERE inds.OWNER = cols.OWNER  AND inds.TABLE_NAME = cols.TABLE_NAME  AND inds.INDEX_NAME = indc.INDEX_NAME  AND rownum = 1 ) = 'UNIQUE' THEN 'UNIQUE' ELSE NULL END AS constraint_type, cols.DATA_DEFAULT AS column_default, cols.COLUMN_ID AS ordinal_position, case when cols.nullable = 'N' then 'YES' else 'NO' end as null_constraint, 'NO' AS auto_increment, 'NO' AS on_update_current_timestamp, indc.INDEX_NAME AS CONSTRAINT_NAME FROM ALL_TAB_COLUMNS cols LEFT JOIN ALL_IND_COLUMNS indc ON cols.OWNER = indc.INDEX_OWNER AND cols.TABLE_NAME = indc.TABLE_NAME AND cols.COLUMN_NAME = indc.COLUMN_NAME WHERE cols.owner in (%s) ORDER BY cols.TABLE_NAME, cols.COLUMN_ID", finalSchemas);
        String jdbcUrl = String.format("jdbc:oracle:thin:@%s:%s/%s", connectionConfig.getHost(), connectionConfig.getPort(), connectionConfig.getDbname());
        log.debug("\u4ece Oracle \u5e93\u4e2d\u83b7\u53d6\u5143\u6570\u636e\uff0c\u8fde\u63a5\uff1a{}\uff0c\u7528\u6237\uff1a{}", (Object)jdbcUrl, (Object)connectionConfig.getUser());
        ArrayList<ColumnMetadata> metadataList = new ArrayList<ColumnMetadata>();
        try (Connection connection = DriverManager.getConnection(jdbcUrl, connectionConfig.getUser(), connectionConfig.getPassword());
             Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            while (rs.next()) {
                ColumnMetadata columnMetadata = new ColumnMetadata();
                columnMetadata.setTableName(rs.getString(1));
                columnMetadata.setColumnName(rs.getString(2));
                columnMetadata.setDataType(rs.getString(3));
                columnMetadata.setIsNullable(rs.getString(4));
                columnMetadata.setConstraintType(rs.getString(5));
                columnMetadata.setColumnDefault(rs.getString(6));
                columnMetadata.setOrdinalPosition(rs.getInt(7));
                columnMetadata.setNullConstraint(rs.getString(8));
                columnMetadata.setAutoIncrement(rs.getString(9));
                columnMetadata.setOnUpdateCurrentTimestamp(rs.getString(10));
                columnMetadata.setConstraintName(rs.getString(11));
                metadataList.add(columnMetadata);
            }
        }
        return metadataList;
    }

    private static List<ColumnMetadata> queryObOracleColumnMetadata(ConnectionConfig connectionConfig) throws Exception {
        String finalSchemas;
        Class.forName("com.alipay.oceanbase.jdbc.Driver");
        if (StringUtils.isNotEmpty((CharSequence)connectionConfig.getSchemas())) {
            log.debug("\u4eceschema\uff1a[{}]\u4e2d\u83b7\u53d6\u5143\u6570\u636e", (Object)connectionConfig.getSchemas());
            finalSchemas = connectionConfig.getSchemas();
        } else if (StringUtils.isNotEmpty((CharSequence)globalStaticParameter.getTableColumnMetadataSchemas())) {
            log.debug("\u4eceschema\uff1a[{}]\u83b7\u53d6\u5143\u6570\u636e", (Object)globalStaticParameter.getTableColumnMetadataSchemas());
            finalSchemas = globalStaticParameter.getTableColumnMetadataSchemas();
        } else {
            log.debug("\u4f7f\u7528\u76ee\u6807\u5e93\u5f53\u524dschema\uff1a[sys_context('USERENV', 'CURRENT_SCHEMA')]\u83b7\u53d6\u5143\u6570\u636e");
            finalSchemas = "sys_context('USERENV', 'CURRENT_SCHEMA')";
        }
        String query = String.format("SELECT cols.table_name AS table_name, cols.column_name AS column_name, cols.data_type AS data_type, CASE cols.nullable WHEN 'N' THEN 'NO' ELSE 'YES' END AS is_nullable, CASE WHEN (  SELECT cons.CONSTRAINT_TYPE  FROM ALL_CONSTRAINTS cons  WHERE cons.OWNER = COLS.OWNER  AND cons.TABLE_NAME = cols.TABLE_NAME  AND cons.CONSTRAINT_NAME = indc.INDEX_NAME  AND rownum = 1 ) = 'P' THEN 'PRIMARY KEY' WHEN (  SELECT inds.UNIQUENESS  FROM ALL_INDEXES inds  WHERE inds.OWNER = cols.OWNER  AND inds.TABLE_NAME = cols.TABLE_NAME  AND inds.INDEX_NAME = indc.INDEX_NAME  AND rownum = 1 ) = 'UNIQUE' THEN 'UNIQUE' ELSE NULL END AS constraint_type, cols.DATA_DEFAULT AS column_default, cols.COLUMN_ID AS ordinal_position, case when cols.nullable = 'N' then 'YES' else 'NO' end as null_constraint, 'NO' AS auto_increment, 'NO' AS on_update_current_timestamp, indc.INDEX_NAME AS CONSTRAINT_NAME FROM ALL_TAB_COLUMNS cols LEFT JOIN ALL_IND_COLUMNS indc ON cols.OWNER = indc.INDEX_OWNER AND cols.TABLE_NAME = indc.TABLE_NAME AND cols.COLUMN_NAME = indc.COLUMN_NAME WHERE cols.owner in (%s) ORDER BY cols.TABLE_NAME, cols.COLUMN_ID", finalSchemas);
        String jdbcUrl = String.format("jdbc:oceanbase://%s:%s/%s", connectionConfig.getHost(), connectionConfig.getPort(), connectionConfig.getDbname());
        log.debug("\u4ece OB-ORACLE \u5e93\u4e2d\u83b7\u53d6\u5143\u6570\u636e\uff0c\u8fde\u63a5\uff1a{}\uff0c\u7528\u6237\uff1a{}", (Object)jdbcUrl, (Object)connectionConfig.getUser());
        ArrayList<ColumnMetadata> metadataList = new ArrayList<ColumnMetadata>();
        try (Connection connection = DriverManager.getConnection(jdbcUrl, connectionConfig.getUser(), connectionConfig.getPassword());
             Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            while (rs.next()) {
                ColumnMetadata columnMetadata = new ColumnMetadata();
                columnMetadata.setTableName(rs.getString(1));
                columnMetadata.setColumnName(rs.getString(2));
                columnMetadata.setDataType(rs.getString(3));
                columnMetadata.setIsNullable(rs.getString(4));
                columnMetadata.setConstraintType(rs.getString(5));
                columnMetadata.setColumnDefault(rs.getString(6));
                columnMetadata.setOrdinalPosition(rs.getInt(7));
                columnMetadata.setNullConstraint(rs.getString(8));
                columnMetadata.setAutoIncrement(rs.getString(9));
                columnMetadata.setOnUpdateCurrentTimestamp(rs.getString(10));
                columnMetadata.setConstraintName(rs.getString(11));
                metadataList.add(columnMetadata);
            }
        }
        return metadataList;
    }

    public static Long createSession() {
        IGoParser parser = GoParserFactory.getGoParser();
        return parser.UnisqlCreateSession();
    }

    public static void freeSession(Long sessionId) {
        IGoParser parser = GoParserFactory.getGoParser();
        parser.UnisqlFreeSession(sessionId);
    }

    public static void main(String[] args) {
        VariableParameter variableParameter = new VariableParameter();
        IGoParser parser = GoParserFactory.getGoParser();
        variableParameter.setSourceSql("select '\u6d59\u6c5f\u7701\u676d\u5dde\u5e02abc\u6052\u751f\u7535\u5b50123\u65e5\u671f111',122312,111 from dual");
        variableParameter.setSourceDialect("oracle");
        variableParameter.setTargetDialect("postgresql");
        Pointer transformResultPointer = null;
        try {
            byte[] encode = variableParameter.encodeToBytes();
            Runtime runtime = Runtime.getSystemRuntime();
            Pointer transformParamPointer = Pointer.wrap((Runtime)runtime, (ByteBuffer)ByteBuffer.wrap(encode));
            transformResultPointer = parser.UnisqlTransformInternel(transformParamPointer);
            ReturnParameter returnParameter = ReturnParameter.decode(transformResultPointer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        SUCCESS_CODE = "00000";
        SUCCESS_MESSAGE = "SUCCESS";
        PATTERN_SKIP = Pattern.compile("/\\*\\+.*?\\bskiptransform\\b.*?\\*/", 34);
        PATTERN_NO_SKIP = Pattern.compile("/\\*\\+.*?\\bnoskiptransform\\b.*?\\*/", 34);
        PATTERN_ORACLE19C_META_NAME_REPLACER = Pattern.compile("[\\\\/*?:\"<>|]");
        LAST_INSERT_ID_PATTERN = Pattern.compile("^\\s*SELECT\\s+LAST_INSERT_ID\\s*\\(\\s*\\)\\s*;?\\s*$", 2);
        GO_SYNCHRONIZED_LOCK = new Object();
        genLastInsertIdSql = ThreadLocal.withInitial(() -> null);
        Transformer.setConfigration();
        Cache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(10000L).weigher(Weighers.singleton()).build();
        TableNameCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(10000L).weigher(Weighers.singleton()).build();
        INSERT_VALUES_PATTERN = Pattern.compile("^\\s*INSERT\\s+INTO\\s+(.+?)\\s+(VALUES)\\s*\\((.+?)\\)\\s*;?\\s*$", 34);
    }

    static class TableNameValue {
        String sourceSql;
        String tableNames;

        public TableNameValue(String sourceSql, String tableNames) {
            this.sourceSql = sourceSql;
            this.tableNames = tableNames;
        }
    }
}

