/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.utils;

import com.hundsun.lightdb.unisql.utils.HashCode;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class Murmur32HashFunction
implements Serializable {
    public static final Murmur32HashFunction GOOD_FAST_HASH_32;
    private final int seed;
    private static final long serialVersionUID = 0L;
    static final int GOOD_FAST_HASH_SEED;

    public static final String calcHash(String value) {
        return GOOD_FAST_HASH_32.hashString(value, StandardCharsets.UTF_8).toString();
    }

    Murmur32HashFunction(int seed) {
        this.seed = seed;
    }

    public int bits() {
        return 32;
    }

    public String toString() {
        return "Hashing.murmur3_32(" + this.seed + ")";
    }

    public boolean equals(Object object) {
        if (object instanceof Murmur32HashFunction) {
            Murmur32HashFunction other = (Murmur32HashFunction)object;
            return this.seed == other.seed;
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.seed;
    }

    public HashCode hashBytes(byte[] input) {
        return this.hashBytes(input, 0, input.length);
    }

    public HashCode hashString(CharSequence input, Charset charset) {
        int codePoint;
        char c;
        if (!StandardCharsets.UTF_8.equals(charset)) {
            return this.hashBytes(input.toString().getBytes(charset));
        }
        int utf16Length = input.length();
        int h1 = this.seed;
        int i = 0;
        int len = 0;
        while (i + 4 <= utf16Length) {
            char c0 = input.charAt(i);
            char c1 = input.charAt(i + 1);
            char c2 = input.charAt(i + 2);
            c = input.charAt(i + 3);
            if (c0 >= '\u0080' || c1 >= '\u0080' || c2 >= '\u0080' || c >= '\u0080') break;
            codePoint = c0 | c1 << 8 | c2 << 16 | c << 24;
            codePoint = Murmur32HashFunction.mixK1(codePoint);
            h1 = Murmur32HashFunction.mixH1(h1, codePoint);
            i += 4;
            len += 4;
        }
        long buffer = 0L;
        int shift = 0;
        while (i < utf16Length) {
            c = input.charAt(i);
            if (c < '\u0080') {
                buffer |= (long)c << shift;
                shift += 8;
                ++len;
            } else if (c < '\u0800') {
                buffer |= Murmur32HashFunction.charToTwoUtf8Bytes(c) << shift;
                shift += 16;
                len += 2;
            } else if (c >= '\ud800' && c <= '\udfff') {
                codePoint = Character.codePointAt(input, i);
                if (codePoint == c) {
                    return this.hashBytes(input.toString().getBytes(charset));
                }
                ++i;
                buffer |= Murmur32HashFunction.codePointToFourUtf8Bytes(codePoint) << shift;
                len += 4;
            } else {
                buffer |= Murmur32HashFunction.charToThreeUtf8Bytes(c) << shift;
                shift += 24;
                len += 3;
            }
            if (shift >= 32) {
                codePoint = Murmur32HashFunction.mixK1((int)buffer);
                h1 = Murmur32HashFunction.mixH1(h1, codePoint);
                buffer >>>= 32;
                shift -= 32;
            }
            ++i;
        }
        int k1 = Murmur32HashFunction.mixK1((int)buffer);
        return Murmur32HashFunction.fmix(h1 ^= k1, len);
    }

    public static void checkPositionIndexes(int start, int end, int size) {
        if (start < 0 || end < start || end > size) {
            throw new IndexOutOfBoundsException(String.format("start:%d  end:%d size:%d ", start, end, size));
        }
    }

    public HashCode hashBytes(byte[] input, int off, int len) {
        int k1;
        Murmur32HashFunction.checkPositionIndexes(off, off + len, input.length);
        int h1 = this.seed;
        int i = 0;
        while (i + 4 <= len) {
            k1 = Murmur32HashFunction.mixK1(Murmur32HashFunction.getIntLittleEndian(input, off + i));
            h1 = Murmur32HashFunction.mixH1(h1, k1);
            i += 4;
        }
        k1 = 0;
        int shift = 0;
        while (i < len) {
            k1 ^= Murmur32HashFunction.toInt(input[off + i]) << shift;
            ++i;
            shift += 8;
        }
        return Murmur32HashFunction.fmix(h1 ^= Murmur32HashFunction.mixK1(k1), len);
    }

    public static int toInt(byte value) {
        return value & 0xFF;
    }

    public static int fromBytes(byte b1, byte b2, byte b3, byte b4) {
        return b1 << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    private static int getIntLittleEndian(byte[] input, int offset) {
        return Murmur32HashFunction.fromBytes(input[offset + 3], input[offset + 2], input[offset + 1], input[offset]);
    }

    private static int mixK1(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        return k1 *= 461845907;
    }

    private static int mixH1(int h1, int k1) {
        h1 ^= k1;
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        return h1;
    }

    private static HashCode fmix(int h1, int length) {
        h1 ^= length;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return HashCode.fromInt(h1);
    }

    private static long codePointToFourUtf8Bytes(int codePoint) {
        return (0xF0L | (long)(codePoint >>> 18)) & 0xFFL | (0x80L | (long)(0x3F & codePoint >>> 12)) << 8 | (0x80L | (long)(0x3F & codePoint >>> 6)) << 16 | (0x80L | (long)(0x3F & codePoint)) << 24;
    }

    private static long charToThreeUtf8Bytes(char c) {
        return (0x1E0 | c >>> 12) & 0xFF | (0x80 | 0x3F & c >>> 6) << 8 | (0x80 | 0x3F & c) << 16;
    }

    private static long charToTwoUtf8Bytes(char c) {
        return (0x3C0 | c >>> 6) & 0xFF | (0x80 | 0x3F & c) << 8;
    }

    static {
        GOOD_FAST_HASH_SEED = (int)System.currentTimeMillis();
        GOOD_FAST_HASH_32 = new Murmur32HashFunction(GOOD_FAST_HASH_SEED);
    }
}

