/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.upgrade;

import com.hundsun.lightdb.unisql.annotation.SuppressFBWarnings;
import com.hundsun.lightdb.unisql.upgrade.DbType;
import com.hundsun.lightdb.unisql.upgrade.TargetUniSqlVersion;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@SuppressFBWarnings(value={"SQL_INJECTION_JDBC"})
public class SqlExecutor {
    private static final Logger log = LoggerFactory.getLogger(SqlExecutor.class);
    public static final String VERSION_TABLE_EXISTS = "select count(1) count from information_schema.tables where table_schema = '%s' and table_name = 'unisql_version'";
    public static final String POSTGRESQL_VERSION_TABLE_EXISTS = "select count(1) count from pg_tables where schemaname = '%s' and tablename='unisql_version'";
    public static final String SELECT_UNISQL_VERSION = "select version from %s.unisql_version where id = 1";
    public static final String INSERT_UNISQL_VERSION = "insert into %s.unisql_version values(1,?,now())";
    public static final String UPDATE_UNISQL_VERSION = "update %s.unisql_version set version=?,update_time=now() where id = 1";
    public static final String GAUSSDB_ORACLE_JDBC_DRIVER = "com.huawei.opengauss.jdbc.Driver";
    public static final String GAUSSDB_ORACLE_JDBC_URL = "jdbc:opengauss://%s:%s/%s";
    public static final String GAUSSDB_ORACLE_CREATE_UNISQL_VERSION = "create table if not exists %s.unisql_version (id int primary key,version varchar(20),update_time date)";
    public static final String POSTGRESQL_JDBC_DRIVER = "org.postgresql.Driver";
    public static final String POSTGRESQL_JDBC_URL = "jdbc:postgresql://%s:%s/%s";
    public static final String POSTGRESQL_CREATE_UNISQL_VERSION = "create table if not exists %s.unisql_version (id int primary key,version varchar(20),update_time timestamp(0))";
    public static final String OCEAN_BASE_JDBC_DRIVER = "com.alipay.oceanbase.jdbc.Driver";
    public static final String OCEAN_BASE_JDBC_URL = "jdbc:oceanbase://%s:%s/%s";
    public static final String OCEAN_BASE_ORACLE_CREATE_UNISQL_VERSION = "CREATE TABLE %s.unisql_version (id int PRIMARY KEY,version VARCHAR2(20),update_time date)";
    public static final String OCEAN_BASE_ORACLE_VERSION_TABLE_EXISTS = "select count(1) count from ALL_TABLES where OWNER = upper('%s') and table_name = upper('unisql_version')";
    public static final String OCEAN_BASE_ORACLE_INSERT_UNISQL_VERSION = "insert into %s.unisql_version values(1,?,sysdate)";
    public static final String OCEAN_BASE_ORACLE_UPDATE_UNISQL_VERSION = "update %s.unisql_version set version=?,update_time=sysdate where id = 1";
    public static final String OCEAN_BASE_MYSQL_CREATE_UNISQL_VERSION = "create table if not exists %s.unisql_version (id int primary key,version varchar(20),update_time datetime)";
    public static final String TDSQL_MYSQL_JDBC_DRIVER = "com.mysql.cj.jdbc.Driver";
    public static final String TDSQL_MYSQL_JDBC_URL = "jdbc:mysql://%s:%s/%s";
    public static final String TDSQL_MYSQL_CREATE_UNISQL_VERSION = "create table if not exists %s.unisql_version (id int primary key,version varchar(20),update_time datetime)";
    public static final String TDSQL_PG_ORACLE_JDBC_DRIVER = "com.tencentcloud.tdsql.pg.jdbc.Driver";
    public static final String TDSQL_PG_ORACLE_JDBC_URL = "jdbc:tdsql-pg://%s:%s/%s";
    public static final String TDSQL_PG_ORACLE_CREATE_UNISQL_VERSION = "create table if not exists %s.unisql_version (id int primary key,version varchar(20),update_time date)";
    public static final String TDSQL_PG_JDBC_DRIVER = "com.tencentcloud.tdsql.pg.jdbc.Driver";
    public static final String TDSQL_PG_JDBC_URL = "jdbc:tdsql-pg://%s:%s/%s";
    public static final String TDSQL_PG_CREATE_UNISQL_VERSION = "create table if not exists %s.unisql_version (id int primary key,version varchar(20),update_time date)";
    public static final int TIMEOUT = 2;
    public static final String ORACLE_19C_JDBC_DRIVER = "oracle.jdbc.OracleDriver";
    public static final String ORACLE_19C_JDBC_URL = "jdbc:oracle:thin:@//%s:%s/%s";
    public static final String ORACLE_19C_CREATE_UNISQL_VERSION = "CREATE TABLE %s.UNISQL_VERSION (id int primary key,version varchar(20),update_time date)";
    public static final String ORACLE_19C_VERSION_TABLE_EXISTS = "SELECT COUNT(1) count from ALL_TABLES WHERE OWNER = upper('%s') AND TABLE_NAME = 'UNISQL_VERSION'";
    public static final String ORACLE_19C_SELECT_UNISQL_VERSION = "select version from %s.UNISQL_VERSION where id = 1";
    public static final String ORACLE_19C_INSERT_UNISQL_VERSION = "insert into %s.UNISQL_VERSION values(1,?,sysdate)";
    public static final String ORACLE_19C_UPDATE_UNISQL_VERSION = "update %s.UNISQL_VERSION set version=?,update_time=sysdate where id = 1";
    public static final String GAUSSDB_MYSQL_B_JDBC_DRIVER = "com.huawei.gaussdb.jdbc.Driver";
    public static final String GAUSSDB_MYSQL_B_JDBC_URL = "jdbc:gaussdb://%s:%s/%s";
    public static final String DM_JDBC_DRIVER = "dm.jdbc.driver.DmDriver";
    public static final String DM_JDBC_URL = "jdbc:dm://%s:%s/%s";
    private final String drive;
    public final TargetUniSqlVersion targetUniSqlVersion;
    private final String url;
    private final String user;
    private final String password;
    private final String schema;
    private static final String UNISQL_REGEX = "(?i)\\bunisql\\b(?!_)";

    public SqlExecutor(String sourceDbType, String targetDbType, String host, String port, String dbname, String schema, String user, String password) throws SQLException {
        this.targetUniSqlVersion = this.getTargetUniSqlVersion(DbType.of((String)sourceDbType), DbType.of((String)targetDbType), host, port, dbname, schema);
        this.drive = this.targetUniSqlVersion.getTargetDriver();
        this.url = this.targetUniSqlVersion.getTargetJdbcUrl();
        this.schema = this.targetUniSqlVersion.getTargetSchema();
        this.user = user;
        this.password = password;
    }

    public void executeCommand(Map<String, String> sqlMap) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        String sql = null;
        try {
            Class.forName(this.drive);
            conn = DriverManager.getConnection(this.url, this.user, this.password);
            stmt = conn.createStatement();
            for (Map.Entry<String, String> integerSqlEntry : sqlMap.entrySet()) {
                String sqlInit = integerSqlEntry.getValue();
                if (StringUtils.isNotBlank((CharSequence)sqlInit)) {
                    sql = sqlInit.trim();
                    if (log.isInfoEnabled()) {
                        log.info("\u6267\u884csql\u5757:\n{}", (Object)sql);
                    }
                    try {
                        conn.setAutoCommit(false);
                        stmt.execute(sql);
                        conn.commit();
                        if (!log.isInfoEnabled()) continue;
                        log.info("\u6267\u884c\u6210\u529f\uff01");
                        continue;
                    }
                    catch (SQLException e) {
                        block20: {
                            try {
                                conn.rollback();
                            }
                            catch (SQLException rollbackEx) {
                                if (!log.isErrorEnabled()) break block20;
                                log.error("\u56de\u6eda\u5f02\u5e38\uff1a", (Throwable)rollbackEx);
                            }
                        }
                        if (log.isErrorEnabled()) {
                            log.error("sql\u6267\u884c\u5931\u8d25: " + sql, (Throwable)e);
                        }
                        throw e;
                    }
                }
                if (!log.isInfoEnabled()) continue;
                log.info("sql is blank\uff01");
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error SQLException\uff1a ", (Throwable)e);
            }
            throw e;
        }
        finally {
            block22: {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException ex) {
                    if (!log.isErrorEnabled()) break block22;
                    log.error("\u8fde\u63a5\u5173\u95ed\u5f02\u5e38\uff1a", (Throwable)ex);
                }
            }
        }
    }

    public String getVersion() throws Exception {
        Connection conn = null;
        Statement stmt = null;
        try {
            Class.forName(this.drive);
            conn = DriverManager.getConnection(this.url, this.user, this.password);
            stmt = conn.createStatement();
            if (log.isInfoEnabled()) {
                log.info("\u6267\u884csql:{}", (Object)this.targetUniSqlVersion.getUniSqlVersionExistsSql());
            }
            try (ResultSet rs = stmt.executeQuery(this.targetUniSqlVersion.getUniSqlVersionExistsSql());){
                if (rs.next()) {
                    String string = rs.getString(1);
                    return string;
                }
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u7edf\u4e00SQL\u7248\u672c\u53f7\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38: {}", (Object)e.getMessage());
            }
            throw e;
        }
        finally {
            block24: {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException ex) {
                    if (!log.isErrorEnabled()) break block24;
                    log.error("\u8fde\u63a5\u5173\u95ed\u5f02\u5e38\uff1a", (Throwable)ex);
                }
            }
        }
        return null;
    }

    public boolean tableIsExists() throws Exception {
        Connection conn = null;
        Statement stmt = null;
        try {
            Class.forName(this.drive);
            conn = DriverManager.getConnection(this.url, this.user, this.password);
            stmt = conn.createStatement();
            if (log.isInfoEnabled()) {
                log.info("\u6267\u884csql:{}", (Object)this.targetUniSqlVersion.getUniSqlVersionTableExistsSql());
            }
            try (ResultSet rs = stmt.executeQuery(this.targetUniSqlVersion.getUniSqlVersionTableExistsSql());){
                while (true) {
                    if (rs.next()) {
                        int count = rs.getInt(1);
                        if (count != 1) continue;
                        boolean bl = false;
                        return bl;
                        continue;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u7edf\u4e00SQL\u7248\u672c\u53f7\u4fe1\u606f\u8868\u5224\u65ad\u662f\u5426\u5b58\u5728\u6267\u884c\u5f02\u5e38: {}", (Object)e.getMessage());
            }
            throw e;
        }
        finally {
            block26: {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException ex) {
                    if (!log.isErrorEnabled()) break block26;
                    log.error("\u8fde\u63a5\u5173\u95ed\u5f02\u5e38\uff1a", (Throwable)ex);
                }
            }
        }
        return true;
    }

    public void updateOrInsertVersion(String updateOrInsertSql, String version) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        try {
            Class.forName(this.drive);
            conn = DriverManager.getConnection(this.url, this.user, this.password);
            stmt = conn.prepareStatement(updateOrInsertSql);
            if (log.isInfoEnabled()) {
                log.info("\u6267\u884csql:{}", (Object)updateOrInsertSql);
            }
            stmt.setString(1, version);
            stmt.execute();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u6267\u884csql\u5f02\u5e38:{} ", (Object)updateOrInsertSql, (Object)e);
            }
            throw e;
        }
        finally {
            block14: {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException ex) {
                    if (!log.isErrorEnabled()) break block14;
                    log.error("\u8fde\u63a5\u5173\u95ed\u5f02\u5e38\uff1a", (Throwable)ex);
                }
            }
        }
    }

    protected TargetUniSqlVersion getTargetUniSqlVersion(DbType sourceDialectType, DbType targetDialectType, String host, String port, String dbname, String schema) {
        TargetUniSqlVersion targetUniSqlVersion = new TargetUniSqlVersion();
        targetUniSqlVersion.setTargetSchema(schema);
        targetUniSqlVersion.setUniSqlVersionTableExistsSql(String.format("select count(1) count from information_schema.tables where table_schema = '%s' and table_name = 'unisql_version'", schema));
        targetUniSqlVersion.setUniSqlVersionExistsSql(String.format("select version from %s.unisql_version where id = 1", schema));
        targetUniSqlVersion.setInsertUniSqlVersionSql(String.format("insert into %s.unisql_version values(1,?,now())", schema));
        targetUniSqlVersion.setUpdateUniSqlVersionSql(String.format("update %s.unisql_version set version=?,update_time=now() where id = 1", schema));
        if (DbType.MYSQL.equals((Object)sourceDialectType)) {
            if (DbType.GAUSSDB500_ORACLE.equals((Object)targetDialectType) || DbType.GAUSSDB_ORACLE.equals((Object)targetDialectType)) {
                return SqlExecutor.getGaussDbTargetUniSqlVersion((String)host, (String)port, (String)dbname, (String)schema, (TargetUniSqlVersion)targetUniSqlVersion);
            }
            if (DbType.GAUSSDB_MYSQL_B.equals((Object)targetDialectType)) {
                targetUniSqlVersion.setTargetDriver("com.huawei.gaussdb.jdbc.Driver");
                targetUniSqlVersion.setTargetJdbcUrl(String.format("jdbc:gaussdb://%s:%s/%s", host, port, dbname));
                targetUniSqlVersion.setCreateUniSqlVersionSql(String.format("create table if not exists %s.unisql_version (id int primary key,version varchar(20),update_time datetime)", schema));
                return targetUniSqlVersion;
            }
            if (DbType.OCEAN_BASE_ORACLE.equals((Object)targetDialectType)) {
                targetUniSqlVersion.setTargetDriver("com.alipay.oceanbase.jdbc.Driver");
                targetUniSqlVersion.setTargetJdbcUrl(String.format("jdbc:oceanbase://%s:%s/%s", host, port, dbname));
                targetUniSqlVersion.setCreateUniSqlVersionSql(String.format("CREATE TABLE %s.unisql_version (id int PRIMARY KEY,version VARCHAR2(20),update_time date)", schema));
                targetUniSqlVersion.setInsertUniSqlVersionSql(String.format("insert into %s.unisql_version values(1,?,sysdate)", schema));
                targetUniSqlVersion.setUpdateUniSqlVersionSql(String.format("update %s.unisql_version set version=?,update_time=sysdate where id = 1", schema));
                targetUniSqlVersion.setUniSqlVersionTableExistsSql(String.format("select count(1) count from ALL_TABLES where OWNER = upper('%s') and table_name = upper('unisql_version')", schema));
                return targetUniSqlVersion;
            }
            if (DbType.ORACLE_19C.equals((Object)targetDialectType)) {
                targetUniSqlVersion.setUniSqlVersionTableExistsSql(String.format("SELECT COUNT(1) count from ALL_TABLES WHERE OWNER = upper('%s') AND TABLE_NAME = 'UNISQL_VERSION'", schema));
                targetUniSqlVersion.setCreateUniSqlVersionSql(String.format("CREATE TABLE %s.UNISQL_VERSION (id int primary key,version varchar(20),update_time date)", schema));
                targetUniSqlVersion.setUniSqlVersionExistsSql(String.format("select version from %s.UNISQL_VERSION where id = 1", schema));
                targetUniSqlVersion.setInsertUniSqlVersionSql(String.format("insert into %s.UNISQL_VERSION values(1,?,sysdate)", schema));
                targetUniSqlVersion.setUpdateUniSqlVersionSql(String.format("update %s.UNISQL_VERSION set version=?,update_time=sysdate where id = 1", schema));
                targetUniSqlVersion.setTargetDriver("oracle.jdbc.OracleDriver");
                targetUniSqlVersion.setTargetJdbcUrl(String.format("jdbc:oracle:thin:@//%s:%s/%s", host, port, dbname));
                return targetUniSqlVersion;
            }
            if (DbType.DM.equals((Object)targetDialectType)) {
                targetUniSqlVersion.setUniSqlVersionTableExistsSql(String.format("SELECT COUNT(1) count from ALL_TABLES WHERE OWNER = upper('%s') AND TABLE_NAME = 'UNISQL_VERSION'", schema));
                targetUniSqlVersion.setCreateUniSqlVersionSql(String.format("CREATE TABLE %s.UNISQL_VERSION (id int primary key,version varchar(20),update_time date)", schema));
                targetUniSqlVersion.setUniSqlVersionExistsSql(String.format("select version from %s.UNISQL_VERSION where id = 1", schema));
                targetUniSqlVersion.setInsertUniSqlVersionSql(String.format("insert into %s.UNISQL_VERSION values(1,?,sysdate)", schema));
                targetUniSqlVersion.setUpdateUniSqlVersionSql(String.format("update %s.UNISQL_VERSION set version=?,update_time=sysdate where id = 1", schema));
                targetUniSqlVersion.setTargetDriver("dm.jdbc.driver.DmDriver");
                targetUniSqlVersion.setTargetJdbcUrl(String.format("jdbc:dm://%s:%s/%s", host, port, dbname));
                return targetUniSqlVersion;
            }
        }
        if (DbType.ORACLE.equals((Object)sourceDialectType)) {
            if (DbType.GAUSSDB_ORACLE.equals((Object)targetDialectType)) {
                return SqlExecutor.getGaussDbTargetUniSqlVersion((String)host, (String)port, (String)dbname, (String)schema, (TargetUniSqlVersion)targetUniSqlVersion);
            }
            if (DbType.POSTGRESQL.equals((Object)targetDialectType)) {
                targetUniSqlVersion.setTargetDriver("org.postgresql.Driver");
                targetUniSqlVersion.setTargetJdbcUrl(String.format("jdbc:postgresql://%s:%s/%s", host, port, dbname));
                targetUniSqlVersion.setUniSqlVersionTableExistsSql(String.format("select count(1) count from pg_tables where schemaname = '%s' and tablename='unisql_version'", schema));
                targetUniSqlVersion.setCreateUniSqlVersionSql(String.format("create table if not exists %s.unisql_version (id int primary key,version varchar(20),update_time timestamp(0))", schema));
                return targetUniSqlVersion;
            }
            if (DbType.OCEAN_BASE_MYSQL.equals((Object)targetDialectType)) {
                targetUniSqlVersion.setTargetDriver("com.alipay.oceanbase.jdbc.Driver");
                targetUniSqlVersion.setTargetJdbcUrl(String.format("jdbc:oceanbase://%s:%s/%s", host, port, dbname));
                targetUniSqlVersion.setCreateUniSqlVersionSql(String.format("create table if not exists %s.unisql_version (id int primary key,version varchar(20),update_time datetime)", schema));
                return targetUniSqlVersion;
            }
            if (DbType.TDSQL_MYSQL.equals((Object)targetDialectType)) {
                targetUniSqlVersion.setTargetDriver("com.mysql.cj.jdbc.Driver");
                targetUniSqlVersion.setTargetJdbcUrl(String.format("jdbc:mysql://%s:%s/%s", host, port, dbname));
                targetUniSqlVersion.setCreateUniSqlVersionSql(String.format("create table if not exists %s.unisql_version (id int primary key,version varchar(20),update_time datetime)", schema));
                return targetUniSqlVersion;
            }
            if (DbType.TDSQL_PG_ORACLE.equals((Object)targetDialectType)) {
                targetUniSqlVersion.setTargetDriver("com.tencentcloud.tdsql.pg.jdbc.Driver");
                targetUniSqlVersion.setTargetJdbcUrl(String.format("jdbc:tdsql-pg://%s:%s/%s", host, port, dbname));
                targetUniSqlVersion.setCreateUniSqlVersionSql(String.format("create table if not exists %s.unisql_version (id int primary key,version varchar(20),update_time date)", schema));
                return targetUniSqlVersion;
            }
            if (DbType.TDSQL_PG.equals((Object)targetDialectType)) {
                targetUniSqlVersion.setTargetDriver("com.tencentcloud.tdsql.pg.jdbc.Driver");
                targetUniSqlVersion.setTargetJdbcUrl(String.format("jdbc:tdsql-pg://%s:%s/%s", host, port, dbname));
                targetUniSqlVersion.setCreateUniSqlVersionSql(String.format("create table if not exists %s.unisql_version (id int primary key,version varchar(20),update_time date)", schema));
                return targetUniSqlVersion;
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u6e90\u7aef\u6570\u636e\u5e93\u7c7b\u578b[{}]\u5230\u76ee\u6807\u6570\u636e\u5e93\u7c7b\u578b[{}]\u65e0\u9700\u6267\u884c\u81ea\u5b9a\u4e49\u811a\u672c\u3002\u7a0b\u5e8f\u6b63\u5e38\u9000\u51fa\uff01", (Object)sourceDialectType, (Object)targetDialectType);
        }
        System.exit(0);
        return null;
    }

    private static TargetUniSqlVersion getGaussDbTargetUniSqlVersion(String host, String port, String dbname, String schema, TargetUniSqlVersion targetUniSqlVersion) {
        targetUniSqlVersion.setTargetDriver("com.huawei.opengauss.jdbc.Driver");
        targetUniSqlVersion.setTargetJdbcUrl(String.format("jdbc:opengauss://%s:%s/%s", host, port, dbname));
        targetUniSqlVersion.setCreateUniSqlVersionSql(String.format("create table if not exists %s.unisql_version (id int primary key,version varchar(20),update_time date)", schema));
        return targetUniSqlVersion;
    }

    public static Map<String, String> parseSqlFile(String filePath) throws Exception {
        LinkedHashMap<String, String> sqlBlocks = new LinkedHashMap<String, String>(16);
        filePath = String.format(filePath + "%s", FilenameUtils.getName((String)""));
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            String currentKey = null;
            StringBuilder currentSql = new StringBuilder();
            int sqlNum = 0;
            while ((line = reader.readLine()) != null) {
                String line1 = line.trim();
                if (line1.startsWith("--")) {
                    ++sqlNum;
                    if (currentKey != null && currentSql.length() > 0) {
                        sqlBlocks.put(currentKey, currentSql.toString());
                        currentSql.setLength(0);
                    }
                    currentKey = sqlNum + "";
                    continue;
                }
                if (line1.isEmpty()) continue;
                currentSql.append(line).append("\n");
            }
            if (currentKey != null && currentSql.length() > 0) {
                sqlBlocks.put(currentKey, currentSql.toString());
            }
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error("\u6587\u4ef6\u89e3\u6790\u5931\u8d25:{}", (Object)filePath, (Object)e);
            }
            throw e;
        }
        return sqlBlocks;
    }

    public static void replaceSchema(Map<String, String> sql, String schema) throws Exception {
        sql.replaceAll((k, v) -> v.replaceAll("(?i)\\bunisql\\b(?!_)", schema));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDatabaseConnectionValid() {
        try {
            Class.forName(this.drive);
        }
        catch (ClassNotFoundException e) {
            if (!log.isErrorEnabled()) return false;
            log.error("\u6570\u636e\u5e93\u9a71\u52a8[{}]\u672a\u627e\u5230\uff0c\u52a0\u8f7d\u5931\u8d25\u3002", (Object)this.drive);
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info("\u5f00\u59cb\u6821\u9a8c\u6570\u636e\u5e93\u8fde\u63a5.");
        }
        try (Connection connection = DriverManager.getConnection(this.url, this.user, this.password);){
            if (connection.isValid(2)) {
                if (log.isInfoEnabled()) {
                    log.info("\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f.");
                }
                boolean bl2 = true;
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            if (!log.isErrorEnabled()) return false;
            log.error("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25:{} ", (Object)e.getMessage());
            return false;
        }
    }
}

