/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.golang;

import com.hundsun.lightdb.unisql.constant.ErrorMessages;
import com.hundsun.lightdb.unisql.golang.Encoder;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class VariableParameter
implements Serializable {
    private String bizSql;
    private String sourceSql;
    private String sourceDialect;
    private String targetDialect;
    private Long restoreFmt;
    private int mode;
    private String dbName;
    private String sqlParameters;
    private int isPrecompiled;
    private String currentTraceId;
    private String appName;
    private String functionId;
    private int sqlSequence;
    private String targetDatabaseVersion;
    private Long sessionId;

    public VariableParameter(String bizSql, String sourceSql, String sourceDialect, String targetDialect, Long restoreFmt, int mode, String dbName, String sqlParameters, int isPrecompiled, String currentTraceId, String appName, String functionId, int sqlSequence, String targetDatabaseVersion, Long sessionId) {
        this.bizSql = bizSql;
        this.sourceSql = sourceSql;
        this.sourceDialect = sourceDialect;
        this.targetDialect = targetDialect;
        this.restoreFmt = restoreFmt;
        this.mode = mode;
        this.dbName = dbName;
        this.sqlParameters = sqlParameters;
        this.isPrecompiled = isPrecompiled;
        this.currentTraceId = currentTraceId;
        this.appName = appName;
        this.functionId = functionId;
        this.sqlSequence = sqlSequence;
        this.targetDatabaseVersion = targetDatabaseVersion;
        this.sessionId = sessionId;
    }

    public VariableParameter() {
    }

    public String getSourceSql() {
        return this.sourceSql;
    }

    public void setSourceSql(String sourceSql) {
        this.sourceSql = sourceSql;
    }

    public String getSourceDialect() {
        return this.sourceDialect;
    }

    public void setSourceDialect(String sourceDialect) {
        this.sourceDialect = sourceDialect;
    }

    public String getTargetDialect() {
        return this.targetDialect;
    }

    public void setTargetDialect(String targetDialect) {
        this.targetDialect = targetDialect;
    }

    public Long getRestoreFmt() {
        return this.restoreFmt;
    }

    public void setRestoreFmt(Long restoreFmt) {
        this.restoreFmt = restoreFmt;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getSqlParameters() {
        return this.sqlParameters;
    }

    public void setSqlParameters(String sqlParameters) {
        this.sqlParameters = sqlParameters;
    }

    public int getIsPrecompiled() {
        return this.isPrecompiled;
    }

    public void setIsPrecompiled(int isPrecompiled) {
        this.isPrecompiled = isPrecompiled;
    }

    public String getCurrentTraceId() {
        return this.currentTraceId;
    }

    public void setCurrentTraceId(String currentTraceId) {
        this.currentTraceId = currentTraceId;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public void setFunctionId(String functionId) {
        this.functionId = functionId;
    }

    public Integer getSqlSequence() {
        return this.sqlSequence;
    }

    public void setSqlSequence(Integer sqlSequence) {
        this.sqlSequence = sqlSequence;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setTargetDatabaseVersion(String targetDatabaseVersion) {
        this.targetDatabaseVersion = targetDatabaseVersion;
    }

    public String getTargetDatabaseVersion() {
        return this.targetDatabaseVersion;
    }

    public Long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(Long sessionId) {
        this.sessionId = sessionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableParameter that = (VariableParameter)o;
        return this.isPrecompiled == that.isPrecompiled && this.mode == that.mode && Objects.equals(this.sourceSql, that.sourceSql) && Objects.equals(this.sourceDialect, that.sourceDialect) && Objects.equals(this.targetDialect, that.targetDialect) && Objects.equals(this.restoreFmt, that.restoreFmt) && Objects.equals(this.dbName, that.dbName) && Objects.equals(this.sqlParameters, that.sqlParameters) && Objects.equals(this.currentTraceId, that.currentTraceId) && Objects.equals(this.appName, that.appName) && Objects.equals(this.functionId, that.functionId) && Objects.equals(this.sqlSequence, that.sqlSequence);
    }

    public int hashCode() {
        return Objects.hash(this.sourceSql, this.sourceDialect, this.targetDialect, this.restoreFmt, this.dbName, this.sqlParameters, this.isPrecompiled, this.currentTraceId, this.appName, this.functionId, this.sqlSequence, this.mode);
    }

    public static String formatLength2(int length) {
        return String.format("%2s", length);
    }

    public static String formatLength8(int length) {
        return String.format("%8s", length);
    }

    public static String formatLength6(int length) {
        return String.format("%6s", length);
    }

    public String encode() {
        StringBuilder result = new StringBuilder();
        result.append(VariableParameter.formatLength2(DbType.of(this.sourceDialect).getDbTypeCode()));
        result.append(VariableParameter.formatLength2(DbType.of(this.targetDialect).getDbTypeCode()));
        result.append(this.mode);
        String encodeSql = "";
        try {
            encodeSql = URLEncoder.encode(this.sourceSql, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0018, this.sourceSql));
        }
        int length = encodeSql.length();
        if (length > 99999999) {
            throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0017, length));
        }
        result.append(VariableParameter.formatLength8(length));
        result.append(encodeSql);
        if (StringUtils.isBlank(this.bizSql)) {
            this.bizSql = this.sourceSql;
        } else {
            try {
                encodeSql = URLEncoder.encode(this.bizSql, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0018, this.bizSql));
            }
            length = encodeSql.length();
            if (length > 99999999) {
                throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0017, length));
            }
        }
        result.append(VariableParameter.formatLength8(length));
        result.append(encodeSql);
        result.append(this.sessionId);
        return result.toString();
    }

    public byte[] encodeToBytes() throws IOException {
        Encoder encoder = new Encoder();
        encoder.writeInt(DbType.of(this.sourceDialect).getDbTypeCode());
        encoder.writeInt(DbType.of(this.targetDialect).getDbTypeCode());
        encoder.writeInt(this.mode);
        encoder.writeString(this.sourceSql);
        encoder.writeString(this.bizSql);
        encoder.writeInt64(this.sessionId);
        return encoder.toByteArray();
    }

    private static Long $default$restoreFmt() {
        return 0L;
    }

    private static int $default$mode() {
        return 0;
    }

    private static String $default$dbName() {
        return "";
    }

    private static String $default$sqlParameters() {
        return "";
    }

    private static int $default$isPrecompiled() {
        return 0;
    }

    private static String $default$currentTraceId() {
        return "";
    }

    private static String $default$appName() {
        return "";
    }

    private static String $default$functionId() {
        return "";
    }

    private static int $default$sqlSequence() {
        return 1;
    }

    private static Long $default$sessionId() {
        return 0L;
    }

    public static VariableParameterBuilder builder() {
        return new VariableParameterBuilder();
    }

    public String getBizSql() {
        return this.bizSql;
    }

    public void setBizSql(String bizSql) {
        this.bizSql = bizSql;
    }

    public String toString() {
        return "VariableParameter(bizSql=" + this.getBizSql() + ", sourceSql=" + this.getSourceSql() + ", sourceDialect=" + this.getSourceDialect() + ", targetDialect=" + this.getTargetDialect() + ", restoreFmt=" + this.getRestoreFmt() + ", mode=" + this.getMode() + ", dbName=" + this.getDbName() + ", sqlParameters=" + this.getSqlParameters() + ", isPrecompiled=" + this.getIsPrecompiled() + ", currentTraceId=" + this.getCurrentTraceId() + ", appName=" + this.getAppName() + ", functionId=" + this.getFunctionId() + ", sqlSequence=" + this.getSqlSequence() + ", targetDatabaseVersion=" + this.getTargetDatabaseVersion() + ", sessionId=" + this.getSessionId() + ")";
    }

    public static class VariableParameterBuilder {
        private String bizSql;
        private String sourceSql;
        private String sourceDialect;
        private String targetDialect;
        private boolean restoreFmt$set;
        private Long restoreFmt;
        private boolean mode$set;
        private int mode;
        private boolean dbName$set;
        private String dbName;
        private boolean sqlParameters$set;
        private String sqlParameters;
        private boolean isPrecompiled$set;
        private int isPrecompiled;
        private boolean currentTraceId$set;
        private String currentTraceId;
        private boolean appName$set;
        private String appName;
        private boolean functionId$set;
        private String functionId;
        private boolean sqlSequence$set;
        private int sqlSequence;
        private String targetDatabaseVersion;
        private boolean sessionId$set;
        private Long sessionId;

        VariableParameterBuilder() {
        }

        public VariableParameterBuilder bizSql(String bizSql) {
            this.bizSql = bizSql;
            return this;
        }

        public VariableParameterBuilder sourceSql(String sourceSql) {
            this.sourceSql = sourceSql;
            return this;
        }

        public VariableParameterBuilder sourceDialect(String sourceDialect) {
            this.sourceDialect = sourceDialect;
            return this;
        }

        public VariableParameterBuilder targetDialect(String targetDialect) {
            this.targetDialect = targetDialect;
            return this;
        }

        public VariableParameterBuilder restoreFmt(Long restoreFmt) {
            this.restoreFmt = restoreFmt;
            this.restoreFmt$set = true;
            return this;
        }

        public VariableParameterBuilder mode(int mode) {
            this.mode = mode;
            this.mode$set = true;
            return this;
        }

        public VariableParameterBuilder dbName(String dbName) {
            this.dbName = dbName;
            this.dbName$set = true;
            return this;
        }

        public VariableParameterBuilder sqlParameters(String sqlParameters) {
            this.sqlParameters = sqlParameters;
            this.sqlParameters$set = true;
            return this;
        }

        public VariableParameterBuilder isPrecompiled(int isPrecompiled) {
            this.isPrecompiled = isPrecompiled;
            this.isPrecompiled$set = true;
            return this;
        }

        public VariableParameterBuilder currentTraceId(String currentTraceId) {
            this.currentTraceId = currentTraceId;
            this.currentTraceId$set = true;
            return this;
        }

        public VariableParameterBuilder appName(String appName) {
            this.appName = appName;
            this.appName$set = true;
            return this;
        }

        public VariableParameterBuilder functionId(String functionId) {
            this.functionId = functionId;
            this.functionId$set = true;
            return this;
        }

        public VariableParameterBuilder sqlSequence(int sqlSequence) {
            this.sqlSequence = sqlSequence;
            this.sqlSequence$set = true;
            return this;
        }

        public VariableParameterBuilder targetDatabaseVersion(String targetDatabaseVersion) {
            this.targetDatabaseVersion = targetDatabaseVersion;
            return this;
        }

        public VariableParameterBuilder sessionId(Long sessionId) {
            this.sessionId = sessionId;
            this.sessionId$set = true;
            return this;
        }

        public VariableParameter build() {
            Long restoreFmt = this.restoreFmt;
            if (!this.restoreFmt$set) {
                restoreFmt = VariableParameter.$default$restoreFmt();
            }
            int mode = this.mode;
            if (!this.mode$set) {
                mode = VariableParameter.$default$mode();
            }
            String dbName = this.dbName;
            if (!this.dbName$set) {
                dbName = VariableParameter.$default$dbName();
            }
            String sqlParameters = this.sqlParameters;
            if (!this.sqlParameters$set) {
                sqlParameters = VariableParameter.$default$sqlParameters();
            }
            int isPrecompiled = this.isPrecompiled;
            if (!this.isPrecompiled$set) {
                isPrecompiled = VariableParameter.$default$isPrecompiled();
            }
            String currentTraceId = this.currentTraceId;
            if (!this.currentTraceId$set) {
                currentTraceId = VariableParameter.$default$currentTraceId();
            }
            String appName = this.appName;
            if (!this.appName$set) {
                appName = VariableParameter.$default$appName();
            }
            String functionId = this.functionId;
            if (!this.functionId$set) {
                functionId = VariableParameter.$default$functionId();
            }
            int sqlSequence = this.sqlSequence;
            if (!this.sqlSequence$set) {
                sqlSequence = VariableParameter.$default$sqlSequence();
            }
            Long sessionId = this.sessionId;
            if (!this.sessionId$set) {
                sessionId = VariableParameter.$default$sessionId();
            }
            return new VariableParameter(this.bizSql, this.sourceSql, this.sourceDialect, this.targetDialect, restoreFmt, mode, dbName, sqlParameters, isPrecompiled, currentTraceId, appName, functionId, sqlSequence, this.targetDatabaseVersion, sessionId);
        }

        public String toString() {
            return "VariableParameter.VariableParameterBuilder(bizSql=" + this.bizSql + ", sourceSql=" + this.sourceSql + ", sourceDialect=" + this.sourceDialect + ", targetDialect=" + this.targetDialect + ", restoreFmt=" + this.restoreFmt + ", mode=" + this.mode + ", dbName=" + this.dbName + ", sqlParameters=" + this.sqlParameters + ", isPrecompiled=" + this.isPrecompiled + ", currentTraceId=" + this.currentTraceId + ", appName=" + this.appName + ", functionId=" + this.functionId + ", sqlSequence=" + this.sqlSequence + ", targetDatabaseVersion=" + this.targetDatabaseVersion + ", sessionId=" + this.sessionId + ")";
        }
    }
}

