/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.mysql;

import com.hundsun.lightdb.unisql.annotation.SuppressFBWarnings;
import com.hundsun.lightdb.unisql.golang.PreparedParameter;
import com.hundsun.lightdb.unisql.golang.ReturnParameter;
import com.hundsun.lightdb.unisql.golang.Transformer;
import com.hundsun.lightdb.unisql.golang.VariableParameter;
import com.hundsun.lightdb.unisql.model.Mode;
import com.hundsun.lightdb.unisql.model.MultiQueryResultDTO;
import com.hundsun.lightdb.unisql.model.MultiplexContext;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.proxy.jdbc.UnisqlConnection;
import com.hundsun.lightdb.unisql.proxy.jdbc.UnisqlPreparedStatement;
import com.hundsun.lightdb.unisql.utils.JsonUtils;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoundRowAdapter {
    private static final Logger log = LoggerFactory.getLogger(FoundRowAdapter.class);
    public static final String LIMIT_REGEX = "(?i)\\s+limit\\s+\\(?'?\\d+'?(::.*)?\\)?(\\s*,\\s*\\(?'?\\d+'?(::.*)?\\)?)?";
    public static final String FETCH_REGEX = "(?i)(offset\\s+(\\d+)\\s+rows)?\\s*fetch\\s+next\\s+(\\d+)\\s+rows\\s+only";
    public static final String LIMIT = "limit";
    public static final String FETCH = "fetch";
    public static final String OFFSET = "offset";

    public static String cleanFoundRows(Mode mode, String parsedSql) {
        if (Mode.MYSQL == mode) {
            return parsedSql.replaceAll("(?i)SQL_CALC_FOUND_ROWS", "");
        }
        return parsedSql;
    }

    public static boolean isFoundRows(Mode mode, String sql) {
        return Mode.MYSQL == mode && sql.toUpperCase().replaceAll("/\\*.*?\\*/", "").replaceAll("\\-\\-.*", "").replaceAll("\\s+", "").trim().equals("SELECTFOUND_ROWS()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"})
    public static String replaceSql(Mode mode, String prevSql, UnisqlPreparedStatement preparedStatement, UnisqlConnection connection) {
        if (prevSql == null) {
            return "SELECT FOUND_ROWS()";
        }
        ReturnParameter returnParameter = new ReturnParameter();
        String transformedSql = Transformer.parse("/*found_rows*/" + prevSql, connection.getSourceDialect().name(), connection.getTargetDialect().name(), VariableParameter.builder().build(), returnParameter);
        List<Integer> bindVariableOrder = returnParameter.getBindVariableOrder();
        List<PreparedParameter> preparedParameters = preparedStatement.getRawPreparedParameters();
        ArrayList<PreparedParameter> finalParameters = new ArrayList<PreparedParameter>();
        if (CollectionUtils.isNotEmpty(bindVariableOrder)) {
            Iterator<Serializable> iterator = bindVariableOrder.iterator();
            while (iterator.hasNext()) {
                int order = (Integer)iterator.next();
                finalParameters.add(preparedParameters.get(order - 1));
            }
        } else {
            for (PreparedParameter parameter : preparedParameters) {
                finalParameters.add(parameter);
            }
        }
        String sql = "";
        if (DbType.DM.name().equals(connection.getTargetDialect().name())) {
            MultiQueryResultDTO queryResultDTO = new MultiQueryResultDTO();
            queryResultDTO.setTargetDialect(connection.getTargetDialect().name());
            sql = MultiplexContext.buildFullSql(transformedSql, finalParameters, queryResultDTO);
        } else {
            try (PreparedStatement statement = connection.getDelegate().prepareStatement(transformedSql);){
                for (int i = 0; i < finalParameters.size(); ++i) {
                    statement.setObject(i + 1, ((PreparedParameter)finalParameters.get(i)).getX());
                }
                sql = statement.toString();
                log.debug("\u524d\u4e00\u6761SQL:[{}] \u9884\u7f16\u8bd1\u53c2\u6570:[{}] \u8fd8\u539f\u540eSQL:[{}]", new Object[]{transformedSql, JsonUtils.toJson(finalParameters), sql});
            }
        }
        StringBuilder stringBuilder = new StringBuilder(sql.length() + 40);
        stringBuilder.append("select count(1) from ( \n");
        stringBuilder.append(FoundRowAdapter.removeLastLimitClause(sql, connection.getTargetDialect().name()));
        stringBuilder.append("\n ) FOUND_ROWS_COUNT");
        return stringBuilder.toString();
    }

    public static String removeLastLimitClause(String sqlQuery, String targetDialect) {
        int lastLimitIndex;
        String lowerCaseQuery = sqlQuery.toLowerCase().replaceAll("/\\*.*?\\*/", "").replaceAll("\\-\\-.*", "");
        String limitKey = LIMIT;
        String limitRegex = LIMIT_REGEX;
        String secondLimitKey = FETCH;
        if (DbType.DM.name().equals(targetDialect)) {
            limitKey = OFFSET;
            limitRegex = FETCH_REGEX;
        }
        if ((lastLimitIndex = lowerCaseQuery.lastIndexOf(" " + limitKey + " ")) == -1) {
            lastLimitIndex = lowerCaseQuery.lastIndexOf(" " + secondLimitKey + " ");
        }
        if (lastLimitIndex != -1) {
            String afterLimit = sqlQuery.substring(lastLimitIndex);
            String modifiedAfterLimit = afterLimit.replaceFirst(limitRegex, "");
            return sqlQuery.substring(0, lastLimitIndex) + modifiedAfterLimit;
        }
        return sqlQuery;
    }
}

