/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.proxy.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public enum UniSqlType implements SQLType
{
    DECIMAL("DECIMAL", 3, BigDecimal.class),
    DEC("DEC", 3, BigDecimal.class),
    DECIMAL_UNSIGNED("DECIMAL UNSIGNED", 3, BigDecimal.class),
    TINYINT("TINYINT", -6, Integer.class),
    TINYINT_UNSIGNED("TINYINT UNSIGNED", -6, Integer.class),
    BOOLEAN("BOOLEAN", 16, Boolean.class),
    BOOL("BOOL", 16, Boolean.class),
    SMALLINT("SMALLINT", 5, Integer.class),
    SMALLINT_UNSIGNED("SMALLINT UNSIGNED", 5, Integer.class),
    INT("INT", 4, Integer.class),
    INT_UNSIGNED("INT UNSIGNED", 4, Long.class),
    FLOAT("FLOAT", 6, Float.class),
    FLOAT_UNSIGNED("FLOAT UNSIGNED", 6, Float.class),
    DOUBLE("DOUBLE", 8, Double.class),
    DOUBLE_UNSIGNED("DOUBLE UNSIGNED", 8, Double.class),
    NULL("NULL", 0, Object.class),
    TIMESTAMP("TIMESTAMP", 93, Timestamp.class),
    BIGINT("BIGINT", -5, Long.class),
    BIGINT_UNSIGNED("BIGINT UNSIGNED", -5, BigInteger.class),
    MEDIUMINT("MEDIUMINT", 4, Integer.class),
    MEDIUMINT_UNSIGNED("MEDIUMINT UNSIGNED", 4, Integer.class),
    DATE("DATE", 91, Date.class),
    TIME("TIME", 92, Time.class),
    DATETIME("DATETIME", 93, LocalDateTime.class),
    YEAR("YEAR", 91, Date.class),
    VARCHAR("VARCHAR", 12, String.class),
    VARBINARY("VARBINARY", -3, null),
    BIT("BIT", -7, Boolean.class),
    TEXT("TEXT", -1, String.class),
    JSON("JSON", -1, String.class),
    CHAR("CHAR", 1, String.class),
    CHARACTER("CHARACTER", 1, String.class),
    ENUM("ENUM", 1, String.class),
    SET("SET", 1, String.class),
    TINYBLOB("TINYBLOB", -3, null),
    TINYTEXT("TINYTEXT", 12, String.class),
    LONGBLOB("LONGBLOB", -4, null),
    MEDIUMBLOB("MEDIUMBLOB", -4, null),
    MEDIUMTEXT("MEDIUMTEXT", -1, String.class),
    LONGTEXT("LONGTEXT", -1, String.class),
    BLOB("BLOB", 2004, null),
    BINARY("BINARY", -2, null),
    GEOMETRY("GEOMETRY", -2, null),
    VARCHAR2("VARCHAR2", 12, String.class),
    NVARCHAR("NVARCHAR", -9, String.class),
    NUMBER("NUMBER", 3, BigDecimal.class),
    LONG("LONG", -1, String.class),
    BINARY_FLOAT("BINARY_FLOAT", 6, Float.class),
    BINARY_DOUBLE("BINARY_DOUBLE", 8, Double.class),
    TIMESTAMP_WITH_TIME_ZONE("TIMESTAMP WITH TIME ZONE", 2014, Timestamp.class),
    TIMESTAMP_WITH_LOCAL_TIME_ZONE("TIMESTAMP WITH LOCAL TIME ZONE", 93, Timestamp.class),
    INTERVAL_YEAR_TO_MONTH("INTERVAL YEAR TO MONTH", -103, null),
    INTERVAL_DAY_TO_SECOND("INTERVAL DAY TO SECOND", -104, null),
    RAW("RAW", -2, null),
    LONG_RAW("LONG RAW", -4, null),
    ROWID("ROWID", -8, null),
    UROWID("UROWID", -8, null),
    NCHAR("NCHAR", -15, String.class),
    CLOB("CLOB", 2005, String.class),
    NCLOB("NCLOB", 2011, String.class),
    BFILE("BFILE", -13, null),
    OBJECT("OBJECT", 2002, null),
    REF("REF", 2006, null),
    VARRAY("VARRAY", 12, null),
    XMLTYPE("XMLTYPE", 2009, null),
    UNKNOWN("UNKNOWN", 1111, null);

    private final String name;
    protected final int jdbcType;
    protected final Class<?> javaClass;

    public static UniSqlType getByName(String fullUniSqlTypeName) {
        String typeName = "";
        typeName = (fullUniSqlTypeName = fullUniSqlTypeName.toUpperCase(Locale.ROOT)).contains("(") ? fullUniSqlTypeName.substring(0, fullUniSqlTypeName.indexOf("(")).trim() : fullUniSqlTypeName;
        if (StringUtils.indexOfIgnoreCase(typeName, DECIMAL.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, DEC.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, NUMBER.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, JDBCType.NUMERIC.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, "FIXED") != -1) {
            return StringUtils.indexOfIgnoreCase(fullUniSqlTypeName, "UNSIGNED") != -1 ? DECIMAL_UNSIGNED : DECIMAL;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, TINYBLOB.getName()) != -1) {
            return TINYBLOB;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, TINYTEXT.getName()) != -1) {
            return TINYTEXT;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, TINYINT.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, INT.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, JDBCType.INTEGER.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, "INT1") != -1 || StringUtils.indexOfIgnoreCase(typeName, SMALLINT.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, "INT2") != -1 || StringUtils.indexOfIgnoreCase(typeName, MEDIUMINT.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, "INT24") != -1 || StringUtils.indexOfIgnoreCase(typeName, "INT3") != -1 || StringUtils.indexOfIgnoreCase(typeName, "MIDDLEINT") != -1 || StringUtils.indexOfIgnoreCase(typeName, "INT4") != -1 || StringUtils.indexOfIgnoreCase(fullUniSqlTypeName, "UNSIGNED") != -1) {
            return INT;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, BIGINT.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, "SERIAL") != -1 || StringUtils.indexOfIgnoreCase(typeName, "INT8") != -1) {
            return StringUtils.indexOfIgnoreCase(fullUniSqlTypeName, "UNSIGNED") != -1 ? BIGINT_UNSIGNED : BIGINT;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, "POINT") != -1) {
            return GEOMETRY;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, DOUBLE.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, "REAL") != -1 || StringUtils.indexOfIgnoreCase(typeName, BINARY_DOUBLE.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, "FLOAT8") != -1) {
            return StringUtils.indexOfIgnoreCase(fullUniSqlTypeName, "UNSIGNED") != -1 ? DOUBLE_UNSIGNED : DOUBLE;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, FLOAT.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, BINARY_FLOAT.getName()) != -1) {
            return StringUtils.indexOfIgnoreCase(fullUniSqlTypeName, "UNSIGNED") != -1 ? FLOAT_UNSIGNED : FLOAT;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, NULL.getName()) != -1) {
            return NULL;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, TIMESTAMP_WITH_LOCAL_TIME_ZONE.getName()) != -1) {
            return TIMESTAMP_WITH_LOCAL_TIME_ZONE;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, TIMESTAMP_WITH_TIME_ZONE.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, "TIMESTAMPTZ") != -1) {
            return TIMESTAMP_WITH_TIME_ZONE;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, TIMESTAMP.getName()) != -1) {
            return TIMESTAMP;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, DATETIME.getName()) != -1) {
            return DATETIME;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, DATE.getName()) != -1) {
            return DATE;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, TIME.getName()) != -1) {
            return TIME;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, YEAR.getName()) != -1) {
            return YEAR;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, LONGBLOB.getName()) != -1) {
            return LONGBLOB;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, LONGTEXT.getName()) != -1) {
            return LONGTEXT;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, MEDIUMBLOB.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, "LONG VARBINARY") != -1) {
            return MEDIUMBLOB;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, MEDIUMTEXT.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, "LONG VARCHAR") != -1 || StringUtils.indexOfIgnoreCase(typeName, LONG.getName()) != -1) {
            return MEDIUMTEXT;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, VARCHAR2.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, VARCHAR.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, NVARCHAR.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, "NATIONAL VARCHAR") != -1 || StringUtils.indexOfIgnoreCase(typeName, "CHARACTER VARYING") != -1) {
            return VARCHAR;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, VARBINARY.getName()) != -1) {
            return VARBINARY;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, BINARY.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, "CHAR BYTE") != -1 || StringUtils.indexOfIgnoreCase(typeName, RAW.getName()) != -1) {
            return BINARY;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, "LINESTRING") != -1) {
            return GEOMETRY;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, "STRING") != -1 || StringUtils.indexOfIgnoreCase(typeName, CHAR.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, NCHAR.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, "NATIONAL CHAR") != -1 || StringUtils.indexOfIgnoreCase(typeName, CHARACTER.getName()) != -1) {
            return CHAR;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, BOOLEAN.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, BOOL.getName()) != -1) {
            return BOOLEAN;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, BIT.getName()) != -1) {
            return BIT;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, JSON.getName()) != -1) {
            return JSON;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, ENUM.getName()) != -1) {
            return ENUM;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, SET.getName()) != -1) {
            return SET;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, BLOB.getName()) != -1 || StringUtils.indexOfIgnoreCase(typeName, LONG_RAW.getName()) != -1) {
            return BLOB;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, TEXT.getName()) != -1) {
            return TEXT;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, "GEOM") != -1 || StringUtils.indexOfIgnoreCase(typeName, "POINT") != -1 || StringUtils.indexOfIgnoreCase(typeName, "POLYGON") != -1) {
            return GEOMETRY;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, INTERVAL_YEAR_TO_MONTH.getName()) != -1) {
            return INTERVAL_YEAR_TO_MONTH;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, INTERVAL_DAY_TO_SECOND.getName()) != -1) {
            return INTERVAL_DAY_TO_SECOND;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, CLOB.getName()) != -1) {
            return CLOB;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, NCLOB.getName()) != -1) {
            return NCLOB;
        }
        if (StringUtils.indexOfIgnoreCase(typeName, ROWID.getName()) != -1) {
            return ROWID;
        }
        return UNKNOWN;
    }

    public static UniSqlType getByJdbcType(int jdbcType) {
        switch (jdbcType) {
            case -5: {
                return BIGINT;
            }
            case -2: {
                return BINARY;
            }
            case -7: {
                return BIT;
            }
            case 16: {
                return BOOLEAN;
            }
            case -15: 
            case 1: {
                return CHAR;
            }
            case 91: {
                return DATE;
            }
            case 2: 
            case 3: {
                return DECIMAL;
            }
            case 8: {
                return DOUBLE;
            }
            case 6: 
            case 7: {
                return FLOAT;
            }
            case 4: {
                return INT;
            }
            case -4: 
            case 2000: 
            case 2004: {
                return BLOB;
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                return TEXT;
            }
            case 0: {
                return NULL;
            }
            case 5: {
                return SMALLINT;
            }
            case 92: {
                return TIME;
            }
            case 93: {
                return TIMESTAMP;
            }
            case -6: {
                return TINYINT;
            }
            case -3: {
                return VARBINARY;
            }
            case -9: 
            case 12: 
            case 70: 
            case 2009: {
                return VARCHAR;
            }
            case 2014: {
                return TIMESTAMP_WITH_TIME_ZONE;
            }
        }
        return UNKNOWN;
    }

    private UniSqlType(String uniSqlTypeName, int jdbcType, Class<?> javaClass) {
        this.name = uniSqlTypeName;
        this.jdbcType = jdbcType;
        this.javaClass = javaClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getClassName() {
        if (this.javaClass == null) {
            return "[B";
        }
        return this.javaClass.getName();
    }

    @Override
    public String getVendor() {
        return "UNISQL DATABASE";
    }

    @Override
    public Integer getVendorTypeNumber() {
        return this.jdbcType;
    }
}

