/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.utils;

import com.hundsun.lightdb.unisql.annotation.SuppressFBWarnings;
import com.hundsun.lightdb.unisql.constant.CompareKindEnum;
import com.hundsun.lightdb.unisql.constant.CompareReportStateEnum;
import com.hundsun.lightdb.unisql.golang.PreparedParameter;
import com.hundsun.lightdb.unisql.model.MultiCompletableFuture;
import com.hundsun.lightdb.unisql.model.MultiProperties;
import com.hundsun.lightdb.unisql.model.MultiQueryResultDTO;
import com.hundsun.lightdb.unisql.model.MultiQueryResultSetDTO;
import com.hundsun.lightdb.unisql.model.MultiplexContext;
import com.hundsun.lightdb.unisql.model.SyncDataParamater;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.utils.DbTypeSerializeUtil;
import com.hundsun.lightdb.unisql.utils.JsonUtils;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import oracle.jdbc.internal.OraclePreparedStatement;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SQL_INJECTION_JDBC"})
public class MultiJdbcUtils {
    private static final Logger log = LoggerFactory.getLogger(MultiJdbcUtils.class);
    private static int FETCHSIZE = 1000;

    public static void doPreparedQuery(Connection connection, String sql, MultiQueryResultDTO queryResultDTO, List<MultiCompletableFuture> multiFutures, Boolean sourceQuery) {
        MultiJdbcUtils.doPreparedQuery(connection, sql, Collections.emptyList(), queryResultDTO, multiFutures, sourceQuery);
    }

    public static void doPreparedQuery(Connection connection, String multiQuerySql, List<PreparedParameter> preparedParameters, MultiQueryResultDTO queryResultDTO, List<MultiCompletableFuture> multiFutures, Boolean sourceQuery) {
        queryResultDTO.setMultiQuerySql(multiQuerySql);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (StringUtils.isNotBlank(MultiProperties.getQueryResultPushUrl())) {
            queryResultDTO.setMessageType("http");
        } else {
            queryResultDTO.setMessageType("pulsar");
        }
        try {
            preparedStatement = connection.prepareStatement(multiQuerySql);
            preparedStatement.setFetchSize(FETCHSIZE);
            if (CollectionUtils.isNotEmpty(preparedParameters)) {
                block13: for (PreparedParameter preparedParameter : preparedParameters) {
                    int sqlDataType = preparedParameter.getVendorTypeNumber();
                    switch (sqlDataType) {
                        case 12: {
                            preparedStatement.setString(preparedParameter.getParameterIndex(), (String)preparedParameter.getX());
                            continue block13;
                        }
                        case 3: {
                            preparedStatement.setBigDecimal(preparedParameter.getParameterIndex(), (BigDecimal)preparedParameter.getX());
                            continue block13;
                        }
                        case 4: {
                            preparedStatement.setInt(preparedParameter.getParameterIndex(), (Integer)preparedParameter.getX());
                            continue block13;
                        }
                        case -5: {
                            preparedStatement.setLong(preparedParameter.getParameterIndex(), (Long)preparedParameter.getX());
                            continue block13;
                        }
                        case 91: {
                            preparedStatement.setDate(preparedParameter.getParameterIndex(), (Date)preparedParameter.getX());
                            continue block13;
                        }
                        case 93: {
                            preparedStatement.setTimestamp(preparedParameter.getParameterIndex(), (Timestamp)preparedParameter.getX());
                            continue block13;
                        }
                        case 2004: {
                            preparedStatement.setBlob(preparedParameter.getParameterIndex(), (Blob)preparedParameter.getX());
                            continue block13;
                        }
                        case 2005: {
                            preparedStatement.setClob(preparedParameter.getParameterIndex(), (Clob)preparedParameter.getX());
                            continue block13;
                        }
                        case -2: {
                            preparedStatement.setBytes(preparedParameter.getParameterIndex(), (byte[])preparedParameter.getX());
                            continue block13;
                        }
                    }
                    preparedStatement.setObject(preparedParameter.getParameterIndex(), preparedParameter.getX());
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u4e32\u884c\u6267\u884c\u5f00\u59cb\uff0ctraceId [{}] \u67e5\u8be2SQL [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql});
            }
            resultSet = preparedStatement.executeQuery();
            if (log.isDebugEnabled()) {
                log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u4e32\u884c\u6267\u884c\u7ed3\u675f\uff0ctraceId [{}] \u67e5\u8be2SQL [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql});
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u4e32\u884c\u6267\u884c\u5931\u8d25\uff0ctraceId [{}] \u6267\u884cSQL [{}] \u5f02\u5e38\u4fe1\u606f [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql, ExceptionUtils.getStackTrace(e)});
            }
            queryResultDTO.setState(CompareReportStateEnum.MULTI_QUERY_FAIL.name());
            queryResultDTO.addErrorReason(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u4e32\u884c\u6267\u884c\u5931\u8d25\uff0c\u591a\u53d1\u67e5\u8be2SQL\uff1a%s ,\u5f02\u5e38\u4fe1\u606f\uff1a%s", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), multiQuerySql, ExceptionUtils.getStackTrace(e)));
            MultiplexContext.sendMessage(queryResultDTO);
            return;
        }
        if (sourceQuery.booleanValue()) {
            MultiJdbcUtils.handleSourceQuery(resultSet, preparedStatement, multiQuerySql, queryResultDTO, multiFutures);
        } else {
            MultiJdbcUtils.handleTargetQuery(resultSet, preparedStatement, multiQuerySql, queryResultDTO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean getReturingData(SyncDataParamater syncData, Statement statement, String multiQuerySql, MultiQueryResultDTO queryResultDTO) {
        ResultSet rs;
        block14: {
            boolean oracleStmt2222222;
            block15: {
                rs = null;
                if (queryResultDTO == null || queryResultDTO.getSourceDialect() == null) break block14;
                if (queryResultDTO.getSourceDialect().equalsIgnoreCase(DbType.ORACLE.name())) {
                    if (statement instanceof OraclePreparedStatement) {
                        OraclePreparedStatement oracleStmt2222222 = (OraclePreparedStatement)statement;
                        rs = oracleStmt2222222.getReturnResultSet();
                    }
                } else if (queryResultDTO.getSourceDialect().equalsIgnoreCase(DbType.MYSQL.name())) {
                    rs = statement.getResultSet();
                }
                if (rs != null) break block15;
                if (log.isDebugEnabled()) {
                    log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2RETUNRING\u7ed3\u679c\u96c6\u5931\u8d25, \u7a7a\u7ed3\u679c\u96c6\uff0ctraceId [{}] \u67e5\u8be2SQL [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql});
                }
                boolean oracleStmt2222222 = false;
                if (rs == null) return oracleStmt2222222;
                MultiJdbcUtils.close(rs);
                return oracleStmt2222222;
            }
            try {
                MultiJdbcUtils.handleReturnSyncResultSet(syncData.getTableName(), syncData.getTableCols(), rs, multiQuerySql, queryResultDTO);
                if (log.isDebugEnabled()) {
                    log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u904d\u5386\u7ed3\u675f\uff0ctraceId [{}] \u67e5\u8be2SQL [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql});
                }
                oracleStmt2222222 = true;
                if (rs == null) return oracleStmt2222222;
            }
            catch (IOException e) {
                queryResultDTO.setState(CompareReportStateEnum.MULTI_QUERY_RESULT_TRANSFER_FAIL.name());
                queryResultDTO.addErrorReason(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u904d\u5386\u7ed3\u679c\u96c6\u4f20\u8f93\u5931\u8d25\uff0c\u591a\u53d1\u67e5\u8be2SQL\uff1a%s ,\u5f02\u5e38\u4fe1\u606f\uff1a%s", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), multiQuerySql, e.toString()));
                if (rs == null) return false;
                MultiJdbcUtils.close(rs);
                return false;
            }
            catch (Exception e2) {
                if (log.isErrorEnabled()) {
                    log.error("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u904d\u5386\u5931\u8d25 traceId [{}] \u6267\u884cSQL [{}] \u5f02\u5e38\u4fe1\u606f [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql, ExceptionUtils.getStackTrace(e2)});
                }
                queryResultDTO.setState(CompareReportStateEnum.MULTI_QUERY_FAIL.name());
                queryResultDTO.addErrorReason(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u904d\u5386\u5931\u8d25\uff0c\u591a\u53d1\u67e5\u8be2SQL\uff1a%s ,\u5f02\u5e38\u4fe1\u606f\uff1a%s", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), multiQuerySql, ExceptionUtils.getStackTrace(e2)));
                if (rs == null) return false;
                {
                    catch (Throwable throwable) {
                        if (rs == null) throw throwable;
                        MultiJdbcUtils.close(rs);
                        throw throwable;
                    }
                }
                MultiJdbcUtils.close(rs);
                return false;
            }
            MultiJdbcUtils.close(rs);
            return oracleStmt2222222;
        }
        if (rs == null) return false;
        MultiJdbcUtils.close(rs);
        return false;
    }

    private static void handleSourceQuery(ResultSet resultSet, PreparedStatement preparedStatement, String multiQuerySql, MultiQueryResultDTO queryResultDTO, List<MultiCompletableFuture> multiFutures) {
        String targetKey = queryResultDTO.getSourceDialect() + ":\u6e90\u5e93\u4e1a\u52a1SQL\u67e5\u8be2\u7ed3\u679c\u96c6\u5f02\u6b65";
        ExecutorService pool = MultiplexContext.getOrCreateTargetPool(targetKey);
        MultiCompletableFuture multiSourceCompletableFuture = new MultiCompletableFuture(targetKey);
        CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> {
            ResultSetWriter resultSetWriter = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u5e76\u53d1\u904d\u5386\u5f00\u59cb\uff0ctraceId [{}] \u67e5\u8be2SQL [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql});
                }
                resultSetWriter = new ResultSetWriter(MultiProperties.isResultSetSpillThresholdEnabled(), MultiProperties.getMultiResultSetSpillThreshold(), MultiProperties.getMultiResultSetSpillFileBasedir(), queryResultDTO.buildSpillFileName());
                MultiJdbcUtils.handleResultSet(resultSet, multiQuerySql, queryResultDTO, resultSetWriter);
                if (log.isDebugEnabled()) {
                    log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u5e76\u53d1\u904d\u5386\u7ed3\u675f\uff0ctraceId [{}] \u67e5\u8be2SQL [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql});
                }
                MultiplexContext.sendMessage(queryResultDTO);
                String string = String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u7ed3\u679c\u96c6\u5e76\u53d1\u904d\u5386\u5904\u7406\u5b8c\u6210", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg());
                return string;
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u5e76\u53d1\u5199\u6587\u4ef6\u5931\u8d25 traceId [{}] \u6267\u884cSQL [{}] \u5f02\u5e38\u4fe1\u606f [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql, ExceptionUtils.getStackTrace(e)});
                }
                queryResultDTO.setState(CompareReportStateEnum.MULTI_QUERY_RESULT_TRANSFER_FAIL.name());
                queryResultDTO.addErrorReason(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u7ed3\u679c\u96c6\u5e76\u53d1\u904d\u5386\u7ed3\u679c\u96c6\u4f20\u8f93\u5931\u8d25\uff0c\u591a\u53d1\u67e5\u8be2SQL\uff1a%s ,\u5f02\u5e38\u4fe1\u606f\uff1a%s", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), multiQuerySql, e.toString()));
                MultiplexContext.sendMessage(queryResultDTO);
                String string = String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u7ed3\u679c\u96c6\u5e76\u53d1\u904d\u5386\u7ed3\u679c\u96c6\u5199\u6587\u4ef6\u5931\u8d25", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg());
                return string;
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u5e76\u53d1\u904d\u5386\u5931\u8d25 traceId [{}] \u6267\u884cSQL [{}] \u5f02\u5e38\u4fe1\u606f [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql, ExceptionUtils.getStackTrace(e)});
                }
                queryResultDTO.setState(CompareReportStateEnum.MULTI_QUERY_FAIL.name());
                queryResultDTO.addErrorReason(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u7ed3\u679c\u96c6\u5e76\u53d1\u904d\u5386\u5931\u8d25\uff0c\u591a\u53d1\u67e5\u8be2SQL\uff1a%s ,\u5f02\u5e38\u4fe1\u606f\uff1a%s", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), multiQuerySql, ExceptionUtils.getStackTrace(e)));
                MultiplexContext.sendMessage(queryResultDTO);
                String string = String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u7ed3\u679c\u96c6\u5e76\u53d1\u904d\u5386\u5931\u8d25", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg());
                return string;
            }
            finally {
                MultiJdbcUtils.close(resultSet);
                MultiJdbcUtils.close(preparedStatement);
                if (resultSetWriter != null) {
                    resultSetWriter.closeWriter();
                }
            }
        }, pool);
        multiSourceCompletableFuture.setFuture(future);
        multiFutures.add(multiSourceCompletableFuture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleTargetQuery(ResultSet resultSet, PreparedStatement preparedStatement, String multiQuerySql, MultiQueryResultDTO queryResultDTO) {
        ResultSetWriter resultSetWriter = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u904d\u5386\u5f00\u59cb\uff0ctraceId [{}] \u67e5\u8be2SQL [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql});
            }
            resultSetWriter = new ResultSetWriter(MultiProperties.isResultSetSpillThresholdEnabled(), MultiProperties.getMultiResultSetSpillThreshold(), MultiProperties.getMultiResultSetSpillFileBasedir(), queryResultDTO.buildSpillFileName());
            MultiJdbcUtils.handleResultSet(resultSet, multiQuerySql, queryResultDTO, resultSetWriter);
            if (log.isDebugEnabled()) {
                log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u904d\u5386\u7ed3\u675f\uff0ctraceId [{}] \u67e5\u8be2SQL [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql});
            }
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u5199\u6587\u4ef6\u5931\u8d25 traceId [{}] \u6267\u884cSQL [{}] \u5f02\u5e38\u4fe1\u606f [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql, ExceptionUtils.getStackTrace(e)});
            }
            queryResultDTO.setState(CompareReportStateEnum.MULTI_QUERY_RESULT_TRANSFER_FAIL.name());
            queryResultDTO.addErrorReason(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u904d\u5386\u7ed3\u679c\u96c6\u4f20\u8f93\u5931\u8d25\uff0c\u591a\u53d1\u67e5\u8be2SQL\uff1a%s ,\u5f02\u5e38\u4fe1\u606f\uff1a%s", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), multiQuerySql, e.toString()));
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u904d\u5386\u5931\u8d25 traceId [{}] \u6267\u884cSQL [{}] \u5f02\u5e38\u4fe1\u606f [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql, ExceptionUtils.getStackTrace(e)});
            }
            queryResultDTO.setState(CompareReportStateEnum.MULTI_QUERY_FAIL.name());
            queryResultDTO.addErrorReason(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u904d\u5386\u5931\u8d25\uff0c\u591a\u53d1\u67e5\u8be2SQL\uff1a%s ,\u5f02\u5e38\u4fe1\u606f\uff1a%s", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), multiQuerySql, ExceptionUtils.getStackTrace(e)));
        }
        finally {
            MultiJdbcUtils.close(resultSet);
            MultiJdbcUtils.close(preparedStatement);
            if (resultSetWriter != null) {
                resultSetWriter.closeWriter();
            }
        }
        MultiplexContext.sendMessage(queryResultDTO);
    }

    private static void handleResultSet(ResultSet resultSet, String multiQuerySql, MultiQueryResultDTO queryResultDTO, ResultSetWriter resultSetWriter) throws Exception {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int columnCount = resultSetMetaData.getColumnCount();
        ArrayList<String> columnNames = new ArrayList<String>(columnCount);
        ArrayList<Integer> columnDataTypes = new ArrayList<Integer>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            String columnName = resultSetMetaData.getColumnLabel(i + 1);
            int columnType = DbTypeSerializeUtil.getColumnType(resultSetMetaData, i + 1);
            columnNames.add(columnName.toLowerCase());
            columnDataTypes.add(columnType);
        }
        MultiQueryResultSetDTO multiQueryResultSet = new MultiQueryResultSetDTO();
        multiQueryResultSet.setColumnNames(columnNames);
        multiQueryResultSet.setColumnDataTypes(columnDataTypes);
        String traceId = queryResultDTO.getTraceId();
        boolean enableFetchLimit = MultiProperties.isMultiResultSetFetchLimitEnabled();
        int fetchLimit = MultiProperties.getMultiResultSetFetchLimit();
        int fetchCount = 0;
        while (resultSet.next()) {
            if (enableFetchLimit) {
                if (fetchCount >= fetchLimit) {
                    multiQueryResultSet.setFetchLimit(fetchLimit);
                    break;
                }
                ++fetchCount;
            }
            ArrayList<Object> curRow = new ArrayList<Object>();
            for (int i = 0; i < columnCount; ++i) {
                Object value = DbTypeSerializeUtil.getResultSetValueBySqlTypeName(traceId, multiQuerySql, resultSet, resultSetMetaData, i + 1, DbType.of(queryResultDTO.getTargetDialect()));
                curRow.add(value);
            }
            if (log.isDebugEnabled()) {
                log.debug("\u8bfb\u53d6\u5f53\u524d\u884c\u6570\u636e\uff0ctrace_id [{}] multiQuerySql [{}] \u6e90\u65b9\u8a00 [{}] \u76ee\u6807\u65b9\u8a00 [{}] \u884c\u5185\u5bb9 [{}]", new Object[]{traceId, multiQuerySql, queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), JsonUtils.toJson(curRow)});
            }
            if (log.isDebugEnabled()) {
                log.debug("\u5e8f\u5217\u5316\u884c\u6570\u636e traceId [{}] \u884c\u5185\u5bb9 [{}] multiQuerySql [{}]", new Object[]{traceId, JsonUtils.toJson(curRow), multiQuerySql});
            }
            resultSetWriter.writeRow(curRow, columnDataTypes);
        }
        resultSetWriter.finish(multiQueryResultSet);
        multiQueryResultSet.setBizSqlTableName(queryResultDTO.getBizSqlTableName());
        queryResultDTO.setMultiQueryRowCount(resultSetWriter.size());
        queryResultDTO.setMultiQueryResultSet(multiQueryResultSet);
    }

    private static void handleSyncResultSet(ResultSet resultSet, String multiQuerySql, MultiQueryResultDTO queryResultDTO) throws Exception {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int columnCount = resultSetMetaData.getColumnCount();
        ArrayList<String> columnNames = new ArrayList<String>(columnCount);
        ArrayList<Integer> columnDataTypes = new ArrayList<Integer>(columnCount);
        String bizTableName = null;
        if (columnCount > 0) {
            bizTableName = resultSetMetaData.getTableName(1);
        }
        for (int i = 0; i < columnCount; ++i) {
            String columnName = resultSetMetaData.getColumnLabel(i + 1);
            int columnType = DbTypeSerializeUtil.getColumnType(resultSetMetaData, i + 1);
            columnNames.add(columnName.toLowerCase());
            columnDataTypes.add(columnType);
        }
        MultiQueryResultSetDTO multiQueryResultSet = new MultiQueryResultSetDTO();
        multiQueryResultSet.setColumnNames(columnNames);
        multiQueryResultSet.setColumnDataTypes(columnDataTypes);
        ArrayList<List<Object>> dataRows = new ArrayList<List<Object>>();
        String traceId = queryResultDTO.getTraceId();
        while (resultSet.next()) {
            ArrayList<Object> curRow = new ArrayList<Object>();
            for (int i = 0; i < columnCount; ++i) {
                Object value = DbTypeSerializeUtil.getResultSetValueBySqlTypeName(traceId, multiQuerySql, resultSet, resultSetMetaData, i + 1, DbType.of(queryResultDTO.getTargetDialect()));
                curRow.add(value);
            }
            dataRows.add(curRow);
        }
        multiQueryResultSet.setDataRows(dataRows);
        multiQueryResultSet.setBizSqlTableName(queryResultDTO.getBizSqlTableName());
        queryResultDTO.setMultiQueryRowCount(dataRows.size());
        queryResultDTO.setMultiQueryResultSet(multiQueryResultSet);
        queryResultDTO.setBizSqlTableName(bizTableName);
    }

    public static void handleReturnSyncResultSet(String syncTableName, List<String> syncColumnNames, ResultSet resultSet, String multiQuerySql, MultiQueryResultDTO queryResultDTO) throws Exception {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int columnCount = resultSetMetaData.getColumnCount();
        MultiQueryResultSetDTO multiQueryResultSet = new MultiQueryResultSetDTO();
        multiQueryResultSet.setColumnNames(syncColumnNames);
        ArrayList<List<Object>> dataRows = new ArrayList<List<Object>>();
        String traceId = queryResultDTO.getTraceId();
        while (resultSet.next()) {
            ArrayList<Object> curRow = new ArrayList<Object>();
            for (int i = 0; i < columnCount; ++i) {
                Object value = DbTypeSerializeUtil.getResultSetValueBySqlTypeName(traceId, multiQuerySql, resultSet, resultSetMetaData, i + 1, DbType.of(queryResultDTO.getTargetDialect()));
                curRow.add(value);
            }
            dataRows.add(curRow);
        }
        multiQueryResultSet.setDataRows(dataRows);
        multiQueryResultSet.setBizSqlTableName(queryResultDTO.getBizSqlTableName());
        queryResultDTO.setMultiQueryRowCount(dataRows.size());
        queryResultDTO.setMultiQueryResultSet(multiQueryResultSet);
        queryResultDTO.setBizSqlTableName(syncTableName);
    }

    public static void close(AutoCloseable autoCloseable) {
        block3: {
            try {
                if (autoCloseable != null) {
                    autoCloseable.close();
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static boolean checkDataBaseConnection(String url, String userName, String password) {
        boolean flag;
        block2: {
            flag = false;
            try {
                Connection connection = DriverManager.getConnection(url, userName, password);
                connection.close();
                flag = true;
            }
            catch (SQLException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error("\u6570\u636e\u5e93\u914d\u7f6e\u9519\u8bef url\uff1a{} userName:{} ", (Object)url, (Object)userName);
            }
        }
        return flag;
    }

    private static final class ResultSetWriter {
        private final boolean spillThresholdEnabled;
        private final int spillThreshold;
        private final String basePath;
        private final String fileName;
        private BufferedWriter writer;
        private List<List<Object>> dataRows = new ArrayList<List<Object>>();
        private int writeCount = 0;
        private boolean spilledToFile = false;

        public ResultSetWriter(boolean spillThresholdEnabled, int spillThreshold, String basePath, String fileName) {
            this.spillThresholdEnabled = spillThresholdEnabled;
            this.spillThreshold = spillThreshold;
            this.basePath = basePath;
            this.fileName = fileName;
        }

        public void writeRow(List<Object> row, List<Integer> columnDataTypes) throws IOException {
            if (this.spillThresholdEnabled && this.writeCount >= this.spillThreshold) {
                if (!this.spilledToFile) {
                    this.spillToFile();
                }
                this.writer.write(this.serializeCsvRow(row) + "\n");
                ++this.writeCount;
            } else {
                this.dataRows.add(row);
                ++this.writeCount;
            }
        }

        private String serializeCsvRow(List<Object> row) {
            return JsonUtils.toJson(row);
        }

        private void spillToFile() throws IOException {
            String filePath = Paths.get(this.basePath, this.fileName).toString();
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), StandardCharsets.UTF_8));
            for (List<Object> row : this.dataRows) {
                this.writer.write(this.serializeCsvRow(row) + "\n");
            }
            this.dataRows.clear();
            this.spilledToFile = true;
        }

        public void finish(MultiQueryResultSetDTO multiQueryResultSet) {
            try {
                if (this.spilledToFile) {
                    multiQueryResultSet.setFilePath(this.basePath + "/" + this.fileName);
                } else {
                    multiQueryResultSet.setDataRows(this.dataRows);
                }
            }
            finally {
                this.closeWriter();
            }
        }

        public int size() {
            return this.writeCount;
        }

        public void closeWriter() {
            if (this.writer != null) {
                try {
                    this.writer.close();
                    this.writer = null;
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u6587\u4ef6\u8def\u5f84\uff1a{}\u3002\u6b64\u9519\u8bef\u53ef\u80fd\u5bfc\u81f4\u6570\u636e\u672a\u5b8c\u5168\u5199\u5165\u6587\u4ef6\u3002", (Object)(this.basePath + "/" + this.fileName), (Object)e);
                }
            }
        }
    }
}

