/*
 * Decompiled with CFR 0.152.
 */
package shaded.jnr.ffi.provider.converters;

import shaded.jnr.ffi.mapper.ToNativeContext;
import shaded.jnr.ffi.mapper.ToNativeConverter;
import shaded.jnr.ffi.provider.ParameterFlags;

@ToNativeConverter.NoContext
@ToNativeConverter.Cacheable
public class BoxedDoubleArrayParameterConverter
implements ToNativeConverter<Double[], double[]> {
    private static final ToNativeConverter<Double[], double[]> IN = new BoxedDoubleArrayParameterConverter(2);
    private static final ToNativeConverter<Double[], double[]> OUT = new Out(1);
    private static final ToNativeConverter<Double[], double[]> INOUT = new Out(3);
    private final int parameterFlags;

    public static ToNativeConverter<Double[], double[]> getInstance(ToNativeContext toNativeContext) {
        int parameterFlags = ParameterFlags.parse(toNativeContext.getAnnotations());
        return ParameterFlags.isOut(parameterFlags) ? (ParameterFlags.isIn(parameterFlags) ? INOUT : OUT) : IN;
    }

    BoxedDoubleArrayParameterConverter(int parameterFlags) {
        this.parameterFlags = parameterFlags;
    }

    @Override
    public double[] toNative(Double[] array, ToNativeContext context) {
        if (array == null) {
            return null;
        }
        double[] primitive = new double[array.length];
        if (ParameterFlags.isIn(this.parameterFlags)) {
            for (int i = 0; i < array.length; ++i) {
                primitive[i] = array[i] != null ? array[i] : 0.0;
            }
        }
        return primitive;
    }

    @Override
    public Class<double[]> nativeType() {
        return double[].class;
    }

    public static final class Out
    extends BoxedDoubleArrayParameterConverter
    implements ToNativeConverter.PostInvocation<Double[], double[]> {
        Out(int parameterFlags) {
            super(parameterFlags);
        }

        @Override
        public void postInvoke(Double[] array, double[] primitive, ToNativeContext context) {
            if (array != null && primitive != null) {
                for (int i = 0; i < array.length; ++i) {
                    array[i] = primitive[i];
                }
            }
        }
    }
}

