-- 创建unisql模式
CREATE SCHEMA IF NOT EXISTS unisql;

-- 授予所有用户对 unisql schema 的使用权限，使得所有用户都可以引用该 schema 中的对象
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
-- 授予所有用户对 unisql schema 中所有表的查询权限
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
-- 设置默认权限，确保未来新建的表、函数、存储过程自动赋予 PUBLIC 相应权限
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
--  创建REGEXP_INSTR函数，REGEXP_INSTR( string text, pattern text ) -> integer
CREATE OR REPLACE FUNCTION unisql.regexp_instr(text, text)
RETURNS integer
AS $$
DECLARE
v_pos integer;
  v_pattern text;
BEGIN
  v_pattern := '(' || $2 || ')';
  v_pos := (SELECT position((SELECT (regexp_matches($1, v_pattern, 'pg'))[1] OFFSET 0 LIMIT 1) IN $1));
  IF v_pos IS NOT NULL THEN
    RETURN v_pos;
END IF;
RETURN 0;
END;
$$
LANGUAGE plpgsql;