-- 创建unisql模式
do language 'plpgsql'
$body$
    declare
create_mark int;
begin
select count(1) into create_mark from pg_namespace where nspname='unisql';
if create_mark = 0 then
create schema unisql;
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
            raise notice 'create schema unisql';
else
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
            raise notice 'do not create schema unisql';
end if;
end $body$;

-- 创建to_number函数
create or replace function public.to_number(interval) returns int4
as $$
begin
return EXTRACT(epoch FROM $1) / 86400;
end; $$ language plpgsql STRICT IMMUTABLE;

-- 创建months_between函数。参与计算的年、月、日、时、分、秒，秒的其他精度不包含
CREATE OR REPLACE FUNCTION unisql.months_between(
    p_ts1 timestamptz,
    p_ts2 timestamptz
)
    RETURNS double precision
    IMMUTABLE strict
AS $$
DECLARE
result double precision;
BEGIN
    IF p_ts1 IS NULL OR p_ts2 IS NULL OR p_ts1 = '' OR p_ts2 = '' THEN
        RETURN NULL;
END IF;
SELECT CASE
           WHEN dd1 = dd2 OR (m1 = dd1 AND m2 = dd2) THEN
               yd * 12 + mmd
           ELSE
               yd * 12 + mmd
                   + (dd1 - dd2) / 31
                   + hd / 31 / 24
                   + md / 31 / 24 / 60
                   + sd / 31 / 24 / 60 / 60
           END INTO result
FROM (SELECT extract('day' FROM date_trunc('month', p_ts1) + interval '1 month -1 day') AS m1,
             extract('day' FROM date_trunc('month', p_ts2) + interval '1 month -1 day') AS m2,
             extract('year' FROM p_ts1) - extract('year' FROM p_ts2) AS yd,
             extract('month' FROM p_ts1) - extract('month' FROM p_ts2) AS mmd,
             extract('day' FROM p_ts1) AS dd1,
             extract('day' FROM p_ts2) AS dd2,
             extract('hour' FROM p_ts1) - extract('hour' FROM p_ts2) AS hd,
             extract('minute' FROM p_ts1) - extract('minute' FROM p_ts2) AS md,
             trunc(extract('second' FROM p_ts1)) - trunc(extract('second' FROM p_ts2)) AS sd) AS x;

RETURN result;
END;
$$ LANGUAGE plpgsql;

-- 创建tabs视图
do language 'plpgsql'
$$
declare
create_mark int;
begin
select count(1) into create_mark from information_schema.views where table_schema='unisql' and table_name='tabs';
if create_mark = 0 then
        CREATE OR REPLACE VIEW unisql.tabs(
            OWNER,
            TABLE_NAME,
            TABLESPACE_NAME,
            STATUS,
            logging,
            PARTITIONED,
            temporary,
            DROPPED,
            READ_ONLY,
            SEGMENT_CREATED,
            HAS_IDENTITY,
            EXTERNAL
            ) AS
SELECT
    upper(owner) as owner,
    upper(TABLE_NAME) TABLE_NAME,
    upper(TABLESPACE_NAME) TABLESPACE_NAME,
    upper(STATUS) STATUS,
    upper(logging) as logging,
    upper(PARTITIONED) PARTITIONED,
    upper(temporary) as temporary,
            DROPPED,
            upper(READ_ONLY) READ_ONLY,
            SEGMENT_CREATED,
            HAS_IDENTITY,
            external
FROM my_tables
WHERE owner = current_user;

raise notice 'create view %','unisql.tabs';
else
        raise notice 'do not create view %','unisql.tabs';
end if;
end $$;

-- 创建user_tables视图
do language 'plpgsql'
$$
declare
create_mark int;
begin
select count(1) into create_mark from information_schema.views where table_schema='unisql' and table_name='user_tables';
if create_mark = 0 then
        CREATE OR REPLACE VIEW unisql.user_tables(
                                                  OWNER,
                                                  TABLE_NAME,
                                                  TABLESPACE_NAME,
                                                  STATUS,
                                                  logging,
                                                  PARTITIONED,
                                                  temporary,
                                                  DROPPED,
                                                  READ_ONLY,
                                                  SEGMENT_CREATED,
                                                  HAS_IDENTITY,
                                                  EXTERNAL
            ) AS
SELECT
    upper(owner) as owner,
    upper(TABLE_NAME) TABLE_NAME,
    upper(TABLESPACE_NAME) TABLESPACE_NAME,
    upper(STATUS) STATUS,
    upper(logging) as logging,
    upper(PARTITIONED) PARTITIONED,
    upper(temporary) as temporary,
            DROPPED,
            upper(READ_ONLY) READ_ONLY,
            SEGMENT_CREATED,
            HAS_IDENTITY,
            external
FROM my_tables
WHERE owner = current_user;

raise notice 'create view %','unisql.user_tables';
else
        raise notice 'do not create view %','unisql.user_tables';
end if;
end $$;

-- 创建cols视图
do language 'plpgsql'
$$
declare
create_mark int;
begin
select count(1) into create_mark from information_schema.views where table_schema='unisql' and table_name='cols';
if create_mark = 0 then
        CREATE OR REPLACE VIEW unisql.cols(
            OWNER,
            TABLE_NAME,
            COLUMN_NAME,
            DATA_TYPE,
            DATA_TYPE_MOD,
            DATA_TYPE_OWNER,
            DATA_LENGTH,
            DATA_PRECISION,
            DATA_SCALE,
            NULLABLE,
            COLUMN_ID,
            DEFAULT_LENGTH,
            DATA_DEFAULT,
            NUM_DISTINCT,
            LOW_VALUE,
            HIGH_VALUE,
            DENSITY,
            NUM_NULLS,
            NUM_BUCKETS,
            LAST_ANALYZED,
            SAMPLE_SIZE,
            CHARACTER_SET_NAME,
            CHAR_COL_DECL_LENGTH,
            GLOBAL_STATS,
            USER_STATS,
            AVG_COL_LEN,
            CHAR_LENGTH,
            CHAR_USED,
            DEFAULT_ON_NULL,
            IDENTITY_COLUMN,
            "COLLATION"
            ) as
select
    upper(owner) as owner,
    upper(TABLE_NAME) TABLE_NAME,
    upper(COLUMN_NAME) COLUMN_NAME,
    upper(DATA_TYPE) DATA_TYPE,
    DATA_TYPE_MOD,
    DATA_TYPE_OWNER,
    DATA_LENGTH,
    DATA_PRECISION,
    DATA_SCALE,
    NULLABLE,
    COLUMN_ID,
    DEFAULT_LENGTH,
    CASE
        WHEN DATA_DEFAULT IS NULL OR DATA_DEFAULT = '' THEN NULL
        ELSE regexp_split_to_array(DATA_DEFAULT, '::')[1]
        END AS DATA_DEFAULT,
    NUM_DISTINCT,
    LOW_VALUE,
    HIGH_VALUE,
    DENSITY,
    NUM_NULLS,
    NUM_BUCKETS,
    LAST_ANALYZED,
    SAMPLE_SIZE,
    CHARACTER_SET_NAME,
    CHAR_COL_DECL_LENGTH,
    GLOBAL_STATS,
    USER_STATS,
    AVG_COL_LEN,
    CHAR_LENGTH,
    CHAR_USED,
    DEFAULT_ON_NULL,
    IDENTITY_COLUMN,
    "collation"
from my_tab_columns
WHERE owner = current_user;

raise notice 'create view %','unisql.cols';
else
        raise notice 'do not create view %','unisql.cols';
end if;
end $$;

-- 创建user_tab_columns视图
do language 'plpgsql'
$$
declare
create_mark int;
begin
select count(1) into create_mark from information_schema.views where table_schema='unisql' and table_name='user_tab_columns';
if create_mark = 0 then
        CREATE OR REPLACE VIEW unisql.user_tab_columns(
            OWNER,
            TABLE_NAME,
            COLUMN_NAME,
            DATA_TYPE,
            DATA_TYPE_MOD,
            DATA_TYPE_OWNER,
            DATA_LENGTH,
            DATA_PRECISION,
            DATA_SCALE,
            NULLABLE,
            COLUMN_ID,
            DEFAULT_LENGTH,
            DATA_DEFAULT,
            NUM_DISTINCT,
            LOW_VALUE,
            HIGH_VALUE,
            DENSITY,
            NUM_NULLS,
            NUM_BUCKETS,
            LAST_ANALYZED,
            SAMPLE_SIZE,
            CHARACTER_SET_NAME,
            CHAR_COL_DECL_LENGTH,
            GLOBAL_STATS,
            USER_STATS,
            AVG_COL_LEN,
            CHAR_LENGTH,
            CHAR_USED,
            DEFAULT_ON_NULL,
            IDENTITY_COLUMN,
            "COLLATION"
            ) as
select
    upper(owner) as owner,
    upper(TABLE_NAME) TABLE_NAME,
    upper(COLUMN_NAME) COLUMN_NAME,
    upper(DATA_TYPE) DATA_TYPE,
    DATA_TYPE_MOD,
    DATA_TYPE_OWNER,
    DATA_LENGTH,
    DATA_PRECISION,
    DATA_SCALE,
    NULLABLE,
    COLUMN_ID,
    DEFAULT_LENGTH,
    CASE
        WHEN DATA_DEFAULT IS NULL OR DATA_DEFAULT = '' THEN NULL
        ELSE regexp_split_to_array(DATA_DEFAULT, '::')[1]
        END AS DATA_DEFAULT,
    NUM_DISTINCT,
    LOW_VALUE,
    HIGH_VALUE,
    DENSITY,
    NUM_NULLS,
    NUM_BUCKETS,
    LAST_ANALYZED,
    SAMPLE_SIZE,
    CHARACTER_SET_NAME,
    CHAR_COL_DECL_LENGTH,
    GLOBAL_STATS,
    USER_STATS,
    AVG_COL_LEN,
    CHAR_LENGTH,
    CHAR_USED,
    DEFAULT_ON_NULL,
    IDENTITY_COLUMN,
    "collation"
from my_tab_columns
WHERE owner = current_user;

raise notice 'create view %','unisql.user_tab_columns';
else
        raise notice 'do not create view %','unisql.user_tab_columns';
end if;
end $$;

-- 创建user_users视图
do language 'plpgsql'
$$
declare
create_mark int;
begin
select count(1) into create_mark from information_schema.views where table_schema='unisql' and table_name='user_users';
if create_mark = 0 then
        CREATE OR REPLACE VIEW unisql.user_users AS
SELECT  UPPER(usename::text) AS USERNAME
     , usesysid as USER_ID
     , 'NORMAL' as account_status
     , NULL::date as LOCK_DATE
             , valuntil as EXPIRY_DATE
     , NULL::text as DEFAULT_TABLESPACE
             , NULL::text as TEMPORARY_TABLESPACE
             , NULL::date as CREATED
             , NULL::text as INITIAL_RSRC_CONSUMER_GROUP
             , NULL::text as EXTERNAL_NAME
FROM pg_catalog.pg_user WHERE USERNAME = upper(current_user::text);

raise notice 'create view %','unisql.user_users';
else
        raise notice 'do not create view %','unisql.user_users';
end if;
end $$;