-- 创建 unisql 用户并赋权
DECLARE
    v_count NUMBER;
BEGIN
    SELECT COUNT(*) INTO v_count FROM DBA_USERS WHERE USERNAME = upper('UNISQL');
    IF v_count = 0 THEN
        EXECUTE IMMEDIATE 'CREATE USER UNISQL IDENTIFIED BY "unisql_pwd123"';
        EXECUTE IMMEDIATE 'GRANT SELECT, INSERT, UPDATE, DELETE ON unisql.* TO PUBLIC';
    END IF;
END;

-- mariadb(10.11.8)2Ob_Oracle(4.2.1) 内置函数转换：该函数用于转 IF(cond, expr1, expr2) ，输入 cond 输出 0 或 1
CREATE OR REPLACE FUNCTION unisql.is_nonzero(input_val IN VARCHAR2) RETURN NUMBER 
IS
  num_val NUMBER;
  trimmed_val VARCHAR2(4000);
BEGIN
  IF input_val IS NULL THEN
    RETURN 0;
  END IF;
  trimmed_val := REGEXP_SUBSTR(TRIM(input_val), '^[-+]?\d*\.?\d+');
  IF trimmed_val IS NULL THEN
    RETURN 0;
  END IF;
  BEGIN
    num_val := TO_NUMBER(trimmed_val);
  EXCEPTION
    WHEN OTHERS THEN
      RETURN 0;
  END;
  IF num_val = 0 OR num_val IS NULL THEN
    RETURN 0;
  ELSE
    RETURN 1;
  END IF;
END is_nonzero;


-- 在赋权前就需要创建unisql_version版本号信息维护表，以便能够被赋权
DECLARE
v_count NUMBER;
BEGIN
SELECT COUNT(*) INTO v_count from ALL_TABLES WHERE OWNER = upper('UNISQL') AND TABLE_NAME = 'UNISQL_VERSION';

IF v_count = 0 THEN
        EXECUTE IMMEDIATE 'create table UNISQL.UNISQL_VERSION (id int primary key,version varchar(20),update_time date)';
END IF;
END;

-- 创建所有用户对unisql下表访问执行权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('TABLE')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT SELECT, INSERT, UPDATE, DELETE ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- 创建所有用户对unisql下视图访问权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('VIEW')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT SELECT ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- 创建所有用户对unisql下PROCEDURE、FUNCTION、PACKAGE访问执行权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('PROCEDURE', 'FUNCTION', 'PACKAGE')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT EXECUTE ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;