-- 创建unisql模式
do language 'plpgsql'
$body$
    declare
create_mark int;
begin
select count(1) into create_mark from pg_namespace where nspname='unisql';
if create_mark = 0 then
create schema unisql;
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
raise notice 'create schema unisql';
else
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
raise notice 'do not create schema unisql';
end if;
end $body$;


-- 创建any_value_transfn用于any_value聚合函数
create or replace function unisql.any_value_transfn(anyelement,anyelement) returns anyelement as $$ begin
    return case when $1 is null then $2 else $1 end;
end;$$ language PLPGSQL STRICT IMMUTABLE;

-- 创建any_value_transfn用于any_value聚合函数
create or replace function unisql.any_value_finalfn(anyelement) returns anyelement as $$ begin
    return $1;
end;$$ language PLPGSQL STRICT IMMUTABLE;

-- 创建any_value聚合函数
DO
$$
BEGIN
        IF NOT EXISTS (
                SELECT 1
                FROM pg_proc
                         JOIN pg_namespace ON pg_proc.pronamespace = pg_namespace.oid
                WHERE nspname = 'unisql' AND proname = 'any_value'
            ) THEN
            EXECUTE 'CREATE AGGREGATE unisql.any_value(anyelement)(
        SFUNC = unisql.any_value_transfn,
        STYPE = anyelement,
        FINALFUNC = unisql.any_value_finalfn
    );';
END IF;
END
$$;

-- 创建用于支持mysql的information_schema.partitions视图
create or replace
view unisql.partitions as
select
    ns.nspname::varchar(64) as table_schema,
        parent_rel.relname::varchar(64) as table_name,
        p.relname::varchar(64) as partition_name,
        case p.partstrategy
            when 'r' then 'RANGE'
            when 'l' then 'LIST'
            when 'h' then 'HASH'
            else 'KNKNOWN'
            end::varchar(18) as partition_method,
        case p.boundaries
            when '{NULL}' then 'MAXVALUE'
            else array_to_string(p.boundaries, ',')
            end as partition_description
from
    pg_partition p
        join pg_class parent_rel on
        p.parentid = parent_rel.oid
        join pg_namespace ns on
        parent_rel.relnamespace = ns.oid
where
    p.parttype = 'p';


-- 创建compress函数
CREATE OR REPLACE FUNCTION unisql.compress(text) RETURNS text AS $$
BEGIN
RETURN $1;
END; $$ language plpgsql STRICT IMMUTABLE;

-- 创建compress函数
CREATE OR REPLACE FUNCTION unisql.compress(bytea) RETURNS bytea AS $$
BEGIN
RETURN $1;
END; $$ language plpgsql STRICT IMMUTABLE;

-- 创建uncompress函数,入参为非二进制格式字符串返回null,与mariadb表现一致
CREATE OR REPLACE FUNCTION unisql.uncompress(text) RETURNS bytea AS $$
BEGIN
RETURN null;
END; $$ language plpgsql STRICT IMMUTABLE;

-- 创建uncompress函数
CREATE OR REPLACE FUNCTION unisql.uncompress(bytea) RETURNS bytea AS $$
BEGIN
RETURN $1;
END; $$ language plpgsql STRICT IMMUTABLE;
