-- dm 授权方案改为创建执行完SQL语句后，增加创建所有用户对unisql下表视图访问执行权限，和对unisql下PROCEDURE、FUNCTION、PACKAGE访问执行权限
-- 创建unisql模式
DECLARE
    v_count NUMBER;
BEGIN
    SELECT COUNT(*) INTO v_count FROM DBA_USERS WHERE USERNAME = 'UNISQL';
    IF v_count = 0 THEN
        EXECUTE IMMEDIATE 'CREATE USER UNISQL IDENTIFIED BY "unisql_pwd123"';
    END IF;
    EXECUTE IMMEDIATE 'GRANT SELECT ON SYS.DBA_TAB_PARTITIONS TO unisql';
    EXECUTE IMMEDIATE 'GRANT SELECT ON SYS.DBA_PART_TABLES TO unisql';
    COMMIT;
END;

-- 创建 date_format 函数：处理 timestamp 类型输入
CREATE OR REPLACE FUNCTION unisql.date_format(p_time TIMESTAMP, p_format VARCHAR2)
RETURN VARCHAR2
AS
BEGIN
    IF p_time IS NULL OR p_format IS NULL THEN
        RETURN NULL;
    END IF;
    RETURN TO_CHAR(p_time, p_format);
END;

-- 创建 date_format 函数：处理 text 类型输入
CREATE OR REPLACE FUNCTION unisql.date_format(p_time_str VARCHAR2, p_format VARCHAR2)
RETURN VARCHAR2
AS
    v_time TIMESTAMP;
BEGIN
    IF p_time_str IS NULL OR p_format IS NULL THEN
        RETURN NULL;
    END IF;
    v_time := TO_TIMESTAMP(p_time_str, 'YYYY-MM-DD HH24:MI:SS.FF');
    RETURN TO_CHAR(v_time, p_format);
END;

-- 创建timestamp函数
CREATE OR REPLACE FUNCTION UNISQL.TIMESTAMP(
    p_date TIMESTAMP,
    p_time text
) RETURN DATETIME
AS
BEGIN
    IF p_date IS NULL OR p_time IS NULL THEN
        RETURN NULL;
END IF;
	IF  p_time = '' THEN
        RETURN NULL;
END IF;
RETURN CAST(p_date AS DATETIME) + TO_DSINTERVAL('0 ' || p_time);
END;

-- 创建 PARTITIONS 视图
CREATE OR REPLACE VIEW UNISQL.PARTITIONS AS
SELECT 
    t.OWNER AS TABLE_SCHEMA,
    t.TABLE_NAME,
    p.PARTITION_NAME,
    t.PARTITIONING_TYPE AS PARTITION_METHOD,
    CASE 
        WHEN p.HIGH_VALUE = 'MAXVALUE' THEN 'MAXVALUE'
        ELSE p.HIGH_VALUE
    END AS PARTITION_DESCRIPTION
FROM 
    DBA_TAB_PARTITIONS p
JOIN 
    DBA_PART_TABLES t 
    ON p.TABLE_OWNER = t.OWNER 
    AND p.TABLE_NAME = t.TABLE_NAME
WHERE 
    t.PARTITIONING_TYPE IN ('RANGE', 'LIST', 'HASH');


-- 注意：下面3个创建权限语句必须放在所有自定义sql后面，请勿删除
-- 创建所有用户对unisql下表访问执行权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('TABLE')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT SELECT, INSERT, UPDATE, DELETE ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- 创建所有用户对unisql下表视图访问权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('VIEW')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT SELECT ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- 创建所有用户对unisql下PROCEDURE、FUNCTION、PACKAGE访问执行权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('PROCEDURE', 'FUNCTION', 'PACKAGE')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT EXECUTE ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;


-- 创建用于支持mysql的information_schema.statistics视图。
CREATE OR REPLACE VIEW UNISQL.statistics AS
SELECT
    ind.table_owner AS TABLE_SCHEMA,
    ind.table_name AS TABLE_NAME
FROM
    all_ind_columns ind;

-- 创建用于支持mysql的information_schema.key_column_usage视图。约束保留主键和唯一约束
CREATE OR REPLACE VIEW UNISQL.key_column_usage AS
SELECT
    acc.owner AS CONSTRAINT_SCHEMA,
    CASE
        WHEN ac.constraint_type = 'P' THEN 'PRIMARY'
        ELSE acc.constraint_name
        END AS CONSTRAINT_NAME,
    acc.owner AS TABLE_SCHEMA,
    acc.table_name AS TABLE_NAME,
    acc.column_name AS COLUMN_NAME,
    acc.position AS ORDINAL_POSITION
FROM
    all_cons_columns acc
    JOIN all_constraints ac
    ON
    acc.owner = ac.owner
     AND acc.constraint_name = ac.constraint_name
     AND ac.constraint_type IN ('P','U');

