-- 创建unisql模式
do language 'plpgsql'
$body$
    declare
        create_mark int;
    begin
        select count(1) into create_mark from pg_namespace where nspname='unisql';
        if create_mark = 0 then
create schema unisql;
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
            raise notice 'create schema unisql';
        else
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
            raise notice 'do not create schema unisql';
        end if;
    end $body$;

-- 创建分区信息视图,对应mysql的information_schema.partitions
create or replace
view unisql.partitions as
select
	ns.nspname::varchar(64) as table_schema,
	parent_rel.relname::varchar(64) as table_name,
	p.relname::varchar(64) as partition_name,
	case p.partstrategy
		when 'r' then 'RANGE'
		when 'l' then 'LIST'
		when 'h' then 'HASH'
		else 'KNKNOWN'
		end::varchar(18) as partition_method,
	case p.boundaries
		when '{NULL}' then 'MAXVALUE'
		else array_to_string(p.boundaries, ',') 
		end as partition_description
from
	pg_partition p
join pg_class parent_rel on
	p.parentid = parent_rel.oid
join pg_namespace ns on
	parent_rel.relnamespace = ns.oid
where
	p.parttype = 'p';

-- 创建unisql模式
do language 'plpgsql'
$body$
    declare
        create_mark int;
    begin
        select count(1) into create_mark from pg_namespace where nspname='unisql';
        if create_mark = 0 then
create schema unisql;
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
            raise notice 'create schema unisql';
        else
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
            raise notice 'do not create schema unisql';
        end if;
    end $body$;

-- 创建unisql.date_sub函数，映射对应的mysql的date_sub函数
create or replace function unisql.date_sub(timestamptz,interval)
    returns date
as $$
begin
    return $1::date - $2;
end;
$$ language plpgsql;

-- 创建unisql.date_sub函数，映射对应的mysql的date_sub函数
create or replace function unisql.date_sub(text,interval)
    returns date
as $$ begin
    return $1::date - $2;
end;
$$language plpgsql;

-- 创建unisql.day函数，映射对应的mysql的day函数
create  or replace function unisql.day(text)
    returns int2
as $$
begin
    return extract(day from $1::date);
end; $$
    language plpgsql;

-- 创建unisql.day函数，映射对应的mysql的day函数
create or replace function unisql.day(timestamptz)
    returns int4
as $$
begin
    return extract(day from $1);
end; $$
    language plpgsql;

--new create dayofweek function
CREATE OR REPLACE function unisql.dayofweek(timestamptz) returns int4
as $$
begin return extract(DOW from $1)+ 1;
end;
$$ language plpgsql;

-- 创建dayofweek函数
CREATE OR REPLACE function unisql.dayofweek(text) returns int4
as $$
begin return extract(DOW FROM $1::date)+1;
end;
$$ language plpgsql ;

--new create weekofyear function
CREATE OR REPLACE function unisql.weekofyear(timestamptz) returns int4
as $$
begin return extract(week FROM $1);
end;
$$ language plpgsql;

-- 创建weekofyear函数
CREATE OR REPLACE function unisql.weekofyear(text) returns int4
as $$
begin return extract(week FROM $1::date);
end;
$$ language plpgsql;

--new create function year()
create or replace function unisql.year(text) returns int4
as $$
begin
    return extract(year from $1::date);
end;
$$ language plpgsql STRICT IMMUTABLE;

-- 创建year函数
create or replace function unisql.year(timestamptz) returns int4
as $$
begin
    return extract(year from $1);
end;
$$ language plpgsql STRICT IMMUTABLE;

--new create function dayofmonth()
create or replace function unisql.dayofmonth(text) returns int2
as $$
begin
    return extract(day from $1::date);
end;
$$ language plpgsql STRICT IMMUTABLE;

-- 创建 dayofmonth函数
create or replace function unisql.dayofmonth(timestamptz) returns int4
as $$
begin
    return extract(day from $1);
end;
$$ language plpgsql STRICT IMMUTABLE;

-- create synonym day for dayofmonth()
create or replace synonym unisql.day for unisql.dayofmonth;

-- create function from_unixtime(text)
CREATE OR REPLACE FUNCTION unisql.from_unixtime(text) RETURNS TIMESTAMP AS $$
BEGIN
    RETURN CASE WHEN cast($1 as bigint ) < 0 THEN NULL ELSE to_timestamp(cast($1 as bigint )) END;
END; $$ LANGUAGE plpgsql STRICT IMMUTABLE;

-- create function from_unixtime(int8)
CREATE OR REPLACE FUNCTION unisql.from_unixtime(int8) RETURNS TIMESTAMP AS $$
BEGIN
    RETURN CASE WHEN $1 < 0 THEN NULL ELSE to_timestamp($1) END;
END; $$ language plpgsql STRICT IMMUTABLE;

-- create function from_unixtime(int8,text)
CREATE OR REPLACE FUNCTION unisql.from_unixtime(int8,text) RETURNS TEXT AS $$
BEGIN
    RETURN CASE WHEN $1 < 0 THEN NULL ELSE to_char(to_timestamp($1),$2) END;
END; $$ language plpgsql STRICT IMMUTABLE;

-- 创建from_unixtime
CREATE OR REPLACE FUNCTION unisql.from_unixtime(text,text) RETURNS TEXT AS $$
BEGIN
    RETURN CASE WHEN cast($1 as bigint ) < 0 THEN NULL ELSE to_char(to_timestamp(cast($1 as bigint)),$2) END;
END; $$ language plpgsql STRICT IMMUTABLE;

-- 创建date_format函数
CREATE OR REPLACE FUNCTION unisql.date_format(timestamp, text) RETURNS TEXT AS $$
BEGIN
    RETURN to_char($1,$2);
END; $$ language plpgsql STRICT IMMUTABLE;

-- 创建date_format函数
CREATE OR REPLACE FUNCTION unisql.date_format(text, text) RETURNS TEXT AS $$
BEGIN
    RETURN to_char($1 :: timestamp, $2);
END; $$ language plpgsql STRICT IMMUTABLE;

-- 创建compress函数
CREATE OR REPLACE FUNCTION unisql.compress(text) RETURNS bytea AS $$
BEGIN
    RETURN cast($1 as bytea);
END; $$ language plpgsql STRICT IMMUTABLE;

-- 创建compress函数
CREATE OR REPLACE FUNCTION unisql.compress(bytea) RETURNS bytea AS $$
BEGIN
    RETURN $1;
END; $$ language plpgsql STRICT IMMUTABLE;

-- 创建uncompress函数
CREATE OR REPLACE FUNCTION unisql.uncompress(bytea) RETURNS bytea AS $$
BEGIN
    RETURN $1;
END; $$ language plpgsql STRICT IMMUTABLE;

-- 创建uncompress函数
CREATE OR REPLACE FUNCTION unisql.uncompress(text) RETURNS bytea AS $$
BEGIN
    RETURN null;
END; $$ language plpgsql STRICT IMMUTABLE;


-- 创建any_value_transfn用于any_value聚合函数
create or replace function unisql.any_value_transfn(anyelement,anyelement) returns anyelement as $$ begin
    return case when $1 is null then $2 else $1 end;
end;$$ language PLPGSQL STRICT IMMUTABLE;

-- 创建any_value_transfn用于any_value聚合函数
create or replace function unisql.any_value_finalfn(anyelement) returns anyelement as $$ begin
    return $1;
end;$$ language PLPGSQL STRICT IMMUTABLE;

-- 创建any_value聚合函数
DO
$$
    BEGIN
        IF NOT EXISTS (
                SELECT 1
                FROM pg_proc
                         JOIN pg_namespace ON pg_proc.pronamespace = pg_namespace.oid
                WHERE nspname = 'unisql' AND proname = 'any_value'
            ) THEN
            EXECUTE 'CREATE AGGREGATE unisql.any_value(anyelement)(
        SFUNC = unisql.any_value_transfn,
        STYPE = anyelement,
        FINALFUNC = unisql.any_value_finalfn
    );';
        END IF;
    END
$$;

-- 创建自定义uuid函数（原因是gaussdb v500R002c10版本没有uuid函数）
CREATE
OR REPLACE FUNCTION unisql.uuid()
    RETURNS VARCHAR AS $$
DECLARE
result VARCHAR := md5(random()::TEXT || clock_timestamp()::TEXT)::UUID;
BEGIN
    result
:= overlay(result placing '-' from 9 for 1);
    result
:= overlay(result placing '-' from 14 for 1);
    result
:= overlay(result placing '-' from 19 for 1);
    result
:= overlay(result placing '-' from 24 for 1);
RETURN result;
END;
$$
LANGUAGE plpgsql;

-- 创建isnull函数
CREATE OR REPLACE FUNCTION unisql.isnull(input_text TEXT)
RETURNS TEXT
AS $$
BEGIN
RETURN CASE WHEN input_text IS NULL THEN '1' ELSE '0' END;
END;
$$ LANGUAGE plpgsql IMMUTABLE;

-- 创建dual视图
DO $$
DECLARE
    create_mark INT;
BEGIN
    SELECT COUNT(1) INTO create_mark
    FROM information_schema.views
    WHERE table_schema = ANY(current_schemas(true))
      AND table_name = 'dual';
    
    IF create_mark = 0 THEN
        CREATE OR REPLACE VIEW public.dual AS
        SELECT 'X' AS dummy;
        RAISE NOTICE 'Created view public.dual.';
    ELSE
        RAISE NOTICE 'The dual view was not created because it already exists in one of the schemas in search_path.';
    END IF;
END
$$ LANGUAGE plpgsql;

-- 创建if函数
CREATE OR REPLACE FUNCTION unisql.if(input_value numeric, true_expr numeric, false_expr numeric)
    RETURNS numeric
AS $$
begin
    IF input_value = 0 THEN
        RETURN false_expr;
    ELSE
        RETURN true_expr;
    END IF;
END;
$$ language PLPGSQL STRICT IMMUTABLE;

-- 创建if函数
CREATE OR REPLACE FUNCTION unisql.if(input_value numeric, true_expr text, false_expr numeric)
    RETURNS text
AS $$
begin
    IF input_value = 0 THEN
        RETURN false_expr;
    ELSE
        RETURN true_expr;
    END IF;
END;
$$ language PLPGSQL STRICT IMMUTABLE;

-- 创建if函数
CREATE OR REPLACE FUNCTION unisql.if(input_value numeric, true_expr numeric, false_expr text)
    RETURNS text
AS $$
begin
    IF input_value = 0 THEN
        RETURN false_expr;
    ELSE
        RETURN true_expr;
    END IF;
END;
$$ language PLPGSQL STRICT IMMUTABLE;

-- 创建if函数
CREATE OR REPLACE FUNCTION unisql.if(input_value numeric, true_expr text, false_expr text)
    RETURNS text
AS $$
begin
    IF input_value = 0 THEN
        RETURN false_expr;
    ELSE
        RETURN true_expr;
    END IF;
END;
$$ language PLPGSQL STRICT IMMUTABLE;


--create new function date_add() begin ----------
create or replace function unisql.date_add (timestamptz,int,text) returns date
as $$
DECLARE
    tn integer;
begin
    return  unisql.date_add($1, $2 ||' '||$3);
end;
$$ language plpgsql;

-- 创建date_add函数
create or replace function unisql.date_add (text,int,text) returns date
as $$
DECLARE
    tn integer;
begin
    return  unisql.date_add($1, $2 ||' '||$3);
end;
$$ language plpgsql;

--create new function date_add override
create or replace function unisql.date_add (timestamptz,text) returns date
as $$
begin
    return $1::date + $2::interval;
end;
$$ language plpgsql;

-- 创建date_add函数
create or replace function unisql.date_add(text,text) returns date
as $$
begin
    return $1::date + $2::interval;
end;
$$ language plpgsql;

-- 创建 date_sub函数
create or replace function unisql.date_sub(timestamptz,int,text) returns date
as $$
DECLARE
    tn integer;
begin
    return  unisql.date_sub($1, $2 ||' '||$3);
end;
$$ language plpgsql;

-- 创建 date_sub函数
create or replace function unisql.date_sub (text,int,text) returns date
as $$
DECLARE
    tn integer;
begin
    return  unisql.date_sub($1, $2 ||' '||$3);
end;
$$ language plpgsql;

-- 创建 date_sub函数
create or replace function unisql.date_sub (timestamptz,text) returns date
as $$
begin
    return $1::date - $2::interval;
end;
$$ language plpgsql;

-- 创建 date_sub函数
create or replace function unisql.date_sub(text,text) returns date
as $$
begin
    return $1::date - $2::interval;
end;
$$ language plpgsql;

