-- 创建 unisql 用户并赋权
DECLARE
    v_count NUMBER;
BEGIN
    SELECT COUNT(*) INTO v_count FROM DBA_USERS WHERE USERNAME = upper('UNISQL');
    IF v_count = 0 THEN
        EXECUTE IMMEDIATE 'CREATE USER UNISQL IDENTIFIED BY "unisql_pwd123"';
        EXECUTE IMMEDIATE 'GRANT SELECT, INSERT, UPDATE, DELETE ON unisql.* TO PUBLIC';
    END IF;
END;

-- mariadb(10.11.8)2Ob_Oracle(4.2.1) 内置函数转换：该函数用于转 IF(cond, expr1, expr2) ，输入 cond 输出 0 或 1
CREATE OR REPLACE FUNCTION unisql.is_nonzero(input_val IN VARCHAR2) RETURN NUMBER 
IS
  num_val NUMBER;
  trimmed_val VARCHAR2(4000);
BEGIN
  IF input_val IS NULL THEN
    RETURN 0;
  END IF;
  trimmed_val := REGEXP_SUBSTR(TRIM(input_val), '^[-+]?\d*\.?\d+');
  IF trimmed_val IS NULL THEN
    RETURN 0;
  END IF;
  BEGIN
    num_val := TO_NUMBER(trimmed_val);
  EXCEPTION
    WHEN OTHERS THEN
      RETURN 0;
  END;
  IF num_val = 0 OR num_val IS NULL THEN
    RETURN 0;
  ELSE
    RETURN 1;
  END IF;
END is_nonzero;


-- 在赋权前就需要创建unisql_version版本号信息维护表，以便能够被赋权
DECLARE
v_count NUMBER;
BEGIN
SELECT COUNT(*) INTO v_count from ALL_TABLES WHERE OWNER = upper('UNISQL') AND TABLE_NAME = 'UNISQL_VERSION';

IF v_count = 0 THEN
        EXECUTE IMMEDIATE 'create table UNISQL.UNISQL_VERSION (id int primary key,version varchar(20),update_time date)';
END IF;
END;

-- 创建所有用户对unisql下表访问执行权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('TABLE')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT SELECT, INSERT, UPDATE, DELETE ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- 创建所有用户对unisql下视图访问权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('VIEW')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT SELECT ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- 创建所有用户对unisql下PROCEDURE、FUNCTION、PACKAGE访问执行权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('PROCEDURE', 'FUNCTION', 'PACKAGE')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT EXECUTE ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- 创建 unisql 用户并赋权
DECLARE
    v_count NUMBER;
BEGIN
    SELECT COUNT(*) INTO v_count FROM DBA_USERS WHERE USERNAME = 'UNISQL';
    IF v_count = 0 THEN
        EXECUTE IMMEDIATE 'CREATE USER UNISQL IDENTIFIED BY "unisql_pwd123"';
        EXECUTE IMMEDIATE 'GRANT SELECT, INSERT, UPDATE, DELETE ON unisql.* TO PUBLIC';
    END IF;
END;


-- 通过表名获取该表上一次的自增 id, 类比 mysql, 该表必须有一个字段有 AUTO_INCREMENT 属性, 允许传空字符串
CREATE OR REPLACE FUNCTION unisql.last_insert_id(
    table_name IN VARCHAR2
) RETURN NUMBER IS
    seq_name VARCHAR2(100);
    like_pattern VARCHAR2(100);
    curr_value NUMBER;
BEGIN
    SELECT 'ISEQ$$_' || object_id || '_%' INTO like_pattern
    FROM user_objects
    WHERE object_name = table_name
      AND object_type = 'TABLE';

    SELECT sequence_name INTO seq_name
    FROM user_sequences
    WHERE sequence_name LIKE like_pattern;

    EXECUTE IMMEDIATE 'SELECT ' || seq_name || '.currval FROM dual'
    INTO curr_value;

    RETURN curr_value;
EXCEPTION
	WHEN OTHERS THEN
		RETURN 0;
END;


-- 创建str_to_timestamp函数，用于模拟MYSQL中 字符串，数值到日期类型的隐式转换
CREATE OR REPLACE FUNCTION unisql.str_to_timestamp(p_input_str VARCHAR2) RETURN TIMESTAMP AS
    v_clean_str    VARCHAR2(30);
    v_year         NUMBER;
    v_length       NUMBER;
   	v_may_month    VARCHAR2(10);
   	v_default_flag BOOL;
BEGIN  
	v_may_month := upper(substr(p_input_str, 4, 3));
	CASE v_may_month
        WHEN 'JAN' THEN v_default_flag := TRUE;
        WHEN 'FEB' THEN v_default_flag := TRUE;
        WHEN 'MAR' THEN v_default_flag := TRUE;
        WHEN 'APR' THEN v_default_flag := TRUE;
        WHEN 'MAY' THEN v_default_flag := TRUE;
        WHEN 'JUN' THEN v_default_flag := TRUE;
        WHEN 'JUL' THEN v_default_flag := TRUE;
        WHEN 'AUG' THEN v_default_flag := TRUE;
        WHEN 'SEP' THEN v_default_flag := TRUE;
        WHEN 'OCT' THEN v_default_flag := TRUE;
        WHEN 'NOV' THEN v_default_flag := TRUE;
        WHEN 'DEC' THEN v_default_flag := TRUE;
        ELSE v_default_flag := FALSE;
    END CASE;
   	
   	IF v_default_flag THEN
   		v_length := LENGTH(p_input_str);
		IF v_length < 9  THEN
			RAISE_APPLICATION_ERROR(-20000, 'Input too short to be a valid date');
		END IF;
	
		IF v_length = 9 THEN
			RETURN TO_TIMESTAMP(p_input_str, 'DD-MON-RR');
		END IF;
	
	    IF INSTR(p_input_str, ' +') > 0 THEN
	    	RETURN TO_TIMESTAMP_TZ(p_input_str, 'DD-MON-RR HH.MI.SSXFF AM TZR');
	    ELSIF INSTR(p_input_str, ' -') > 0 THEN
	      	RETURN TO_TIMESTAMP_TZ(p_input_str, 'DD-MON-RR HH.MI.SSXFF AM TZR'); 
	    ELSE 
	    	RETURN TO_TIMESTAMP(p_input_str, 'DD-MON-RR HH.MI.SSXFF AM');
	    END IF;
   	END IF;
   
    IF INSTR(p_input_str, '. +') > 0 THEN   
    	RETURN TO_TIMESTAMP_TZ(p_input_str, 'YYYY-MM-DD HH24:MI:SS. TZR TZD');
    ELSIF INSTR(p_input_str, '. -') > 0 THEN 
      	RETURN TO_TIMESTAMP_TZ(p_input_str, 'YYYY-MM-DD HH24:MI:SS. TZR TZD');  
    ELSIF INSTR(p_input_str, ' +') > 0 THEN
    	RETURN TO_TIMESTAMP_TZ(p_input_str, 'YYYY-MM-DD HH24:MI:SS.FF TZR TZD');
    ELSIF INSTR(p_input_str, ' -') > 0 THEN
      	RETURN TO_TIMESTAMP_TZ(p_input_str, 'YYYY-MM-DD HH24:MI:SS.FF TZR TZD'); 
    END IF;

    v_clean_str := REGEXP_REPLACE(p_input_str, '[^0-9]', '');
    v_length := LENGTH(v_clean_str);

    IF v_length < 6 THEN
        RAISE_APPLICATION_ERROR(-20000, 'Input too short to be a valid date');
    END IF;
       
    IF v_length = 6 THEN
        v_year := TO_NUMBER(SUBSTR(v_clean_str, 1, 2));
        IF v_year BETWEEN 0 AND 69 THEN
            RETURN TO_TIMESTAMP('20' || v_clean_str, 'YYYYMMDD');
        ELSE
            RETURN TO_TIMESTAMP('19' || v_clean_str, 'YYYYMMDD');
        END IF;
    ELSIF v_length = 8 THEN
        RETURN TO_TIMESTAMP(v_clean_str, 'YYYYMMDD');
    ELSIF v_length = 12 THEN
        v_year := TO_NUMBER(SUBSTR(v_clean_str, 1, 2));
        IF v_year BETWEEN 0 AND 69 THEN
            RETURN TO_TIMESTAMP('20' || v_clean_str, 'YYYYMMDDHH24MISS');
        ELSE
            RETURN TO_TIMESTAMP('19' || v_clean_str, 'YYYYMMDDHH24MISS');
        END IF;
    ELSIF v_length = 14 THEN
        RETURN TO_TIMESTAMP(v_clean_str, 'YYYYMMDDHH24MISS');
    ELSE 
    	RETURN TO_TIMESTAMP(v_clean_str, 'YYYYMMDDHH24MISSFF');
    END IF;
END;

-- 支持mariadb的weekofyear函数转换到ob_oracle执行
CREATE OR REPLACE FUNCTION unisql.weekofyear(
    date_str IN VARCHAR2
) RETURN NUMBER
IS
BEGIN
    IF date_str IS NULL THEN
        RETURN NULL;
END IF;
RETURN TO_CHAR(unisql.str_to_timestamp(date_str),'IW');
END;

-- oceanbase_oracle 中没有 date_add函数，使用自定义函数实现
CREATE OR REPLACE FUNCTION unisql.date_add(
    date_str      IN VARCHAR2,
    interval_val  IN NUMBER,
    interval_unit IN VARCHAR2
) RETURN TIMESTAMP IS
	v_timestamp_tz TIMESTAMP WITH TIME ZONE;
    v_ts TIMESTAMP;
    v_new_date TIMESTAMP;
    v_original_day NUMBER;
    v_last_day TIMESTAMP;
   	v_time_part INTERVAL DAY(9) TO SECOND;
    interval_val_month NUMBER;
BEGIN
    IF date_str IS NULL THEN
        RETURN NULL;
    END IF;

    BEGIN
        v_ts := unisql.str_to_timestamp(date_str);
    EXCEPTION WHEN OTHERS THEN
        RETURN NULL;
    END;

    CASE UPPER(interval_unit)
        WHEN 'SECOND' THEN
                RETURN v_ts + NUMTODSINTERVAL(interval_val, 'SECOND');
        WHEN 'MINUTE' THEN
                RETURN v_ts + NUMTODSINTERVAL(interval_val, 'MINUTE');
        WHEN 'HOUR' THEN
                RETURN v_ts + NUMTODSINTERVAL(interval_val, 'HOUR');
        WHEN 'DAY' THEN
                RETURN v_ts + NUMTODSINTERVAL(interval_val, 'DAY');
        WHEN 'MONTH' THEN
                interval_val_month := interval_val;
                v_new_date := ADD_MONTHS(v_ts, interval_val_month);
                v_original_day := EXTRACT(DAY FROM v_ts);
                v_last_day := LAST_DAY(v_new_date);
                v_time_part := v_ts - TRUNC(v_ts);

                IF v_original_day <= EXTRACT(DAY FROM v_last_day) THEN

                    v_new_date :=
                        TO_TIMESTAMP(
                            TO_CHAR(EXTRACT(YEAR FROM v_new_date), 'FM9999') || '-' ||
                            TO_CHAR(EXTRACT(MONTH FROM v_new_date), 'FM09') || '-' ||
                            TO_CHAR(v_original_day, 'FM09'),
                            'YYYY-MM-DD'
                        ) + v_time_part;
                ELSE
                    v_new_date := TO_TIMESTAMP(TO_CHAR(v_new_date, 'YYYY-MM-DD'), 'YYYY-MM-DD') + v_time_part;
                END IF;
                RETURN v_new_date;

        WHEN 'YEAR' THEN
                interval_val_month := 12 * interval_val;
                v_new_date := ADD_MONTHS(v_ts, interval_val_month);
                v_original_day := EXTRACT(DAY FROM v_ts);
                v_last_day := LAST_DAY(v_new_date);
                v_time_part := v_ts - TRUNC(v_ts);

                IF v_original_day <= EXTRACT(DAY FROM v_last_day) THEN

                    v_new_date :=
                        TO_TIMESTAMP(
                            TO_CHAR(EXTRACT(YEAR FROM v_new_date), 'FM9999') || '-' ||
                            TO_CHAR(EXTRACT(MONTH FROM v_new_date), 'FM09') || '-' ||
                            TO_CHAR(v_original_day, 'FM09'),
                            'YYYY-MM-DD'
                        ) + v_time_part;
                ELSE
                    v_new_date :=
                        TO_TIMESTAMP(TO_CHAR(v_new_date, 'YYYY-MM-DD'), 'YYYY-MM-DD') + v_time_part;
                END IF;
                RETURN v_new_date;
        ELSE
            RAISE_APPLICATION_ERROR(-20002, 'Unsupported interval unit: ' || interval_unit);
    END CASE;
END;

-- oceanbase_oracle 中没有 date_sub函数，使用自定义函数实现
CREATE OR REPLACE FUNCTION unisql.date_sub(
    date_str      IN VARCHAR2,
    interval_val  IN NUMBER,
    interval_unit IN VARCHAR2
) RETURN TIMESTAMP IS
    v_new_date TIMESTAMP;
BEGIN
	v_new_date := unisql.date_add(date_str,-interval_val,interval_unit);
    RETURN v_new_date;
END;

-- oceanbase_oracle 中没有UUID函数, 使用自定义函数实现
CREATE OR REPLACE FUNCTION unisql.uuid RETURN VARCHAR2
IS
    v_guid RAW(16);
    v_result VARCHAR2(36);
BEGIN
    v_guid := SYS_GUID();
    
    v_result := 
        LOWER(SUBSTR(RAWTOHEX(v_guid), 1, 8)) || '-' ||
        LOWER(SUBSTR(RAWTOHEX(v_guid), 9, 4)) || '-' ||
        LOWER(SUBSTR(RAWTOHEX(v_guid), 13, 4)) || '-' ||
        LOWER(SUBSTR(RAWTOHEX(v_guid), 17, 4)) || '-' ||
        LOWER(SUBSTR(RAWTOHEX(v_guid), 21, 12));
    
    RETURN v_result;
END;

-- 在赋权前就需要创建unisql_version版本号信息维护表，以便能够被赋权
DECLARE
v_count NUMBER;
BEGIN
SELECT COUNT(*) INTO v_count from ALL_TABLES WHERE OWNER = upper('UNISQL') AND TABLE_NAME = 'UNISQL_VERSION';

IF v_count = 0 THEN
        EXECUTE IMMEDIATE 'create table UNISQL.UNISQL_VERSION (id int primary key,version varchar(20),update_time date)';
END IF;
END;

-- 创建所有用户对unisql下表访问执行权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('TABLE')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT SELECT, INSERT, UPDATE, DELETE ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- 创建所有用户对unisql下视图访问权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('VIEW')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT SELECT ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- 创建所有用户对unisql下PROCEDURE、FUNCTION、PACKAGE访问执行权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('PROCEDURE', 'FUNCTION', 'PACKAGE')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT EXECUTE ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;


-- 创建 unisql 用户并赋权
DECLARE
v_count NUMBER;
BEGIN
SELECT COUNT(*) INTO v_count FROM DBA_USERS WHERE USERNAME = 'UNISQL';
IF v_count = 0 THEN
        EXECUTE IMMEDIATE 'CREATE USER UNISQL IDENTIFIED BY "unisql_pwd123"';
END IF;
EXECUTE IMMEDIATE 'GRANT SELECT ANY DICTIONARY TO UNISQL';
EXECUTE IMMEDIATE 'GRANT ALTER ANY TABLE TO UNISQL';
EXECUTE IMMEDIATE 'GRANT CREATE ANY TRIGGER TO UNISQL';
EXECUTE IMMEDIATE 'GRANT CREATE ANY SEQUENCE TO UNISQL';
EXECUTE IMMEDIATE 'GRANT SELECT ANY SEQUENCE TO UNISQL';
EXECUTE IMMEDIATE 'GRANT ALTER ANY SEQUENCE TO UNISQL';
EXECUTE IMMEDIATE 'GRANT SELECT ON SYS.DBA_TAB_PARTITIONS TO unisql WITH GRANT OPTION';
EXECUTE IMMEDIATE 'GRANT SELECT ON SYS.DBA_PART_TABLES TO unisql WITH GRANT OPTION';
EXECUTE IMMEDIATE 'GRANT SELECT ON SYS.DBA_TABLES TO unisql WITH GRANT OPTION';
COMMIT;
END;

-- 模拟创建 mysql 的 auto_increment 列
CREATE OR REPLACE PROCEDURE unisql.create_identity_column(
    p_schema_name IN VARCHAR2,
    p_table_name IN VARCHAR2,
    p_column_name IN VARCHAR2,
    p_start_value IN NUMBER
)
IS
    v_object_id NUMBER;
    v_sequence_name VARCHAR2(100);
    v_current_val NUMBER;
BEGIN
    SELECT object_id INTO v_object_id
    FROM dba_objects
    WHERE object_name = p_table_name
    AND owner = p_schema_name
    AND object_type = 'TABLE';
    
    v_sequence_name := p_schema_name || '.UNISQL_AUTO_INCREMENT_SEQ_' || v_object_id;

    EXECUTE IMMEDIATE 'CREATE SEQUENCE ' || v_sequence_name || ' START WITH ' || p_start_value ;
    
    EXECUTE IMMEDIATE 'CREATE OR REPLACE TRIGGER ' || p_schema_name || '.UNISQL_AUTO_INCREMENT_TRIGGER_' || v_object_id ||
    ' BEFORE INSERT ON ' || p_schema_name || '.' || p_table_name || ' FOR EACH ROW ' ||
    ' DECLARE ' ||
      ' v_val NUMBER; '||
    ' BEGIN ' ||
      ' IF :NEW.' || p_column_name || ' IS NULL OR :NEW.' || p_column_name || ' = 0 THEN ' ||
        ' :NEW.' || p_column_name || ' := ' || v_sequence_name || '.NEXTVAL;' ||
        ' RETURN; ' ||
      ' END IF;' ||
      ' BEGIN ' ||
        ' SELECT ' || v_sequence_name || '.CURRVAL INTO v_val FROM dual;' ||
      ' EXCEPTION WHEN OTHERS THEN ' ||
         ' SELECT ' || v_sequence_name || '.NEXTVAL INTO v_val FROM dual;' ||
      ' END; ' ||
      ' IF :NEW.' || p_column_name || ' > v_val THEN ' ||
        ' LOOP ' ||
          ' SELECT ' || v_sequence_name || '.nextval INTO v_val FROM dual; ' ||
          ' EXIT WHEN v_val >= :NEW.' || p_column_name || ';' ||
        ' END LOOP; ' ||
      ' END IF;' ||
    ' END;';
EXCEPTION
    WHEN NO_DATA_FOUND THEN
        RAISE_APPLICATION_ERROR(-20001, 'Table ' || p_schema_name || '.' || p_table_name || ' or column ' || p_column_name || ' not found.');
    WHEN OTHERS THEN
        RAISE_APPLICATION_ERROR(-20002, 'Error: ' || SQLERRM);
END;

-- 模拟 mysql 修改 auto_increment 列
CREATE OR REPLACE PROCEDURE unisql.change_identity_column_nextval(
    p_schema_name IN VARCHAR2,
    p_table_name IN VARCHAR2,
    p_start_value IN NUMBER
)
IS
    v_object_id NUMBER;
    v_sequence_name VARCHAR2(100);
    v_current_val NUMBER;
    v_increment NUMBER;
    v_dummy NUMBER;
BEGIN
    SELECT object_id INTO v_object_id
    FROM dba_objects
    WHERE object_name = p_table_name
    AND owner = p_schema_name
    AND object_type = 'TABLE';

    v_sequence_name := p_schema_name || '.UNISQL_AUTO_INCREMENT_SEQ_' || v_object_id;

    EXECUTE IMMEDIATE 'SELECT ' || v_sequence_name || '.NEXTVAL FROM dual' INTO v_current_val;

    v_increment := p_start_value - v_current_val - 1;

    IF v_increment > 0 THEN
        EXECUTE IMMEDIATE 'ALTER SEQUENCE ' || v_sequence_name || ' INCREMENT BY ' || v_increment;
        EXECUTE IMMEDIATE 'SELECT ' || v_sequence_name || '.NEXTVAL FROM dual' INTO v_dummy;
        EXECUTE IMMEDIATE 'ALTER SEQUENCE ' || v_sequence_name || ' INCREMENT BY 1';
    END IF;
EXCEPTION
    WHEN NO_DATA_FOUND THEN
        RAISE_APPLICATION_ERROR(-20003, 'Identity column for table ' || p_schema_name || '.' || p_table_name || ' not found or table does not exist.');
    WHEN OTHERS THEN
        RAISE_APPLICATION_ERROR(-20004, 'Error changing nextval for identity column on table ' || p_schema_name || '.' || p_table_name || ': ' || SQLERRM);
END;

-- 通过表名获取该表上一次的自增 id, 类比 mysql, 该表必须有一个字段有 AUTO_INCREMENT 属性, 允许传空字符串
CREATE OR REPLACE FUNCTION unisql.last_insert_id(
    table_name IN VARCHAR2
) RETURN NUMBER AUTHID CURRENT_USER IS
    seq_name VARCHAR2(100);
    like_pattern VARCHAR2(100);
    curr_value NUMBER;
BEGIN
    BEGIN
      SELECT 'UNISQL_AUTO_INCREMENT_SEQ_' || object_id INTO seq_name
      FROM user_objects
      WHERE object_name = table_name
      AND object_type = 'TABLE';
    EXCEPTION
      WHEN OTHERS THEN
        SELECT 'ISEQ$$_' || object_id || '_%' INTO like_pattern
        FROM user_objects
        WHERE object_name = table_name
        AND object_type = 'TABLE';

        SELECT sequence_name INTO seq_name
        FROM user_sequences
        WHERE sequence_name LIKE like_pattern;
    END;

    EXECUTE IMMEDIATE 'SELECT ' || seq_name || '.currval FROM dual'
    INTO curr_value;

    RETURN curr_value;
EXCEPTION
	WHEN OTHERS THEN
		RETURN 0;
END;

-- 创建用于支持mysql的information_schema.partitions视图
CREATE OR REPLACE VIEW UNISQL.PARTITIONS AS
SELECT
    t.OWNER AS TABLE_SCHEMA,
    t.TABLE_NAME,
    p.PARTITION_NAME,
    p.HIGH_VALUE AS PARTITION_DESCRIPTION
FROM
    DBA_TAB_PARTITIONS p
        JOIN
    DBA_PART_TABLES t
    ON
        p.TABLE_OWNER = t.OWNER
            AND p.TABLE_NAME = t.TABLE_NAME
UNION
SELECT
    dt.owner AS TABLE_SCHEMA,
    dt.table_name AS TABLE_NAME,
    NULL AS PARTITION_NAME,
    NULL AS PARTITION_DESCRIPTION
FROM
    dba_tables dt
WHERE
    dt.partitioned = 'NO';


-- 创建用于支持mysql的information_schema.statistics视图。
CREATE OR REPLACE VIEW UNISQL.statistics AS
SELECT
    ind.table_owner AS TABLE_SCHEMA,
    ind.table_name AS TABLE_NAME
FROM
    all_ind_columns ind;


-- 创建用于支持mysql的information_schema.key_column_usage视图。约束保留主键和唯一约束
CREATE OR REPLACE VIEW UNISQL.key_column_usage AS
SELECT
    acc.owner AS CONSTRAINT_SCHEMA,
    CASE
        WHEN ac.constraint_type = 'P' THEN 'PRIMARY'
        ELSE acc.constraint_name
        END AS CONSTRAINT_NAME,
    acc.owner AS TABLE_SCHEMA,
    acc.table_name AS TABLE_NAME,
    acc.column_name AS COLUMN_NAME,
    acc.position AS ORDINAL_POSITION
FROM
    all_cons_columns acc
    JOIN all_constraints ac
    ON
    acc.owner = ac.owner
     AND acc.constraint_name = ac.constraint_name
     AND ac.constraint_type IN ('P','U');


-- oceanbase_oracle 中没有FIND_IN_SET函数, 使用自定义函数实现
CREATE OR REPLACE FUNCTION UNISQL.FIND_IN_SET(p_str IN VARCHAR2, p_list IN VARCHAR2)
RETURN NUMBER IS
    l_position NUMBER := 0;
    l_start_pos NUMBER := 1;
    l_comma_pos NUMBER;
    l_element VARCHAR2(32767);
BEGIN
    IF p_str is NULL OR p_list is NULL THEN
        RETURN 0;
    END IF;

    IF INSTR(p_str, ',') > 0 THEN
        RETURN 0;
    END IF;

    LOOP
        l_comma_pos := INSTR(p_list, ',', l_start_pos);
        IF l_comma_pos = 0 THEN
            l_element := SUBSTR(p_list, l_start_pos);
        ELSE
            l_element := SUBSTR(p_list, l_start_pos, l_comma_pos - l_start_pos);
        END IF;

        IF l_element = p_str THEN
            RETURN l_position + 1;
        END IF;

        l_position := l_position + 1;
        EXIT WHEN l_comma_pos = 0;
        l_start_pos := l_comma_pos + 1;
    END LOOP;

    RETURN 0;
END FIND_IN_SET;

-- 创建自定义函数unisql.substring_index实现mariadb中函数substring_index功能
CREATE OR REPLACE FUNCTION unisql.substring_index(
    f_string IN VARCHAR2,
    f_delimiter IN VARCHAR2,
    f_position IN NUMBER
) RETURN VARCHAR2
AS
    v_instr_pos NUMBER;
    v_abs_position NUMBER := ABS(f_position);
BEGIN
    IF f_position = 0 THEN
        RETURN '';
    END IF;

    IF f_position > 0 THEN
        v_instr_pos := INSTR(f_string, f_delimiter, 1, f_position);

        IF v_instr_pos = 0 THEN
            RETURN f_string;
        ELSE
            RETURN SUBSTR(f_string, 1, v_instr_pos - 1);
        END IF;
    ELSE
        v_instr_pos := INSTR(f_string, f_delimiter, -1, v_abs_position);

        IF v_instr_pos = 0 THEN
            RETURN f_string;
        ELSE
            RETURN SUBSTR(f_string, v_instr_pos + LENGTH(f_delimiter));
        END IF;
    END IF;
END substring_index;


-- 创建包的声明部分,重载str_to_timestamp，用于对日期类型的不进行转换，只对字符串类型进行转换，不能处理NULL常量
CREATE OR REPLACE PACKAGE unisql.convert AS

  FUNCTION str_to_timestamp(p_input_str VARCHAR2) RETURN TIMESTAMP DETERMINISTIC PARALLEL_ENABLE;
  FUNCTION str_to_timestamp(p_input_timestamp TIMESTAMP) RETURN TIMESTAMP DETERMINISTIC PARALLEL_ENABLE;
  FUNCTION str_to_timestamp(p_input_timestamptz TIMESTAMP WITH TIME ZONE) RETURN TIMESTAMP WITH TIME ZONE DETERMINISTIC PARALLEL_ENABLE;
  FUNCTION str_to_timestamp(p_input_date DATE) RETURN DATE DETERMINISTIC PARALLEL_ENABLE;
END convert;



-- 创建包体的实现部分
CREATE OR REPLACE PACKAGE BODY unisql.convert AS

  FUNCTION str_to_timestamp(p_input_str VARCHAR2) RETURN TIMESTAMP DETERMINISTIC PARALLEL_ENABLE AS
      v_clean_str    VARCHAR2(30);
      v_year         NUMBER;
      v_length       NUMBER;
      v_may_month    VARCHAR2(10);
      v_default_flag BOOL;
  BEGIN  
    v_may_month := upper(substr(p_input_str, 4, 3));
    CASE v_may_month
          WHEN 'JAN' THEN v_default_flag := TRUE;
          WHEN 'FEB' THEN v_default_flag := TRUE;
          WHEN 'MAR' THEN v_default_flag := TRUE;
          WHEN 'APR' THEN v_default_flag := TRUE;
          WHEN 'MAY' THEN v_default_flag := TRUE;
          WHEN 'JUN' THEN v_default_flag := TRUE;
          WHEN 'JUL' THEN v_default_flag := TRUE;
          WHEN 'AUG' THEN v_default_flag := TRUE;
          WHEN 'SEP' THEN v_default_flag := TRUE;
          WHEN 'OCT' THEN v_default_flag := TRUE;
          WHEN 'NOV' THEN v_default_flag := TRUE;
          WHEN 'DEC' THEN v_default_flag := TRUE;
          ELSE v_default_flag := FALSE;
      END CASE;
      
      IF v_default_flag THEN
        v_length := LENGTH(p_input_str);
      IF v_length < 9  THEN
        RAISE_APPLICATION_ERROR(-20000, 'Input too short to be a valid date');
      END IF;
    
      IF v_length = 9 THEN
        RETURN TO_TIMESTAMP(p_input_str, 'DD-MON-RR');
      END IF;
    
        IF INSTR(p_input_str, ' +') > 0 THEN
          RETURN TO_TIMESTAMP_TZ(p_input_str, 'DD-MON-RR HH.MI.SSXFF AM TZR');
        ELSIF INSTR(p_input_str, ' -') > 0 THEN
            RETURN TO_TIMESTAMP_TZ(p_input_str, 'DD-MON-RR HH.MI.SSXFF AM TZR'); 
        ELSE 
          RETURN TO_TIMESTAMP(p_input_str, 'DD-MON-RR HH.MI.SSXFF AM');
        END IF;
      END IF;
    
      IF INSTR(p_input_str, '. +') > 0 THEN   
        RETURN TO_TIMESTAMP_TZ(p_input_str, 'YYYY-MM-DD HH24:MI:SS. TZR TZD');
      ELSIF INSTR(p_input_str, '. -') > 0 THEN 
          RETURN TO_TIMESTAMP_TZ(p_input_str, 'YYYY-MM-DD HH24:MI:SS. TZR TZD');  
      ELSIF INSTR(p_input_str, ' +') > 0 THEN
        RETURN TO_TIMESTAMP_TZ(p_input_str, 'YYYY-MM-DD HH24:MI:SS.FF TZR TZD');
      ELSIF INSTR(p_input_str, ' -') > 0 THEN
          RETURN TO_TIMESTAMP_TZ(p_input_str, 'YYYY-MM-DD HH24:MI:SS.FF TZR TZD'); 
      END IF;

      v_clean_str := REGEXP_REPLACE(p_input_str, '[^0-9]', '');
      v_length := LENGTH(v_clean_str);

      IF v_length < 6 THEN
          RAISE_APPLICATION_ERROR(-20000, 'Input too short to be a valid date');
      END IF;
        
      IF v_length = 6 THEN
          v_year := TO_NUMBER(SUBSTR(v_clean_str, 1, 2));
          IF v_year BETWEEN 0 AND 69 THEN
              RETURN TO_TIMESTAMP('20' || v_clean_str, 'YYYYMMDD');
          ELSE
              RETURN TO_TIMESTAMP('19' || v_clean_str, 'YYYYMMDD');
          END IF;
      ELSIF v_length = 8 THEN
          RETURN TO_TIMESTAMP(v_clean_str, 'YYYYMMDD');
      ELSIF v_length = 12 THEN
          v_year := TO_NUMBER(SUBSTR(v_clean_str, 1, 2));
          IF v_year BETWEEN 0 AND 69 THEN
              RETURN TO_TIMESTAMP('20' || v_clean_str, 'YYYYMMDDHH24MISS');
          ELSE
              RETURN TO_TIMESTAMP('19' || v_clean_str, 'YYYYMMDDHH24MISS');
          END IF;
      ELSIF v_length = 14 THEN
          RETURN TO_TIMESTAMP(v_clean_str, 'YYYYMMDDHH24MISS');
      ELSE 
        RETURN TO_TIMESTAMP(v_clean_str, 'YYYYMMDDHH24MISSFF');
      END IF;
  END;


  FUNCTION str_to_timestamp(p_input_timestamp TIMESTAMP) RETURN TIMESTAMP DETERMINISTIC PARALLEL_ENABLE AS
  BEGIN
      return p_input_timestamp;
  END;

  FUNCTION str_to_timestamp(p_input_timestamptz TIMESTAMP WITH TIME ZONE) RETURN TIMESTAMP WITH TIME ZONE DETERMINISTIC PARALLEL_ENABLE AS
  BEGIN
      return p_input_timestamptz;
  END;

  FUNCTION str_to_timestamp(p_input_date DATE) RETURN DATE DETERMINISTIC PARALLEL_ENABLE AS
  BEGIN
      return p_input_date;
  END;

END convert;



-- 注意：下面3个创建权限语句必须放在所有自定义sql后面，请勿删除
-- 创建所有用户对unisql下表访问执行权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('TABLE')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT SELECT, INSERT, UPDATE, DELETE ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- 创建所有用户对unisql下表视图访问权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('VIEW')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT SELECT ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- 创建所有用户对unisql下PROCEDURE、FUNCTION、PACKAGE访问执行权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('PROCEDURE', 'FUNCTION', 'PACKAGE')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT EXECUTE ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- 创建辅助函数来检测时间字符串的格式
CREATE OR REPLACE FUNCTION unisql.detect_time_format(p_time_str VARCHAR2)
RETURN VARCHAR2
AS
    v_time_str VARCHAR2(100);
BEGIN
    v_time_str := UPPER(TRIM(p_time_str));
    
    IF REGEXP_LIKE(v_time_str, '^[0-9]{2}-[A-Z]{3}-[0-9]{2} [0-9]{2}\.[0-9]{2}\.[0-9]{2}\.[0-9]+ AM$') THEN
        RETURN 'DD-MON-YY HH.MI.SS.FF6 AM';
    ELSIF REGEXP_LIKE(v_time_str, '^[0-9]{2}-[A-Z]{3}-[0-9]{2} [0-9]{2}\.[0-9]{2}\.[0-9]{2}\.[0-9]+ PM$') THEN
        RETURN 'DD-MON-YY HH.MI.SS.FF6 PM';
    ELSIF REGEXP_LIKE(v_time_str, '^[0-9]{4}/[0-9]{2}/[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}$') THEN
        RETURN 'YYYY/MM/DD HH24:MI:SS';
    ELSIF REGEXP_LIKE(v_time_str, '^[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}$') THEN
        RETURN 'YYYY-MM-DD HH24:MI:SS';
    ELSIF REGEXP_LIKE(v_time_str, '^[0-9]{2}:[0-9]{2}:[0-9]{2}$') THEN
        RETURN 'HH24:MI:SS';
    ELSIF REGEXP_LIKE(v_time_str, '^[0-9]{2}:[0-9]{2}:[0-9]{2}\.[0-9]+$') THEN
        RETURN 'HH24:MI:SS.FF';
    ELSIF REGEXP_LIKE(v_time_str, '^[0-9]{4}/[0-9]{2}/[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}\.[0-9]+$') THEN
        RETURN 'YYYY/MM/DD HH24:MI:SS.FF';
    ELSIF REGEXP_LIKE(v_time_str, '^[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}\.[0-9]+$') THEN
        RETURN 'YYYY-MM-DD HH24:MI:SS.FF';
    ELSE
        RETURN NULL;
    END IF;
END;

-- 创建 time_format 函数：处理 text 类型输入
CREATE OR REPLACE FUNCTION unisql.time_format(p_time_str VARCHAR2, p_format VARCHAR2)
RETURN VARCHAR2
AS
    v_time TIMESTAMP;
    v_format_mask VARCHAR2(50);
    result VARCHAR2(50);
BEGIN
    IF p_time_str IS NULL OR p_format IS NULL THEN
        RETURN NULL;
    END IF;
    
    BEGIN
        v_time := unisql.str_to_timestamp(p_time_str);
        result := TO_CHAR(v_time, p_format);

    EXCEPTION
        WHEN OTHERS THEN
            v_format_mask := unisql.detect_time_format(p_time_str);
            
            IF v_format_mask IS NULL THEN
                BEGIN
                    v_time := TO_TIMESTAMP(p_time_str, 'YYYY/MM/DD HH24:MI:SS');
                EXCEPTION
                    WHEN OTHERS THEN
                        BEGIN
                            v_time := TO_TIMESTAMP(p_time_str, 'YYYY-MM-DD HH24:MI:SS');
                        EXCEPTION
                            WHEN OTHERS THEN
                                BEGIN
                                    v_time := TO_TIMESTAMP(p_time_str, 'HH24:MI:SS');
                                EXCEPTION
                                    WHEN OTHERS THEN
                                        RETURN NULL;
                                END;
                        END;
                END;
            ELSE
                v_time := TO_TIMESTAMP(p_time_str, v_format_mask);
            END IF;
            result := TO_CHAR(v_time, p_format);
    END;
    RETURN result;
END;


