/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.function.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class StringToAny
implements Function {
    final Object defaultValue;
    final Class targetClass;

    public StringToAny(Class targetClass, Object defaultValue) {
        this.targetClass = targetClass;
        this.defaultValue = defaultValue;
    }

    public Object apply(Object from) {
        String str = (String)from;
        if (str == null || "null".equals(str) || "".equals(str)) {
            return this.defaultValue;
        }
        if (this.targetClass == Byte.TYPE || this.targetClass == Byte.class) {
            return Byte.parseByte(str);
        }
        if (this.targetClass == Short.TYPE || this.targetClass == Short.class) {
            return Short.parseShort(str);
        }
        if (this.targetClass == Integer.TYPE || this.targetClass == Integer.class) {
            return Integer.parseInt(str);
        }
        if (this.targetClass == Long.TYPE || this.targetClass == Long.class) {
            return Long.parseLong(str);
        }
        if (this.targetClass == Float.TYPE || this.targetClass == Float.class) {
            return Float.valueOf(Float.parseFloat(str));
        }
        if (this.targetClass == Double.TYPE || this.targetClass == Double.class) {
            return Double.parseDouble(str);
        }
        if (this.targetClass == Character.TYPE || this.targetClass == Character.class) {
            return Character.valueOf(str.charAt(0));
        }
        if (this.targetClass == Boolean.TYPE || this.targetClass == Boolean.class) {
            return "true".equals(str);
        }
        if (this.targetClass == BigDecimal.class) {
            return new BigDecimal(str);
        }
        if (this.targetClass == BigInteger.class) {
            return new BigInteger(str);
        }
        if ((this.targetClass == Collections.class || this.targetClass == List.class || this.targetClass == JSONArray.class) && "[]".equals(str)) {
            return new JSONArray();
        }
        throw new JSONException("can not convert to " + this.targetClass + ", value : " + str);
    }
}

