/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;

public final class ObjectReaderImplListInt64
implements ObjectReader {
    final Class listType;
    final Class instanceType;
    final long instanceTypeHash;

    public ObjectReaderImplListInt64(Class listType, Class instanceType) {
        this.listType = listType;
        this.instanceType = instanceType;
        this.instanceTypeHash = Fnv.hashCode64(TypeUtils.getTypeName(instanceType));
    }

    public Object createInstance(long features) {
        if (this.instanceType == ArrayList.class) {
            return new ArrayList();
        }
        if (this.instanceType == LinkedList.class) {
            return new LinkedList();
        }
        try {
            return this.instanceType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new JSONException("create list error, type " + this.instanceType);
        }
    }

    public Object createInstance(Collection collection) {
        Collection list = (Collection)this.createInstance(0L);
        for (Object item : collection) {
            list.add(TypeUtils.toLong(item));
        }
        return list;
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        return null;
    }

    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Collection<Object> list;
        if (jsonReader.nextIfNull()) {
            return null;
        }
        Class listType = this.listType;
        ObjectReader objectReader = jsonReader.checkAutoType(listType, this.instanceTypeHash, features);
        if (objectReader != null) {
            listType = objectReader.getObjectClass();
        }
        if (listType == ArrayList.class) {
            list = new ArrayList();
        } else if (listType == JSONArray.class) {
            list = new JSONArray();
        } else if (listType != null && listType != this.listType) {
            try {
                list = (Collection)listType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new JSONException(jsonReader.info("create instance error " + listType), e);
            }
        } else {
            list = (Collection)this.createInstance(jsonReader.getContext().getFeatures() | features);
        }
        int entryCnt = jsonReader.startArray();
        for (int i = 0; i < entryCnt; ++i) {
            list.add(jsonReader.readInt64());
        }
        return list;
    }

    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, fieldType, fieldName, 0L);
        }
        if (jsonReader.readIfNull()) {
            return null;
        }
        if (jsonReader.isString()) {
            Collection list = (Collection)this.createInstance(jsonReader.getContext().getFeatures() | features);
            String str = jsonReader.readString();
            if (str.indexOf(44) != -1) {
                String[] items;
                for (String item : items = str.split(",")) {
                    list.add(Long.parseLong(item));
                }
            } else {
                list.add(Long.parseLong(str));
            }
            jsonReader.nextIfMatch(',');
            return list;
        }
        boolean set = jsonReader.nextIfSet();
        if (jsonReader.current() != '[') {
            throw new JSONException(jsonReader.info("format error"));
        }
        jsonReader.next();
        Collection list = set && this.instanceType == Collection.class ? new LinkedHashSet() : (Collection)this.createInstance(jsonReader.getContext().getFeatures() | features);
        while (!jsonReader.nextIfMatch(']')) {
            list.add(jsonReader.readInt64());
        }
        jsonReader.nextIfMatch(',');
        return list;
    }
}

