/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.model;

import com.hundsun.lightdb.unisql.golang.Transformer;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnisqlProperties {
    private static final Logger log;
    private static final UnisqlProperties INSTANCE;
    private static final String PROP_LIB_DIR = "unisql.lib.dir";
    private static final String PROP_LIB_FULL_PATH = "unisql.lib.full-path";
    private static final String PROP_UNISQL_GO_GOGC = "unisql.go.gogc";
    private static final String PROP_UNISQL_GO_GOMEMLIMIT = "unisql.go.gomemlimit";
    private static final long DEFAULT_GO_GOGC = 1000L;
    private static final long DEFAULT_GO_GOMEMLIMIT = 256L;
    private static final String PROP_UNISQL_DEBUG = "unisql.debug";
    private static final String SKIP_UNISQL_RUNTIME_CONVERT = "unisql.skipUnisqlRuntimeConvert";
    private static final String COLLECT_MICRO_SERVICE_PARAMETERS_ENABLED = "unisql.collectMicroServiceParametersEnabled";
    public static boolean skipUnisqlRuntimeConvertProperty;
    public static boolean collectMicroServiceParametersEnabled;
    private static final String PROP_UNISQL_ERROR_SKIP = "unisql.error.skip";
    private static final String PROP_UNISQL_TABLE_COLUMN_NAME_RANDOM = "unisql.table.column.name.random";
    private static final String PROP_UNISQL_BACK_QUOTES_TO_DOUBLE_QUOTES = "unisql.change.backquotes.to.doublequotes";
    private static final String PROP_UNISQL_SKIP = "unisql.skip";
    private static final String PROP_UNISQL_SKIP_EXCEPTION_KEYWORDS = "unisql.skipTransform.exception.keywords";
    private static final String PROP_UNISQL_CACHE = "unisql.cache";
    private static final String PROP_UNISQL_COMPARE_SERVER_URL = "unisql.compare.server.url";
    private static final String GLOBAL_REPLACE_SQL = "unisql.global.replace.sql";
    private static final String PROP_UNISQL_SCHEMA = "unisql.schema";
    private static final String PROP_UNISQL_REMOVEDOUBLEQUOTED = "unisql.remove.doubleQuoted";
    private static final String PROP_UNISQL_PRINTSYSINFO = "unisql.print.sysinfo";
    private static final String PROP_UNISQL_DECODEPARAMETERSFUNCNAMES = "unisql.decode.parameters.funcnames";
    private static final String PROP_UNISQL_MYSQLBACKSLASHESCAPES = "unisql.mysql.backslash.escapes";
    private static final String PROP_UNISQL_CHANGE_DATABASE_TO_SCHEMA = "unisql.change.database.to.schema";
    private static final String PROP_UNISQL_KEYWORD_DOUBLE_QUOTES = "unisql.keyword.doublequotes";
    private static final String PROP_UNISQL_ON_UPDATE_CURRENTIMESTAMP_COLUMN = "unisql.on.update.currentimestamp.columns";
    private static String UNISQL_CONF_DIR;
    private String PROP_AUTO_INCREMENT_COLUMN = "unisql.auto.increment.column";
    private String PROP_TABLE_COLUMN_METADATA_SCHEMAS = "unisql.table.column.metadata.schemas";
    private String PROP_TABLE_METADATA_SCHEDULE_SWITCH = "unisql.table.metadata.schedule.switch";
    private String PROP_TABLE_METADATA_SCHEDULE_FREQUENCY = "unisql.table.metadata.schedule.frequency";
    private static final String PROP_UNISQL_TABLE_COLUMN_REPLACE_DATATYPE = "unisql.table.column.replace.datatype";
    private static final String PROP_UNISQL_DATATYPE_NUMBER_REPLACE_INTEGER = "unisql.datatype.number.replace.integer";
    private static final String PROP_UNISQL_BIND_VARIABLE_MODE = "unisql.bind.variable.mode";
    private static final String PROP_UNISQL_GEN_LASTINSERTID_AFTER_INSERT = "unisql.gen.lastinsertid.after.insert";
    private static final String PROP_UNISQL_REMOVE_TABLESPACE = "unisql.remove.tablespace";
    private static final String PROP_UNISQL_TRANSFORM_UPDATE_MULTI_CLOB_BLOB_GTT = "unisql.transform.update.multi.clob.blob.gtt";
    public static boolean autoTestInitMetaData;
    public static int AUTOTEST;
    public static int MULTIPLEX;
    private static final boolean DEFAULT_UNISQL_DEBUG = false;
    private static final boolean DEFAULT_UNISQL_ERROR_SKIP = false;
    private static final int DEFAULT_UNISQL_TABLE_COLUMN_NAME_RANDOM = 1;
    private static final int DEFAULT_UNISQL_BACK_QUOTES_TO_DOUBLE_QUOTES = 0;
    private static final boolean DEFAULT_UNISQL_SKIP = false;
    private static final boolean DEFAULT_UNISQL_CACHE = true;
    private static final String DEFAULT_EMPTY = "";
    private static final String DEFAULT_UNISQL_KEYWORD_DOUBLE_QUOTES = "";
    private static final String DEFAULT_UNISQL_ON_UPDATE_CURRENTIMESTAMP_COLUMN = "";
    private static final String DEFAULT_UNISQL_SCHEMA = "unisql";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String OPEN = "1";
    private static final String CLOSE = "0";
    public static final int OPEN_INT = 1;
    public static final int CLOSE_INT = 0;
    private static final String PROP_UNISQL_EXCLUDE_RULES = "unisql.default.excludeRules";
    public static final String PROP_UNISQL_TARGET_DIALECT_FORCEUSEGAUSSDB500 = "unisql.target.dialect.forceusegaussdb500";
    private static boolean PROP_UNISQL_TARGET_DIALECT_FORCEUSEGAUSSDB500_VALUE;
    private static Properties PROPERTIES;
    private static final String WORK_DIR = "user.dir";
    public static final String UNISQL_CONF_PATH_PROPERTY = "unisql_conf_dir";
    public static final String DEFAULT_UNISQL_METADATA_DEFAULT_SCHEMA_NAME = "internel.metadata.default.schema.name";
    private static final String CONFIG = "config";
    private static final String UNISQL_CONF_NAME = "unisql.conf";
    private static final String UNISQL_CONF_RELOAD_NAME = "unisql.reload";
    private static final int DEFAULT_UNISQL_REMOVEDOUBLEQUOTED = 0;
    private static final int DEFAULT_PROP_TABLE_METADATA_SCHEDULE_SWITCH = 0;
    private static final int DEFAULT_UNISQL_PRINTSYSINFO = 0;
    private static final String DEFAULT_UNISQL_DECODEPARAMETERSFUNCNAMES = "";
    private static final int DEFAULT_CHANGE_DATABASE_TO_SCHEMA = 0;
    private static final String JRESCLOUD_PROPERTIES = "jrescloud.properties";
    public static String MULTI_CONFIGURATION_PATH;
    private static Path fileWatcherPath;
    private static WatchService watchService;
    private static final int CORE_POOL_SIZE = 1;
    private static final int MAX_POOL_SIZE = 1;
    private static final long KEEP_ALIVE_TIME = 0L;
    private static final TimeUnit TIME_UNIT;
    private static final BlockingQueue<Runnable> WORK_QUEUE;
    private static final ThreadFactory DAEMON_THREAD_FACTORY;
    private static final ExecutorService EXECUTOR;
    private static final String MULTI_SIMULATE_REMAP = "multi.simulate.remap";
    private static final String UNISQL_CONFIG_RELOAD_ENABLE = "unisql.config.reload.enable";
    private static Map<String, String> SIMULATE_DIALECT_MAPPING;

    public static UnisqlProperties getInstance() {
        return INSTANCE;
    }

    private UnisqlProperties() {
    }

    private static void checkAndSetFileWatcher() {
        HashSet<String> trueValues = new HashSet<String>();
        HashSet<String> falseValues = new HashSet<String>();
        trueValues.add(TRUE);
        trueValues.add("on");
        trueValues.add(OPEN);
        falseValues.add(FALSE);
        falseValues.add("off");
        falseValues.add(CLOSE);
        String configReloadValue = PROPERTIES.getProperty(UNISQL_CONFIG_RELOAD_ENABLE);
        if (StringUtils.isBlank(configReloadValue)) {
            log.info("\u672a\u914d\u7f6e\u53c2\u6570{}\uff0c\u9ed8\u8ba4\u542f\u52a8\u70ed\u52a0\u8f7d\u76d1\u542c\u7a0b\u5e8f", (Object)UNISQL_CONFIG_RELOAD_ENABLE);
            UnisqlProperties.setFileWatcher();
            return;
        }
        if (trueValues.contains(configReloadValue = configReloadValue.toLowerCase().trim())) {
            log.info("\u542f\u52a8\u70ed\u52a0\u8f7d\u76d1\u542c\u7a0b\u5e8f");
            UnisqlProperties.setFileWatcher();
        } else {
            if (falseValues.contains(configReloadValue)) {
                return;
            }
            log.warn("\u5f53\u524d\u914d\u7f6e\u53c2\u6570[{}={}],\u975e\u6b63\u5e38\u8f93\u5165\u503c\uff0c\u9ed8\u8ba4\u542f\u52a8\u70ed\u52a0\u8f7d\u76d1\u542c\u7a0b\u5e8f\u3002", (Object)UNISQL_CONFIG_RELOAD_ENABLE, (Object)configReloadValue);
            UnisqlProperties.setFileWatcher();
        }
    }

    private static void setFileWatcher() {
        block3: {
            if (fileWatcherPath == null) {
                return;
            }
            try {
                watchService = FileSystems.getDefault().newWatchService();
                fileWatcherPath.getParent().register(watchService, StandardWatchEventKinds.ENTRY_CREATE);
                EXECUTOR.submit(() -> UnisqlProperties.processEvents());
            }
            catch (IOException ex) {
                if (!log.isErrorEnabled()) break block3;
                log.error("\u8bbe\u7f6e\u914d\u7f6e\u6587\u4ef6\u76d1\u542c\u5f02\u5e38\uff1a{} ", (Object)ex.getMessage());
            }
        }
    }

    private static void processEvents() {
        block5: {
            try {
                WatchKey key;
                boolean valid;
                do {
                    key = watchService.take();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent<?> ev;
                        Path fileName;
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind != StandardWatchEventKinds.ENTRY_CREATE || !(fileName = (Path)(ev = event).context()).equals(fileWatcherPath.getFileName())) continue;
                        if (log.isInfoEnabled()) {
                            log.info(fileWatcherPath + "\u6587\u4ef6\u88ab\u521b\u5efa");
                        }
                        UnisqlProperties.setConfigration();
                        Transformer.setConfigration();
                        Transformer.cleanCache();
                        if (!Files.exists(fileWatcherPath, new LinkOption[0]) || !Files.isRegularFile(fileWatcherPath, new LinkOption[0])) continue;
                        Files.delete(fileWatcherPath);
                        if (!log.isInfoEnabled()) continue;
                        log.info("\u7edf\u4e00sql\u70ed\u66f4\u65b0\u5b8c\u6210\uff0c" + fileWatcherPath + "\u6587\u4ef6\u5df2\u6210\u529f\u5220\u9664\u3002");
                    }
                } while (valid = key.reset());
            }
            catch (IOException | InterruptedException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error("\u914d\u7f6e\u6587\u4ef6\u76d1\u542c\u5904\u7406\u5f02\u5e38\uff1a{} ", (Throwable)e);
            }
        }
    }

    public static String determineUnisqlConfigPath() {
        String unisqlConfDir = System.getProperty(UNISQL_CONF_PATH_PROPERTY);
        if (StringUtils.isNotBlank(unisqlConfDir)) {
            log.info("\u4ece\u7cfb\u7edf\u53c2\u6570[{}]\u4e2d\u83b7\u53d6\u7edf\u4e00SQL\u914d\u7f6e\u76ee\u5f55 [{}]", (Object)UNISQL_CONF_PATH_PROPERTY, (Object)unisqlConfDir);
            return unisqlConfDir.trim();
        }
        unisqlConfDir = System.getenv(UNISQL_CONF_PATH_PROPERTY);
        if (StringUtils.isNotBlank(unisqlConfDir)) {
            log.info("\u4ece\u73af\u5883\u53d8\u91cf[{}]\u4e2d\u83b7\u53d6\u7edf\u4e00SQL\u914d\u7f6e\u76ee\u5f55 [{}]", (Object)UNISQL_CONF_PATH_PROPERTY, (Object)unisqlConfDir);
            return unisqlConfDir.trim();
        }
        log.info("\u672a\u6307\u5b9a\u7edf\u4e00SQL\u914d\u7f6e\u6587\u4ef6\u76ee\u5f55\uff0c\u4f7f\u7528\u9ed8\u8ba4\u89c4\u5219\u4ece\u5f53\u524d\u5de5\u4f5c\u76ee\u5f55\u4e0b\u7684config\u76ee\u5f55\u8bfb\u53d6");
        String workDir = System.getProperty(WORK_DIR);
        unisqlConfDir = workDir + File.separator + CONFIG;
        log.info("\u5f53\u524d\u5de5\u4f5c\u76ee\u5f55\u4e0b\u7684\u4f5c\u4e3a\u7edf\u4e00SQL\u914d\u7f6e\u76ee\u5f55 [{}]", (Object)unisqlConfDir);
        return unisqlConfDir;
    }

    private static void setConfigration() {
        block10: {
            UNISQL_CONF_DIR = UnisqlProperties.determineUnisqlConfigPath();
            PROPERTIES = new Properties();
            String conf = String.format(UNISQL_CONF_DIR + File.separator + "%s", UNISQL_CONF_NAME);
            log.info("\u7edf\u4e00SQL\u914d\u7f6e\u6587\u4ef6\u8def\u5f84 [{}]", (Object)conf);
            File file = new File(conf);
            if (file.exists()) {
                try (FileInputStream input = new FileInputStream(file);){
                    PROPERTIES.load(input);
                    break block10;
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error("\u52a0\u8f7d\u7edf\u4e00SQL\u914d\u7f6e\u6587\u4ef6\u5931\u8d25 " + conf, (Throwable)e);
                    }
                    break block10;
                }
            }
            if (log.isInfoEnabled()) {
                log.info("\u7edf\u4e00SQL\u914d\u7f6e\u6587\u4ef6\u672a\u627e\u5230\uff0c\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e [{}]", (Object)conf);
            }
        }
        fileWatcherPath = Paths.get(String.format(UNISQL_CONF_DIR + File.separator + "%s", UNISQL_CONF_RELOAD_NAME), new String[0]);
    }

    public static String getProperty(String configName) {
        return PROPERTIES.getProperty(configName);
    }

    private boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    public static boolean isOpen(String str) {
        return StringUtils.isNotBlank(str) && (TRUE.equalsIgnoreCase(str.trim()) || OPEN.equalsIgnoreCase(str.trim()));
    }

    public static String getPropMultiConfigurationPath() {
        return MULTI_CONFIGURATION_PATH;
    }

    public String getLibFullPath() {
        return PROPERTIES.getProperty(PROP_LIB_FULL_PATH);
    }

    public String getLibDir() {
        return PROPERTIES.getProperty(PROP_LIB_DIR);
    }

    public long getGOGC() {
        long def = 1000L;
        String str = PROPERTIES.getProperty(PROP_UNISQL_GO_GOGC);
        if (this.isEmpty(str)) {
            return 1000L;
        }
        try {
            return Long.parseLong(str);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(String.format("System property '%s' value '%s' is not a valid number! Using default GOGC %d%n", PROP_UNISQL_GO_GOGC, str, 1000L));
            }
            return 1000L;
        }
    }

    public long getGOMEMLIMIT() {
        long def = 256L;
        String str = PROPERTIES.getProperty(PROP_UNISQL_GO_GOMEMLIMIT);
        if (this.isEmpty(str)) {
            return 256L;
        }
        try {
            return Long.parseLong(str);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(String.format("System property '%s' value '%s' is not a valid number! Using default GOMEMLIMIT %d%n", PROP_UNISQL_GO_GOMEMLIMIT, str, 256L));
            }
            return 256L;
        }
    }

    public boolean isDebug() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_DEBUG);
        if (this.defaultClose(got)) {
            return false;
        }
        return UnisqlProperties.isOpen(got);
    }

    private boolean handleSwitchConfig(String configName) {
        String configContent = PROPERTIES.getProperty(configName);
        if (this.defaultClose(configContent)) {
            return false;
        }
        return UnisqlProperties.isOpen(configContent);
    }

    private boolean defaultOpen(String got) {
        return StringUtils.isBlank(got) || !CLOSE.equalsIgnoreCase(got.trim()) && !FALSE.equalsIgnoreCase(got.trim());
    }

    private boolean defaultClose(String got) {
        return StringUtils.isBlank(got) || !OPEN.equalsIgnoreCase(got.trim()) && !TRUE.equalsIgnoreCase(got.trim());
    }

    public boolean isErrorSkip() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_ERROR_SKIP);
        if (this.defaultClose(got)) {
            return false;
        }
        return UnisqlProperties.isOpen(got);
    }

    public boolean isSkip() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_SKIP);
        if (StringUtils.isBlank(got) || !OPEN.equalsIgnoreCase(got.trim())) {
            return false;
        }
        return OPEN.equalsIgnoreCase(got.trim());
    }

    public Set<String> getSkipExceptionKeywords() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_SKIP_EXCEPTION_KEYWORDS);
        if (StringUtils.isBlank(got = StringUtils.lowerCase(got))) {
            return new HashSet<String>();
        }
        String[] keywords = got.split(",");
        return new HashSet<String>(Arrays.asList(keywords));
    }

    public boolean isMysqlBackslashEscapes() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_MYSQLBACKSLASHESCAPES);
        if (got == null) {
            return Boolean.TRUE;
        }
        if (CLOSE.equalsIgnoreCase(got.trim())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public int isRemoveTablespace() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_REMOVE_TABLESPACE);
        if (got == null) {
            return 0;
        }
        if (OPEN.equalsIgnoreCase(got.trim())) {
            return 1;
        }
        return 0;
    }

    public boolean isOpenCache() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_CACHE);
        if (this.defaultOpen(got)) {
            return true;
        }
        return UnisqlProperties.isOpen(got);
    }

    public String getCompareServerUrl() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_COMPARE_SERVER_URL);
        if (StringUtils.isBlank(got)) {
            return "";
        }
        return got.trim();
    }

    public String getSchema() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_SCHEMA);
        if (StringUtils.isBlank(got)) {
            return DEFAULT_UNISQL_SCHEMA;
        }
        return got.trim();
    }

    public int getRemoveDoublequoted() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_REMOVEDOUBLEQUOTED);
        if (StringUtils.isNotBlank(got) && OPEN.equalsIgnoreCase(got.trim())) {
            return 1;
        }
        return 0;
    }

    public int getPrintSysinfo() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_PRINTSYSINFO);
        if (StringUtils.isNotBlank(got) && OPEN.equalsIgnoreCase(got.trim())) {
            return 1;
        }
        return 0;
    }

    public String getDecodeParametersFuncNames() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_DECODEPARAMETERSFUNCNAMES);
        if (StringUtils.isBlank(got)) {
            return "";
        }
        return got.trim();
    }

    public String getGlobalReplaceSql() {
        String got = PROPERTIES.getProperty(GLOBAL_REPLACE_SQL);
        if (StringUtils.isBlank(got)) {
            return "";
        }
        return got.trim();
    }

    public int getDefaultChangeDatabaseToSchema() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_CHANGE_DATABASE_TO_SCHEMA);
        if (StringUtils.isNotBlank(got) && OPEN.equalsIgnoreCase(got.trim())) {
            return 1;
        }
        return 0;
    }

    public int isTableOrColumnNameRandom() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_TABLE_COLUMN_NAME_RANDOM);
        if (StringUtils.isNotBlank(got) && CLOSE.equalsIgnoreCase(got.trim())) {
            return 0;
        }
        return 1;
    }

    public int isChangeBackQuotesToDoubleQuotes() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_BACK_QUOTES_TO_DOUBLE_QUOTES);
        if (StringUtils.isNotBlank(got) && OPEN.equalsIgnoreCase(got.trim())) {
            return 1;
        }
        return 0;
    }

    public String getKeywordDoubleQuotes() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_KEYWORD_DOUBLE_QUOTES);
        if (StringUtils.isBlank(got)) {
            return "";
        }
        return got.trim();
    }

    public String getAutoIncrementColumn() {
        String got = PROPERTIES.getProperty(this.PROP_AUTO_INCREMENT_COLUMN);
        if (StringUtils.isBlank(got)) {
            return "";
        }
        return got.trim();
    }

    public String getTableColumnMetaDataSchemas() {
        String got = PROPERTIES.getProperty(this.PROP_TABLE_COLUMN_METADATA_SCHEMAS);
        if (StringUtils.isBlank(got)) {
            return "";
        }
        return got.trim();
    }

    public String getUnsqlExcludeRulesDirectory() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_EXCLUDE_RULES);
        if (StringUtils.isBlank(got)) {
            got = "";
        }
        return got.trim();
    }

    public boolean getUnsqlTargetForceUseGaussDb500() {
        return PROP_UNISQL_TARGET_DIALECT_FORCEUSEGAUSSDB500_VALUE;
    }

    public String getOnUpdateCurrentimestampColumn() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_ON_UPDATE_CURRENTIMESTAMP_COLUMN);
        if (StringUtils.isBlank(got)) {
            return "";
        }
        return got.trim();
    }

    public Integer getTableMetadataScheduleSwitch() {
        String got = PROPERTIES.getProperty(this.PROP_TABLE_METADATA_SCHEDULE_SWITCH);
        if (StringUtils.isNotBlank(got) && OPEN.equalsIgnoreCase(got.trim())) {
            return 1;
        }
        return 0;
    }

    public String getTableColumnReplaceDatatype() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_TABLE_COLUMN_REPLACE_DATATYPE);
        if (StringUtils.isBlank(got)) {
            return "";
        }
        return got.trim();
    }

    public int getDatatypeNumberReplaceInteger() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_DATATYPE_NUMBER_REPLACE_INTEGER);
        if (StringUtils.isNotBlank(got) && OPEN.equalsIgnoreCase(got.trim())) {
            return 1;
        }
        return 0;
    }

    public int getUnisqlBindVariableMode() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_BIND_VARIABLE_MODE);
        if (StringUtils.isNotBlank(got) && OPEN.equalsIgnoreCase(got.trim())) {
            return 1;
        }
        return 0;
    }

    public static String getSimulateMapping(String sourceDialect) {
        return SIMULATE_DIALECT_MAPPING.get(sourceDialect);
    }

    public static int getGenLastInsertIdAfterInsert() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_GEN_LASTINSERTID_AFTER_INSERT);
        if (StringUtils.isNotBlank(got) && OPEN.equalsIgnoreCase(got.trim())) {
            return 1;
        }
        return 0;
    }

    public boolean getUnisqlCleanGttQuery() {
        String got = PROPERTIES.getProperty(PROP_UNISQL_TRANSFORM_UPDATE_MULTI_CLOB_BLOB_GTT);
        return UnisqlProperties.isOpen(got);
    }

    static {
        block15: {
            log = LoggerFactory.getLogger(UnisqlProperties.class);
            INSTANCE = new UnisqlProperties();
            skipUnisqlRuntimeConvertProperty = false;
            collectMicroServiceParametersEnabled = false;
            autoTestInitMetaData = false;
            AUTOTEST = 1;
            MULTIPLEX = 2;
            PROP_UNISQL_TARGET_DIALECT_FORCEUSEGAUSSDB500_VALUE = false;
            TIME_UNIT = TimeUnit.MILLISECONDS;
            WORK_QUEUE = new LinkedBlockingQueue<Runnable>();
            DAEMON_THREAD_FACTORY = new ThreadFactory(){
                private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
                private final AtomicInteger threadNumber = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = this.defaultFactory.newThread(r);
                    thread.setDaemon(true);
                    thread.setName("custom-daemon-pool-thread-" + this.threadNumber.getAndIncrement());
                    return thread;
                }
            };
            EXECUTOR = new ThreadPoolExecutor(1, 1, 0L, TIME_UNIT, WORK_QUEUE, DAEMON_THREAD_FACTORY, new ThreadPoolExecutor.AbortPolicy());
            SIMULATE_DIALECT_MAPPING = new HashMap<String, String>();
            UnisqlProperties.setConfigration();
            MULTI_CONFIGURATION_PATH = String.format(UNISQL_CONF_DIR + File.separator + "%s", JRESCLOUD_PROPERTIES);
            String multiConfigurationPath = String.format(MULTI_CONFIGURATION_PATH + "%s", "");
            File multiplexFile = new File(multiConfigurationPath);
            if (multiplexFile.exists()) {
                try (FileInputStream input = new FileInputStream(multiplexFile);){
                    PROPERTIES.load(input);
                    if (log.isInfoEnabled()) {
                        log.info("\u591a\u53d1\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u6210\u529f [{}]", (Object)multiplexFile.getAbsolutePath());
                    }
                    break block15;
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error("\u591a\u53d1\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u5931\u8d25 [{}]", (Object)e.getMessage());
                    }
                    break block15;
                }
            }
            if (log.isInfoEnabled()) {
                log.info("\u591a\u53d1\u914d\u7f6e\u6587\u4ef6\u672a\u627e\u5230 [{}]", (Object)multiplexFile.getAbsolutePath());
            }
        }
        skipUnisqlRuntimeConvertProperty = UnisqlProperties.getInstance().handleSwitchConfig(SKIP_UNISQL_RUNTIME_CONVERT);
        collectMicroServiceParametersEnabled = UnisqlProperties.getInstance().handleSwitchConfig(COLLECT_MICRO_SERVICE_PARAMETERS_ENABLED);
        PROP_UNISQL_TARGET_DIALECT_FORCEUSEGAUSSDB500_VALUE = UnisqlProperties.isOpen(UnisqlProperties.getProperty(PROP_UNISQL_TARGET_DIALECT_FORCEUSEGAUSSDB500));
        UnisqlProperties.checkAndSetFileWatcher();
        String property = UnisqlProperties.getProperty(MULTI_SIMULATE_REMAP);
        if (StringUtils.isNotBlank(property)) {
            String[] targetDialectMapping;
            if (log.isInfoEnabled()) {
                log.info("\u8bfb\u53d6\u591a\u53d1\u914d\u7f6e\u9879\uff0c\u914d\u7f6e\u9879\u540d\u79f0 [{}] \u914d\u7f6e\u9879\u7684\u503c [{}]", (Object)MULTI_SIMULATE_REMAP, (Object)property);
            }
            if ((targetDialectMapping = property.split("->")).length == 2) {
                DbType source = DbType.of(targetDialectMapping[0]);
                DbType target = DbType.of(targetDialectMapping[1]);
                SIMULATE_DIALECT_MAPPING.put(source.name(), target.name());
                if (log.isInfoEnabled()) {
                    log.info("\u6210\u529f\u52a0\u8f7d\u6570\u636e\u6e90\u6a21\u62df\u591a\u53d1\u914d\u7f6e\u9879\uff0c\u6e90\u65b9\u8a00 [{}] \u6a21\u62df\u65b9\u8a00 [{}]", (Object)source.name(), (Object)target.name());
                }
            }
        }
    }
}

