/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.proxy.jdbc;

import com.hundsun.lightdb.unisql.annotation.SuppressFBWarnings;
import com.hundsun.lightdb.unisql.constant.ErrorMessages;
import com.hundsun.lightdb.unisql.golang.PreparedParameter;
import com.hundsun.lightdb.unisql.golang.ReturnParameter;
import com.hundsun.lightdb.unisql.golang.Transformer;
import com.hundsun.lightdb.unisql.model.MultiCompletableFuture;
import com.hundsun.lightdb.unisql.model.MultiProperties;
import com.hundsun.lightdb.unisql.model.MultiQueryResultDTO;
import com.hundsun.lightdb.unisql.model.MultiplexContext;
import com.hundsun.lightdb.unisql.model.SyncDataParamater;
import com.hundsun.lightdb.unisql.model.UnisqlProperties;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.proxy.jdbc.UnisqlConnection;
import com.hundsun.lightdb.unisql.proxy.jdbc.UnisqlStatement;
import com.hundsun.lightdb.unisql.utils.UnisqlCommonUtils;
import com.hundsun.lightdb.unisql.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.jdbc.internal.OraclePreparedStatement;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SQL_INJECTION_JDBC", "EXTERNAL_CONFIG_CONTROL"})
public class UnisqlPreparedStatement
extends UnisqlStatement
implements PreparedStatement {
    private static Logger log = LoggerFactory.getLogger(UnisqlPreparedStatement.class);
    private final UnisqlConnection connection;
    private final PreparedStatement delegate;
    private int columnCountSum = 0;
    private int autoIncrementColumnIndex = 0;
    private int currentCancelNum = 0;
    private List<Integer> bindVariableOrder;
    private final DbType sourceDialect;
    private final DbType targetDialect;
    private final SyncDataParamater syncDataParam;
    private final String bizSql;
    private final String transformedPreparedSql;
    private final UnisqlProperties properties = UnisqlProperties.getInstance();
    protected final List<ArrayList<PreparedParameter>> comparePreparedBindingVariablesBatch;
    protected final TreeMap<Integer, PreparedParameter> comparePreparedBindingVariables;
    protected final TreeMap<Integer, PreparedParameter> rawPreparedBindingVariables;

    @Override
    public DbType getSourceDialect() {
        return this.sourceDialect;
    }

    @Override
    public DbType getTargetDialect() {
        return this.targetDialect;
    }

    private int isCancelIndex(int parameterIndex) {
        if (this.isNeedResetBindVariable()) {
            return parameterIndex;
        }
        if (this.columnCountSum == 0 || this.autoIncrementColumnIndex == 0) {
            return parameterIndex;
        }
        if (this.autoIncrementColumnIndex == parameterIndex) {
            this.autoIncrementColumnIndex += this.columnCountSum;
            ++this.currentCancelNum;
            return 0;
        }
        if (parameterIndex - this.currentCancelNum > 0) {
            parameterIndex -= this.currentCancelNum;
        }
        return parameterIndex;
    }

    private boolean isNeedResetBindVariable() {
        return CollectionUtils.isNotEmpty(this.bindVariableOrder);
    }

    public UnisqlPreparedStatement(UnisqlConnection connection, PreparedStatement delegate, String comparePreparedSql, String bizSql) {
        super(connection, delegate);
        this.connection = connection;
        this.delegate = delegate;
        this.transformedPreparedSql = comparePreparedSql;
        this.bizSql = bizSql;
        this.comparePreparedBindingVariablesBatch = new ArrayList<ArrayList<PreparedParameter>>();
        this.comparePreparedBindingVariables = new TreeMap();
        this.rawPreparedBindingVariables = new TreeMap();
        this.sourceDialect = connection.getSourceDialect();
        this.targetDialect = connection.getTargetDialect();
        this.syncDataParam = null;
    }

    public UnisqlPreparedStatement(UnisqlConnection connection, PreparedStatement delegate, String comparePreparedSql, String bizSql, SyncDataParamater syncData) {
        super(connection, delegate);
        this.connection = connection;
        this.delegate = delegate;
        this.transformedPreparedSql = comparePreparedSql;
        this.bizSql = bizSql;
        this.comparePreparedBindingVariablesBatch = new ArrayList<ArrayList<PreparedParameter>>();
        this.comparePreparedBindingVariables = new TreeMap();
        this.rawPreparedBindingVariables = new TreeMap();
        this.sourceDialect = connection.getSourceDialect();
        this.targetDialect = connection.getTargetDialect();
        this.syncDataParam = syncData;
    }

    public UnisqlPreparedStatement(UnisqlConnection connection, PreparedStatement delegate, String transformedPreparedSql, ReturnParameter returnParameter, String bizSql, SyncDataParamater syncData) {
        super(connection, delegate);
        this.connection = connection;
        this.delegate = delegate;
        this.transformedPreparedSql = transformedPreparedSql;
        this.bizSql = bizSql;
        this.comparePreparedBindingVariablesBatch = new ArrayList<ArrayList<PreparedParameter>>();
        this.comparePreparedBindingVariables = new TreeMap();
        this.rawPreparedBindingVariables = new TreeMap();
        this.columnCountSum = returnParameter.getColumnCountSum();
        this.autoIncrementColumnIndex = returnParameter.getAutoIncrementColumnIndex();
        this.bindVariableOrder = returnParameter.getBindVariableOrder();
        this.sourceDialect = connection.getSourceDialect();
        this.targetDialect = connection.getTargetDialect();
        this.syncDataParam = syncData;
    }

    @Override
    public PreparedStatement getDelegate() {
        return this.delegate;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        boolean execute = this.execute();
        if (!execute) {
            throw new SQLException("SQL\u672a\u8fd4\u56de\u4efb\u4f55\u67e5\u8be2\u7ed3\u679c\u96c6");
        }
        return this.getResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        boolean execute = this.execute();
        if (execute) {
            throw new SQLException("SQL\u8fd4\u56de\u672a\u903e\u671f\u7684\u67e5\u8be2\u7ed3\u679c\u96c6");
        }
        return this.getUpdateCount();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        MultiplexContext.collectPreparedParameter(this.rawPreparedBindingVariables, "setNull", parameterIndex, null, 0);
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setObject(i, null);
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setNull", i, null, 0);
            }
        } else {
            this.delegate.setNull(parameterIndex, sqlType);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        MultiplexContext.collectPreparedParameter(this.rawPreparedBindingVariables, "setBoolean", parameterIndex, x, 16);
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setBoolean(i, x);
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setBoolean", i, x, 16);
            }
        } else {
            this.delegate.setBoolean(parameterIndex, x);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        MultiplexContext.collectPreparedParameter(this.rawPreparedBindingVariables, "setByte", parameterIndex, x, -6);
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setByte(i, x);
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setByte", i, x, -6);
            }
        } else {
            this.delegate.setByte(parameterIndex, x);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        MultiplexContext.collectPreparedParameter(this.rawPreparedBindingVariables, "setShort", parameterIndex, x, 5);
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setShort(i, x);
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setShort", i, x, 5);
            }
        } else {
            this.delegate.setShort(parameterIndex, x);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        MultiplexContext.collectPreparedParameter(this.rawPreparedBindingVariables, "setInt", parameterIndex, x, 4);
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setInt(i, x);
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setInt", i, x, 4);
            }
        } else {
            this.delegate.setInt(parameterIndex, x);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        MultiplexContext.collectPreparedParameter(this.rawPreparedBindingVariables, "setLong", parameterIndex, x, -5);
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setLong(i, x);
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setLong", i, x, -5);
            }
        } else {
            this.delegate.setLong(parameterIndex, x);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        MultiplexContext.collectPreparedParameter(this.rawPreparedBindingVariables, "setFloat", parameterIndex, Float.valueOf(x), 6);
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setFloat(i, x);
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setFloat", i, Float.valueOf(x), 6);
            }
        } else {
            this.delegate.setFloat(parameterIndex, x);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        MultiplexContext.collectPreparedParameter(this.rawPreparedBindingVariables, "setDouble", parameterIndex, x, 8);
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setDouble(i, x);
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setDouble", i, x, 8);
            }
        } else {
            this.delegate.setDouble(parameterIndex, x);
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        MultiplexContext.collectPreparedParameter(this.rawPreparedBindingVariables, "setBigDecimal", parameterIndex, x, 3);
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setBigDecimal(i, x);
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setBigDecimal", i, x, 3);
            }
        } else {
            this.delegate.setBigDecimal(parameterIndex, x);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        MultiplexContext.collectPreparedParameter(this.rawPreparedBindingVariables, "setString", parameterIndex, x, 12);
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setString(i, x);
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setString", i, x, 12);
            }
        } else {
            this.delegate.setString(parameterIndex, x);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        MultiplexContext.collectPreparedParameter(this.rawPreparedBindingVariables, "setBytes", parameterIndex, x, -2);
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setBytes(i, x);
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setBytes", i, x, -2);
            }
        } else {
            this.delegate.setBytes(parameterIndex, x);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        MultiplexContext.collectPreparedParameter(this.rawPreparedBindingVariables, "setDate", parameterIndex, x, 91);
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setDate(i, x);
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setDate", i, x, 91);
            }
        } else {
            this.delegate.setDate(parameterIndex, x);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        MultiplexContext.collectPreparedParameter(this.rawPreparedBindingVariables, "setTime", parameterIndex, x, 92);
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setTime(i, x);
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setTime", i, x, 92);
            }
        } else {
            this.delegate.setTime(parameterIndex, x);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        MultiplexContext.collectPreparedParameter(this.rawPreparedBindingVariables, "setTimestamp", parameterIndex, x, 93);
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setTimestamp(i, x);
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setTimestamp", parameterIndex, x, 93);
            }
        } else {
            this.delegate.setTimestamp(parameterIndex, x);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        block14: {
            if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
                return;
            }
            if (Transformer.COLLECT_PARAMS || MultiProperties.getSendCompareService()) {
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    this.copyInputStreamToByteArray(x, byteArrayOutputStream);
                    try (ByteArrayInputStream inputStream1 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                        this.delegate.setAsciiStream(parameterIndex, (InputStream)inputStream1, length);
                        PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setAsciiStream").parameterCount(3).inputStream(inputStream1).parameterIndex(parameterIndex).x(Utils.byteArrayOutputStreamToBase64(byteArrayOutputStream)).scaleOrLength(length).base64Flag(true).build();
                        this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
                        break block14;
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
                }
            }
            this.delegate.setAsciiStream(parameterIndex, x, length);
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        block14: {
            if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
                return;
            }
            if (Transformer.COLLECT_PARAMS || MultiProperties.getSendCompareService()) {
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    this.copyInputStreamToByteArray(x, byteArrayOutputStream);
                    try (ByteArrayInputStream inputStream1 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                        this.delegate.setUnicodeStream(parameterIndex, inputStream1, length);
                        PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setUnicodeStream").parameterCount(3).parameterIndex(parameterIndex).x(Utils.byteArrayOutputStreamToBase64(byteArrayOutputStream)).scaleOrLength(length).base64Flag(true).build();
                        this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
                        break block14;
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
                }
            }
            this.delegate.setUnicodeStream(parameterIndex, x, length);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        block14: {
            if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
                return;
            }
            if (Transformer.COLLECT_PARAMS || MultiProperties.getSendCompareService()) {
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    this.copyInputStreamToByteArray(x, byteArrayOutputStream);
                    try (ByteArrayInputStream inputStream1 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                        this.delegate.setBinaryStream(parameterIndex, (InputStream)inputStream1, length);
                        PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setBinaryStream").parameterCount(3).parameterIndex(parameterIndex).inputStream(inputStream1).x(Utils.byteArrayOutputStreamToBase64(byteArrayOutputStream)).scaleOrLength(length).base64Flag(true).build();
                        this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
                        break block14;
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
                }
            }
            this.delegate.setBinaryStream(parameterIndex, x, length);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        try {
            this.delegate.clearParameters();
        }
        finally {
            if (Transformer.COLLECT_PARAMS || Transformer.SEND_MQ_TO_COMPARE_SERVER) {
                this.comparePreparedBindingVariables.clear();
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setObject(i, x, targetSqlType);
            }
        } else {
            this.delegate.setObject(parameterIndex, x, targetSqlType);
        }
        if (Transformer.COLLECT_PARAMS || Transformer.SEND_MQ_TO_COMPARE_SERVER) {
            PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setObject").parameterCount(3).parameterIndex(parameterIndex).x(x).vendorTypeNumber(targetSqlType).build();
            this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        MultiplexContext.collectPreparedParameter(this.rawPreparedBindingVariables, "setObject", parameterIndex, x, 2000);
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setObject(i, x);
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setObject", i, x, 2000);
            }
        } else {
            this.delegate.setObject(parameterIndex, x);
        }
    }

    public boolean execute(boolean needTransform, String traceId) throws SQLException {
        boolean isSendCompareService = Transformer.SEND_MQ_TO_COMPARE_SERVER;
        if (!isSendCompareService || MultiplexContext.inValidTraceId(traceId)) {
            return this.delegate.execute();
        }
        MultiQueryResultDTO multiQueryResult = MultiplexContext.createMultiQueryResult(traceId, this.connection.getSourceDialect(), this.connection.getTargetDialect(), this.connection.getDataBase(), this.connection.getMultiDbTypes(), this.connection.getConnectionInfo());
        String bizFullSql = MultiplexContext.buildFullSql(this.bizSql, this.getRawPreparedParameters(), multiQueryResult);
        String fullSql = MultiplexContext.buildFullSql(this.transformedPreparedSql, this.getPreparedParameters(), multiQueryResult);
        multiQueryResult.setBizSql(this.bizSql);
        multiQueryResult.setTransformedBizSql(this.transformedPreparedSql);
        multiQueryResult.setRawBizBindVarReplacedSql(bizFullSql);
        multiQueryResult.setBizBindVarReplacedSql(fullSql);
        return MultiplexContext.executePrepared(this.connection.getDelegate(), this.delegate, multiQueryResult, new ArrayList<MultiCompletableFuture>(), false, this.syncDataParam);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.execute(true, MultiplexContext.getCurrentTraceId());
    }

    private void clearResoures(Statement currStat) throws SQLException {
        if (currStat != null) {
            currStat.close();
        }
        if (Transformer.COLLECT_PARAMS || Transformer.SEND_MQ_TO_COMPARE_SERVER) {
            this.comparePreparedBindingVariables.clear();
            this.rawPreparedBindingVariables.clear();
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.delegate.addBatch();
        if (Transformer.COLLECT_PARAMS || Transformer.SEND_MQ_TO_COMPARE_SERVER) {
            this.comparePreparedBindingVariablesBatch.add(this.getSortObjectArrayList());
            this.comparePreparedBindingVariables.clear();
            this.rawPreparedBindingVariables.clear();
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        block9: {
            if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
                return;
            }
            if (Transformer.COLLECT_PARAMS || Transformer.SEND_MQ_TO_COMPARE_SERVER) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = UnisqlCommonUtils.copyReaderToByteArrayOutputStream(reader);
                    try (InputStreamReader bufferedReader1 = new InputStreamReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));){
                        this.delegate.setCharacterStream(parameterIndex, (Reader)bufferedReader1, length);
                        PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setCharacterStream").parameterCount(3).parameterIndex(parameterIndex).x(Utils.byteArrayOutputStreamToBase64(byteArrayOutputStream)).scaleOrLength(length).base64Flag(true).build();
                        this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
                        break block9;
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
                }
            }
            this.delegate.setCharacterStream(parameterIndex, reader, length);
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setRef(i, x);
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setRef", i, x.getBaseTypeName(), 12);
            }
        } else {
            this.delegate.setRef(parameterIndex, x);
            MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setRef", parameterIndex, x.getBaseTypeName(), 12);
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setBlob(i, x);
                try {
                    PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setBlob").parameterIndex(i).x(Utils.byteArrayOutputStreamToBase64(Utils.blobToByteArrayOutputStream(x))).base64Flag(true).build();
                    this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
                    continue;
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
                }
            }
        } else {
            this.delegate.setBlob(parameterIndex, x);
            try {
                PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setBlob").parameterIndex(parameterIndex).x(Utils.byteArrayOutputStreamToBase64(Utils.blobToByteArrayOutputStream(x))).base64Flag(true).build();
                this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
            }
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setClob(i, x);
                try {
                    PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setClob").parameterIndex(i).x(Utils.byteArrayOutputStreamToBase64(Utils.clobToByteArrayOutputStream(x))).base64Flag(true).build();
                    this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
                    continue;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
                }
            }
        } else {
            this.delegate.setClob(parameterIndex, x);
            try {
                PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setClob").parameterIndex(parameterIndex).x(Utils.byteArrayOutputStreamToBase64(Utils.clobToByteArrayOutputStream(x))).base64Flag(true).build();
                this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
            }
        }
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setArray(i, x);
            }
        } else {
            this.delegate.setArray(parameterIndex, x);
        }
        if (Transformer.COLLECT_PARAMS || Transformer.SEND_MQ_TO_COMPARE_SERVER) {
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                 ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                objectOutputStream.writeObject(x.getArray());
                byte[] byteArray = byteArrayOutputStream.toByteArray();
                PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setArray").parameterIndex(parameterIndex).x(Base64.getEncoder().encodeToString(byteArray)).base64Flag(true).build();
                this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
            }
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.delegate.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setDate(i, x, cal);
            }
        } else {
            this.delegate.setDate(parameterIndex, x, cal);
        }
        if (Transformer.COLLECT_PARAMS || Transformer.SEND_MQ_TO_COMPARE_SERVER) {
            PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setDate").parameterCount(3).parameterIndex(parameterIndex).x(x).calendar(cal).build();
            this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setTime(i, x, cal);
            }
        } else {
            this.delegate.setTime(parameterIndex, x, cal);
        }
        if (Transformer.COLLECT_PARAMS || Transformer.SEND_MQ_TO_COMPARE_SERVER) {
            PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setTime").parameterCount(3).parameterIndex(parameterIndex).x(x).calendar(cal).build();
            this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        Timestamp timestamp = UnisqlPreparedStatement.convertToRegularTimestamp(x, cal);
        this.setTimestamp(parameterIndex, timestamp);
    }

    public static Timestamp convertToRegularTimestamp(Timestamp timestamp, Calendar calendar) {
        int offset = calendar.getTimeZone().getOffset(timestamp.getTime());
        long adjustedTime = timestamp.getTime() - (long)offset;
        return new Timestamp(adjustedTime);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setNull(i, sqlType, typeName);
            }
        } else {
            this.delegate.setNull(parameterIndex, sqlType, typeName);
        }
        if (Transformer.COLLECT_PARAMS || Transformer.SEND_MQ_TO_COMPARE_SERVER) {
            PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setNull").parameterCount(3).parameterIndex(parameterIndex).x(null).vendorTypeNumber(sqlType).build();
            this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setURL(i, x);
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setURL", i, x.toString(), 12);
            }
        } else {
            this.delegate.setURL(parameterIndex, x);
            MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setURL", parameterIndex, x.toString(), 12);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.delegate.getParameterMetaData();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setRowId(i, x);
            }
        } else {
            this.delegate.setRowId(parameterIndex, x);
        }
        if (Transformer.COLLECT_PARAMS || Transformer.SEND_MQ_TO_COMPARE_SERVER) {
            MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setRowId", parameterIndex, x.toString(), 12);
        }
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        boolean isLightDB;
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        MultiplexContext.collectPreparedParameter(this.rawPreparedBindingVariables, "setNString", parameterIndex, value, -9);
        boolean bl = isLightDB = DbType.LIGHTDB_ORACLE.equals((Object)this.targetDialect) || DbType.LIGHTDB_MYSQL.equals((Object)this.targetDialect);
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                if (isLightDB) {
                    this.delegate.setString(i, value);
                } else {
                    this.delegate.setNString(i, value);
                }
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setNString", i, value, 12);
            }
        } else if (isLightDB) {
            this.delegate.setString(parameterIndex, value);
        } else {
            this.delegate.setNString(parameterIndex, value);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        block9: {
            if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
                return;
            }
            if (Transformer.COLLECT_PARAMS || Transformer.SEND_MQ_TO_COMPARE_SERVER) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = UnisqlCommonUtils.copyReaderToByteArrayOutputStream(value);
                    try (InputStreamReader bufferedReader1 = new InputStreamReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));){
                        this.delegate.setNCharacterStream(parameterIndex, bufferedReader1, length);
                        PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setNCharacterStream").parameterIndex(parameterIndex).x(byteArrayOutputStream.toString()).vendorTypeNumber(12).build();
                        this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
                        break block9;
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
                }
            }
            this.delegate.setNCharacterStream(parameterIndex, value, length);
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setNClob(i, value);
            }
        } else {
            this.delegate.setNClob(parameterIndex, value);
        }
        if (Transformer.COLLECT_PARAMS || Transformer.SEND_MQ_TO_COMPARE_SERVER) {
            try {
                PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setNClob").parameterIndex(parameterIndex).x(Utils.clobToByteArrayOutputStream(value)).base64Flag(true).build();
                this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
            }
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        block9: {
            if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
                return;
            }
            if (Transformer.COLLECT_PARAMS || MultiProperties.getSendCompareService()) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = UnisqlCommonUtils.copyReaderToByteArrayOutputStream(reader);
                    try (InputStreamReader bufferedReader1 = new InputStreamReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));){
                        this.delegate.setClob(parameterIndex, bufferedReader1, length);
                        PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setClob").parameterCount(3).parameterIndex(parameterIndex).x(Utils.byteArrayOutputStreamToBase64(byteArrayOutputStream)).scaleOrLength(length).base64Flag(true).build();
                        this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
                        break block9;
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
                }
            }
            this.delegate.setClob(parameterIndex, reader, length);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        block14: {
            if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
                return;
            }
            if (Transformer.COLLECT_PARAMS || MultiProperties.getSendCompareService()) {
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    this.copyInputStreamToByteArray(inputStream, byteArrayOutputStream);
                    try (ByteArrayInputStream inputStream1 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                        this.delegate.setBlob(parameterIndex, inputStream1, length);
                        PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setBlob").parameterCount(3).parameterIndex(parameterIndex).x(Utils.byteArrayOutputStreamToBase64(byteArrayOutputStream)).scaleOrLength(length).base64Flag(true).build();
                        this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
                        break block14;
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
                }
            }
            this.delegate.setBlob(parameterIndex, inputStream, length);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        block9: {
            if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
                return;
            }
            if (Transformer.COLLECT_PARAMS || MultiProperties.getSendCompareService()) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = UnisqlCommonUtils.copyReaderToByteArrayOutputStream(reader);
                    try (InputStreamReader bufferedReader1 = new InputStreamReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));){
                        this.delegate.setNClob(parameterIndex, bufferedReader1, length);
                        PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setNClob").parameterCount(3).parameterIndex(parameterIndex).x(Utils.byteArrayOutputStreamToBase64(byteArrayOutputStream)).scaleOrLength(length).base64Flag(true).build();
                        this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
                        break block9;
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
                }
            }
            this.delegate.setNClob(parameterIndex, reader, length);
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setSQLXML(i, xmlObject);
            }
        } else {
            this.delegate.setSQLXML(parameterIndex, xmlObject);
        }
        if (Transformer.COLLECT_PARAMS || Transformer.SEND_MQ_TO_COMPARE_SERVER) {
            try {
                Method getStringMethod = xmlObject.getClass().getDeclaredMethod("getStringVal", new Class[0]);
                getStringMethod.setAccessible(true);
                String xmlString = (String)getStringMethod.invoke((Object)xmlObject, new Object[0]);
                MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setSQLXML", parameterIndex, xmlString, 2009);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setObject(i, x, targetSqlType, scaleOrLength);
            }
        } else {
            this.delegate.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }
        if (Transformer.COLLECT_PARAMS || Transformer.SEND_MQ_TO_COMPARE_SERVER) {
            PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setObject").parameterCount(4).parameterIndex(parameterIndex).x(x).vendorTypeNumber(targetSqlType).scaleOrLength(scaleOrLength).build();
            this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        block14: {
            if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
                return;
            }
            if (Transformer.COLLECT_PARAMS || MultiProperties.getSendCompareService()) {
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    this.copyInputStreamToByteArray(x, byteArrayOutputStream);
                    try (ByteArrayInputStream inputStream1 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                        this.delegate.setAsciiStream(parameterIndex, (InputStream)inputStream1, length);
                        PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setAsciiStream").parameterCount(3).parameterIndex(parameterIndex).x(Utils.byteArrayOutputStreamToBase64(byteArrayOutputStream)).scaleOrLength(length).base64Flag(true).build();
                        this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
                        break block14;
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
                }
            }
            this.delegate.setAsciiStream(parameterIndex, x, length);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        block14: {
            if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
                return;
            }
            if (Transformer.COLLECT_PARAMS || MultiProperties.getSendCompareService()) {
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    this.copyInputStreamToByteArray(x, byteArrayOutputStream);
                    try (ByteArrayInputStream inputStream1 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                        this.delegate.setBinaryStream(parameterIndex, (InputStream)inputStream1, length);
                        PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setBinaryStream").parameterCount(3).parameterIndex(parameterIndex).x(Utils.byteArrayOutputStreamToBase64(byteArrayOutputStream)).scaleOrLength(length).base64Flag(true).build();
                        this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
                        break block14;
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
                }
            }
            this.delegate.setBinaryStream(parameterIndex, x, length);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        block9: {
            if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
                return;
            }
            if (Transformer.COLLECT_PARAMS || MultiProperties.getSendCompareService()) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = UnisqlCommonUtils.copyReaderToByteArrayOutputStream(reader);
                    try (InputStreamReader bufferedReader1 = new InputStreamReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));){
                        this.delegate.setCharacterStream(parameterIndex, (Reader)bufferedReader1, length);
                        PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setCharacterStream").parameterCount(3).parameterIndex(parameterIndex).x(Utils.byteArrayOutputStreamToBase64(byteArrayOutputStream)).scaleOrLength(length).base64Flag(true).build();
                        this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
                        break block9;
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
                }
            }
            this.delegate.setCharacterStream(parameterIndex, reader, length);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        block14: {
            if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
                return;
            }
            if (Transformer.COLLECT_PARAMS || MultiProperties.getSendCompareService()) {
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    this.copyInputStreamToByteArray(x, byteArrayOutputStream);
                    try (ByteArrayInputStream inputStream1 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                        this.delegate.setAsciiStream(parameterIndex, inputStream1);
                        PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setAsciiStream").parameterIndex(parameterIndex).x(Utils.byteArrayOutputStreamToBase64(byteArrayOutputStream)).base64Flag(true).build();
                        this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
                        break block14;
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
                }
            }
            this.delegate.setAsciiStream(parameterIndex, x);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        block14: {
            if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
                return;
            }
            if (Transformer.COLLECT_PARAMS || MultiProperties.getSendCompareService()) {
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    this.copyInputStreamToByteArray(x, byteArrayOutputStream);
                    try (ByteArrayInputStream inputStream1 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                        this.delegate.setBinaryStream(parameterIndex, inputStream1);
                        PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setBinaryStream").parameterIndex(parameterIndex).x(Utils.byteArrayOutputStreamToBase64(byteArrayOutputStream)).base64Flag(true).build();
                        this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
                        break block14;
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
                }
            }
            this.delegate.setBinaryStream(parameterIndex, x);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        if (Transformer.COLLECT_PARAMS || MultiProperties.getSendCompareService()) {
            ByteArrayOutputStream byteArrayOutputStream = UnisqlCommonUtils.copyReaderToByteArrayOutputStream(value);
            this.delegate.setCharacterStream(parameterIndex, new InputStreamReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
            PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setCharacterStream").parameterIndex(parameterIndex).x(byteArrayOutputStream.toString()).vendorTypeNumber(12).build();
            this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
        } else {
            this.delegate.setCharacterStream(parameterIndex, value);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        if (Transformer.COLLECT_PARAMS || MultiProperties.getSendCompareService()) {
            ByteArrayOutputStream byteArrayOutputStream = UnisqlCommonUtils.copyReaderToByteArrayOutputStream(value);
            this.delegate.setNCharacterStream(parameterIndex, new InputStreamReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
            PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setNCharacterStream").parameterIndex(parameterIndex).x(byteArrayOutputStream.toString()).vendorTypeNumber(12).build();
            this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
        } else {
            this.delegate.setNCharacterStream(parameterIndex, value);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        block9: {
            if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
                return;
            }
            if (Transformer.COLLECT_PARAMS || MultiProperties.getSendCompareService()) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = UnisqlCommonUtils.copyReaderToByteArrayOutputStream(reader);
                    try (InputStreamReader bufferedReader1 = new InputStreamReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));){
                        this.delegate.setClob(parameterIndex, bufferedReader1);
                        PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setClob").parameterIndex(parameterIndex).x(Utils.byteArrayOutputStreamToBase64(byteArrayOutputStream)).base64Flag(true).build();
                        this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
                        break block9;
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
                }
            }
            this.delegate.setClob(parameterIndex, reader);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        block14: {
            if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
                return;
            }
            if (Transformer.COLLECT_PARAMS || MultiProperties.getSendCompareService()) {
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    this.copyInputStreamToByteArray(inputStream, byteArrayOutputStream);
                    try (ByteArrayInputStream inputStream1 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                        this.delegate.setBlob(parameterIndex, inputStream1);
                        PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setBlob").parameterIndex(parameterIndex).x(Utils.byteArrayOutputStreamToBase64(byteArrayOutputStream)).base64Flag(true).build();
                        this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
                        break block14;
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
                }
            }
            this.delegate.setBlob(parameterIndex, inputStream);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        block9: {
            if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
                return;
            }
            if (Transformer.COLLECT_PARAMS || MultiProperties.getSendCompareService()) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = UnisqlCommonUtils.copyReaderToByteArrayOutputStream(reader);
                    try (InputStreamReader bufferedReader1 = new InputStreamReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));){
                        this.delegate.setNClob(parameterIndex, bufferedReader1);
                        PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setNClob").parameterIndex(parameterIndex).x(Utils.byteArrayOutputStreamToBase64(byteArrayOutputStream)).base64Flag(true).build();
                        this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
                        break block9;
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
                }
            }
            this.delegate.setNClob(parameterIndex, reader);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setObject(i, x, targetSqlType, scaleOrLength);
            }
        } else {
            this.delegate.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }
        if (Transformer.COLLECT_PARAMS || Transformer.SEND_MQ_TO_COMPARE_SERVER) {
            PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setObject").parameterCount(4).parameterIndex(parameterIndex).x(x).targetSqlType(targetSqlType).scaleOrLength(scaleOrLength).build();
            this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        if ((parameterIndex = this.isCancelIndex(parameterIndex)) == 0) {
            return;
        }
        if (this.isNeedResetBindVariable()) {
            for (int i = 1; i <= this.bindVariableOrder.size(); ++i) {
                if (this.bindVariableOrder.get(i - 1) != parameterIndex) continue;
                this.delegate.setObject(i, x, targetSqlType);
            }
        } else {
            this.delegate.setObject(parameterIndex, x, targetSqlType);
        }
        if (Transformer.COLLECT_PARAMS || Transformer.SEND_MQ_TO_COMPARE_SERVER) {
            PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setObject").parameterCount(3).parameterIndex(parameterIndex).x(x).targetSqlType(targetSqlType).build();
            this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
        }
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return this.delegate.executeLargeUpdate();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return super.executeBatch();
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            super.clearBatch();
        }
        finally {
            if (Transformer.COLLECT_PARAMS || Transformer.SEND_MQ_TO_COMPARE_SERVER) {
                this.comparePreparedBindingVariablesBatch.clear();
            }
        }
    }

    public ArrayList<PreparedParameter> getSortObjectArrayList() {
        ArrayList<Map.Entry<Integer, PreparedParameter>> entryList = new ArrayList<Map.Entry<Integer, PreparedParameter>>(this.comparePreparedBindingVariables.entrySet());
        Collections.sort(entryList, Comparator.comparingInt(Map.Entry::getKey));
        ArrayList<PreparedParameter> x = new ArrayList<PreparedParameter>();
        for (Map.Entry entry : entryList) {
            x.add((PreparedParameter)entry.getValue());
        }
        return x;
    }

    private void copyInputStreamToByteArray(InputStream input, ByteArrayOutputStream output) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
    }

    private <T> ArrayList<T> getSortValueArrayList() {
        ArrayList<Map.Entry<Integer, PreparedParameter>> entryList = new ArrayList<Map.Entry<Integer, PreparedParameter>>(this.comparePreparedBindingVariables.entrySet());
        Collections.sort(entryList, Comparator.comparingInt(Map.Entry::getKey));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Map.Entry entry : entryList) {
            arrayList.add(((PreparedParameter)entry.getValue()).getX());
        }
        return arrayList;
    }

    public List<PreparedParameter> getPreparedParameters() {
        Collection<PreparedParameter> values = this.isNeedResetBindVariable() ? this.comparePreparedBindingVariables.values() : this.rawPreparedBindingVariables.values();
        return new ArrayList<PreparedParameter>(values);
    }

    public List<PreparedParameter> getRawPreparedParameters() {
        Collection<PreparedParameter> values = this.rawPreparedBindingVariables.values();
        return new ArrayList<PreparedParameter>(values);
    }

    protected static void registerReturnParameter(DbType sourceDialect, PreparedStatement delegate, Integer returnCount) throws SQLException {
        if (sourceDialect == DbType.ORACLE && returnCount != null && returnCount > 0 && delegate instanceof OraclePreparedStatement) {
            OraclePreparedStatement stmt = (OraclePreparedStatement)delegate;
            for (int i = 1; i <= returnCount; ++i) {
                stmt.registerReturnParameter(i, 12);
            }
        }
    }
}

