/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.utils;

import com.hundsun.lightdb.unisql.annotation.SuppressFBWarnings;
import com.hundsun.lightdb.unisql.constant.ErrorMessages;
import com.hundsun.lightdb.unisql.golang.ReturnParameter;
import com.hundsun.lightdb.unisql.golang.SqlState;
import com.hundsun.lightdb.unisql.golang.Transformer;
import com.hundsun.lightdb.unisql.golang.VariableParameter;
import com.hundsun.lightdb.unisql.model.MultiplexContext;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.utils.JsonUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLServerSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"COMMAND_INJECTION"})
public class UnisqlCommonUtils {
    private static final Logger log = LoggerFactory.getLogger(UnisqlCommonUtils.class);
    private static final ExecutorService ETL_OUTPUT_EXECUTOR = new ThreadPoolExecutor(3, 3, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100), new EtlOutputThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
    private static final int CORE_POOL_SIZE = 3;
    private static final int MAX_POOL_SIZE = 3;
    private static final int QUEUE_CAPACITY = 100;
    private static final long KEEP_ALIVE_TIME = 30L;

    public static ReturnParameter getReturnParameter(String sql, DbType sourceDialect, DbType targetDialect) {
        ReturnParameter returnParameter;
        block4: {
            returnParameter = null;
            VariableParameter variableParameter = new VariableParameter();
            variableParameter.setSourceSql(sql);
            variableParameter.setSourceDialect(sourceDialect.name());
            variableParameter.setTargetDialect(targetDialect.name());
            try {
                returnParameter = Transformer.getDqlByDml(variableParameter);
                if (!SqlState.SUCCESS.getState().equals(returnParameter.getState()) && log.isWarnEnabled()) {
                    log.warn("unisqlDmlDeriveDqlException  error is:{}", (Object)returnParameter.getMessage());
                }
            }
            catch (Exception exception) {
                if (!log.isErrorEnabled()) break block4;
                String msg = ErrorMessages.format(ErrorMessages.LTU0008, sourceDialect.name(), targetDialect.name(), sql);
                log.error(msg, (Throwable)exception);
            }
        }
        if (log.isDebugEnabled()) {
            log.info("\u591a\u53d1\u6267\u884c\u524d\u540e\u67e5\u8be2\u8f6c\u6362\u5b8c\u6210 traceId [{}] \u8fd4\u56de\u503c [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)JsonUtils.toJson(returnParameter));
        }
        return returnParameter;
    }

    public static String trimEndsWithSemicolon(String input) {
        if (input == null) {
            return input;
        }
        String trimmed = input.trim();
        if (trimmed.endsWith(";")) {
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        }
        return trimmed;
    }

    public static ReturnParameter getWithSqlReturnParameter(String sql, String sourceDialect, String targetDialect) {
        ReturnParameter returnParameter;
        block4: {
            returnParameter = null;
            VariableParameter variableParameter = new VariableParameter();
            variableParameter.setSourceSql(sql);
            variableParameter.setSourceDialect(sourceDialect);
            variableParameter.setTargetDialect(targetDialect);
            try {
                returnParameter = Transformer.IdentifySqlType(variableParameter);
                if (!SqlState.SUCCESS.getState().equals(returnParameter.getState()) && log.isWarnEnabled()) {
                    log.warn("unisqlDmlDeriveDqlException  error is:{}", (Object)returnParameter.getMessage());
                }
            }
            catch (Exception exception) {
                if (!log.isErrorEnabled()) break block4;
                String msg = ErrorMessages.format(ErrorMessages.LTU0008, sourceDialect, targetDialect, sql);
                log.error(msg, (Throwable)exception);
            }
        }
        if (log.isDebugEnabled()) {
            log.info("\u67e5\u8be2\u5e26with\u7684sql\u7c7b\u578b traceId [{}] \u8fd4\u56de\u503c [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)JsonUtils.toJson(returnParameter));
        }
        return returnParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findRandomAvailablePort() {
        ServerSocket serverSocket;
        try {
            serverSocket = SSLServerSocketFactory.getDefault().createServerSocket(0);
        }
        catch (Exception e) {
            log.error("Failed to find a random available port", (Throwable)e);
            return -1;
        }
        if (serverSocket == null) {
            return -1;
        }
        try {
            int e = serverSocket.getLocalPort();
            return e;
        }
        catch (Exception e) {
            log.error("Failed to find a random available port", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                serverSocket.close();
            }
            catch (Exception e) {
                log.error("Failed to find a random available port", (Throwable)e);
            }
        }
    }

    public static String executeClientCommand(String clientCommand, String etlLogPath) {
        String envOsName = "os.name";
        String envOsWindows = "win";
        if (System.getProperty(envOsName).toLowerCase().contains(envOsWindows)) {
            log.warn("windows\u4e0d\u652f\u6301\u6267\u884c\u5ba2\u6237\u7aef\u547d\u4ee4");
            return "windows\u4e0d\u652f\u6301\u6267\u884c\u5ba2\u6237\u7aef\u547d\u4ee4";
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("/bin/bash", "-c", clientCommand);
            Map<String, String> env = processBuilder.environment();
            env.put("ETL_LOG_PATH", etlLogPath);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            process.waitFor();
        }
        catch (Exception e) {
            log.error("\u5728\u76ee\u5f55({}/logs/lightdb-etl/{})\u4e0b\u6267\u884cetl\u7684\u5168\u8868\u6570\u636e\u8fc1\u79fb\u547d\u4ee4[{}]\u51fa\u9519\uff0c\u51fa\u9519\u539f\u56e0:", new Object[]{System.getProperty("user.dir"), etlLogPath, clientCommand, e});
            return e.getMessage();
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ByteArrayOutputStream copyReaderToByteArrayOutputStream(Reader value) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            ByteArrayOutputStream byteArrayOutputStream2;
            try (OutputStreamWriter writer = new OutputStreamWriter(byteArrayOutputStream);){
                int bytesRead;
                char[] buffer = new char[1024];
                while ((bytesRead = value.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, bytesRead);
                }
                ((Writer)writer).flush();
                byteArrayOutputStream2 = byteArrayOutputStream;
            }
            return byteArrayOutputStream2;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isInsertStmt(String sql) {
        if (sql == null) {
            return false;
        }
        String[] sqlParts = (sql = sql.replaceAll("(?s)/\\*.*?\\*/", "")).trim().split("\\s+");
        return sqlParts.length > 0 && sqlParts[0].equalsIgnoreCase("INSERT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeClientCommandForEtlDataSync(String clientCommand, String etlLogPath) {
        String envOsName = "os.name";
        String envOsWindows = "win";
        if (System.getProperty(envOsName).toLowerCase().contains(envOsWindows)) {
            log.warn("windows\u4e0d\u652f\u6301\u6267\u884c\u5ba2\u6237\u7aef\u547d\u4ee4");
            return "windows\u4e0d\u652f\u6301\u6267\u884c\u5ba2\u6237\u7aef\u547d\u4ee4";
        }
        Process process = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("/bin/bash", "-c", clientCommand);
            Map<String, String> env = processBuilder.environment();
            env.put("ETL_LOG_PATH", etlLogPath);
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
            UnisqlCommonUtils.readProcessOutput(process.getInputStream(), etlLogPath);
            process.waitFor();
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                String string = "\u5b50\u8fdb\u7a0b\u6267\u884c\u5f02\u5e38\uff0c\u9000\u51fa\u7801\uff1a" + exitCode + "\uff0c\u8be6\u60c5\u89c1\u65e5\u5fd7\uff1a" + etlLogPath + "/etl_subprocess.log";
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            log.error("\u6267\u884cetl\u547d\u4ee4[{}]\u51fa\u9519", (Object)clientCommand, (Object)e);
            String string = e.getMessage();
            return string;
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }

    private static void readProcessOutput(InputStream inputStream, String etlLogPath) {
        ETL_OUTPUT_EXECUTOR.submit(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                String userDir = System.getProperty("user.dir");
                log.info("\u83b7\u53d6\u5f53\u524d\u5de5\u4f5c\u76ee\u5f55\uff08user.dir\uff09\uff1a{}", (Object)userDir);
                String etlInitialDir = new File(userDir, "logs/lightdb-etl").getAbsolutePath();
                log.info("\u83b7\u53d6etl\u521d\u59cb\u76ee\u5f55\uff1a{}", (Object)etlInitialDir);
                String etlWorkPath = String.format("%s/%s", etlInitialDir, etlLogPath);
                log.info("\u83b7\u53d6etl\u5de5\u4f5c\u76ee\u5f55\uff1a{}", (Object)etlWorkPath);
                String formatLogFilePath = String.format(etlWorkPath + "/etl_subprocess.log%s", "");
                log.info("\u65e5\u5fd7\u6587\u4ef6\u8def\u5f84:{}", (Object)formatLogFilePath);
                File logFile = new File(formatLogFilePath);
                File parentDir = logFile.getParentFile();
                if (parentDir != null && !parentDir.exists()) {
                    parentDir.mkdirs();
                }
                try (FileWriter writer = new FileWriter(logFile, true);){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        writer.write(line + System.lineSeparator());
                        log.info("\u5b50\u8fdb\u7a0b\u8f93\u51fa: {}", (Object)line);
                    }
                }
            }
            catch (IOException e) {
                log.error("\u8bfb\u53d6\u5b50\u8fdb\u7a0b\u8f93\u51fa\u6d41\u5931\u8d25", (Throwable)e);
            }
        });
    }

    private static class EtlOutputThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        private EtlOutputThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("etl-output-reader-" + this.threadNumber.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }
}

