/*
 * Decompiled with CFR 0.152.
 */
package shaded.jnr.ffi.provider.jffi;

import java.util.Collection;
import java.util.Map;
import shaded.jnr.ffi.LibraryLoader;
import shaded.jnr.ffi.LibraryOption;
import shaded.jnr.ffi.provider.jffi.AsmLibraryLoader;
import shaded.jnr.ffi.provider.jffi.NativeLibrary;
import shaded.jnr.ffi.provider.jffi.ReflectionLibraryLoader;
import shaded.jnr.ffi.provider.jffi.Util;

class NativeLibraryLoader<T>
extends LibraryLoader<T> {
    static final boolean ASM_ENABLED = Util.getBooleanProperty("shaded.jnr.ffi.asm.enabled", true);

    NativeLibraryLoader(Class<T> interfaceClass) {
        super(interfaceClass);
    }

    @Override
    public T loadLibrary(Class<T> interfaceClass, Collection<String> libraryNames, Collection<String> searchPaths, Map<LibraryOption, Object> options) {
        NativeLibrary nativeLibrary = new NativeLibrary(libraryNames, searchPaths);
        try {
            return ASM_ENABLED ? new AsmLibraryLoader().loadLibrary(nativeLibrary, interfaceClass, options) : new ReflectionLibraryLoader().loadLibrary(nativeLibrary, interfaceClass, options);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

