/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.upgrade;

import com.hundsun.jrescloud.common.boot.CloudApplication;
import com.hundsun.lightdb.unisql.upgrade.CommandParser;
import com.hundsun.lightdb.unisql.upgrade.SqlExecutor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@CloudApplication
public class UniSqlUpgradeApplication {
    private static final Logger log = LoggerFactory.getLogger(UniSqlUpgradeApplication.class);
    private static final String VERSION = "VERSION";
    private static final String USER_DIR = "user.dir";
    private static final String PARENT_DIR = "..";
    private static final String ALL_SQL_DIR = "all";
    private static final String UNISQL_PATCH_SQL_FORMAT_NAME = "unisql-patch-%s.sql";
    private static final String TO = "2";
    private static final String UNISQL_SCHEMA = "unisql";
    private static final String REGEX_POINT = "\\.";
    private static final String UNISQL_VERSION_FORMAT = "%02d%02d%02d%03d";
    public static final int MIN_VERSION_LENGTH = 2;
    public static final int VERSION_THREE_SEGMENT = 3;
    private static final int MAX_VERSION_LENGTH = 4;
    public static final int VERSION_THREE_SEGMENT_MAX = 99;
    public static final int VERSION_FOUR_SEGMENT_MAX = 999;
    public static final String BETA = "beta";
    static String versionNowString;
    static String versionOldString;
    static int versionNow;
    static int versionOld;

    public static void main(String[] args) throws Exception {
        UniSqlUpgradeApplication.run((String[])args);
    }

    public static void run(String ... args) throws Exception {
        CommandParser parser = null;
        try {
            parser = new CommandParser(args);
        }
        catch (ParseException e) {
            System.exit(1);
        }
        UniSqlUpgradeApplication.check((CommandParser)parser);
        SqlExecutor executor = new SqlExecutor(parser.getSource(), parser.getTarget(), parser.getHost(), parser.getPort(), parser.getDatabase(), parser.getSchema(), parser.getUsername(), parser.getPassword());
        if (!executor.isDatabaseConnectionValid()) {
            System.exit(1);
        }
        String currentDir = System.getProperty("user.dir");
        if (log.isInfoEnabled()) {
            log.info("\u5f53\u524d\u76ee\u5f55: {}", (Object)currentDir);
        }
        if (!UniSqlUpgradeApplication.getVersionOfFile((String)currentDir)) {
            System.exit(1);
        }
        TreeMap executedScripts = new TreeMap();
        String source2target = parser.getSource().toLowerCase() + "2" + parser.getTarget().toLowerCase();
        if (parser.hasAllOption()) {
            UniSqlUpgradeApplication.executeAll((String)currentDir, (String)source2target, (CommandParser)parser, (SqlExecutor)executor, executedScripts);
        } else {
            UniSqlUpgradeApplication.traverseVersion((SqlExecutor)executor, (CommandParser)parser, (String)currentDir, (String)source2target, executedScripts);
        }
        UniSqlUpgradeApplication.updateUniSqlVersion(executedScripts, (SqlExecutor)executor);
    }

    private static void updateUniSqlVersion(Map<String, String> executedScripts, SqlExecutor executor) {
        if (!executedScripts.isEmpty()) {
            try {
                if (executor.tableIsExists()) {
                    LinkedHashMap<String, String> sqlMap = new LinkedHashMap<String, String>();
                    sqlMap.put("1", executor.targetUniSqlVersion.getCreateUniSqlVersionSql());
                    executor.executeCommand(sqlMap);
                    executor.updateOrInsertVersion(executor.targetUniSqlVersion.getInsertUniSqlVersionSql(), versionNowString);
                } else if (executor.getVersion() != null) {
                    executor.updateOrInsertVersion(executor.targetUniSqlVersion.getUpdateUniSqlVersionSql(), versionNowString);
                } else {
                    executor.updateOrInsertVersion(executor.targetUniSqlVersion.getInsertUniSqlVersionSql(), versionNowString);
                }
            }
            catch (Exception e) {
                System.exit(1);
            }
            if (log.isInfoEnabled()) {
                log.info("\u66f4\u65b0\u6570\u636e\u5e93\u4e2d\u7248\u672c\u53f7\u6210\u529f\uff01\u5f53\u524d\u7248\u672c\u53f7\uff1a{}", (Object)versionNowString);
            }
            for (Map.Entry<String, String> entry : executedScripts.entrySet()) {
                if (!log.isInfoEnabled()) continue;
                log.info("\u6267\u884c\u8fc7\u7684\u811a\u672c\u7248\u672c\u53f7\uff1a{},\u811a\u672c\u8def\u5f84\uff1a{}", (Object)entry.getKey(), (Object)entry.getValue());
            }
            if (log.isInfoEnabled()) {
                log.info("\u811a\u672c\u6267\u884c\u5b8c\u6210\uff01");
                log.info("\u7a0b\u5e8f\u6b63\u5e38\u9000\u51fa\uff01");
            }
            System.exit(0);
        } else {
            if (log.isWarnEnabled()) {
                log.warn("\u672a\u6267\u884c\u4efb\u4f55\u811a\u672c\uff01\u7a0b\u5e8f\u6b63\u5e38\u9000\u51fa\uff01");
            }
            System.exit(0);
        }
    }

    private static void traverseVersion(SqlExecutor executor, CommandParser parser, String currentDir, String source2target, Map<String, String> executedScripts) {
        String version = null;
        try {
            if (executor.tableIsExists()) {
                if (log.isErrorEnabled()) {
                    log.error("unisql_version\u7248\u672c\u53f7\u4fe1\u606f\u8868\u672a\u67e5\u5230\uff0c\u8bf7\u786e\u8ba4\u7528\u6237\u5bf9[{}]schema\u6216\u6570\u636e\u5e93\u5177\u6709\u8bbf\u95ee\u548c\u6267\u884c\u7684\u6743\u9650\uff0c\u5e76\u4e14\u9700\u8981\u7ef4\u62a4\u7248\u672c\u53f7\u4fe1\u606f\u8868\uff01", (Object)parser.getSchema());
                }
                System.exit(1);
            }
            version = executor.getVersion();
        }
        catch (Exception e) {
            System.exit(1);
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            if (log.isErrorEnabled()) {
                log.error("unisql_version\u8868\u4e2did=1\u6570\u636e\u4e0d\u6b63\u786e\uff0c\u8bf7\u5148\u7ef4\u62a4\u7248\u672c\u53f7\u4fe1\u606f\uff01");
            }
            System.exit(1);
        }
        try {
            versionOld = Integer.parseInt(UniSqlUpgradeApplication.formatVersionToFourSegments((String)version.trim()));
            versionOldString = version.trim();
        }
        catch (NumberFormatException e) {
            if (log.isErrorEnabled()) {
                log.error("\u6570\u636e\u5e93\u4e2d\u7248\u672c\u53f7\u4e0d\u6b63\u786e: {}", (Object)version);
            }
            System.exit(1);
        }
        if (log.isInfoEnabled()) {
            log.info("\u6570\u636e\u5e93\u4e2d\u7248\u672c\u53f7\uff1a{}", (Object)version);
        }
        if (StringUtils.isNotBlank((CharSequence)parser.getVersion())) {
            try {
                String versionNewString = parser.getVersion();
                int versionNew = Integer.parseInt(UniSqlUpgradeApplication.formatVersionToFourSegments((String)versionNewString));
                if (versionNew > versionNow) {
                    if (log.isErrorEnabled()) {
                        log.error("\u8f93\u5165\u7684\u7248\u672c\u53f7[{}]\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u5b89\u88c5\u5305\u7248\u672c\u53f7[{}]\uff01", (Object)versionNewString, (Object)versionNowString);
                    }
                    System.exit(1);
                }
                versionNow = versionNew;
                versionNowString = versionNewString;
            }
            catch (NumberFormatException e) {
                if (log.isErrorEnabled()) {
                    log.error("\u8f93\u5165\u7684\u7248\u672c\u53f7\u4e0d\u6b63\u786e: {}", (Object)parser.getVersion());
                }
                System.exit(1);
            }
        }
        if (log.isInfoEnabled()) {
            log.info("\u5347\u7ea7\u5230\u7248\u672c\u53f7\uff1a{}", (Object)versionNowString);
        }
        if (versionOld > versionNow) {
            if (log.isErrorEnabled()) {
                log.error("\u4e0d\u652f\u6301\u4ece\u9ad8\u7248\u672c[{}]\u5347\u7ea7\u5230\u4f4e\u7248\u672c[{}]\uff01", (Object)versionOldString, (Object)versionNowString);
            }
            System.exit(1);
        }
        if (versionOld == versionNow) {
            if (log.isInfoEnabled()) {
                log.info("\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5230\u7684\u7248\u672c\u53f7[{}]\uff0c\u8ddf\u5f53\u524d\u7248\u672c\u53f7[{}]\u76f8\u540c\uff0c\u65e0\u9700\u6267\u884c\uff01", (Object)versionOldString, (Object)versionNowString);
                log.info("\u7a0b\u5e8f\u6b63\u5e38\u9000\u51fa\uff01");
            }
            System.exit(0);
        }
        UniSqlUpgradeApplication.executeIncrement((SqlExecutor)executor, (CommandParser)parser, (String)currentDir, (String)source2target, executedScripts);
    }

    private static void executeIncrement(SqlExecutor executor, CommandParser parser, String currentDir, String source2target, Map<String, String> executedScripts) {
        if (versionOld < versionNow) {
            File[] files = new File(currentDir = String.format(currentDir + "%s", FilenameUtils.getName((String)""))).listFiles();
            if (files == null) {
                if (log.isErrorEnabled()) {
                    log.error("\u5f53\u524d\u76ee\u5f55\u4e0b\u6ca1\u6709\u6587\u4ef6\uff01{}", (Object)currentDir);
                }
                System.exit(1);
            }
            TreeMap<Integer, String> map = new TreeMap<Integer, String>();
            for (File file : files) {
                int dirNum;
                if (!file.isDirectory()) continue;
                String dirName = file.getName();
                try {
                    dirNum = Integer.parseInt(UniSqlUpgradeApplication.formatVersionToFourSegments((String)dirName));
                }
                catch (Exception e) {
                    continue;
                }
                if (dirNum <= versionOld || dirNum > versionNow) continue;
                map.put(dirNum, dirName);
            }
            if (map.isEmpty()) {
                if (log.isInfoEnabled()) {
                    log.info("\u6ca1\u6709\u627e\u5230\u9700\u8981\u5347\u7ea7\u7684\u811a\u672c\uff0c\u65e0\u9700\u6267\u884c\uff01");
                    log.info("\u7a0b\u5e8f\u6b63\u5e38\u9000\u51fa\uff01");
                }
                System.exit(0);
            }
            for (Map.Entry entry : map.entrySet()) {
                String dirName = (String)entry.getValue();
                String dirPath = currentDir + File.separator + dirName;
                if (log.isInfoEnabled()) {
                    log.info("\u8fdb\u5165\u589e\u91cf\u7248\u672c\u76ee\u5f55\uff1a{}", (Object)dirPath);
                }
                String path = dirPath + File.separator + source2target;
                File pathSource2target = new File(path = String.format(path + "%s", FilenameUtils.getName((String)"")));
                if (pathSource2target.exists() && pathSource2target.isDirectory()) {
                    path = path + File.separator + String.format("unisql-patch-%s.sql", dirName);
                    File pathSource2targetSql = new File(path = String.format(path + "%s", FilenameUtils.getName((String)"")));
                    if (pathSource2targetSql.exists() && pathSource2targetSql.isFile()) {
                        Map sqlMap = null;
                        try {
                            sqlMap = SqlExecutor.parseSqlFile((String)path);
                            if (log.isInfoEnabled()) {
                                log.info("\u6267\u884c\u589e\u91cf\u811a\u672c\uff1a" + path);
                            }
                            if (!"unisql".equalsIgnoreCase(parser.getSchema())) {
                                if (log.isWarnEnabled()) {
                                    log.warn("\u5f53\u524d\u8f93\u5165\u6a21\u5f0f\u4e3a[{}]\uff0c\u975eunisql\u6a21\u5f0f\uff0c\u5c06\u66ff\u6362\u4e3a[{}]", (Object)parser.getSchema(), (Object)parser.getSchema());
                                }
                                SqlExecutor.replaceSchema((Map)sqlMap, (String)parser.getSchema());
                            }
                            executor.executeCommand(sqlMap);
                        }
                        catch (Exception e) {
                            System.exit(1);
                        }
                        if (log.isInfoEnabled()) {
                            log.info("\u6267\u884c\u589e\u91cf\u811a\u672c\u6210\u529f\uff01\uff1a{}", (Object)path);
                        }
                        executedScripts.put(dirName, path);
                        continue;
                    }
                    if (!log.isInfoEnabled()) continue;
                    log.info("[{}]\u7248\u672c\u4e0b,\u6e90\u7aef\u5230\u76ee\u6807\u7aef[{}]\u6ca1\u6709\u627e\u5230\u9700\u8981\u5347\u7ea7\u7684\u811a\u672c[{}]\uff0c\u65e0\u9700\u6267\u884c\uff0c\u8df3\u8fc7\uff01", new Object[]{dirName, source2target, path});
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                log.info("[{}]\u7248\u672c\u4e0b\uff0c\u6e90\u7aef\u5230\u76ee\u6807\u7aef[{}]\u6ca1\u6709\u627e\u5230\u9700\u8981\u5347\u7ea7\u7684\u811a\u672c[{}]\uff0c\u65e0\u9700\u6267\u884c\uff0c\u8df3\u8fc7\uff01", new Object[]{dirName, source2target, path});
            }
        }
    }

    private static void executeAll(String currentDir, String source2target, CommandParser parser, SqlExecutor executor, Map<String, String> executedScripts) {
        String path = currentDir + File.separator + "all" + File.separator + source2target;
        File pathSource2target = new File(path = String.format(path + "%s", FilenameUtils.getName((String)"")));
        if (pathSource2target.exists() && pathSource2target.isDirectory()) {
            path = path + File.separator + String.format("unisql-patch-%s.sql", "all");
            File pathSource2targetSql = new File(path = String.format(path + "%s", FilenameUtils.getName((String)"")));
            if (pathSource2targetSql.exists() && pathSource2targetSql.isFile()) {
                Map sqlMap = null;
                try {
                    sqlMap = SqlExecutor.parseSqlFile((String)path);
                    if (log.isInfoEnabled()) {
                        log.info("\u6267\u884c\u5168\u91cf\u811a\u672c\uff1a{}", (Object)path);
                    }
                    if (!"unisql".equalsIgnoreCase(parser.getSchema())) {
                        if (log.isWarnEnabled()) {
                            log.warn("\u5f53\u524d\u8f93\u5165\u6a21\u5f0f\u4e3a[{}]\uff0c\u975eunisql\u6a21\u5f0f\uff0c\u5c06\u66ff\u6362\u4e3a[{}]", (Object)parser.getSchema(), (Object)parser.getSchema());
                        }
                        SqlExecutor.replaceSchema((Map)sqlMap, (String)parser.getSchema());
                    }
                    executor.executeCommand(sqlMap);
                }
                catch (Exception e) {
                    System.exit(1);
                }
                if (log.isInfoEnabled()) {
                    log.info("\u6267\u884c\u5168\u91cf\u811a\u672c\u6210\u529f\uff01\uff1a{}", (Object)path);
                }
                executedScripts.put(versionNowString, path);
            } else {
                if (log.isInfoEnabled()) {
                    log.info("\u6e90\u7aef\u5230\u76ee\u6807\u7aef[{}]\u7684\u5168\u91cf\u811a\u672c[{}]\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u6267\u884c\uff01", (Object)source2target, (Object)path);
                    log.info("\u7a0b\u5e8f\u6b63\u5e38\u9000\u51fa\uff01");
                }
                System.exit(0);
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info("\u6e90\u7aef\u5230\u76ee\u6807\u7aef[{}]\u7684\u5168\u91cf\u811a\u672c\u76ee\u5f55[{}]\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u6267\u884c\uff01", (Object)source2target, (Object)path);
                log.info("\u7a0b\u5e8f\u6b63\u5e38\u9000\u51fa\uff01");
            }
            System.exit(0);
        }
    }

    private static void check(CommandParser parser) {
        if (parser.hasHelpOption()) {
            CommandParser.printHelp();
            System.exit(0);
        }
        if (!parser.validateRequiredOptions()) {
            if (log.isInfoEnabled()) {
                log.info("\u7f3a\u5c11\u5165\u53c2\u4fe1\u606f\u3002\u8bf7\u901a\u8fc7 java -jar unisql-upgrade-<version>.jar \u2013help \u67e5\u770b\u4f7f\u7528\u660e\u7ec6\u3002");
            }
            System.exit(1);
        }
        if (!parser.checkParameters()) {
            System.exit(1);
        }
        if (log.isInfoEnabled()) {
            String version = StringUtils.isBlank((CharSequence)parser.getVersion()) ? "" : parser.getVersion();
            log.info("\u53c2\u6570\u503c\uff1asource[{}],target[{}],host[{}],port[{}],username[{}],password[{}],dbname[{}],schema[{}],all[{}],version[{}]", new Object[]{parser.getSource(), parser.getTarget(), parser.getHost(), parser.getPort(), parser.getUsername(), parser.getPassword(), parser.getDatabase(), parser.getSchema(), parser.hasAllOption(), version});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean getVersionOfFile(String currentDir) {
        String versionDir = currentDir + File.separator + ".." + File.separator + "VERSION";
        File versionFile = new File(versionDir = String.format(versionDir + "%s", FilenameUtils.getName((String)"")));
        if (versionFile.exists() && versionFile.isFile()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(versionFile));
                try {
                    String firstLine = reader.readLine();
                    if (firstLine != null && !firstLine.trim().isEmpty()) {
                        try {
                            versionNow = Integer.parseInt(UniSqlUpgradeApplication.formatVersionToFourSegments((String)firstLine.trim()));
                            versionNowString = firstLine.trim();
                        }
                        catch (NumberFormatException e) {
                            if (log.isInfoEnabled()) {
                                log.error("VERSION\u6587\u4ef6[{}]\u4e2d\u7248\u672c\u53f7\u4e0d\u6b63\u786e:{} ", (Object)versionFile.getPath(), (Object)firstLine.trim());
                            }
                            boolean bl = false;
                            reader.close();
                            return bl;
                        }
                        if (!log.isInfoEnabled()) return true;
                        log.info("VERSION\u6587\u4ef6\u4e2d\u7248\u672c\u53f7[{}]", (Object)firstLine.trim());
                        return true;
                    }
                    if (log.isErrorEnabled()) {
                        log.error("VERSION\u6587\u4ef6[{}]\u4e2d\u7248\u672c\u53f7\u4e3a\u7a7a\uff01\u8bf7\u68c0\u67e5\uff01", (Object)versionFile.getPath());
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) return false;
                log.error("\u8bfb\u53d6VERSION\u6587\u4ef6[{}]\u5931\u8d25:{} ", (Object)versionFile.getPath(), (Object)e.getMessage());
                return false;
            }
        }
        if (!log.isErrorEnabled()) return false;
        log.error("VERSION\u6587\u4ef6[{}]\u672a\u627e\u5230\uff01", (Object)versionFile.getPath());
        return false;
    }

    public static String formatVersionToFourSegments(String input) {
        int i;
        int length;
        String[] segments = input.split("\\.");
        String lastSegment = segments[(length = segments.length) - 1];
        if (lastSegment.startsWith("beta")) {
            --length;
        }
        if (length > 4 || length < 2) {
            throw new IllegalArgumentException("\u8f93\u5165\u7684\u7248\u672c\u53f7\u4e0d\u6b63\u786e\uff01");
        }
        if (length == 2 && StringUtils.isBlank((CharSequence)segments[1])) {
            throw new IllegalArgumentException("\u8f93\u5165\u7684\u7248\u672c\u53f7\u4e0d\u6b63\u786e\uff01");
        }
        int[] formattedParts = new int[4];
        for (i = 0; i < length; ++i) {
            try {
                formattedParts[i] = Integer.parseInt(segments[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("\u7248\u672c\u53f7\u683c\u5f0f\u9519\u8bef\uff1a\u5305\u542b\u975e\u6570\u5b57\u5185\u5bb9");
            }
        }
        for (i = 0; i < 3; ++i) {
            if (formattedParts[i] >= 0 && formattedParts[i] <= 99) continue;
            throw new IllegalArgumentException("\u7248\u672c\u53f7\u683c\u5f0f\u9519\u8bef\uff1a\u524d\u4e09\u6bb5\u5fc5\u987b\u5728 0 \u5230 99 \u8303\u56f4\u5185");
        }
        if (formattedParts[3] < 0 || formattedParts[3] > 999) {
            throw new IllegalArgumentException("\u7248\u672c\u53f7\u683c\u5f0f\u9519\u8bef\uff1a\u7b2c\u56db\u6bb5\u5fc5\u987b\u5728 0 \u5230 999 \u8303\u56f4\u5185");
        }
        return String.format("%02d%02d%02d%03d", formattedParts[0], formattedParts[1], formattedParts[2], formattedParts[3]);
    }
}

