-- SQL --  创建unisql模式
CREATE SCHEMA IF NOT EXISTS unisql;

-- SQL --  授权模式给public
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
-- SQL --  授予所有用户对 unisql schema 中所有表的查询权限
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
-- SQL --  设置默认权限，确保未来新建的表、函数、存储过程自动赋予 PUBLIC 相应权限
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
-- SQL --  创建months_between函数
CREATE OR REPLACE FUNCTION unisql.months_between( p_ts1 timestamptz
                                                    , p_ts2 timestamptz)
RETURNS double precision IMMUTABLE strict parallel safe AS $$
select case when dd1 = dd2 or (m1 = dd1 and m2 = dd2)
                then yd * 12 + mmd
            else yd * 12 + mmd
                + (dd1 - dd2) / 31
                + hd / 31 / 24
                + md / 31 / 24 / 60
                + sd / 31 / 24 / 60 / 60
           end
from (select extract('day' from date_trunc('month', p_ts1) + interval '1 month -1 day') as m1
           , extract('day' from date_trunc('month', p_ts2) + interval '1 month -1 day') as m2
           , extract('year' from p_ts1) - extract('year' from p_ts2) as yd
           , extract('month' from p_ts1) - extract('month' from p_ts2) as mmd
           , extract('day' from p_ts1) as dd1
           , extract('day' from p_ts2) as dd2
           , extract('hour' from p_ts1) - extract('hour' from p_ts2) as hd
           , extract('minute' from p_ts1) - extract('minute' from p_ts2) as md
           , extract('second' from p_ts1) - extract('second' from p_ts2) as sd
     ) as x;
$$ LANGUAGE sql;

-- SQL --  创建instr函数
CREATE OR REPLACE FUNCTION unisql.instr(string varchar, string_to_search varchar,
                      beg_index integer, occur_index integer)
    RETURNS integer AS $$
DECLARE
pos integer NOT NULL DEFAULT 0;
    occur_number integer NOT NULL DEFAULT 0;
    temp_str varchar;
    beg integer;
    i integer;
    length integer;
    ss_length integer;
begin
	if beg_index = 0 then
		return 0;
    elseIF beg_index > 0 THEN
        beg := beg_index;
        temp_str := substring(string FROM beg_index);
FOR i IN 1..occur_index LOOP
            pos := position(string_to_search IN temp_str);
            IF i = 1 THEN
                beg := beg + pos - 1;
ELSE
                beg := beg + pos;
END IF;
            temp_str := substring(string FROM beg + 1);
END LOOP;
        IF pos = 0 THEN
            RETURN 0;
ELSE
            RETURN beg;
END IF;
ELSE
        ss_length := char_length(string_to_search);
        length := char_length(string);
        beg :=  LEAST (length + beg_index ,length - ss_length) + 1  ;
        raise info '%,%,%',length + beg_index ,length - ss_length,beg;
        WHILE beg > 0 LOOP
            temp_str := substring(string FROM beg FOR ss_length);
            pos := position(string_to_search IN temp_str);
            IF pos > 0 THEN
                occur_number := occur_number + 1;
                IF occur_number = occur_index THEN
                    RETURN beg;
END IF;
END IF;
            beg := beg - 1;
END LOOP;
RETURN 0;
END IF;
END;
$$ LANGUAGE plpgsql STRICT IMMUTABLE;

-- SQL --  创建instr函数
CREATE OR REPLACE FUNCTION unisql.instr(string varchar, string_to_search varchar,
                      beg_index integer)
    RETURNS integer AS $$
declare
occur_index integer NOT NULL DEFAULT 1;
pos integer NOT NULL DEFAULT 0;
    occur_number integer NOT NULL DEFAULT 0;
    temp_str varchar;
    beg integer;
    i integer;
    length integer;
    ss_length integer;

begin
	if beg_index = 0 then
		return 0;
    elseIF beg_index > 0 THEN
        beg := beg_index;
        temp_str := substring(string FROM beg_index);
FOR i IN 1..occur_index LOOP
            pos := position(string_to_search IN temp_str);
            IF i = 1 THEN
                beg := beg + pos - 1;
ELSE
                beg := beg + pos;
END IF;
            temp_str := substring(string FROM beg + 1);
END LOOP;
        IF pos = 0 THEN
            RETURN 0;
ELSE
            RETURN beg;
END IF;
ELSE
        ss_length := char_length(string_to_search);
        length := char_length(string);
        beg :=  LEAST (length + beg_index ,length - ss_length) + 1  ;
        raise info '%,%,%',length + beg_index ,length - ss_length,beg;
        WHILE beg > 0 LOOP
            temp_str := substring(string FROM beg FOR ss_length);
            pos := position(string_to_search IN temp_str);
            IF pos > 0 THEN
                occur_number := occur_number + 1;
                IF occur_number = occur_index THEN
                    RETURN beg;
END IF;
END IF;
            beg := beg - 1;
END LOOP;
RETURN 0;
END IF;
END;
$$ LANGUAGE plpgsql STRICT IMMUTABLE;

-- SQL --  创建substr函数
CREATE OR REPLACE FUNCTION unisql.substr(TEXT, int4)
RETURNS TEXT LANGUAGE SQL AS $$
SELECT pg_catalog.substr(
               $1,
               CASE WHEN $2 = 0 THEN
                        1
                    WHEN $2 < 0 THEN
                            LENGTH ( $1 ) + $2 + 1 ELSE $2
                   END
           ) $$;

-- SQL --  创建substr函数
CREATE OR REPLACE FUNCTION unisql.substr(TEXT, int4, int4)
RETURNS TEXT LANGUAGE SQL AS $$
    SELECT pg_catalog.substr(
               $1,
               CASE WHEN $2 = 0 THEN
                        1
                    WHEN $2 < 0 THEN
                            LENGTH ( $1 ) + $2 + 1 ELSE $2
                   END,
               CASE WHEN $3 <= 0 THEN
                        NULL ELSE $3
                   END
           ) $$;

-- SQL --  创建regexp_substr函数
CREATE OR REPLACE FUNCTION unisql.regexp_substr(text, text)

RETURNS text

AS $$

DECLARE

v_substr text;

  v_pattern text;

BEGIN

  v_pattern := '(' || $2 || ')';

  v_substr := (SELECT (regexp_matches($1, v_pattern, 'pg'))[1] OFFSET 0 LIMIT 1);

RETURN v_substr;

END;

$$

LANGUAGE plpgsql;

-- SQL --  创建regexp_substr函数
CREATE OR REPLACE FUNCTION unisql.regexp_substr(text, text, int)

RETURNS text

AS $$

DECLARE

v_substr text;

  v_pattern text;

BEGIN

  IF $3 < 1 THEN

    RAISE EXCEPTION 'argument ''position'' must be a number greater than 0';

END IF;

  v_pattern := '(' || $2 || ')';

  v_substr := (SELECT (regexp_matches(substr($1, $3), v_pattern, 'pg'))[1] OFFSET 0 LIMIT 1);

RETURN v_substr;

END;

$$

LANGUAGE plpgsql;

-- SQL --  创建regexp_substr函数
CREATE OR REPLACE FUNCTION unisql.regexp_substr(text, text, integer, integer)

RETURNS text

AS $$

DECLARE

v_substr text;

  v_pattern text;

BEGIN

  IF $3 < 1 THEN

    RAISE EXCEPTION 'argument ''position'' must be a number greater than 0';

END IF;

  IF $4 < 1 THEN

    RAISE EXCEPTION 'argument ''occurence'' must be a number greater than 0';

END IF;

  v_pattern := '(' || $2 || ')';

  v_substr := (SELECT (regexp_matches(substr($1, $3), v_pattern, 'pg'))[1] OFFSET $4 - 1 LIMIT 1);

RETURN v_substr;

END;

$$

LANGUAGE plpgsql;


-- SQL --  创建regexp_substr函数
CREATE OR REPLACE FUNCTION unisql.regexp_substr(text, text, integer, integer, text)
RETURNS text
AS $$
DECLARE
v_substr text;
  v_pattern text;
  modifiers text;
BEGIN
  IF $1 IS NULL OR $2 IS NULL OR $3 IS NULL OR $4 IS NULL THEN
    RETURN NULL;
END IF;
  IF $3 < 1 THEN
    RAISE EXCEPTION 'argument ''position'' must be a number greater than 0';
END IF;
  IF $4 < 1 THEN
    RAISE EXCEPTION 'argument ''occurence'' must be a number greater than 0';
END IF;

  modifiers := unisql.translate_oracle_modifiers($5, true);
  v_pattern := '(' || $2 || ')';
  v_substr := (SELECT (regexp_matches(substr($1, $3), v_pattern, modifiers))[1] OFFSET $4 - 1 LIMIT 1);
RETURN v_substr;
END;
$$
LANGUAGE plpgsql;


-- SQL --  创建regexp_substr函数
CREATE OR REPLACE FUNCTION unisql.regexp_substr(text, text, integer, integer, text, int)
RETURNS text
AS $$
DECLARE
v_substr text;
  v_pattern text;
  modifiers text;
  v_subexpr integer := $6;
  has_group integer;
BEGIN
  IF $1 IS NULL OR $2 IS NULL OR $3 IS NULL OR $4 IS NULL OR $6 IS NULL THEN
    RETURN NULL;
END IF;
  IF $3 < 1 THEN
    RAISE EXCEPTION 'argument ''position'' must be a number greater than 0';
END IF;
  IF $4 < 1 THEN
    RAISE EXCEPTION 'argument ''occurence'' must be a number greater than 0';
END IF;
  IF v_subexpr < 0 THEN
    RAISE EXCEPTION 'argument ''group'' must be a positive number';
END IF;

  has_group := (SELECT count(*) FROM regexp_matches($2, '(?:[^\\]|^)\(', 'g'));
  IF $6 = 1 AND has_group = 0 THEN
    RETURN NULL;
END IF;

  modifiers := unisql.translate_oracle_modifiers($5, true);

  IF v_subexpr = 0 THEN
    v_pattern := '(' || $2 || ')';
    v_subexpr := 1;
ELSE
    v_pattern := $2;
END IF;

  v_substr := (SELECT (regexp_matches(substr($1, $3), v_pattern, modifiers))[v_subexpr] OFFSET $4 - 1 LIMIT 1);
RETURN v_substr;
END;
$$
LANGUAGE plpgsql;

-- SQL --  创建last_day函数
CREATE OR REPLACE FUNCTION unisql.last_day(TIMESTAMPTZ)
RETURNS TIMESTAMP
AS $$ SELECT (date_trunc('MONTH', $1) + INTERVAL '1 MONTH - 1 day' + $1::time)::timestamp(0); $$
LANGUAGE SQL IMMUTABLE STRICT;

-- SQL --  创建translate_oracle_modifiers函数
CREATE OR REPLACE FUNCTION unisql.translate_oracle_modifiers(text, bool)
RETURNS text
AS $$
DECLARE
modifiers text;
BEGIN
  IF $1 ~ '[^icnsmx]' THEN
    RAISE EXCEPTION 'argument ''flags'' has unsupported modifier(s).';
END IF;
  modifiers := translate($1, 'nm', 'sn');
  IF $2 THEN
    modifiers := modifiers || 'g';
END IF;
RETURN modifiers;
END;
$$
LANGUAGE plpgsql;

-- SQL --  创建regexp_like函数
CREATE OR REPLACE FUNCTION unisql.regexp_like(text, text)
 RETURNS boolean
 LANGUAGE sql
AS $function$
SELECT CASE WHEN (count(*) > 0) THEN true ELSE false END FROM regexp_matches($1, $2, 'p');
$function$;

-- SQL --  创建regexp_like函数
CREATE OR REPLACE FUNCTION unisql.regexp_like(text, text, text)
 RETURNS boolean
 LANGUAGE plpgsql
AS $function$
DECLARE
modifiers text;
BEGIN
  modifiers := unisql.translate_oracle_modifiers($3, false);
  IF (regexp_matches($1, $2, modifiers))[1] IS NOT NULL THEN
    RETURN true;
END IF;
RETURN false;
END;
$function$;