-- SQL --  创建unisql模式
do language 'plpgsql'
$body$
    declare
        create_mark int;
    begin
        select count(1) into create_mark from pg_namespace where nspname='unisql';
        if create_mark = 0 then
create schema unisql;
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
            raise notice 'create schema unisql';
        else
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
            raise notice 'do not create schema unisql';
        end if;
    end $body$;

-- SQL --  创建分区信息视图,对应mysql的information_schema.partitions
create or replace
view unisql.partitions as
select
	ns.nspname::varchar(64) as table_schema,
	parent_rel.relname::varchar(64) as table_name,
	p.relname::varchar(64) as partition_name,
	case p.partstrategy
		when 'r' then 'RANGE'
		when 'l' then 'LIST'
		when 'h' then 'HASH'
		else 'KNKNOWN'
		end::varchar(18) as partition_method,
	case p.boundaries
		when '{NULL}' then 'MAXVALUE'
		else array_to_string(p.boundaries, ',') 
		end as partition_description
from
	pg_partition p
join pg_class parent_rel on
	p.parentid = parent_rel.oid
join pg_namespace ns on
	parent_rel.relnamespace = ns.oid
where
	p.parttype = 'p';