-- SQL --  删除之前创建的unisql.substr的所有函数，保留参数为(text, numeric)和(text, numeric,numeric)
DROP FUNCTION IF EXISTS
    unisql.substr(text,numeric,text),
    unisql.substr(text,text,numeric),
    unisql.substr(text,text,text),
    unisql.substr(numeric,numeric,numeric),
    unisql.substr(numeric, numeric,text),
    unisql.substr(numeric, text, numeric),
    unisql.substr(numeric, text, text),
    unisql.substr(numeric, numeric),
    unisql.substr(numeric, text),
    unisql.substr(text, text),
    unisql.substr(text, int4, int4),
    unisql.substr(text, int4);

-- SQL -- 创建substring_index函数
CREATE OR REPLACE FUNCTION unisql.substring_index(f_string varchar, f_delimiter varchar, f_position numeric)
RETURNS varchar AS $$
DECLARE
    o_string varchar;
    v_instr_pos int := 0;
    v_start_pos int := 1;
    sub_string varchar;
    sub_position int;
    sub_length int;
    v_position_int int;
BEGIN
    IF f_string IS NULL OR f_string = '' THEN
        RETURN NULL;
    END IF;

    IF f_delimiter IS NULL OR f_delimiter = '' THEN
        RETURN NULL;
    END IF;

    IF f_position IS NULL OR f_position = 0 THEN
        RETURN NULL;
    END IF;

    v_position_int := trunc(f_position);
    
    sub_length := length(f_string) + 1;

    IF v_position_int > 0 THEN
        sub_string := f_string;
        sub_position := v_position_int;
    ELSE
        sub_string := reverse(f_string);
        sub_position := abs(v_position_int);
    END IF;

    FOR i IN 1..sub_position LOOP
        v_instr_pos := strpos(substring(sub_string FROM v_start_pos), f_delimiter);
        EXIT WHEN v_instr_pos = 0; 
        v_start_pos := v_start_pos + v_instr_pos;
    END LOOP;

    IF v_instr_pos = 0 THEN
        RETURN f_string;
    END IF;
    
    IF v_position_int > 0 THEN
        o_string := substring(f_string FROM 1 FOR v_start_pos - 2);
    ELSE
        o_string := substring(f_string FROM sub_length - v_start_pos + 2);
    END IF;

    RETURN o_string;
END;
$$ LANGUAGE plpgsql;


-- SQL --  如果存在，则删除之前定义的unisql.emptystr2null(text)
DROP FUNCTION IF EXISTS unisql.emptystr2null(text);

-- SQL --  如果存在，删除之前定义的unisql.emptystr2null(anyelement)
DROP FUNCTION IF EXISTS unisql.emptystr2null(anyelement);

-- SQL --  如果存在，删除之前定义的unisql.decode_eq(anycompatible, anycompatible)
DROP FUNCTION IF EXISTS unisql.decode_eq(anycompatible, anycompatible);

-- SQL --  创建emptystr2null
CREATE OR REPLACE FUNCTION unisql.emptystr2null(var anyelement)
RETURNS anyelement
strict immutable
AS $$ 
DECLARE
	input_text text;
BEGIN
	input_text := var::text;
	if input_text = '' then 
		return null;
	end if;
	return var;
EXCEPTION
	WHEN others THEN
	RETURN var;
end;$$ LANGUAGE plpgsql;

-- SQL --  创建decode_eq
CREATE OR REPLACE FUNCTION unisql.decode_eq(anycompatible, anycompatible)
RETURNS boolean 
LANGUAGE sql
IMMUTABLE
as
$function$ SELECT CASE WHEN $1 IS NULL THEN $2 IS NULL ELSE $1 = $2 END; $function$;