-- SQL --  创建用于支持mysql的information_schema.statistics视图。
CREATE OR REPLACE VIEW UNISQL.statistics AS
SELECT
    ind.table_owner AS TABLE_SCHEMA,
    ind.table_name AS TABLE_NAME
FROM
    all_ind_columns ind;

-- SQL --  创建用于支持mysql的information_schema.key_column_usage视图。约束保留主键和唯一约束
CREATE OR REPLACE VIEW UNISQL.key_column_usage AS
SELECT
    acc.owner AS CONSTRAINT_SCHEMA,
    CASE
        WHEN ac.constraint_type = 'P' THEN 'PRIMARY'
        ELSE acc.constraint_name
        END AS CONSTRAINT_NAME,
    acc.owner AS TABLE_SCHEMA,
    acc.table_name AS TABLE_NAME,
    acc.column_name AS COLUMN_NAME,
    acc.position AS ORDINAL_POSITION
FROM
    all_cons_columns acc
    JOIN all_constraints ac
    ON
    acc.owner = ac.owner
     AND acc.constraint_name = ac.constraint_name
     AND ac.constraint_type IN ('P','U');