-- SQL --  通过表名获取该表上一次的自增 id, 类比 mysql, 该表必须有一个字段有 AUTO_INCREMENT 属性, 允许传空字符串
CREATE OR REPLACE FUNCTION unisql.last_insert_id(
    schema_name IN VARCHAR2,
    table_name IN VARCHAR2
) RETURN NUMBER AUTHID CURRENT_USER IS
    seq_name VARCHAR2(100);
    like_pattern VARCHAR2(100);
    curr_value NUMBER;
BEGIN
    BEGIN
      SELECT schema_name || '.UNISQL_AUTO_INCREMENT_SEQ_' || object_id INTO seq_name
      FROM all_objects
      WHERE object_name = table_name
	  AND owner = schema_name
      AND object_type = 'TABLE';
    EXCEPTION
      WHEN OTHERS THEN
        SELECT 'ISEQ$$_' || object_id || '_%' INTO like_pattern
        FROM all_objects
        WHERE object_name = table_name
		AND owner = schema_name
        AND object_type = 'TABLE';

        SELECT schema_name || '.' || sequence_name INTO seq_name
        FROM all_sequences
        WHERE 
		sequence_owner = schema_name
		AND sequence_name LIKE like_pattern;
    END;

    EXECUTE IMMEDIATE 'SELECT ' || seq_name || '.currval FROM dual'
    INTO curr_value;

    RETURN curr_value;
EXCEPTION
	WHEN OTHERS THEN
		RETURN 0;
END;

-- SQL --  模拟创建 mysql 的 auto_increment 列 新增p_table_name_str 因为创建对象时，如果对象名携带了双引号创建触发器时也需要携带双引号
CREATE OR REPLACE PROCEDURE unisql.create_identity_column(
    p_schema_name IN VARCHAR2,
    p_table_name IN VARCHAR2,
	p_table_name_str IN VARCHAR2,
    p_column_name IN VARCHAR2,
    p_start_value IN NUMBER
)
IS
    v_object_id NUMBER;
    v_sequence_name VARCHAR2(100);
    v_current_val NUMBER;
BEGIN
    SELECT object_id INTO v_object_id
    FROM dba_objects
    WHERE object_name = p_table_name
    AND owner = p_schema_name
    AND object_type = 'TABLE';
    
    v_sequence_name := p_schema_name || '.UNISQL_AUTO_INCREMENT_SEQ_' || v_object_id;

    EXECUTE IMMEDIATE 'CREATE SEQUENCE ' || v_sequence_name || ' START WITH ' || p_start_value ;
    
    EXECUTE IMMEDIATE 'CREATE OR REPLACE TRIGGER ' || p_schema_name || '.UNISQL_AUTO_INCREMENT_TRIGGER_' || v_object_id ||
    ' BEFORE INSERT ON ' || p_schema_name || '.' || p_table_name_str || ' FOR EACH ROW ' ||
    ' DECLARE ' ||
      ' v_val NUMBER; '||
    ' BEGIN ' ||
      ' IF :NEW.' || p_column_name || ' IS NULL OR :NEW.' || p_column_name || ' = 0 THEN ' ||
        ' :NEW.' || p_column_name || ' := ' || v_sequence_name || '.NEXTVAL;' ||
        ' RETURN; ' ||
      ' END IF;' ||
      ' BEGIN ' ||
        ' SELECT ' || v_sequence_name || '.CURRVAL INTO v_val FROM dual;' ||
      ' EXCEPTION WHEN OTHERS THEN ' ||
         ' SELECT ' || v_sequence_name || '.NEXTVAL INTO v_val FROM dual;' ||
      ' END; ' ||
      ' IF :NEW.' || p_column_name || ' > v_val THEN ' ||
        ' LOOP ' ||
          ' SELECT ' || v_sequence_name || '.nextval INTO v_val FROM dual; ' ||
          ' EXIT WHEN v_val >= :NEW.' || p_column_name || ';' ||
        ' END LOOP; ' ||
      ' END IF;' ||
    ' END;';
EXCEPTION
    WHEN NO_DATA_FOUND THEN
        RAISE_APPLICATION_ERROR(-20001, 'Table ' || p_schema_name || '.' || p_table_name || ' or column ' || p_column_name || ' not found.');
    WHEN OTHERS THEN
        RAISE_APPLICATION_ERROR(-20002, 'Error: ' || SQLERRM);
END;
