-- SQL --  创建unisql模式
do language 'plpgsql'
$body$
    declare
create_mark int;
begin
select count(1) into create_mark from pg_namespace where nspname='unisql';
if create_mark = 0 then
create schema unisql;
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
raise notice 'create schema unisql';
else
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
raise notice 'do not create schema unisql';
end if;
end $body$;


-- SQL --  创建用于支持mysql的information_schema.partitions视图
CREATE OR REPLACE VIEW unisql.partitions
AS
SELECT
    ns.nspname::VARCHAR(64) AS table_schema,
    parent_rel.relname::VARCHAR(64) AS table_name,
    p.relname::VARCHAR(64) AS partition_name,
    CASE p.partstrategy
        WHEN 'r' THEN 'RANGE'
        WHEN 'l' THEN 'LIST'
        WHEN 'h' THEN 'HASH'
        ELSE 'UNKNOWN'
    END::VARCHAR(18) AS partition_method,
    CASE p.partstrategy
        WHEN 'h' THEN null
        WHEN 'l' THEN (
            SELECT string_agg(
                CASE 
                    WHEN v IS NULL THEN 'DEFAULT'
                    ELSE v
                END,
                ','
            )
            FROM unnest(p.boundaries) AS t(v)
        )
        ELSE (
            SELECT string_agg(
                CASE 
                    WHEN v IS NULL THEN 'MAXVALUE'
                    ELSE v
                END,
                ','
            )
            FROM unnest(p.boundaries) AS t(v)
        )
    END AS partition_description
FROM pg_partition p
    JOIN pg_class parent_rel ON p.parentid = parent_rel.oid
    JOIN pg_namespace ns ON parent_rel.relnamespace = ns.oid
WHERE
    p.parttype = 'p';


-- SQL --  创建用于支持mysql的information_schema.statistics视图
CREATE OR REPLACE VIEW unisql.statistics
AS
SELECT
    n.nspname AS table_schema,
    t.relname AS table_name,
    CASE 
        WHEN ix.indisprimary THEN 'PRIMARY'
        ELSE i.relname 
    END AS index_name,
    a.attname AS column_name
FROM pg_index ix
    JOIN pg_class t ON t.oid = ix.indrelid
    JOIN pg_class i ON i.oid = ix.indexrelid
    JOIN pg_namespace n ON n.oid = t.relnamespace
    JOIN pg_attribute a ON a.attrelid = t.oid AND a.attnum = ANY(ix.indkey)
WHERE t.relkind = 'r'
UNION ALL
SELECT
    table_schema,
    table_name,
    index_name,
    (regexp_match)[1] AS column_name
FROM (
    SELECT
        n.nspname AS table_schema,
        t.relname AS table_name,
        i.relname AS index_name,
        regexp_matches(pg_get_indexdef(i.oid), 'to_tsvector\([^,]*,\s*\(?"?([a-zA-Z_][a-zA-Z0-9_]*)"?\)?(::text)?\s*\)', 'g') AS regexp_match
    FROM pg_index ix
        JOIN pg_class t ON t.oid = ix.indrelid
        JOIN pg_class i ON i.oid = ix.indexrelid
        JOIN pg_namespace n ON n.oid = t.relnamespace
        JOIN pg_am am ON am.oid = i.relam
    WHERE t.relkind = 'r'
        AND am.amname = 'gin'
        AND pg_get_indexdef(i.oid) ~ 'to_tsvector\s*\('
) AS sub
ORDER BY table_schema, table_name, index_name, column_name;


-- SQL --  创建用于支持mysql的information_schema.key_column_usage视图
CREATE OR REPLACE VIEW unisql.key_column_usage
AS
SELECT
    c.relname AS table_name,
    a.attname AS column_name,
    n.nspname AS constraint_schema,
    CASE
        WHEN con.contype = 'p' THEN 'PRIMARY'
        ELSE con.conname
    END AS constraint_name
FROM pg_constraint con
    JOIN pg_class c ON con.conrelid = c.oid
    JOIN pg_namespace n ON c.relnamespace = n.oid
    JOIN pg_attribute a ON a.attnum = ANY(con.conkey) AND a.attrelid = c.oid
WHERE con.contype IN ('p', 'u')
  AND c.relkind = 'r'
ORDER BY table_name, column_name, constraint_schema, constraint_name;
