-- SQL --  创建unisql模式
do language 'plpgsql'
$body$
    declare
create_mark int;
begin
select count(1) into create_mark from pg_namespace where nspname='unisql';
if create_mark = 0 then
create schema unisql;
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
raise notice 'create schema unisql';
else
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
raise notice 'do not create schema unisql';
end if;
end $body$;


-- SQL --  创建用于支持oracle的all_objects视图
CREATE OR REPLACE VIEW unisql.all_objects AS
SELECT
    UPPER(owner)                 AS owner,
    UPPER(object_name)           AS object_name,
    object_id,
    UPPER(object_type)           AS object_type,
    namespace,
    UPPER(temporary)             AS temporary,
    UPPER(status)                AS status,
    UPPER(subobject_name)        AS subobject_name,
    UPPER(generated)             AS generated,
    created,
    last_ddl_time,
    UPPER(default_collation)     AS default_collation,
    data_object_id,
    UPPER(timestamp)             AS timestamp,
    UPPER(secondary)             AS secondary,
    UPPER(edition_name)          AS edition_name,
    UPPER(sharing)               AS sharing,
    UPPER(editionable)           AS editionable,
    UPPER(oracle_maintained)     AS oracle_maintained,
    UPPER(application)           AS application,
    UPPER(duplicated)            AS duplicated,
    UPPER(sharded)               AS sharded,
    created_appid,
    modified_appid,
    created_vsnid,
    modified_vsnid
FROM db_objects;
